/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.structuralsearch.StructuralSearchProfileBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.debugger.fragments.GroovyCodeFragment;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.template.GroovyTemplateContextType;

public class GroovyStructuralSearchProfile
extends StructuralSearchProfileBase {
    public static final String FILE_CONTEXT = "File";
    public static final String CLASS_CONTEXT = "Class";
    private static final TokenSet VARIABLE_DELIMETERS = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mCOMMA, GroovyTokenTypes.mSEMI});

    @NotNull
    protected String[] getVarPrefixes() {
        String[] stringArray = new String[]{"_$_____"};
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/GroovyStructuralSearchProfile", "getVarPrefixes"));
        }
        return stringArray;
    }

    @NotNull
    public String[] getContextNames() {
        String[] stringArray = new String[]{FILE_CONTEXT, CLASS_CONTEXT};
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/GroovyStructuralSearchProfile", "getContextNames"));
        }
        return stringArray;
    }

    @NotNull
    protected LanguageFileType getFileType() {
        GroovyFileType groovyFileType = GroovyFileType.GROOVY_FILE_TYPE;
        if (groovyFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/GroovyStructuralSearchProfile", "getFileType"));
        }
        return groovyFileType;
    }

    @NotNull
    protected TokenSet getVariableDelimiters() {
        TokenSet tokenSet = VARIABLE_DELIMETERS;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/GroovyStructuralSearchProfile", "getVariableDelimiters"));
        }
        return tokenSet;
    }

    public PsiCodeFragment createCodeFragment(Project project, String text, @Nullable PsiElement context) {
        GroovyCodeFragment result = new GroovyCodeFragment(project, text);
        result.setContext(context);
        return result;
    }

    public Class<? extends TemplateContextType> getTemplateContextTypeClass() {
        return GroovyTemplateContextType.class;
    }

    public String getContext(@NotNull String pattern, @Nullable Language language, String contextName) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/structuralsearch/GroovyStructuralSearchProfile", "getContext"));
        }
        return CLASS_CONTEXT.equals(contextName) ? "class AAAAA { $$PATTERN_PLACEHOLDER$$ }" : "$$PATTERN_PLACEHOLDER$$";
    }

    public Class getElementContextByPsi(PsiElement element) {
        if (element instanceof PsiIdentifier) {
            element = element.getParent();
        }
        if (element instanceof PsiMember) {
            return PsiMember.class;
        }
        return PsiExpression.class;
    }

    public boolean isIdentifier(PsiElement element) {
        return element instanceof PsiIdentifier;
    }
}

