/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.checkers;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.checkers.AliasedAnnotationHolder;
import org.jetbrains.plugins.groovy.annotator.checkers.AnnotationChecker;
import org.jetbrains.plugins.groovy.annotator.checkers.CustomAnnotationChecker;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers.GrAnnotationCollector;

public class GrAliasAnnotationChecker
extends CustomAnnotationChecker {
    @Override
    public boolean checkApplicability(@NotNull AnnotationHolder holder, @NotNull GrAnnotation annotation) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/groovy/annotator/checkers/GrAliasAnnotationChecker", "checkApplicability"));
        }
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/plugins/groovy/annotator/checkers/GrAliasAnnotationChecker", "checkApplicability"));
        }
        ArrayList<GrAnnotation> aliasedAnnotations = GrAliasAnnotationChecker.getAliasedAnnotations(annotation);
        if (aliasedAnnotations == null) {
            return false;
        }
        AliasedAnnotationHolder aliasedHolder = new AliasedAnnotationHolder(holder, annotation);
        AnnotationChecker checker = new AnnotationChecker(aliasedHolder);
        for (GrAnnotation aliased : aliasedAnnotations) {
            checker.checkApplicability(aliased, annotation.getOwner());
        }
        return true;
    }

    @Nullable
    private static ArrayList<GrAnnotation> getAliasedAnnotations(GrAnnotation annotation) {
        PsiAnnotation annotationCollector = GrAnnotationCollector.findAnnotationCollector(annotation);
        if (annotationCollector == null) {
            return null;
        }
        ArrayList aliasedAnnotations = ContainerUtil.newArrayList();
        GrAnnotationCollector.collectAnnotations(aliasedAnnotations, annotation, annotationCollector);
        return aliasedAnnotations;
    }

    @Override
    public boolean checkArgumentList(@NotNull AnnotationHolder holder, @NotNull GrAnnotation annotation) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/groovy/annotator/checkers/GrAliasAnnotationChecker", "checkArgumentList"));
        }
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/plugins/groovy/annotator/checkers/GrAliasAnnotationChecker", "checkArgumentList"));
        }
        PsiAnnotation annotationCollector = GrAnnotationCollector.findAnnotationCollector(annotation);
        if (annotationCollector == null) {
            return false;
        }
        ArrayList annotations = ContainerUtil.newArrayList();
        Set<String> usedAttributes = GrAnnotationCollector.collectAnnotations(annotations, annotation, annotationCollector);
        AliasedAnnotationHolder aliasedHolder = new AliasedAnnotationHolder(holder, annotation);
        AnnotationChecker checker = new AnnotationChecker(aliasedHolder);
        for (GrAnnotation aliased : annotations) {
            checker.checkAnnotationArgumentList(aliased);
        }
        GrAnnotationNameValuePair[] attributes = annotation.getParameterList().getAttributes();
        String aliasQName = annotation.getQualifiedName();
        if (attributes.length == 1 && attributes[0].getNameIdentifierGroovy() == null && !usedAttributes.contains("value")) {
            holder.createErrorAnnotation((PsiElement)attributes[0], GroovyBundle.message("at.interface.0.does.not.contain.attribute", aliasQName, "value"));
        }
        for (GrAnnotationNameValuePair pair : attributes) {
            PsiElement nameIdentifier = pair.getNameIdentifierGroovy();
            if (nameIdentifier == null || usedAttributes.contains(pair.getName())) continue;
            holder.createErrorAnnotation(nameIdentifier, GroovyBundle.message("at.interface.0.does.not.contain.attribute", aliasQName, pair.getName()));
        }
        return true;
    }
}

