/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInsight.hint;

import com.intellij.lang.ExpressionTypeProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceHandlerBase;

public class GroovyExpressionTypeProvider
extends ExpressionTypeProvider<GrExpression> {
    @NotNull
    public String getInformationHint(@NotNull GrExpression element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/codeInsight/hint/GroovyExpressionTypeProvider", "getInformationHint"));
        }
        PsiType type = element.getType();
        String string = StringUtil.escapeXml((String)(type == null ? "<unknown>" : type.getPresentableText()));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInsight/hint/GroovyExpressionTypeProvider", "getInformationHint"));
        }
        return string;
    }

    @NotNull
    public String getErrorHint() {
        if ("No expression found" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInsight/hint/GroovyExpressionTypeProvider", "getErrorHint"));
        }
        return "No expression found";
    }

    @NotNull
    public List<GrExpression> getExpressionsAt(@NotNull PsiElement elementAt) {
        if (elementAt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementAt", "org/jetbrains/plugins/groovy/codeInsight/hint/GroovyExpressionTypeProvider", "getExpressionsAt"));
        }
        List<GrExpression> list = GrIntroduceHandlerBase.collectExpressions(elementAt, true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInsight/hint/GroovyExpressionTypeProvider", "getExpressionsAt"));
        }
        return list;
    }
}

