/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParserDefinition;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.Separators;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.modifiers.Modifiers;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.BranchStatement;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.ForStatement;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.SwitchStatement;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.SynchronizedStatement;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.TryCatchStatement;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.blocks.OpenOrClosableBlock;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.constructor.ConstructorBody;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.declaration.Declaration;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.AssignmentExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.ConditionalExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.ExpressionStatement;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.imports.ImportStatement;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.typeDefinitions.TypeDefinition;
import org.jetbrains.plugins.groovy.lang.parser.parsing.toplevel.CompilationUnit;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class GroovyParser
implements PsiParser {
    public static final TokenSet RCURLY_ONLY = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mRCURLY});
    public static final TokenSet CASE_SECTION_END = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.kCASE, GroovyTokenTypes.kDEFAULT, GroovyTokenTypes.mRCURLY});

    public boolean parseDeep() {
        return false;
    }

    public static void parseExpression(PsiBuilder builder) {
        ExpressionStatement.argParse(builder, new GroovyParser());
    }

    @NotNull
    public ASTNode parse(IElementType root, PsiBuilder builder) {
        if (root == GroovyElementTypes.OPEN_BLOCK) {
            OpenOrClosableBlock.parseOpenBlockDeep(builder, this);
        } else if (root == GroovyElementTypes.CLOSABLE_BLOCK) {
            OpenOrClosableBlock.parseClosableBlockDeep(builder, this);
        } else if (root == GroovyElementTypes.CONSTRUCTOR_BODY) {
            ConstructorBody.parseConstructorBodyDeep(builder, this);
        } else {
            assert (root == GroovyParserDefinition.GROOVY_FILE) : root;
            PsiBuilder.Marker rootMarker = builder.mark();
            CompilationUnit.parseFile(builder, this);
            rootMarker.done(root);
        }
        ASTNode aSTNode = builder.getTreeBuilt();
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/GroovyParser", "parse"));
        }
        return aSTNode;
    }

    public boolean parseForStatement(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        ParserUtils.getToken(builder, GroovyTokenTypes.kFOR);
        if (!ParserUtils.getToken(builder, GroovyTokenTypes.mLPAREN, GroovyBundle.message("lparen.expected", new Object[0]))) {
            marker.done((IElementType)GroovyElementTypes.FOR_STATEMENT);
            return true;
        }
        if (!ForStatement.forClauseParse(builder, this)) {
            builder.error(GroovyBundle.message("for.clause.expected", new Object[0]));
            marker.done((IElementType)GroovyElementTypes.FOR_STATEMENT);
            return true;
        }
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        if (!ParserUtils.getToken(builder, GroovyTokenTypes.mRPAREN, GroovyBundle.message("rparen.expected", new Object[0]))) {
            ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
            marker.done((IElementType)GroovyElementTypes.FOR_STATEMENT);
            return true;
        }
        PsiBuilder.Marker warn = builder.mark();
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        if (this.parseExtendedStatement(builder)) {
            warn.rollbackTo();
            marker.done((IElementType)GroovyElementTypes.FOR_STATEMENT);
            return true;
        }
        if (this.parseStatement(builder, true)) {
            warn.drop();
        } else {
            warn.rollbackTo();
            builder.error(GroovyBundle.message("statement.expected", new Object[0]));
        }
        marker.done((IElementType)GroovyElementTypes.FOR_STATEMENT);
        return true;
    }

    public boolean parseIfStatement(PsiBuilder builder) {
        PsiBuilder.Marker ifStmtMarker = builder.mark();
        if (!ParserUtils.getToken(builder, GroovyTokenTypes.kIF)) {
            ifStmtMarker.rollbackTo();
            builder.error(GroovyBundle.message("if.expected", new Object[0]));
            return false;
        }
        if (!ParserUtils.getToken(builder, GroovyTokenTypes.mLPAREN, GroovyBundle.message("lparen.expected", new Object[0]))) {
            ifStmtMarker.done((IElementType)GroovyElementTypes.IF_STATEMENT);
            return true;
        }
        if (!ConditionalExpression.parse(builder, this)) {
            builder.error(GroovyBundle.message("expression.expected", new Object[0]));
        }
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        ParserUtils.getToken(builder, GroovyTokenTypes.mRPAREN, GroovyBundle.message("rparen.expected", new Object[0]));
        if (!this.parseBranch(builder)) {
            ifStmtMarker.done((IElementType)GroovyElementTypes.IF_STATEMENT);
            return true;
        }
        PsiBuilder.Marker rb = builder.mark();
        if (GroovyTokenTypes.kELSE.equals(builder.getTokenType()) || Separators.parse(builder) && builder.getTokenType() == GroovyTokenTypes.kELSE) {
            rb.drop();
            ParserUtils.getToken(builder, GroovyTokenTypes.kELSE);
            this.parseBranch(builder);
        } else {
            rb.rollbackTo();
        }
        ifStmtMarker.done((IElementType)GroovyElementTypes.IF_STATEMENT);
        return true;
    }

    public void parseSwitchCaseList(PsiBuilder builder) {
        if (this.parseGenericStatement(builder, CASE_SECTION_END)) {
            this.parseCodeBlock(builder, CASE_SECTION_END);
        }
    }

    protected boolean isExtendedSeparator(@Nullable IElementType tokenType) {
        return false;
    }

    protected boolean parseExtendedStatement(PsiBuilder builder) {
        return false;
    }

    public boolean parseWhileStatement(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        ParserUtils.getToken(builder, GroovyTokenTypes.kWHILE);
        if (!ParserUtils.getToken(builder, GroovyTokenTypes.mLPAREN, GroovyBundle.message("lparen.expected", new Object[0]))) {
            marker.done((IElementType)GroovyElementTypes.WHILE_STATEMENT);
            return true;
        }
        if (!ExpressionStatement.argParse(builder, this)) {
            builder.error(GroovyBundle.message("expression.expected", new Object[0]));
        }
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        if (!ParserUtils.getToken(builder, GroovyTokenTypes.mRPAREN, GroovyBundle.message("rparen.expected", new Object[0]))) {
            marker.done((IElementType)GroovyElementTypes.WHILE_STATEMENT);
            return true;
        }
        this.parseBranch(builder);
        marker.done((IElementType)GroovyElementTypes.WHILE_STATEMENT);
        return true;
    }

    private boolean parseBranch(@NotNull PsiBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/plugins/groovy/lang/parser/GroovyParser", "parseBranch"));
        }
        PsiBuilder.Marker warn = builder.mark();
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        if (!this.parseStatement(builder, true) && !this.parseExtendedStatement(builder)) {
            warn.rollbackTo();
            builder.error(GroovyBundle.message("statement.expected", new Object[0]));
            return false;
        }
        warn.drop();
        return true;
    }

    public void parseBlockBody(PsiBuilder builder) {
        this.skipSeparators(builder);
        this.parseBlockBodyWithoutSkippingSeparators(builder);
    }

    public void parseBlockBodyWithoutSkippingSeparators(PsiBuilder builder) {
        this.parseCodeBlock(builder, RCURLY_ONLY);
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
    }

    private void parseCodeBlock(PsiBuilder builder, TokenSet until) {
        while (!builder.eof() && !until.contains(builder.getTokenType()) && this.parseGenericStatement(builder, until)) {
        }
    }

    private boolean parseGenericStatement(PsiBuilder builder, TokenSet until) {
        boolean plainStatement = this.parseStatement(builder, false);
        if (plainStatement || this.parseExtendedStatement(builder)) {
            if (this.parseSeparatorsWithoutLastNls(builder, plainStatement, until)) {
                return false;
            }
        } else {
            builder.error(GroovyBundle.message("wrong.statement", new Object[0]));
            assert (builder.getTokenType() != GroovyTokenTypes.mLCURLY && builder.getTokenType() != GroovyTokenTypes.mRCURLY);
            builder.advanceLexer();
        }
        return true;
    }

    private boolean parseSeparatorsWithoutLastNls(PsiBuilder builder, boolean requireSeparator, TokenSet until) {
        boolean hasSeparator = false;
        while (true) {
            if (builder.getTokenType() == GroovyTokenTypes.mSEMI || this.isExtendedSeparator(builder.getTokenType())) {
                hasSeparator = true;
                builder.advanceLexer();
                continue;
            }
            if (builder.getTokenType() != GroovyTokenTypes.mNLS) break;
            PsiBuilder.Marker beforeNls = builder.mark();
            hasSeparator = true;
            builder.advanceLexer();
            if (builder.eof() || until.contains(builder.getTokenType())) {
                beforeNls.rollbackTo();
                return true;
            }
            beforeNls.drop();
        }
        if (builder.eof() || until.contains(builder.getTokenType())) {
            return true;
        }
        if (requireSeparator && !hasSeparator) {
            builder.error(GroovyBundle.message("separator.or.rcurly.expected", new Object[0]));
        }
        return false;
    }

    private boolean skipSeparators(PsiBuilder builder) {
        boolean hasSeparators = false;
        while (builder.getTokenType() == GroovyTokenTypes.mSEMI || this.isExtendedSeparator(builder.getTokenType()) || builder.getTokenType() == GroovyTokenTypes.mNLS) {
            hasSeparators = true;
            builder.advanceLexer();
        }
        return hasSeparators;
    }

    public boolean parseStatement(PsiBuilder builder, boolean isBlockStatementNeeded) {
        PsiBuilder.Marker marker;
        if (isBlockStatementNeeded && GroovyTokenTypes.mLCURLY.equals(builder.getTokenType())) {
            PsiBuilder.Marker marker2 = builder.mark();
            OpenOrClosableBlock.parseOpenBlockDeep(builder, this);
            marker2.done((IElementType)GroovyElementTypes.BLOCK_STATEMENT);
            return true;
        }
        if (isBlockStatementNeeded && GroovyTokenTypes.mSEMI == builder.getTokenType()) {
            return true;
        }
        if (GroovyTokenTypes.kIMPORT.equals(builder.getTokenType())) {
            PsiBuilder.Marker marker3 = builder.mark();
            ImportStatement.parse(builder, this);
            marker3.error(GroovyBundle.message("import.not.allowed", new Object[0]));
            return true;
        }
        if (GroovyTokenTypes.kIF.equals(builder.getTokenType())) {
            return this.parseIfStatement(builder);
        }
        if (GroovyTokenTypes.kSWITCH.equals(builder.getTokenType())) {
            SwitchStatement.parseSwitch(builder, this);
            return true;
        }
        if (GroovyTokenTypes.kTRY.equals(builder.getTokenType())) {
            return TryCatchStatement.parse(builder, this);
        }
        if (GroovyTokenTypes.kWHILE.equals(builder.getTokenType())) {
            return this.parseWhileStatement(builder);
        }
        if (GroovyTokenTypes.kFOR.equals(builder.getTokenType())) {
            return this.parseForStatement(builder);
        }
        if (ParserUtils.lookAhead(builder, GroovyTokenTypes.kSYNCHRONIZED, GroovyTokenTypes.mLPAREN)) {
            PsiBuilder.Marker synMarker = builder.mark();
            if (SynchronizedStatement.parse(builder, this)) {
                synMarker.drop();
                return true;
            }
            synMarker.rollbackTo();
        }
        if (GroovyTokenTypes.kELSE.equals(builder.getTokenType())) {
            ParserUtils.wrapError(builder, GroovyBundle.message("else.without.if", new Object[0]));
            this.parseStatement(builder, true);
            return true;
        }
        if (GroovyTokenTypes.kCATCH.equals(builder.getTokenType())) {
            ParserUtils.wrapError(builder, GroovyBundle.message("catch.without.try", new Object[0]));
            this.parseStatement(builder, false);
            return true;
        }
        if (GroovyTokenTypes.kFINALLY.equals(builder.getTokenType())) {
            ParserUtils.wrapError(builder, GroovyBundle.message("finally.without.try", new Object[0]));
            this.parseStatement(builder, false);
            return true;
        }
        if (GroovyTokenTypes.kCASE.equals(builder.getTokenType())) {
            marker = builder.mark();
            SwitchStatement.parseCaseLabel(builder, this);
            marker.error(GroovyBundle.message("case.without.switch", new Object[0]));
            this.parseStatement(builder, false);
            return true;
        }
        if (GroovyTokenTypes.kDEFAULT.equals(builder.getTokenType())) {
            marker = builder.mark();
            SwitchStatement.parseCaseLabel(builder, this);
            marker.error(GroovyBundle.message("default.without.switch", new Object[0]));
            this.parseStatement(builder, false);
            return true;
        }
        if (BranchStatement.BRANCH_KEYWORDS.contains(builder.getTokenType())) {
            return BranchStatement.parse(builder, this);
        }
        if (this.parseLabeledStatement(builder)) {
            return true;
        }
        if (this.parseDeclaration(builder, false, false, null)) {
            return true;
        }
        return AssignmentExpression.parse(builder, this, true);
    }

    public boolean parseDeclaration(@NotNull PsiBuilder builder, boolean isInClass, boolean isInAnnotation, @Nullable String typeDefinitionName) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/plugins/groovy/lang/parser/GroovyParser", "parseDeclaration"));
        }
        PsiBuilder.Marker declMarker = builder.mark();
        boolean modifiersParsed = Modifiers.parse(builder, this);
        if (GroovyTokenTypes.kIMPORT == builder.getTokenType()) {
            PsiBuilder.Marker impMarker = declMarker.precede();
            ImportStatement.parseAfterModifiers(builder);
            declMarker.done((IElementType)GroovyElementTypes.IMPORT_STATEMENT);
            impMarker.error(GroovyBundle.message("import.not.allowed", new Object[0]));
            return true;
        }
        if (GroovyParser.isTypeDefinitionStart(builder)) {
            IElementType tdType = TypeDefinition.parseAfterModifiers(builder, this);
            if (tdType != GroovyElementTypes.WRONGWAY) {
                declMarker.done(tdType);
            } else {
                builder.error(GroovyBundle.message("identifier.expected", new Object[0]));
                declMarker.drop();
            }
            return true;
        }
        if (isInClass && this.parseInitializer(builder)) {
            declMarker.done((IElementType)GroovyElementTypes.CLASS_INITIALIZER);
            return true;
        }
        IElementType declType = Declaration.parseAfterModifiers(builder, isInClass, isInAnnotation, typeDefinitionName, this, modifiersParsed);
        if (declType != GroovyElementTypes.WRONGWAY) {
            if (declType != null) {
                declMarker.done(declType);
            } else {
                declMarker.drop();
            }
            return true;
        }
        if (modifiersParsed) {
            declMarker.drop();
            builder.error(GroovyBundle.message("identifier.expected", new Object[0]));
            return true;
        }
        declMarker.rollbackTo();
        return false;
    }

    private boolean parseInitializer(PsiBuilder builder) {
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        return GroovyTokenTypes.mLCURLY == builder.getTokenType() && OpenOrClosableBlock.parseOpenBlock(builder, this);
    }

    private static boolean isTypeDefinitionStart(PsiBuilder builder) {
        return GroovyTokenTypes.kCLASS == builder.getTokenType() || GroovyTokenTypes.kINTERFACE == builder.getTokenType() || GroovyTokenTypes.kENUM == builder.getTokenType() || GroovyTokenTypes.kTRAIT == builder.getTokenType() || ParserUtils.lookAhead(builder, GroovyTokenTypes.mAT, GroovyTokenTypes.kINTERFACE);
    }

    public boolean parseStatementWithImports(PsiBuilder builder) {
        if (ImportStatement.parse(builder, this)) {
            return true;
        }
        return this.parseStatement(builder, false);
    }

    private boolean parseLabeledStatement(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        if (!ParserUtils.getToken(builder, GroovyTokenTypes.mIDENT) || !ParserUtils.getToken(builder, GroovyTokenTypes.mCOLON)) {
            marker.rollbackTo();
            return false;
        }
        PsiBuilder.Marker nlsMarker = builder.mark();
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        if (this.parseStatement(builder, true)) {
            nlsMarker.drop();
        } else {
            nlsMarker.rollbackTo();
            builder.error(GroovyBundle.message("statement.expected", new Object[0]));
        }
        marker.done((IElementType)GroovyElementTypes.LABELED_STATEMENT);
        return true;
    }
}

