/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs.elements;

import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.toplevel.imports.GrImportStatementImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrImportStatementStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrStubUtils;
import org.jetbrains.plugins.groovy.lang.psi.stubs.elements.GrStubElementType;

public class GrImportStatementElementType
extends GrStubElementType<GrImportStatementStub, GrImportStatement> {
    public GrImportStatementElementType(String debugName) {
        super(debugName);
    }

    public GrImportStatement createPsi(@NotNull GrImportStatementStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrImportStatementElementType", "createPsi"));
        }
        return new GrImportStatementImpl(stub, (IStubElementType)this);
    }

    public GrImportStatementStub createStub(@NotNull GrImportStatement psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrImportStatementElementType", "createStub"));
        }
        GrCodeReferenceElement ref = psi.getImportReference();
        return new GrImportStatementStub(parentStub, this, ref != null ? ref.getText() : null, psi.isAliasedImport() ? psi.getImportedName() : null, GrImportStatementStub.buildFlags(psi.isStatic(), psi.isOnDemand()));
    }

    public void serialize(@NotNull GrImportStatementStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrImportStatementElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrImportStatementElementType", "serialize"));
        }
        GrStubUtils.writeNullableString(dataStream, stub.getReferenceText());
        GrStubUtils.writeNullableString(dataStream, stub.getAliasName());
        dataStream.writeByte((int)stub.getFlags());
    }

    @NotNull
    public GrImportStatementStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrImportStatementElementType", "deserialize"));
        }
        String referenceText = GrStubUtils.readNullableString(dataStream);
        String aliasName = GrStubUtils.readNullableString(dataStream);
        byte flags = dataStream.readByte();
        GrImportStatementStub grImportStatementStub = new GrImportStatementStub(parentStub, this, referenceText, aliasName, flags);
        if (grImportStatementStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrImportStatementElementType", "deserialize"));
        }
        return grImportStatementStub;
    }
}

