/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.WatchedRootsProvider;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;

public class MvcWatchedRootProvider
implements WatchedRootsProvider {
    private final Project myProject;

    public MvcWatchedRootProvider(Project project) {
        this.myProject = project;
    }

    @NotNull
    public Set<String> getRootsToWatch() {
        Set<String> set = MvcWatchedRootProvider.getRootsToWatch(this.myProject);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/mvc/MvcWatchedRootProvider", "getRootsToWatch"));
        }
        return set;
    }

    @NotNull
    public static Set<String> getRootsToWatch(Project project) {
        if (!project.isInitialized()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/mvc/MvcWatchedRootProvider", "getRootsToWatch"));
            }
            return set;
        }
        HashSet<String> result = null;
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            File globalPluginsDir;
            File sdkWorkDir;
            MvcFramework framework = MvcFramework.getInstance(module);
            if (framework == null) continue;
            if (result == null) {
                result = new HashSet<String>();
            }
            if ((sdkWorkDir = framework.getCommonPluginsDir(module)) != null) {
                result.add(sdkWorkDir.getAbsolutePath());
            }
            if ((globalPluginsDir = framework.getGlobalPluginsDir(module)) == null) continue;
            result.add(globalPluginsDir.getAbsolutePath());
        }
        Set<String> set = result == null ? Collections.emptySet() : result;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/mvc/MvcWatchedRootProvider", "getRootsToWatch"));
        }
        return set;
    }
}

