/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.keychain;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.keychain.CredentialsStoreKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0002\u0010\u0011\n\u0002\b\t\bf\u0018\u0000 %2\u00020\u0001:\u0001%J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH&J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0005H&J\u001c\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H&JN\u0010\u0010\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00142\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0005H&Jk\u0010\u001a\u001a\u00020\u000e2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00142\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u001c2\u0012\b\u0002\u0010\u0018\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u001d2\u0012\b\u0002\u0010\u0019\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u001dH&\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0005H&J\u001c\u0010 \u001a\u00020\u00032\b\u0010!\u001a\u0004\u0018\u00010\u00052\b\u0010\"\u001a\u0004\u0018\u00010\u0005H&J*\u0010#\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00052\b\u0010!\u001a\u0004\u0018\u00010\u00052\u0006\u0010$\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u0014H&\u00a8\u0006&"}, d2={"Lorg/jetbrains/keychain/OSXKeychainLibrary;", "Lcom/sun/jna/Library;", "CFRelease", "", "cf", "Lcom/sun/jna/Pointer;", "CFStringGetCharacterAtIndex", "", "theString", "idx", "", "CFStringGetLength", "SecCopyErrorMessageString", "status", "", "reserved", "SecKeychainAddGenericPassword", "keychain", "serviceNameLength", "serviceName", "", "accountNameLength", "accountName", "passwordLength", "passwordData", "itemRef", "SecKeychainFindGenericPassword", "keychainOrArray", "", "", "(Lcom/sun/jna/Pointer;I[BI[B[I[Lcom/sun/jna/Pointer;[Lcom/sun/jna/Pointer;)I", "SecKeychainItemDelete", "SecKeychainItemFreeContent", "attrList", "data", "SecKeychainItemModifyContent", "length", "Companion", "settings-repository"})
public interface OSXKeychainLibrary
extends Library {
    public static final Companion Companion = new Companion(null);

    public int SecKeychainAddGenericPassword(@Nullable Pointer var1, int var2, @NotNull byte[] var3, int var4, @NotNull byte[] var5, int var6, @NotNull byte[] var7, @Nullable Pointer var8);

    public int SecKeychainItemModifyContent(@NotNull Pointer var1, @Nullable Pointer var2, int var3, @NotNull byte[] var4);

    public int SecKeychainFindGenericPassword(@Nullable Pointer var1, int var2, @NotNull byte[] var3, int var4, @NotNull byte[] var5, @Nullable int[] var6, @Nullable Pointer[] var7, @Nullable Pointer[] var8);

    public int SecKeychainItemDelete(@NotNull Pointer var1);

    @Nullable
    public Pointer SecCopyErrorMessageString(int var1, @Nullable Pointer var2);

    public long CFStringGetLength(@NotNull Pointer var1);

    public char CFStringGetCharacterAtIndex(@NotNull Pointer var1, long var2);

    public void CFRelease(@NotNull Pointer var1);

    public void SecKeychainItemFreeContent(@Nullable Pointer var1, @Nullable Pointer var2);

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=3)
    public static final class DefaultImpls {
        public static /* bridge */ /* synthetic */ int SecKeychainAddGenericPassword$default(OSXKeychainLibrary oSXKeychainLibrary, Pointer pointer, int n, byte[] byArray, int n2, byte[] byArray2, int n3, byte[] byArray3, Pointer pointer2, int n4, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: SecKeychainAddGenericPassword");
            }
            if ((n4 & 0x80) != 0) {
                pointer2 = null;
            }
            return oSXKeychainLibrary.SecKeychainAddGenericPassword(pointer, n, byArray, n2, byArray2, n3, byArray3, pointer2);
        }

        public static /* bridge */ /* synthetic */ int SecKeychainFindGenericPassword$default(OSXKeychainLibrary oSXKeychainLibrary, Pointer pointer, int n, byte[] byArray, int n2, byte[] byArray2, int[] nArray, Pointer[] pointerArray, Pointer[] pointerArray2, int n3, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: SecKeychainFindGenericPassword");
            }
            if ((n3 & 0x20) != 0) {
                nArray = null;
            }
            if ((n3 & 0x40) != 0) {
                pointerArray = null;
            }
            if ((n3 & 0x80) != 0) {
                pointerArray2 = null;
            }
            return oSXKeychainLibrary.SecKeychainFindGenericPassword(pointer, n, byArray, n2, byArray2, nArray, pointerArray, pointerArray2);
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nJ\u0018\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nJ \u0010\u0012\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J(\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\fH\u0002J\u001e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0017J\u001e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nR\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/keychain/OSXKeychainLibrary$Companion;", "", "()V", "LIBRARY", "Lorg/jetbrains/keychain/OSXKeychainLibrary;", "getLIBRARY", "()Lorg/jetbrains/keychain/OSXKeychainLibrary;", "checkForError", "", "message", "", "code", "", "deleteGenericPassword", "serviceName", "", "accountName", "findGenericPassword", "saveGenericPassword", "passwordBuffer", "Ljava/nio/ByteBuffer;", "password", "passwordSize", "", "settings-repository"})
    public static final class Companion {
        private static final OSXKeychainLibrary LIBRARY;

        private final OSXKeychainLibrary getLIBRARY() {
            return LIBRARY;
        }

        public final void saveGenericPassword(@NotNull byte[] serviceName, @NotNull String accountName, @NotNull char[] password) {
            Intrinsics.checkParameterIsNotNull((Object)serviceName, (String)"serviceName");
            Intrinsics.checkParameterIsNotNull((Object)accountName, (String)"accountName");
            Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
            ByteBuffer byteBuffer = Charsets.UTF_8.encode(CharBuffer.wrap(password));
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"Charsets.UTF_8.encode(CharBuffer.wrap(password))");
            this.saveGenericPassword(serviceName, accountName, byteBuffer);
        }

        public final void saveGenericPassword(@NotNull byte[] serviceName, @NotNull String accountName, @NotNull String password) {
            Intrinsics.checkParameterIsNotNull((Object)serviceName, (String)"serviceName");
            Intrinsics.checkParameterIsNotNull((Object)accountName, (String)"accountName");
            Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
            ByteBuffer byteBuffer = Charsets.UTF_8.encode(password);
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"Charsets.UTF_8.encode(password)");
            this.saveGenericPassword(serviceName, accountName, byteBuffer);
        }

        private final void saveGenericPassword(byte[] serviceName, String accountName, ByteBuffer passwordBuffer) {
            byte[] passwordData;
            int passwordDataSize = passwordBuffer.limit();
            if (passwordBuffer.hasArray() && passwordBuffer.arrayOffset() == 0) {
                byte[] byArray = passwordBuffer.array();
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"passwordBuffer.array()");
                passwordData = byArray;
            } else {
                passwordData = new byte[passwordDataSize];
                passwordBuffer.get(passwordData);
            }
            this.saveGenericPassword(serviceName, accountName, passwordData, passwordDataSize);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final String findGenericPassword(@NotNull byte[] serviceName, @NotNull String accountName) {
            void bytes$iv;
            void elements$iv;
            Intrinsics.checkParameterIsNotNull((Object)serviceName, (String)"serviceName");
            Intrinsics.checkParameterIsNotNull((Object)accountName, (String)"accountName");
            String string = accountName;
            Charset charset = null;
            boolean bl = true;
            Object var7_7 = null;
            if (var7_7 != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toByteArray");
            }
            if (bl & true) {
                charset = Charsets.UTF_8;
            }
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] accountNameBytes = byArray;
            int[] passwordSize = new int[1];
            Pointer[] $i$f$toByteArray = new Pointer[]{null};
            Pointer[] passwordData = (Pointer[])((Object[])elements$iv);
            this.checkForError("find", DefaultImpls.SecKeychainFindGenericPassword$default(this.getLIBRARY(), null, serviceName.length, serviceName, accountNameBytes.length, accountNameBytes, passwordSize, passwordData, null, 128, null));
            Pointer pointer = passwordData[0];
            if (pointer == null) {
                return null;
            }
            Pointer pointer2 = pointer;
            byte[] byArray2 = pointer2.getByteArray(0L, passwordSize[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"pointer.getByteArray(0, passwordSize[0])");
            byte[] byArray3 = byArray2;
            String result = new String((byte[])bytes$iv, Charsets.UTF_8);
            this.getLIBRARY().SecKeychainItemFreeContent(null, pointer2);
            return result;
        }

        /*
         * WARNING - void declaration
         */
        private final void saveGenericPassword(byte[] serviceName, String accountName, byte[] password, int passwordSize) {
            void elements$iv;
            String string = accountName;
            Pointer[] pointerArray = null;
            boolean bl = true;
            Object var9_8 = null;
            if (var9_8 != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toByteArray");
            }
            if (bl & true) {
                pointerArray = Charsets.UTF_8;
            }
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes((Charset)pointerArray);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] accountNameBytes = byArray;
            pointerArray = new Pointer[]{null};
            Pointer[] itemRef = (Pointer[])((Object[])elements$iv);
            this.checkForError("find (for save)", this.getLIBRARY().SecKeychainFindGenericPassword(null, serviceName.length, serviceName, accountNameBytes.length, accountNameBytes, null, null, itemRef));
            Pointer pointer = itemRef[0];
            if (pointer == null) {
                this.checkForError("save (new)", DefaultImpls.SecKeychainAddGenericPassword$default(this.getLIBRARY(), null, serviceName.length, serviceName, accountNameBytes.length, accountNameBytes, passwordSize, password, null, 128, null));
            } else {
                this.checkForError("save (update)", this.getLIBRARY().SecKeychainItemModifyContent(pointer, null, passwordSize, password));
                this.getLIBRARY().CFRelease(pointer);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void deleteGenericPassword(@NotNull byte[] serviceName, @NotNull String accountName) {
            void elements$iv;
            Intrinsics.checkParameterIsNotNull((Object)serviceName, (String)"serviceName");
            Intrinsics.checkParameterIsNotNull((Object)accountName, (String)"accountName");
            Pointer[] pointerArray = new Pointer[]{null};
            Pointer[] itemRef = (Pointer[])((Object[])elements$iv);
            String $i$f$arrayOf = accountName;
            Charset charset = null;
            boolean bl = true;
            Object var8_8 = null;
            if (var8_8 != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toByteArray");
            }
            if (bl & true) {
                charset = Charsets.UTF_8;
            }
            String string = $i$f$arrayOf;
            if (string == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] accountNameBytes = byArray;
            this.checkForError("find (for delete)", this.getLIBRARY().SecKeychainFindGenericPassword(null, serviceName.length, serviceName, accountNameBytes.length, accountNameBytes, null, null, itemRef));
            Pointer pointer = itemRef[0];
            if (pointer != null) {
                this.checkForError("delete", this.getLIBRARY().SecKeychainItemDelete(pointer));
                this.getLIBRARY().CFRelease(pointer);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void checkForError(@NotNull String message, int code) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            if (code != 0 && code != -25300) {
                Pointer translated = this.getLIBRARY().SecCopyErrorMessageString(code, null);
                StringBuilder builder = new StringBuilder(message).append(": ");
                if (translated == null) {
                    builder.append(code);
                } else {
                    int n = 0;
                    char[] buf = new char[(int)this.getLIBRARY().CFStringGetLength(translated)];
                    int n2 = buf.length - 1;
                    if (n <= n2) {
                        while (true) {
                            void i;
                            buf[i] = this.getLIBRARY().CFStringGetCharacterAtIndex(translated, (long)i);
                            if (i == n2) break;
                            ++i;
                        }
                    }
                    this.getLIBRARY().CFRelease(translated);
                    builder.append(buf).append(" (").append(code).append(')');
                }
                CredentialsStoreKt.getLOG().error(builder.toString());
            }
        }

        private Companion() {
            Object object = Native.loadLibrary((String)"Security", OSXKeychainLibrary.class);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.keychain.OSXKeychainLibrary");
            }
            LIBRARY = (OSXKeychainLibrary)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

