/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.impl;

import com.intellij.pom.PomManager;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.PomTransaction;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nullable;

public abstract class PomTransactionBase
implements PomTransaction {
    private final PsiElement myScope;
    private final PomModelAspect myAspect;
    private final PomModelEvent myAccumulatedEvent;

    public PomTransactionBase(PsiElement scope2, PomModelAspect aspect) {
        this.myScope = scope2;
        this.myAspect = aspect;
        this.myAccumulatedEvent = new PomModelEvent(PomManager.getModel(scope2.getProject()));
    }

    public PomModelEvent getAccumulatedEvent() {
        return this.myAccumulatedEvent;
    }

    public void run() throws IncorrectOperationException {
        PomModelEvent event = this.runInner();
        if (event == null) {
            this.myAccumulatedEvent.registerChangeSet(this.myAspect, null);
            return;
        }
        this.myAccumulatedEvent.merge(event);
    }

    @Nullable
    public abstract PomModelEvent runInner() throws IncorrectOperationException;

    public PsiElement getChangeScope() {
        return this.myScope;
    }

    public PomModelAspect getTransactionAspect() {
        return this.myAspect;
    }
}

