/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiCatchSectionImpl
extends CompositePsiElement
implements PsiCatchSection,
Constants {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiCatchSectionImpl");
    private final Object myTypesCacheLock = new Object();
    private CachedValue<List<PsiType>> myTypesCache = null;

    public PsiCatchSectionImpl() {
        super(CATCH_SECTION);
    }

    @Override
    public PsiParameter getParameter() {
        return (PsiParameter)this.findChildByRoleAsPsiElement(15);
    }

    @Override
    public PsiCodeBlock getCatchBlock() {
        return (PsiCodeBlock)this.findChildByRoleAsPsiElement(49);
    }

    @Override
    public PsiType getCatchType() {
        PsiParameter parameter = this.getParameter();
        if (parameter == null) {
            return null;
        }
        return parameter.getType();
    }

    @Override
    @NotNull
    public List<PsiType> getPreciseCatchTypes() {
        PsiParameter parameter = this.getParameter();
        if (parameter == null) {
            List<PsiType> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiCatchSectionImpl", "getPreciseCatchTypes"));
            }
            return list2;
        }
        List<PsiType> list3 = this.getTypesCache().getValue();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiCatchSectionImpl", "getPreciseCatchTypes"));
        }
        return list3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCaches() {
        super.clearCaches();
        Object object = this.myTypesCacheLock;
        synchronized (object) {
            this.myTypesCache = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CachedValue<List<PsiType>> getTypesCache() {
        Object object = this.myTypesCacheLock;
        synchronized (object) {
            if (this.myTypesCache == null) {
                CachedValuesManager cacheManager = CachedValuesManager.getManager(this.getProject());
                this.myTypesCache = cacheManager.createCachedValue(new CachedValueProvider<List<PsiType>>(){

                    @Override
                    public CachedValueProvider.Result<List<PsiType>> compute() {
                        List types2 = PsiCatchSectionImpl.this.computePreciseCatchTypes(PsiCatchSectionImpl.this.getParameter());
                        return CachedValueProvider.Result.create(types2, PsiModificationTracker.MODIFICATION_COUNT);
                    }
                }, false);
            }
            return this.myTypesCache;
        }
    }

    private List<PsiType> computePreciseCatchTypes(final @Nullable PsiParameter parameter) {
        if (parameter == null) {
            return ContainerUtil.emptyList();
        }
        PsiType declaredType = parameter.getType();
        if (PsiUtil.getLanguageLevel(parameter).isAtLeast(LanguageLevel.JDK_1_7) && PsiCatchSectionImpl.isCatchParameterEffectivelyFinal(parameter, this.getCatchBlock())) {
            PsiTryStatement statement = this.getTryStatement();
            Collection<PsiClassType> thrownTypes = PsiCatchSectionImpl.getThrownTypes(statement);
            if (thrownTypes.isEmpty()) {
                return Collections.emptyList();
            }
            final PsiParameter[] parameters2 = statement.getCatchBlockParameters();
            List<PsiType> uncaughtTypes = ContainerUtil.mapNotNull(thrownTypes, new NullableFunction<PsiClassType, PsiType>(){

                @Override
                public PsiType fun(PsiClassType thrownType) {
                    for (int i = 0; i < parameters2.length && parameters2[i] != parameter; ++i) {
                        PsiType catchType = parameters2[i].getType();
                        if (!catchType.isAssignableFrom(thrownType)) continue;
                        return null;
                    }
                    return thrownType;
                }
            });
            boolean passed = true;
            for (PsiType type2 : uncaughtTypes) {
                if (declaredType.isAssignableFrom(type2)) continue;
                passed = false;
                break;
            }
            if (passed) {
                return uncaughtTypes;
            }
        }
        return Collections.singletonList(declaredType);
    }

    private static Collection<PsiClassType> getThrownTypes(@NotNull PsiTryStatement statement) {
        PsiResourceList resourceList;
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/psi/impl/source/tree/java/PsiCatchSectionImpl", "getThrownTypes"));
        }
        ArrayList<PsiClassType> types2 = ContainerUtil.newArrayList();
        PsiCodeBlock tryBlock = statement.getTryBlock();
        if (tryBlock != null) {
            types2.addAll(ExceptionUtil.getThrownExceptions(tryBlock));
        }
        if ((resourceList = statement.getResourceList()) != null) {
            types2.addAll(ExceptionUtil.getThrownExceptions(resourceList));
        }
        return types2;
    }

    private static boolean isCatchParameterEffectivelyFinal(final PsiParameter parameter, @Nullable PsiCodeBlock catchBlock) {
        final boolean[] result2 = new boolean[]{true};
        if (catchBlock != null) {
            catchBlock.accept(new JavaRecursiveElementWalkingVisitor(){

                @Override
                public void visitReferenceExpression(PsiReferenceExpression expression) {
                    super.visitReferenceExpression(expression);
                    if (expression.resolve() == parameter && PsiUtil.isAccessedForWriting(expression)) {
                        result2[0] = false;
                        this.stopWalking();
                    }
                }
            });
        }
        return result2[0];
    }

    @Override
    @NotNull
    public PsiTryStatement getTryStatement() {
        PsiTryStatement psiTryStatement = (PsiTryStatement)this.getParent();
        if (psiTryStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiCatchSectionImpl", "getTryStatement"));
        }
        return psiTryStatement;
    }

    @Override
    @Nullable
    public PsiJavaToken getLParenth() {
        return (PsiJavaToken)((Object)this.findChildByRole(50));
    }

    @Override
    @Nullable
    public PsiJavaToken getRParenth() {
        return (PsiJavaToken)((Object)this.findChildByRole(51));
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/tree/java/PsiCatchSectionImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitCatchSection(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiCatchSection";
    }

    @Override
    public ASTNode findChildByRole(int role) {
        switch (role) {
            default: {
                return null;
            }
            case 15: {
                return this.findChildByType(PARAMETER);
            }
            case 46: {
                return this.findChildByType(CATCH_KEYWORD);
            }
            case 50: {
                return this.findChildByType(LPARENTH);
            }
            case 51: {
                return this.findChildByType(RPARENTH);
            }
            case 49: 
        }
        return this.findChildByType(CODE_BLOCK);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == PARAMETER) {
            return 15;
        }
        if (i == CODE_BLOCK) {
            return 49;
        }
        if (i == CATCH_KEYWORD) {
            return 46;
        }
        if (i == LPARENTH) {
            return 50;
        }
        if (i == RPARENTH) {
            return 51;
        }
        return 0;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/source/tree/java/PsiCatchSectionImpl", "processDeclarations"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/source/tree/java/PsiCatchSectionImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/source/tree/java/PsiCatchSectionImpl", "processDeclarations"));
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, this);
        if (lastParent == null || lastParent.getParent() != this) {
            return true;
        }
        PsiParameter catchParameter = this.getParameter();
        if (catchParameter != null) {
            return processor.execute(catchParameter, state2);
        }
        return PsiScopesUtil.walkChildrenScopes(this, processor, state2, lastParent, place);
    }
}

