/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.PersistentBTreeEnumerator;
import com.intellij.util.io.PersistentEnumerator;
import com.intellij.util.io.PersistentEnumeratorBase;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentEnumeratorDelegate<Data>
implements Closeable {
    @NotNull
    protected final PersistentEnumeratorBase<Data> myEnumerator;

    public PersistentEnumeratorDelegate(@NotNull File file, @NotNull KeyDescriptor<Data> dataDescriptor, int initialSize) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/io/PersistentEnumeratorDelegate", "<init>"));
        }
        if (dataDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataDescriptor", "com/intellij/util/io/PersistentEnumeratorDelegate", "<init>"));
        }
        this(file, dataDescriptor, initialSize, null);
    }

    public PersistentEnumeratorDelegate(@NotNull File file, @NotNull KeyDescriptor<Data> dataDescriptor, int initialSize, @Nullable PagedFileStorage.StorageLockContext lockContext) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/io/PersistentEnumeratorDelegate", "<init>"));
        }
        if (dataDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataDescriptor", "com/intellij/util/io/PersistentEnumeratorDelegate", "<init>"));
        }
        this.myEnumerator = PersistentEnumeratorDelegate.useBtree() ? new PersistentBTreeEnumerator<Data>(file, dataDescriptor, initialSize, lockContext) : new PersistentEnumerator<Data>(file, dataDescriptor, initialSize);
    }

    static boolean useBtree() {
        String property = System.getProperty("idea.use.btree");
        return !"false".equals(property);
    }

    @Override
    public void close() throws IOException {
        PersistentEnumeratorBase<Data> enumerator = this.myEnumerator;
        if (enumerator != null) {
            enumerator.close();
        }
    }

    public boolean isClosed() {
        return this.myEnumerator.isClosed();
    }

    public boolean isDirty() {
        return this.myEnumerator.isDirty();
    }

    public boolean isCorrupted() {
        return this.myEnumerator.isCorrupted();
    }

    public void markCorrupted() {
        this.myEnumerator.markCorrupted();
    }

    public void force() {
        this.myEnumerator.force();
    }

    public Data valueOf(int id) throws IOException {
        return this.myEnumerator.valueOf(id);
    }

    public int enumerate(Data name) throws IOException {
        return this.myEnumerator.enumerate(name);
    }

    public int tryEnumerate(Data name) throws IOException {
        return this.myEnumerator.tryEnumerate(name);
    }

    public boolean traverseAllRecords(PersistentEnumeratorBase.RecordsProcessor recordsProcessor) throws IOException {
        return this.myEnumerator.traverseAllRecords(recordsProcessor);
    }

    public Collection<Data> getAllDataObjects(@Nullable PersistentEnumeratorBase.DataFilter filter2) throws IOException {
        return this.myEnumerator.getAllDataObjects(filter2);
    }
}

