/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.analyze;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.context.ContextKt;
import org.jetbrains.kotlin.context.ModuleContext;
import org.jetbrains.kotlin.context.MutableModuleContext;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.frontend.js.di.InjectionKt;
import org.jetbrains.kotlin.js.analyzer.JsAnalysisResult;
import org.jetbrains.kotlin.js.config.Config;
import org.jetbrains.kotlin.js.resolve.JsPlatform;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.LazyTopDownAnalyzerForTopLevel;
import org.jetbrains.kotlin.resolve.TopDownAnalysisMode;
import org.jetbrains.kotlin.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;

public final class TopDownAnalyzerFacadeForJS {
    private TopDownAnalyzerFacadeForJS() {
    }

    @NotNull
    public static JsAnalysisResult analyzeFiles(@NotNull Collection<KtFile> files, @NotNull Config config) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFiles"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFiles"));
        }
        BindingTraceContext trace = new BindingTraceContext();
        MutableModuleContext newModuleContext = ContextKt.ContextForNewModule(config.getProject(), Name.special("<" + config.getModuleId() + ">"), JsPlatform.INSTANCE);
        newModuleContext.setDependencies(TopDownAnalyzerFacadeForJS.computeDependencies(newModuleContext.getModule(), config));
        JsAnalysisResult jsAnalysisResult = TopDownAnalyzerFacadeForJS.analyzeFilesWithGivenTrace(files, trace, newModuleContext, config);
        if (jsAnalysisResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFiles"));
        }
        return jsAnalysisResult;
    }

    @NotNull
    private static List<ModuleDescriptorImpl> computeDependencies(ModuleDescriptorImpl module, @NotNull Config config) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "computeDependencies"));
        }
        ArrayList<ModuleDescriptorImpl> allDependencies = new ArrayList<ModuleDescriptorImpl>();
        allDependencies.add(module);
        allDependencies.addAll(config.getModuleDescriptors());
        allDependencies.add(JsPlatform.INSTANCE.getBuiltIns().getBuiltInsModule());
        ArrayList<ModuleDescriptorImpl> arrayList = allDependencies;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "computeDependencies"));
        }
        return arrayList;
    }

    @NotNull
    public static JsAnalysisResult analyzeFilesWithGivenTrace(@NotNull Collection<KtFile> files, @NotNull BindingTrace trace, @NotNull ModuleContext moduleContext, @NotNull Config config) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFilesWithGivenTrace"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFilesWithGivenTrace"));
        }
        if (moduleContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleContext", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFilesWithGivenTrace"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFilesWithGivenTrace"));
        }
        Collection<KtFile> allFiles = Config.withJsLibAdded(files, config);
        LazyTopDownAnalyzerForTopLevel analyzerForJs = InjectionKt.createTopDownAnalyzerForJs(moduleContext, trace, new FileBasedDeclarationProviderFactory(moduleContext.getStorageManager(), allFiles));
        analyzerForJs.analyzeFiles(TopDownAnalysisMode.TopLevelDeclarations, files, Collections.emptyList());
        JsAnalysisResult jsAnalysisResult = JsAnalysisResult.success(trace, moduleContext.getModule());
        if (jsAnalysisResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "analyzeFilesWithGivenTrace"));
        }
        return jsAnalysisResult;
    }

    public static void checkForErrors(@NotNull Collection<KtFile> allFiles, @NotNull BindingContext bindingContext) {
        if (allFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allFiles", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "checkForErrors"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS", "checkForErrors"));
        }
        AnalyzingUtils.throwExceptionOnErrors(bindingContext);
        for (KtFile file : allFiles) {
            AnalyzingUtils.checkForSyntacticErrors(file);
        }
    }
}

