/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.dataClassUtils;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0003\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"COMPONENT_FUNCTION_NAME_PREFIX", "", "createComponentName", "Lorg/jetbrains/kotlin/name/Name;", "index", "", "getComponentIndex", "componentName", "isComponentLike", "", "name", "kotlin-compiler"})
public final class DataClassUtilsKt {
    private static final String COMPONENT_FUNCTION_NAME_PREFIX = "component";

    public static final boolean isComponentLike(@NotNull Name name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        if (!StringsKt.startsWith$default(name.asString(), COMPONENT_FUNCTION_NAME_PREFIX, false, 2, null)) {
            return false;
        }
        try {
            DataClassUtilsKt.getComponentIndex(name);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static final int getComponentIndex(@NotNull Name componentName) {
        String $receiver$iv;
        Intrinsics.checkParameterIsNotNull(componentName, "componentName");
        String string = componentName.asString();
        int startIndex$iv = COMPONENT_FUNCTION_NAME_PREFIX.length();
        void v0 = $receiver$iv;
        if (v0 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = ((String)v0).substring(startIndex$iv);
        Intrinsics.checkExpressionValueIsNotNull(string2, "(this as java.lang.String).substring(startIndex)");
        $receiver$iv = string2;
        return Integer.parseInt($receiver$iv);
    }

    @NotNull
    public static final Name createComponentName(int index2) {
        Name name = Name.identifier(COMPONENT_FUNCTION_NAME_PREFIX + index2);
        Intrinsics.checkExpressionValueIsNotNull(name, "Name.identifier(COMPONEN\u2026TION_NAME_PREFIX + index)");
        return name;
    }

    static {
        COMPONENT_FUNCTION_NAME_PREFIX = COMPONENT_FUNCTION_NAME_PREFIX;
    }
}

