/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.org.objectweb.asm.commons;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.org.objectweb.asm.Type;

public class Method {
    private final String name;
    private final String desc;
    private static final Map<String, String> DESCRIPTORS = new HashMap<String, String>();

    public Method(String name, String desc) {
        this.name = name;
        this.desc = desc;
    }

    public Method(String name, Type returnType2, Type[] argumentTypes) {
        this(name, Type.getMethodDescriptor(returnType2, argumentTypes));
    }

    public String getName() {
        return this.name;
    }

    public String getDescriptor() {
        return this.desc;
    }

    public Type getReturnType() {
        return Type.getReturnType(this.desc);
    }

    public Type[] getArgumentTypes() {
        return Type.getArgumentTypes(this.desc);
    }

    public String toString() {
        return this.name + this.desc;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Method)) {
            return false;
        }
        Method other = (Method)o;
        return this.name.equals(other.name) && this.desc.equals(other.desc);
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.desc.hashCode();
    }

    static {
        DESCRIPTORS.put("void", "V");
        DESCRIPTORS.put("byte", "B");
        DESCRIPTORS.put("char", "C");
        DESCRIPTORS.put("double", "D");
        DESCRIPTORS.put("float", "F");
        DESCRIPTORS.put("int", "I");
        DESCRIPTORS.put("long", "J");
        DESCRIPTORS.put("short", "S");
        DESCRIPTORS.put("boolean", "Z");
    }
}

