/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.SVGShapeElementBridge;
import org.apache.batik.dom.svg.AbstractSVGAnimatedLength;
import org.apache.batik.dom.svg.AnimatedLiveAttributeValue;
import org.apache.batik.dom.svg.LiveAttributeException;
import org.apache.batik.dom.svg.SVGOMEllipseElement;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.gvt.ShapePainter;
import org.w3c.dom.Element;

public class SVGEllipseElementBridge
extends SVGShapeElementBridge {
    @Override
    public String getLocalName() {
        return "ellipse";
    }

    @Override
    public Bridge getInstance() {
        return new SVGEllipseElementBridge();
    }

    @Override
    protected void buildShape(BridgeContext bridgeContext, Element element, ShapeNode shapeNode) {
        try {
            SVGOMEllipseElement sVGOMEllipseElement = (SVGOMEllipseElement)element;
            AbstractSVGAnimatedLength abstractSVGAnimatedLength = (AbstractSVGAnimatedLength)sVGOMEllipseElement.getCx();
            float f = abstractSVGAnimatedLength.getCheckedValue();
            AbstractSVGAnimatedLength abstractSVGAnimatedLength2 = (AbstractSVGAnimatedLength)sVGOMEllipseElement.getCy();
            float f2 = abstractSVGAnimatedLength2.getCheckedValue();
            AbstractSVGAnimatedLength abstractSVGAnimatedLength3 = (AbstractSVGAnimatedLength)sVGOMEllipseElement.getRx();
            float f3 = abstractSVGAnimatedLength3.getCheckedValue();
            AbstractSVGAnimatedLength abstractSVGAnimatedLength4 = (AbstractSVGAnimatedLength)sVGOMEllipseElement.getRy();
            float f4 = abstractSVGAnimatedLength4.getCheckedValue();
            shapeNode.setShape(new Ellipse2D.Float(f - f3, f2 - f4, f3 * 2.0f, f4 * 2.0f));
        }
        catch (LiveAttributeException liveAttributeException) {
            throw new BridgeException(bridgeContext, liveAttributeException);
        }
    }

    @Override
    public void handleAnimatedAttributeChanged(AnimatedLiveAttributeValue animatedLiveAttributeValue) {
        String string;
        if (animatedLiveAttributeValue.getNamespaceURI() == null && ((string = animatedLiveAttributeValue.getLocalName()).equals("cx") || string.equals("cy") || string.equals("rx") || string.equals("ry"))) {
            this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
            this.handleGeometryChanged();
            return;
        }
        super.handleAnimatedAttributeChanged(animatedLiveAttributeValue);
    }

    @Override
    protected ShapePainter createShapePainter(BridgeContext bridgeContext, Element element, ShapeNode shapeNode) {
        Rectangle2D rectangle2D = shapeNode.getShape().getBounds2D();
        if (rectangle2D.getWidth() == 0.0 || rectangle2D.getHeight() == 0.0) {
            return null;
        }
        return super.createShapePainter(bridgeContext, element, shapeNode);
    }
}

