/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.NestedCopyInfo;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.StatusReceiver;
import org.jetbrains.idea.svn.SvnFileUrlMapping;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusType;
import org.tmatesoft.svn.core.SVNURL;

public class NestedCopiesBuilder
implements StatusReceiver {
    @NotNull
    private final Set<NestedCopyInfo> myCopies;
    @NotNull
    private final SvnFileUrlMapping myMapping;
    @NotNull
    private final SvnVcs myVcs;

    public NestedCopiesBuilder(@NotNull SvnVcs vcs, @NotNull SvnFileUrlMapping mapping) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/NestedCopiesBuilder", "<init>"));
        }
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "org/jetbrains/idea/svn/NestedCopiesBuilder", "<init>"));
        }
        this.myVcs = vcs;
        this.myMapping = mapping;
        this.myCopies = ContainerUtil.newHashSet();
    }

    @Override
    public void process(@NotNull FilePath path, Status status) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/NestedCopiesBuilder", "process"));
        }
        VirtualFile file = path.getVirtualFile();
        if (file != null) {
            if (status.is(StatusType.STATUS_EXTERNAL)) {
                this.myCopies.add(new NestedCopyInfo(file, null, WorkingCopyFormat.UNKNOWN, NestedCopyType.external, null));
            } else if (status.getURL() != null && !status.is(StatusType.STATUS_UNVERSIONED) && status.isSwitched()) {
                this.myCopies.add(new NestedCopyInfo(file, status.getURL(), this.myVcs.getWorkingCopyFormat(path.getIOFile()), NestedCopyType.switched, status.getRepositoryRootURL()));
            }
        }
    }

    @Override
    public void processIgnored(VirtualFile vFile) {
    }

    @Override
    public void processUnversioned(VirtualFile vFile) {
    }

    @Override
    public void processCopyRoot(@NotNull VirtualFile file, @Nullable SVNURL url, @NotNull WorkingCopyFormat format, @Nullable SVNURL rootURL) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/NestedCopiesBuilder", "processCopyRoot"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "org/jetbrains/idea/svn/NestedCopiesBuilder", "processCopyRoot"));
        }
        this.myCopies.add(new NestedCopyInfo(file, url, format, NestedCopyType.inner, rootURL));
    }

    @Override
    public void bewareRoot(@NotNull VirtualFile vf, SVNURL url) {
        if (vf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vf", "org/jetbrains/idea/svn/NestedCopiesBuilder", "bewareRoot"));
        }
        File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)vf);
        RootUrlInfo info = this.myMapping.getWcRootForFilePath(ioFile);
        if (info != null && FileUtil.filesEqual((File)ioFile, (File)info.getIoFile()) && !info.getAbsoluteUrlAsUrl().equals((Object)url)) {
            this.myVcs.invokeRefreshSvnRoots();
        }
    }

    @Override
    public void finish() {
    }

    @NotNull
    public Set<NestedCopyInfo> getCopies() {
        Set<NestedCopyInfo> set = this.myCopies;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/NestedCopiesBuilder", "getCopies"));
        }
        return set;
    }
}

