/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.change.ChangeListClient;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.status.Status;
import org.tmatesoft.svn.core.SVNErrorCode;

public class SvnChangelistListener
implements ChangeListListener {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.SvnChangelistListener");
    @NotNull
    private final SvnVcs myVcs;
    @NotNull
    private final Condition<FilePath> myUnderSvnCondition;

    public SvnChangelistListener(@NotNull SvnVcs vcs) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/SvnChangelistListener", "<init>"));
        }
        this.myVcs = vcs;
        this.myUnderSvnCondition = new Condition<FilePath>(){

            public boolean value(@NotNull FilePath path) {
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/SvnChangelistListener$1", "value"));
                }
                AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)SvnChangelistListener.this.myVcs.getProject()).getVcsFor(path);
                return vcs != null && "svn".equals(vcs.getName());
            }
        };
    }

    public void changeListAdded(ChangeList list) {
    }

    public void changesRemoved(Collection<Change> changes, ChangeList fromList) {
        if (LocalChangeList.DEFAULT_NAME.equals(fromList.getName())) {
            return;
        }
        this.removeFromChangeList(changes);
    }

    public void changesAdded(Collection<Change> changes, ChangeList toList) {
        if (toList == null || LocalChangeList.DEFAULT_NAME.equals(toList.getName())) {
            return;
        }
        this.addToChangeList(toList.getName(), changes);
    }

    public void changeListRemoved(ChangeList list) {
        this.removeFromChangeList(list.getChanges());
    }

    @NotNull
    private List<FilePath> getPathsFromChanges(@NotNull Collection<Change> changes) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "org/jetbrains/idea/svn/SvnChangelistListener", "getPathsFromChanges"));
        }
        List list = ContainerUtil.findAll((Collection)ChangesUtil.getPaths(changes), this.myUnderSvnCondition);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnChangelistListener", "getPathsFromChanges"));
        }
        return list;
    }

    public void changeListChanged(ChangeList list) {
    }

    public void changeListRenamed(ChangeList list, String oldName) {
        if (Comparing.equal((String)list.getName(), (String)oldName)) {
            return;
        }
        if (LocalChangeList.DEFAULT_NAME.equals(list.getName())) {
            this.changeListRemoved(list);
            return;
        }
        this.addToChangeList(list.getName(), list.getChanges());
    }

    public void changeListCommentChanged(ChangeList list, String oldComment) {
    }

    public void changesMoved(Collection<Change> changes, ChangeList fromList, ChangeList toList) {
        String[] stringArray;
        if (fromList.getName().equals(toList.getName())) {
            return;
        }
        if (LocalChangeList.DEFAULT_NAME.equals(toList.getName())) {
            this.changeListRemoved(toList);
            return;
        }
        if (LocalChangeList.DEFAULT_NAME.equals(fromList.getName())) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = fromList.getName();
        }
        String[] fromLists = stringArray;
        this.addToChangeList(toList.getName(), changes, fromLists);
    }

    public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList) {
    }

    public void unchangedFileStatusChanged() {
    }

    public void changeListUpdateDone() {
    }

    @Nullable
    public static String getCurrentMapping(@NotNull SvnVcs vcs, @NotNull File file) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/SvnChangelistListener", "getCurrentMapping"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/SvnChangelistListener", "getCurrentMapping"));
        }
        try {
            Status status = vcs.getFactory(file).createStatusClient().doStatus(file, false);
            return status == null ? null : status.getChangelistName();
        }
        catch (SvnBindException e) {
            if (e.contains(SVNErrorCode.WC_NOT_DIRECTORY) || e.contains(SVNErrorCode.WC_NOT_FILE)) {
                LOG.debug("Logging only, exception is valid (caught) here", (Throwable)((Object)e));
            } else {
                LOG.info("Logging only, exception is valid (caught) here", (Throwable)((Object)e));
            }
            return null;
        }
    }

    public static void putUnderList(@NotNull SvnVcs vcs, @NotNull String list, @NotNull File after) throws VcsException {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/SvnChangelistListener", "putUnderList"));
        }
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/idea/svn/SvnChangelistListener", "putUnderList"));
        }
        if (after == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "after", "org/jetbrains/idea/svn/SvnChangelistListener", "putUnderList"));
        }
        SvnChangelistListener.doChangeListOperation(vcs, after, (ThrowableConsumer<ChangeListClient, VcsException>)((ThrowableConsumer)client -> {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/idea/svn/SvnChangelistListener", "lambda$putUnderList$0"));
            }
            if (after == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "after", "org/jetbrains/idea/svn/SvnChangelistListener", "lambda$putUnderList$0"));
            }
            client.add(list, after, null);
        }));
    }

    public static void removeFromList(@NotNull SvnVcs vcs, @NotNull File after) throws VcsException {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/SvnChangelistListener", "removeFromList"));
        }
        if (after == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "after", "org/jetbrains/idea/svn/SvnChangelistListener", "removeFromList"));
        }
        SvnChangelistListener.doChangeListOperation(vcs, after, (ThrowableConsumer<ChangeListClient, VcsException>)((ThrowableConsumer)client -> {
            if (after == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "after", "org/jetbrains/idea/svn/SvnChangelistListener", "lambda$removeFromList$1"));
            }
            client.remove(after);
        }));
    }

    private static void doChangeListOperation(@NotNull SvnVcs vcs, @NotNull File file, @NotNull ThrowableConsumer<ChangeListClient, VcsException> operation) throws VcsException {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/SvnChangelistListener", "doChangeListOperation"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/SvnChangelistListener", "doChangeListOperation"));
        }
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "org/jetbrains/idea/svn/SvnChangelistListener", "doChangeListOperation"));
        }
        try {
            operation.consume((Object)vcs.getFactory(file).createChangeListClient());
        }
        catch (SvnBindException e) {
            LOG.info((Throwable)((Object)e));
            if (!e.contains(SVNErrorCode.WC_NOT_DIRECTORY) && !e.contains(SVNErrorCode.WC_NOT_FILE)) {
                throw e;
            }
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
            throw e;
        }
    }

    private void removeFromChangeList(@NotNull Collection<Change> changes) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "org/jetbrains/idea/svn/SvnChangelistListener", "removeFromChangeList"));
        }
        for (FilePath path : this.getPathsFromChanges(changes)) {
            try {
                File file = path.getIOFile();
                this.myVcs.getFactory(file).createChangeListClient().remove(file);
            }
            catch (VcsException e) {
                LOG.info((Throwable)e);
            }
        }
    }

    private void addToChangeList(@NotNull String changeList, @NotNull Collection<Change> changes) {
        if (changeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "org/jetbrains/idea/svn/SvnChangelistListener", "addToChangeList"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "org/jetbrains/idea/svn/SvnChangelistListener", "addToChangeList"));
        }
        this.addToChangeList(changeList, changes, null);
    }

    private void addToChangeList(@NotNull String changeList, @NotNull Collection<Change> changes, @Nullable String[] changeListsToOperate) {
        if (changeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "org/jetbrains/idea/svn/SvnChangelistListener", "addToChangeList"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "org/jetbrains/idea/svn/SvnChangelistListener", "addToChangeList"));
        }
        for (FilePath path : this.getPathsFromChanges(changes)) {
            try {
                File file = path.getIOFile();
                this.myVcs.getFactory(file).createChangeListClient().add(changeList, file, changeListsToOperate);
            }
            catch (VcsException e) {
                LOG.info((Throwable)e);
            }
        }
    }
}

