/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.TaskDescriptor;
import com.intellij.util.continuation.Where;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.integrate.BaseMergeTask;
import org.jetbrains.idea.svn.integrate.MergeAllOrSelectedChooserTask;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.integrate.QuickMergeInteraction;

public class CheckRepositorySupportsMergeInfoTask
extends BaseMergeTask {
    public CheckRepositorySupportsMergeInfoTask(@NotNull MergeContext mergeContext, @NotNull QuickMergeInteraction interaction) {
        if (mergeContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeContext", "org/jetbrains/idea/svn/integrate/CheckRepositorySupportsMergeInfoTask", "<init>"));
        }
        if (interaction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interaction", "org/jetbrains/idea/svn/integrate/CheckRepositorySupportsMergeInfoTask", "<init>"));
        }
        super(mergeContext, interaction, "Checking repository capabilities", Where.POOLED);
    }

    public void run(ContinuationContext context) {
        context.next(this.supportsMergeInfo() ? this.getChooseMergeTypeTasks() : this.getMergeAllTasks());
    }

    private boolean supportsMergeInfo() {
        return this.myMergeContext.getWcInfo().getFormat().supportsMergeInfo() && SvnUtil.checkRepositoryVersion15(this.myMergeContext.getVcs(), this.myMergeContext.getSourceUrl());
    }

    @NotNull
    private List<TaskDescriptor> getChooseMergeTypeTasks() {
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])new TaskDescriptor[]{new MergeAllOrSelectedChooserTask(this.myMergeContext, this.myInteraction)});
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/CheckRepositorySupportsMergeInfoTask", "getChooseMergeTypeTasks"));
        }
        return arrayList;
    }
}

