/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.lib.cvsclient.IClientEnvironment;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.CvsFile;
import org.netbeans.lib.cvsclient.command.CvsFiles;
import org.netbeans.lib.cvsclient.command.LocalFiles;
import org.netbeans.lib.cvsclient.file.AbstractFileObject;
import org.netbeans.lib.cvsclient.file.DirectoryObject;
import org.netbeans.lib.cvsclient.file.FileObject;
import org.netbeans.lib.cvsclient.util.BugLog;

final class FileSystemScanner {
    private final IClientEnvironment clientEnvironment;
    private final boolean recursive;

    public FileSystemScanner(IClientEnvironment clientEnvironment, boolean recursive) {
        BugLog.getInstance().assertNotNull(clientEnvironment);
        this.clientEnvironment = clientEnvironment;
        this.recursive = recursive;
    }

    public void scan(List<AbstractFileObject> abstractFileObjects, CvsFiles cvsFiles) throws IOException {
        cvsFiles.clear();
        if (abstractFileObjects.size() == 0) {
            this.scanDirectories(DirectoryObject.getRoot(), cvsFiles);
        } else {
            for (AbstractFileObject fileOrDirectory : abstractFileObjects) {
                if (fileOrDirectory instanceof DirectoryObject) {
                    DirectoryObject directoryObject = (DirectoryObject)fileOrDirectory;
                    this.scanDirectories(directoryObject, cvsFiles);
                    continue;
                }
                if (!(fileOrDirectory instanceof FileObject)) continue;
                FileObject fileObject = (FileObject)fileOrDirectory;
                this.addRequestsForFile(fileObject, cvsFiles);
            }
        }
    }

    private void scanDirectories(DirectoryObject rootDirectoryObject, CvsFiles cvsFiles) throws IOException {
        LinkedList<DirectoryObject> directories = new LinkedList<DirectoryObject>();
        directories.add(rootDirectoryObject);
        while (directories.size() > 0) {
            DirectoryObject directoryObject = (DirectoryObject)directories.remove(0);
            List<DirectoryObject> subDirectories = this.scanDirectory(directoryObject, cvsFiles);
            if (!this.recursive) continue;
            directories.addAll(subDirectories);
        }
    }

    private List<DirectoryObject> scanDirectory(DirectoryObject directoryObject, CvsFiles cvsFiles) throws IOException {
        if (!this.clientEnvironment.getLocalFileReader().exists(directoryObject, this.clientEnvironment.getCvsFileSystem())) {
            return Collections.emptyList();
        }
        cvsFiles.add(CvsFile.createCvsDirectory(directoryObject));
        HashSet<String> subDirectoryNames = new HashSet<String>();
        LocalFiles localFiles = new LocalFiles(directoryObject, this.clientEnvironment);
        Collection<Entry> entries = this.clientEnvironment.getAdminReader().getEntries(directoryObject, this.clientEnvironment.getCvsFileSystem());
        for (Entry entry : entries) {
            if (entry.isDirectory()) {
                subDirectoryNames.add(entry.getFileName());
                continue;
            }
            FileObject fileObject = FileObject.createInstance(directoryObject, entry.getFileName());
            boolean fileExists = this.clientEnvironment.getLocalFileReader().exists(fileObject, this.clientEnvironment.getCvsFileSystem());
            cvsFiles.add(CvsFile.createCvsFileForEntry(fileObject, entry, fileExists));
            localFiles.removeFile(entry.getFileName());
        }
        for (String fileName : localFiles.getFileNames()) {
            cvsFiles.add(CvsFile.createCvsFileForExistingFile(FileObject.createInstance(directoryObject, fileName)));
        }
        ArrayList<DirectoryObject> subDirectories = new ArrayList<DirectoryObject>(subDirectoryNames.size());
        for (String directoryName : subDirectoryNames) {
            subDirectories.add(DirectoryObject.createInstance(directoryObject, directoryName));
        }
        return subDirectories;
    }

    private void addRequestsForFile(FileObject fileObject, CvsFiles cvsFiles) throws IOException {
        cvsFiles.add(CvsFile.createCvsDirectory(fileObject.getParent()));
        Entry entry = this.clientEnvironment.getAdminReader().getEntry(fileObject, this.clientEnvironment.getCvsFileSystem());
        if (entry != null) {
            boolean exists = this.clientEnvironment.getLocalFileReader().exists(fileObject, this.clientEnvironment.getCvsFileSystem());
            cvsFiles.add(CvsFile.createCvsFileForEntry(fileObject, entry, exists));
        }
    }
}

