/*
 * Decompiled with CFR 0.152.
 */
package git4idea.reset;

import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.ui.VcsLogOneCommitPerRepoAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.vcs.log.VcsFullCommitDetails;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.reset.GitNewResetDialog;
import git4idea.reset.GitResetMode;
import git4idea.reset.GitResetOperation;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitResetAction
extends VcsLogOneCommitPerRepoAction<GitRepository> {
    @NotNull
    protected AbstractRepositoryManager<GitRepository> getRepositoryManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/reset/GitResetAction", "getRepositoryManager"));
        }
        AbstractRepositoryManager abstractRepositoryManager = (AbstractRepositoryManager)ServiceManager.getService((Project)project, GitRepositoryManager.class);
        if (abstractRepositoryManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/reset/GitResetAction", "getRepositoryManager"));
        }
        return abstractRepositoryManager;
    }

    @Nullable
    protected GitRepository getRepositoryForRoot(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/reset/GitResetAction", "getRepositoryForRoot"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/reset/GitResetAction", "getRepositoryForRoot"));
        }
        return (GitRepository)this.getRepositoryManager(project).getRepositoryForRoot(root);
    }

    protected void actionPerformed(final @NotNull Project project, final @NotNull Map<GitRepository, VcsFullCommitDetails> commits) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/reset/GitResetAction", "actionPerformed"));
        }
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "git4idea/reset/GitResetAction", "actionPerformed"));
        }
        GitVcsSettings settings = GitVcsSettings.getInstance(project);
        GitResetMode defaultMode = (GitResetMode)((Object)ObjectUtils.notNull((Object)((Object)settings.getResetMode()), (Object)((Object)GitResetMode.getDefault())));
        GitNewResetDialog dialog = new GitNewResetDialog(project, commits, defaultMode);
        if (dialog.showAndGet()) {
            final GitResetMode selectedMode = dialog.getResetMode();
            settings.setResetMode(selectedMode);
            new Task.Backgroundable(project, "Git reset", true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/reset/GitResetAction$1", "run"));
                    }
                    new GitResetOperation(project, commits, selectedMode, indicator).execute();
                }
            }.queue();
        }
    }
}

