/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.util.Map;
import javajs.awt.Font;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.T3;
import org.jmol.export.UseTable;
import org.jmol.export._VrmlExporter;
import org.jmol.java.BS;
import org.jmol.viewer.Viewer;

public class _X3dExporter
extends _VrmlExporter {
    public _X3dExporter() {
        this.useTable = new UseTable("USE='");
    }

    @Override
    protected void outputHeader() {
        this.output("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
        this.output("<!DOCTYPE X3D PUBLIC \"ISO//Web3D//DTD X3D 3.1//EN\" \"http://www.web3d.org/specifications/x3d-3.1.dtd\">\n");
        this.output("<X3D profile='Immersive' version='3.1' xmlns:xsd='http://www.w3.org/2001/XMLSchema-instance' xsd:noNamespaceSchemaLocation=' http://www.web3d.org/specifications/x3d-3.1.xsd '>\n");
        this.output("<head>\n");
        this.output("<meta name='title' content=" + PT.esc(this.vwr.ms.modelSetName).replace('<', ' ').replace('>', ' ').replace('&', ' ') + "/>\n");
        this.output("<meta name='description' content='Jmol rendering'/>\n");
        this.output("<meta name='creator' content=' '/>\n");
        this.output("<meta name='created' content='" + this.getExportDate() + "'/>\n");
        this.output("<meta name='generator' content='Jmol " + Viewer.getJmolVersion() + ", http://www.jmol.org'/>\n");
        this.output("<meta name='license' content='http://www.gnu.org/licenses/licenses.html#LGPL'/>\n");
        this.output("</head>\n");
        this.output("<Scene>\n");
        this.output("<NavigationInfo type='EXAMINE'/>\n");
        this.output("<Background skyColor='" + this.rgbFractionalFromColix(this.backgroundColix) + "'/>\n");
        float f = this.getViewpoint();
        this.output("<Viewpoint fieldOfView='" + f);
        this.output("' position='");
        this.output(this.cameraPosition);
        this.output("' orientation='");
        this.output(this.tempP1);
        this.output(" " + -this.viewpoint.angle + "'\n jump='true' description='v1'/>\n");
        this.output("\n  <!-- ");
        this.output(this.getJmolPerspective());
        this.output("\n  -->\n\n");
        this.output("<Transform translation='");
        this.tempP1.setT(this.center);
        this.tempP1.scale(-1.0f);
        this.output(this.tempP1);
        this.output("'>\n");
    }

    @Override
    protected void outputFooter() {
        this.useTable = null;
        this.output("</Transform>\n");
        this.output("</Scene>\n");
        this.output("</X3D>\n");
    }

    @Override
    protected void outputAppearance(short s, boolean bl) {
        String string = this.useTable.getDef((bl ? "T" : "") + s);
        this.output("<Appearance ");
        if (string.charAt(0) == '_') {
            String string2 = this.rgbFractionalFromColix(s);
            this.output("DEF='" + string + "'><Material diffuseColor='");
            if (bl) {
                this.output("0 0 0' specularColor='0 0 0' ambientIntensity='0.0' shininess='0.0' emissiveColor='" + string2 + "'/>");
            } else {
                this.output(string2 + "' transparency='" + _X3dExporter.translucencyFractionalFromColix(s) + "'/>");
            }
        } else {
            this.output(string + ">");
        }
        this.output("</Appearance>");
    }

    @Override
    protected void outputTransRot(P3 p3, P3 p32, int n, int n2, int n3) {
        this.output(" ");
        this.outputTransRot(p3, p32, n, n2, n3, "='", "'");
    }

    @Override
    protected void outputCircle(P3 p3, P3 p32, float f, short s, boolean bl) {
        if (bl) {
            this.output("<Transform translation='");
            this.tempV1.ave(this.tempP3, p3);
            this.output(this.tempV1);
            this.output("'><Billboard axisOfRotation='0 0 0'><Transform rotation='1 0 0 1.5708'>");
            this.outputCylinderChildScaled(p3, this.tempP3, s, (byte)2, f);
            this.output("</Transform></Billboard>");
            this.output("</Transform>\n");
            return;
        }
        String string = this.useTable.getDef("C" + s + "_" + f);
        this.output("<Transform");
        this.outputTransRot(this.tempP3, p3, 0, 0, 1);
        this.tempP3.set(1.0f, 1.0f, 1.0f);
        this.tempP3.scale(f);
        this.output(" scale='");
        this.output(this.tempP3);
        this.output("'>\n<Billboard ");
        if (string.charAt(0) == '_') {
            int n;
            this.output("DEF='" + string + "'");
            this.output(" axisOfRotation='0 0 0'><Transform>");
            this.output("<Shape><Extrusion beginCap='false' convex='false' endCap='false' creaseAngle='1.57'");
            this.output(" crossSection='");
            float f2 = (float)Math.PI / 180;
            float f3 = 0.02f / f;
            for (n = 0; n <= 360; n += 10) {
                this.output(_X3dExporter.round(Math.cos((float)n * f2) * (double)f3) + " ");
                this.output(_X3dExporter.round(Math.sin((float)n * f2) * (double)f3) + " ");
            }
            this.output("' spine='");
            for (n = 0; n <= 360; n += 10) {
                this.output(_X3dExporter.round(Math.cos((float)n * f2)) + " ");
                this.output(_X3dExporter.round(Math.sin((float)n * f2)) + " 0 ");
            }
            this.output("'/>");
            this.outputAppearance(s, false);
            this.output("</Shape></Transform>");
        } else {
            this.output(string + ">");
        }
        this.output("</Billboard>\n");
        this.output("</Transform>\n");
    }

    @Override
    protected void outputCone(P3 p3, P3 p32, float f, short s) {
        f = this.scale(f);
        float f2 = this.scale(p3.distance(p32));
        this.output("<Transform");
        this.outputTransRot(p3, p32, 0, 1, 0);
        this.output(">\n<Shape ");
        String string = "o" + (int)(f2 * 100.0f) + "_" + (int)(f * 100.0f);
        String string2 = this.useTable.getDef("c" + string + "_" + s);
        if (string2.charAt(0) == '_') {
            this.output("DEF='" + string2 + "'>");
            string = this.useTable.getDef(string);
            this.output("<Cone ");
            if (string.charAt(0) == '_') {
                this.output("DEF='" + string + "' height='" + _X3dExporter.round(f2) + "' bottomRadius='" + _X3dExporter.round(f) + "'/>");
            } else {
                this.output(string + "/>");
            }
            this.outputAppearance(s, false);
        } else {
            this.output(string2 + ">");
        }
        this.output("</Shape>\n");
        this.output("</Transform>\n");
    }

    @Override
    protected boolean outputCylinder(P3 p3, P3 p32, P3 p33, short s, byte by, float f, P3 p34, P3 p35, boolean bl) {
        this.output("<Transform");
        if (p34 == null) {
            this.outputTransRot(p32, p33, 0, 1, 0);
        } else {
            this.output(" translation='");
            this.output(p3);
            this.output("'");
            this.outputQuaternionFrame(p3, p35, p32, p34, 2.0f, "='", "'");
            p32.set(0.0f, 0.0f, -1.0f);
            p33.set(0.0f, 0.0f, 1.0f);
        }
        this.output(">\n");
        this.outputCylinderChildScaled(p32, p33, s, by, f);
        this.output("\n</Transform>\n");
        if (by == 3) {
            this.outputSphere(p32, f * 1.01f, s, true);
            this.outputSphere(p33, f * 1.01f, s, true);
        }
        return true;
    }

    @Override
    protected void outputCylinderChildScaled(P3 p3, P3 p32, short s, byte by, float f) {
        float f2 = this.scale(p3.distance(p32));
        f = this.scale(f);
        String string = this.useTable.getDef("C" + s + "_" + (int)(f2 * 100.0f) + "_" + f + "_" + by);
        this.output("<Shape ");
        if (string.charAt(0) == '_') {
            this.output("DEF='" + string + "'>");
            this.output("<Cylinder ");
            String string2 = this.useTable.getDef("c" + _X3dExporter.round(f2) + "_" + by + "_" + f);
            if (string2.charAt(0) == '_') {
                this.output("DEF='" + string2 + "' height='" + _X3dExporter.round(f2) + "' radius='" + f + "'" + (by == 2 ? "" : " top='false' bottom='false'") + "/>");
            } else {
                this.output(string2 + "/>");
            }
            this.outputAppearance(s, false);
        } else {
            this.output(string + ">");
        }
        this.output("</Shape>");
    }

    @Override
    protected void outputEllipsoid(P3 p3, P3[] p3Array, short s) {
        this.output("<Transform translation='");
        this.output(p3);
        this.output("'");
        this.outputQuaternionFrame(p3, p3Array[1], p3Array[3], p3Array[5], 1.0f, "='", "'");
        this.output(">");
        this.tempP3.set(0.0f, 0.0f, 0.0f);
        this.outputSphereChildUnscaled(this.tempP3, 1.0f, s);
        this.output("</Transform>\n");
    }

    @Override
    protected void outputSphereChildUnscaled(T3 t3, float f, short s) {
        this.output("<Transform translation='");
        this.output(t3);
        this.output("'>\n<Shape ");
        String string = this.useTable.getDef("S" + s + "_" + (int)(f * 100.0f));
        if (string.charAt(0) == '_') {
            this.output("DEF='" + string + "'>");
            this.output("<Sphere radius='" + f + "'/>");
            this.outputAppearance(s, false);
        } else {
            this.output(string + ">");
        }
        this.output("</Shape>\n");
        this.output("</Transform>\n");
    }

    @Override
    protected void outputSurface(T3[] t3Array, T3[] t3Array2, short[] sArray, int[][] nArray, short[] sArray2, int n, int n2, int n3, BS bS, int n4, short s, Lst<Short> lst, Map<Short, Integer> map, P3 p3) {
        this.output("<Shape>\n");
        this.outputAppearance(s, false);
        this.output("<IndexedFaceSet \n");
        if (sArray2 != null) {
            this.output(" colorPerVertex='false'\n");
        }
        this.output("coordIndex='\n");
        int[] nArray2 = new int[n];
        this.getCoordinateMap(t3Array, nArray2, null);
        this.outputIndices(nArray, nArray2, n2, bS, n4);
        this.output("'\n");
        Lst<String> lst2 = null;
        if (t3Array2 != null) {
            lst2 = new Lst<String>();
            nArray2 = this.getNormalMap(t3Array2, n, null, lst2);
            this.output("  solid='false'\n  normalPerVertex='true'\n  normalIndex='\n");
            this.outputIndices(nArray, nArray2, n2, bS, n4);
            this.output("'\n");
        }
        nArray2 = null;
        if (lst != null) {
            this.output("  colorIndex='\n");
            this.outputColorIndices(nArray, n2, bS, n4, map, sArray, sArray2);
            this.output("'\n");
        }
        this.output(">\n");
        this.output("<Coordinate point='\n");
        this.outputVertices(t3Array, n, p3);
        this.output("'/>\n");
        if (t3Array2 != null) {
            this.output("<Normal vector='\n");
            this.outputNormals(lst2);
            lst2 = null;
            this.output("'/>\n");
        }
        if (lst != null) {
            this.output("<Color color='\n");
            this.outputColors(lst);
            this.output("'/>\n");
        }
        this.output("</IndexedFaceSet>\n");
        this.output("</Shape>\n");
    }

    @Override
    protected void outputTriangle(T3 t3, T3 t32, T3 t33, short s) {
        this.output("<Shape>\n");
        this.output("<IndexedFaceSet solid='false' ");
        this.output("coordIndex='0 1 2 -1'>");
        this.output("<Coordinate point='");
        this.output(t3);
        this.output(" ");
        this.output(t32);
        this.output(" ");
        this.output(t33);
        this.output("'/>");
        this.output("</IndexedFaceSet>\n");
        this.outputAppearance(s, false);
        this.output("\n</Shape>\n");
    }

    @Override
    protected void outputTextPixel(P3 p3, int n) {
    }

    @Override
    void plotText(int n, int n2, int n3, short s, String string, Font font) {
        this.output("<Transform translation='");
        this.output(this.setFont(n, n2, n3, s, string, font));
        this.output("'>");
        this.output("<Billboard ");
        if (this.fontChild.charAt(0) == '_') {
            this.output("DEF='" + this.fontChild + "' axisOfRotation='0 0 0'>" + "<Transform translation='0.0 0.0 0.0'>" + "<Shape>");
            this.outputAppearance(s, true);
            this.output("<Text string=" + PT.esc(string) + ">");
            this.output("<FontStyle ");
            String string2 = this.useTable.getDef("F" + this.fontFace + this.fontStyle);
            if (string2.charAt(0) == '_') {
                this.output("DEF='" + string2 + "' size='" + this.fontSize + "' family='" + this.fontFace + "' style='" + this.fontStyle + "'/>");
            } else {
                this.output(string2 + "/>");
            }
            this.output("</Text>");
            this.output("</Shape>");
            this.output("</Transform>");
        } else {
            this.output(this.fontChild + ">");
        }
        this.output("</Billboard>\n");
        this.output("</Transform>\n");
    }
}

