/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.SB;
import org.jmol.java.BS;
import org.jmol.smiles.InvalidSmilesException;
import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesBond;
import org.jmol.smiles.SmilesParser;
import org.jmol.smiles.SmilesSearch;
import org.jmol.smiles.SmilesStereo;
import org.jmol.smiles.VTemp;
import org.jmol.util.BNode;
import org.jmol.util.BSUtil;
import org.jmol.util.Edge;
import org.jmol.util.Elements;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.util.Node;

public class SmilesGenerator {
    private Node[] atoms;
    private int ac;
    private BS bsSelected;
    private BS bsAromatic;
    private int flags;
    private boolean explicitH;
    private SB ringSets;
    private VTemp vTemp = new VTemp();
    private int nPairs;
    private int nPairsMax;
    private BS bsBondsUp = new BS();
    private BS bsBondsDn = new BS();
    private BS bsToDo;
    private Node prevAtom;
    private Node[] prevSp2Atoms;
    private Map<String, Object[]> htRingsSequence = new Hashtable<String, Object[]>();
    private Map<String, Object[]> htRings = new Hashtable<String, Object[]>();
    private BS bsRingKeys = new BS();
    private BS bsIncludingH;
    private boolean topologyOnly;
    boolean getAromatic = true;
    private boolean addAtomComment;
    private boolean noBioComment;
    private boolean noStereo;
    private boolean openSMILES;
    public P3 stereoReference;
    private SmilesStereo smilesStereo;
    private boolean isPolyhedral;
    private Lst<BS> aromaticRings;
    private Node[] atemp;

    String getSmiles(Node[] nodeArray, int n, BS bS, String string, int n2) throws InvalidSmilesException {
        int n3 = bS.nextSetBit(0);
        if (n3 < 0) {
            return "";
        }
        this.flags = n2;
        this.atoms = nodeArray;
        this.ac = n;
        bS = BSUtil.copy(bS);
        if ((n2 & 0x100000) == 0x100000) {
            return this.getBioSmiles(bS, string, n2);
        }
        this.bsSelected = bS;
        this.flags = n2 = SmilesSearch.addFlags(n2, string == null ? "" : string.toUpperCase());
        this.openSMILES = (n2 & 5) == 5;
        this.addAtomComment = (n2 & 0x20000) == 131072;
        this.explicitH = (n2 & 0x1000) == 4096;
        this.topologyOnly = (n2 & 0x2000) == 8192;
        this.getAromatic = (n2 & 0x4000) != 16384;
        this.noStereo = (n2 & 0x8000) == 32768;
        this.isPolyhedral = (n2 & 0x10000) == 65536;
        return this.getSmilesComponent(nodeArray[n3], bS, true, false, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getBioSmiles(BS bS, String string, int n) throws InvalidSmilesException {
        String string2;
        SB sB;
        boolean bl;
        boolean bl2;
        block26: {
            this.addAtomComment = (n & 0x20000) == 131072;
            bl2 = (n & 0x300000) == 0x300000;
            bl = (n & 0x2100000) == 0x2100000;
            boolean bl3 = (n & 0x500000) == 0x500000;
            boolean bl4 = (n & 0x900000) == 0x900000;
            boolean bl5 = bl3 || bl4;
            sB = new SB();
            BS bS2 = bS;
            if (string != null && !this.noBioComment) {
                sB.append("//* Jmol bioSMILES ").append(string.replace('*', '_')).append(" *//");
            }
            String string3 = this.noBioComment ? "" : "\n";
            BS bS3 = new BS();
            String string4 = null;
            String string5 = "";
            Lst<Integer> lst = new Lst<Integer>();
            try {
                int n2 = 0;
                int n3 = bS2.nextSetBit(0);
                while (n3 >= 0) {
                    block25: {
                        int n4;
                        boolean bl6;
                        String string6;
                        String string7;
                        BNode bNode;
                        block27: {
                            block28: {
                                bNode = (BNode)this.atoms[n3];
                                string7 = bNode.getGroup1('?');
                                string6 = bNode.getBioStructureTypeName();
                                boolean bl7 = bl6 = string7 == string7.toLowerCase();
                                if (string3 == null) break block27;
                                if (sB.length() > 0) {
                                    sB.append(string3);
                                }
                                string3 = null;
                                n2 = 0;
                                if (string6.length() > 0) break block28;
                                string2 = this.getSmilesComponent(bNode, bS2, false, true, true);
                                if (string2.equals(string4)) {
                                    string3 = "";
                                    break block25;
                                } else {
                                    String string8;
                                    string4 = string2;
                                    String string9 = bNode.getGroup3(true);
                                    if (bl) {
                                        string8 = "/" + string2 + "/";
                                    } else {
                                        if (string9 != null) {
                                            string2 = "//* " + string9 + " *//" + string2;
                                        }
                                        string8 = string2 + "//";
                                    }
                                    if (string5.indexOf(string8) >= 0) {
                                        string3 = "";
                                        break block25;
                                    } else {
                                        string5 = string5 + string8;
                                        sB.append(string2);
                                        string3 = bl ? "." : ".\n";
                                    }
                                }
                                break block25;
                            }
                            n4 = bNode.getChainID();
                            if (n4 != 0 && !bl) {
                                string2 = "//* chain " + bNode.getChainIDStr() + " " + string6 + " " + bNode.getResno() + " *// ";
                                n2 = string2.length();
                                sB.append(string2);
                            }
                            ++n2;
                            sB.append("~").appendC(string6.toLowerCase().charAt(0)).append("~");
                        }
                        if (n2 >= 75 && !bl) {
                            sB.append("\n  ");
                            n2 = 2;
                        }
                        if (this.addAtomComment) {
                            sB.append("\n//* [" + bNode.getGroup3(false) + "#" + bNode.getResno() + "] *//\t");
                        }
                        if (bl6) {
                            this.addBracketedBioName(sB, bNode, string6.length() > 0 ? ".0" : null, false);
                        } else {
                            sB.append(string7);
                        }
                        ++n2;
                        if (bl5) {
                            bNode.getCrossLinkVector(lst, bl3, bl4);
                            for (n4 = 0; n4 < lst.size(); n2 += 1 + string2.length(), n4 += 3) {
                                sB.append(":");
                                string2 = this.getRingCache((Integer)lst.get(n4), (Integer)lst.get(n4 + 1), this.htRingsSequence);
                                sB.append(string2);
                            }
                            lst.clear();
                        }
                        bNode.getGroupBits(bS3);
                        bS2.andNot(bS3);
                        n4 = bNode.getOffsetResidueAtom("\u0000", 1);
                        if (n4 < 0 || !bS2.get(n4)) {
                            if (!bl) {
                                sB.append(" //* ").appendI(bNode.getResno()).append(" *//");
                            }
                            if (n4 < 0 && (n4 = bS2.nextSetBit(n3 + 1)) < 0) break block26;
                            if (n2 > 0) {
                                string3 = bl ? "." : ".\n";
                            }
                        }
                        n3 = n4 - 1;
                    }
                    n3 = bS2.nextSetBit(n3 + 1);
                }
            }
            catch (Exception exception) {
                throw new InvalidSmilesException("//* error: " + exception.getMessage() + " *//");
            }
        }
        if (!bl2 && !this.htRingsSequence.isEmpty()) {
            this.dumpRingKeys(sB, this.htRingsSequence);
            throw new InvalidSmilesException("//* ?ring error? *//");
        }
        string2 = sB.toString();
        if (string2.endsWith(".\n")) {
            return string2.substring(0, string2.length() - 2);
        }
        if (!bl) return string2;
        if (!string2.endsWith(".")) return string2;
        return string2.substring(0, string2.length() - 1);
    }

    private void addBracketedBioName(SB sB, Node node, String string, boolean bl) {
        sB.append("[");
        if (string != null && node instanceof BNode) {
            BNode bNode = (BNode)node;
            String string2 = bNode.getChainIDStr();
            sB.append(bNode.getGroup3(false));
            if (!string.equals(".0")) {
                sB.append(string).append("#").appendI(bNode.getElementNumber());
            }
            if (bl) {
                sB.append("//* ").appendI(bNode.getResno());
                if (string2.length() > 0) {
                    sB.append(":").append(string2);
                }
                sB.append(" *//");
            }
        } else {
            sB.append(Elements.elementNameFromNumber(node.getElementNumber()));
        }
        sB.append("]");
    }

    private String getSmilesComponent(Node node, BS bS, boolean bl, boolean bl2, boolean bl3) throws InvalidSmilesException {
        Lst<type>[] lstArray;
        if (!this.explicitH && node.getElementNumber() == 1 && node.getEdges().length > 0) {
            node = this.atoms[node.getBondedAtomIndex(0)];
        }
        this.bsSelected = JmolMolecule.getBranchBitSet(this.atoms, node.getIndex(), BSUtil.copy(bS), null, -1, true, bl);
        bS.andNot(this.bsSelected);
        this.bsIncludingH = BSUtil.copy(this.bsSelected);
        if (!this.explicitH) {
            int n = this.bsSelected.nextSetBit(0);
            while (n >= 0) {
                lstArray = this.atoms[n];
                if (lstArray.getElementNumber() == 1 && lstArray.getIsotopeNumber() == 0) {
                    this.bsSelected.clear(n);
                }
                n = this.bsSelected.nextSetBit(n + 1);
            }
        }
        if (this.getAromatic && !this.topologyOnly && this.bsSelected.cardinality() > 2) {
            SmilesSearch smilesSearch = SmilesParser.getMolecule("A[=&@]A", true);
            smilesSearch.jmolAtoms = this.atoms;
            if (this.atoms instanceof BNode[]) {
                smilesSearch.bioAtoms = (BNode[])this.atoms;
            }
            smilesSearch.setSelected(this.bsSelected);
            smilesSearch.jmolAtomCount = this.ac;
            smilesSearch.ringDataMax = 7;
            smilesSearch.flags = this.flags;
            lstArray = AU.createArrayOfArrayList(4);
            smilesSearch.setRingData(null, lstArray, true);
            this.bsAromatic = smilesSearch.bsAromatic;
            this.ringSets = smilesSearch.ringSets;
            this.aromaticRings = lstArray[3];
            this.setBondDirections();
        } else {
            this.bsAromatic = new BS();
        }
        this.bsToDo = BSUtil.copy(this.bsSelected);
        SB sB = new SB();
        int n = this.bsToDo.nextSetBit(0);
        while (n >= 0) {
            if (this.atoms[n].getCovalentBondCount() > 4 || this.isPolyhedral) {
                if (node == null) {
                    sB.append(".");
                }
                this.getSmilesAt(sB, this.atoms[n], bl2, false, this.explicitH, bl3);
                node = null;
            }
            n = this.bsToDo.nextSetBit(n + 1);
        }
        if (node != null) {
            while ((node = this.getSmilesAt(sB, node, bl2, true, this.explicitH, bl3)) != null) {
            }
        }
        while (this.bsToDo.cardinality() > 0 || !this.htRings.isEmpty()) {
            Iterator<Object[]> iterator = this.htRings.values().iterator();
            if (iterator.hasNext()) {
                node = this.atoms[(Integer)iterator.next()[1]];
                if (!this.bsToDo.get(node.getIndex())) {
                    break;
                }
            } else {
                node = this.atoms[this.bsToDo.nextSetBit(0)];
            }
            sB.append(".");
            this.prevSp2Atoms = null;
            this.prevAtom = null;
            while ((node = this.getSmilesAt(sB, node, bl2, true, this.explicitH, bl3)) != null) {
            }
        }
        if (!this.htRings.isEmpty()) {
            this.dumpRingKeys(sB, this.htRings);
            throw new InvalidSmilesException("//* ?ring error? *//\n" + sB);
        }
        return sB.toString();
    }

    private char getBondStereochemistry(Edge edge, Node node) {
        boolean bl;
        if (edge == null) {
            return '\u0000';
        }
        int n = edge.index;
        boolean bl2 = bl = node == null || edge.getAtomIndex1() == node.getIndex();
        return (char)(this.bsBondsUp.get(n) ? (bl ? 47 : 92) : (this.bsBondsDn.get(n) ? (bl ? 92 : 47) : 0));
    }

    private void setBondDirections() {
        BS bS = new BS();
        Edge[][] edgeArray = new Edge[2][3];
        int n = this.bsSelected.nextSetBit(0);
        while (n >= 0) {
            Node node = this.atoms[n];
            Edge[] edgeArray2 = node.getEdges();
            for (int i = 0; i < edgeArray2.length; ++i) {
                char c;
                Object object;
                Object object2;
                Node node2;
                Edge edge = edgeArray2[i];
                int n2 = edge.index;
                if (bS.get(n2) || edge.getCovalentOrder() != 2 || SmilesSearch.isRingBond(this.ringSets, n, (node2 = edge.getOtherAtomNode(node)).getIndex())) continue;
                bS.set(n2);
                int n3 = 0;
                Node node3 = node;
                while (node2.getBondCount() == 2 && node2.getValence() == 4) {
                    object = object2[(object2 = node2.getEdges())[0].getOtherAtomNode(node2) == node3 ? 1 : 0];
                    bS.set(((Edge)object).index);
                    node3 = node2;
                    node2 = ((Edge)object).getOtherAtomNode(node2);
                    ++n3;
                }
                if (n3 % 2 == 1) continue;
                object2 = null;
                object = null;
                char c2 = '\u0000';
                Node[] nodeArray = new Node[]{node, node2};
                if (Logger.debugging) {
                    Logger.debug(node + " == " + node2);
                }
                int n4 = 1;
                for (c = '\u0000'; c < '\u0002' && n4 > 0 && n4 < 3; ++c) {
                    n4 = 0;
                    Node node4 = nodeArray[c];
                    Edge[] edgeArray3 = node4.getEdges();
                    for (int j = 0; j < edgeArray3.length; ++j) {
                        if (edgeArray3[j].getCovalentOrder() != 1 || edgeArray3[j].getOtherAtomNode(node4).getElementNumber() == 1) continue;
                        edgeArray[c][n4++] = edgeArray3[j];
                        if (this.getBondStereochemistry(edgeArray3[j], node4) == '\u0000') continue;
                        object2 = edgeArray3[j];
                        c2 = c;
                    }
                }
                if (n4 == 3 || n4 == 0) continue;
                if (object2 == null) {
                    c2 = '\u0000';
                    object2 = edgeArray[c2][0];
                    this.bsBondsUp.set(((Edge)object2).index);
                }
                c = this.getBondStereochemistry((Edge)object2, nodeArray[c2]);
                object = ((Edge)object2).getOtherAtomNode(nodeArray[c2]);
                if (object == null) continue;
                for (int j = 0; j < 2; ++j) {
                    for (int k = 0; k < 2; ++k) {
                        Edge edge2 = edgeArray[j][k];
                        if (edge2 == null || edge2 == object2) continue;
                        int n5 = edge2.index;
                        Node node5 = edge2.getOtherAtomNode(nodeArray[j]);
                        if (node5 == null) continue;
                        char c3 = this.getBondStereochemistry(edge2, nodeArray[j]);
                        boolean bl = SmilesStereo.isDiaxial(nodeArray[c2], nodeArray[j], (Node)object, node5, this.vTemp, 0.0f);
                        if (c3 == '\u0000' || c3 != c == bl) {
                            boolean bl2 = c == '\\' && bl || c == '/' && !bl;
                            if (bl2 == (edge2.getAtomIndex1() != node5.getIndex())) {
                                this.bsBondsUp.set(n5);
                            } else {
                                this.bsBondsDn.set(n5);
                            }
                        } else {
                            Logger.error("BOND STEREOCHEMISTRY ERROR");
                        }
                        if (!Logger.debugging) continue;
                        Logger.debug(this.getBondStereochemistry((Edge)object2, nodeArray[0]) + " " + object.getIndex() + " " + node5.getIndex() + " " + this.getBondStereochemistry(edge2, nodeArray[j]));
                    }
                }
            }
            n = this.bsSelected.nextSetBit(n + 1);
        }
    }

    private Node getSmilesAt(SB sB, Node node, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        String string;
        int n;
        Object object;
        int n2;
        char c;
        int n3;
        Object object2;
        int n4 = node.getIndex();
        if (!this.bsToDo.get(n4)) {
            return null;
        }
        this.bsToDo.clear(n4);
        boolean bl5 = !this.bsSelected.get(n4);
        int n5 = this.prevAtom == null ? -1 : this.prevAtom.getIndex();
        boolean bl6 = this.bsAromatic.get(n4);
        boolean bl7 = this.prevSp2Atoms != null;
        Node[] nodeArray = this.prevSp2Atoms;
        int n6 = 0;
        int n7 = node.getElementNumber();
        int n8 = 0;
        Lst<Edge> lst = new Lst<Edge>();
        Edge edge = null;
        Edge edge2 = null;
        Edge[] edgeArray = node.getEdges();
        if (this.stereoReference != null) {
            bl2 = false;
            this.sortBonds(node, this.prevAtom, this.stereoReference);
        }
        Object object3 = null;
        int n9 = bl6 ? 10 : 0;
        Node[] nodeArray2 = new Node[7];
        if (Logger.debugging) {
            Logger.debug(sB.toString());
        }
        if (edgeArray != null) {
            int n10 = edgeArray.length;
            while (--n10 >= 0) {
                boolean bl8;
                Edge edge3 = edgeArray[n10];
                if (!edge3.isCovalent()) continue;
                object2 = edgeArray[n10].getOtherAtomNode(node);
                n3 = object2.getIndex();
                if (n3 == n5) {
                    edge2 = edgeArray[n10];
                    continue;
                }
                boolean bl9 = bl8 = !bl3 && object2.getElementNumber() == 1 && object2.getIsotopeNumber() == 0;
                if (!this.bsIncludingH.get(n3)) {
                    if (bl8 || !bl || !this.bsSelected.get(n4)) continue;
                    this.bsToDo.set(n3);
                }
                if (bl8) {
                    object3 = object2;
                    if (++n8 <= 1) continue;
                    n9 = 10;
                    continue;
                }
                lst.addLast(edgeArray[n10]);
            }
        }
        String string2 = null;
        if (nodeArray == null) {
            nodeArray = new Node[5];
        }
        if (edge2 != null) {
            string2 = this.getBondOrder(edge2, n4, n5, bl6);
            if (this.prevSp2Atoms == null) {
                nodeArray[n6++] = this.prevAtom;
            } else {
                n6 = 2;
            }
        }
        n6 += n8;
        char c2 = '\u0000';
        object2 = new BS();
        if (bl2) {
            for (n3 = 0; n3 < lst.size(); ++n3) {
                Edge edge4 = (Edge)lst.get(n3);
                Node node2 = edge4.getOtherAtomNode(node);
                c = node2.getCovalentBondCount() - (bl3 ? 0 : node2.getCovalentHydrogenCount());
                int n11 = edge4.getCovalentOrder();
                if (n11 == 1 && c == '\u0001' && n3 < lst.size() - (edge == null ? 1 : 0)) {
                    ((BS)object2).set(edge4.index);
                    continue;
                }
                if (n11 <= 1 && c <= c2 || this.htRings.containsKey(SmilesGenerator.getRingKey(node2.getIndex(), n4))) continue;
                c2 = n11 > 1 ? 1000 + n11 : c;
                edge = edge4;
            }
        }
        Node node3 = edge == null ? null : edge.getOtherAtomNode(node);
        int n12 = n2 = edge == null ? 0 : edge.getCovalentOrder();
        if (bl6 || n2 == 2 && n8 > 1 || node3 != null && SmilesSearch.isRingBond(this.ringSets, n4, node3.getIndex())) {
            nodeArray = null;
        }
        if (n9 < 7 && edge2 != null) {
            if (edge2.getCovalentOrder() == 2 && n2 == 2 && this.prevSp2Atoms != null && this.prevSp2Atoms[1] != null) {
                nodeArray2[n9++] = this.prevSp2Atoms[0];
                nodeArray2[n9++] = this.prevSp2Atoms[1];
            } else {
                nodeArray2[n9++] = this.prevAtom;
            }
        }
        if (n9 < 7 && n8 == 1) {
            nodeArray2[n9++] = object3;
        }
        boolean bl10 = n2 == 1 && this.prevSp2Atoms == null;
        c = this.getBondStereochemistry(edge2, this.prevAtom);
        if (string2 != null || c != '\u0000') {
            if (c != '\u0000') {
                string2 = "" + c;
            }
            sB.append(string2);
        }
        SB sB2 = new SB();
        int n13 = n9;
        int n14 = n6;
        for (int i = 0; i < lst.size(); ++i) {
            Edge edge5 = (Edge)lst.get(i);
            if (!((BS)object2).get(edge5.index)) continue;
            Node node4 = edge5.getOtherAtomNode(node);
            object = new SB();
            ((SB)object).append("(");
            this.prevAtom = node;
            this.prevSp2Atoms = null;
            Edge edge6 = edge;
            this.getSmilesAt((SB)object, node4, bl, bl2, bl3, bl4);
            edge = edge6;
            ((SB)object).append(")");
            if (sB2.indexOf(((SB)object).toString()) >= 0) {
                n9 = 10;
            }
            sB2.appendSB((SB)object);
            lst.remove(i--);
            if (n9 < 7) {
                nodeArray2[n9++] = node4;
            }
            if (nodeArray == null || n6 >= 5) continue;
            nodeArray[n6++] = node4;
        }
        SB sB3 = new SB();
        int n15 = n9;
        int n16 = n6;
        object = null;
        if (!(bl2 || this.noStereo || this.stereoReference != null || lst.size() != 5 && lst.size() != 6)) {
            object = this.sortInorganic(node, lst, this.vTemp);
        }
        for (n = 0; n < lst.size(); ++n) {
            Edge edge7 = (Edge)lst.get(n);
            if (edge7 == edge) continue;
            Node node5 = edge7.getOtherAtomNode(node);
            string2 = this.getBondOrder(edge7, n4, node5.getIndex(), bl6);
            if (!bl10 && (c = (char)this.getBondStereochemistry(edge7, node)) != '\u0000') {
                string2 = "" + c;
            }
            sB3.append(string2);
            sB3.append(this.getRingCache(n4, node5.getIndex(), this.htRings));
            if (n9 < 7) {
                nodeArray2[n9++] = node5;
            }
            if (nodeArray == null || n6 >= 5) continue;
            nodeArray[n6++] = node5;
        }
        if (n13 != n15 && n15 != n9) {
            this.swapArray(nodeArray2, n13, n15, n9);
        }
        if (nodeArray != null && n14 != n16 && n16 != n6) {
            this.swapArray(nodeArray, n14, n16, n6);
        }
        if (bl7 && n9 == 2 && n2 == 2 && node3.getCovalentBondCount() == 3) {
            edgeArray = node3.getEdges();
            for (n = 0; n < edgeArray.length; ++n) {
                if (!edgeArray[n].isCovalent() || node3.getBondedAtomIndex(n) == n4) continue;
                nodeArray2[n9++] = this.atoms[node3.getBondedAtomIndex(n)];
            }
            n6 = 0;
        } else if (node3 != null && n9 < 7) {
            nodeArray2[n9++] = node3;
        }
        n = node.getFormalCharge();
        int n17 = node.getIsotopeNumber();
        int n18 = node.getValence();
        float f = this.openSMILES ? node.getFloatProperty("property_atomclass") : 0.0f;
        String string3 = node.getAtomName();
        String string4 = string = node instanceof BNode ? ((BNode)node).getBioStructureTypeName() : "";
        if (this.addAtomComment) {
            sB.append("\n//* " + node.toString() + " *//\t");
        }
        if (this.topologyOnly) {
            sB.append("*");
        } else if (bl5 && string.length() != 0 && string3.length() != 0) {
            this.addBracketedBioName(sB, node, "." + string3, false);
        } else {
            sB.append(SmilesAtom.getAtomLabel(n7, n17, bl4 ? -1 : n18, n, f, n8, bl6, (String)(object != null ? object : (this.noStereo ? null : this.checkStereoPairs(node, n4, nodeArray2, n9)))));
        }
        sB.appendSB(sB3).appendSB(sB2);
        System.out.println(sB);
        if (edge == null) {
            return null;
        }
        if (nodeArray != null && n2 == 2 && (n6 == 1 || n6 == 2)) {
            if (nodeArray[0] == null) {
                nodeArray[0] = node;
            }
            if (nodeArray[1] == null) {
                nodeArray[1] = node;
            }
        } else {
            nodeArray = null;
            n6 = 0;
        }
        this.prevSp2Atoms = nodeArray;
        this.prevAtom = node;
        return node3;
    }

    private void swapArray(Node[] nodeArray, int n, int n2, int n3) {
        int n4 = n2 - n;
        if (this.atemp == null || this.atemp.length < n4) {
            this.atemp = new Node[n4];
        }
        int n5 = n4;
        int n6 = n2;
        while (n5 > 0) {
            this.atemp[--n5] = nodeArray[--n6];
        }
        for (n5 = n2; n5 < n3; ++n5) {
            nodeArray[n5 - n4] = nodeArray[n5];
        }
        n5 = n4;
        n6 = n3;
        while (n5 > 0) {
            nodeArray[--n6] = this.atemp[--n5];
        }
    }

    private String getBondOrder(Edge edge, int n, int n2, boolean bl) {
        int n3 = edge.getCovalentOrder();
        return !bl || !this.bsAromatic.get(n2) ? SmilesBond.getBondOrderString(n3) : (n3 == 1 && !this.isSameAromaticRing(n, n2) ? "-" : "");
    }

    private boolean isSameAromaticRing(int n, int n2) {
        int n3 = this.aromaticRings.size();
        while (--n3 >= 0) {
            BS bS = (BS)this.aromaticRings.get(n3);
            if (!bS.get(n) || !bS.get(n2)) continue;
            return true;
        }
        return false;
    }

    void sortBonds(Node node, Node node2, P3 p3) {
        if (this.smilesStereo == null) {
            try {
                this.smilesStereo = SmilesStereo.newStereo(null);
            }
            catch (InvalidSmilesException invalidSmilesException) {
                // empty catch block
            }
        }
        this.smilesStereo.sortBondsByStereo(node, node2, p3, node.getEdges(), this.vTemp.vA);
    }

    private String sortInorganic(Node node, Lst<Edge> lst, VTemp vTemp) {
        int n;
        Edge edge;
        int n2;
        int n3 = node.getIndex();
        int n4 = lst.size();
        Lst<Edge[]> lst2 = new Lst<Edge[]>();
        Lst<Edge> lst3 = new Lst<Edge>();
        Node node2 = null;
        Node node3 = null;
        BS bS = new BS();
        Edge[] edgeArray = null;
        Node[] nodeArray = new Node[6];
        boolean bl = true;
        String string = "";
        int n5 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            Node node4;
            edge = (Edge)lst.get(n2);
            nodeArray[0] = node4 = edge.getOtherAtomNode(node);
            if (n2 == 0) {
                string = this.addStereoCheck(n3, nodeArray, 0, "");
            } else if (bl && this.addStereoCheck(n3, nodeArray, 0, string) != null) {
                bl = false;
            }
            if (bS.get(n2)) continue;
            bS.set(n2);
            n = 0;
            for (int i = n2 + 1; i < n4; ++i) {
                Edge edge2;
                Node node5;
                if (bS.get(i) || !SmilesStereo.isDiaxial(node, node, node4, node5 = (edge2 = (Edge)lst.get(i)).getOtherAtomNode(node), vTemp, -0.95f)) continue;
                switch (++n5) {
                    case 1: {
                        node2 = node4;
                        break;
                    }
                    case 2: {
                        node3 = node4;
                        break;
                    }
                    case 3: {
                        if (SmilesStereo.getHandedness(node3, node2, node4, node, vTemp) != 2) break;
                        Edge edge3 = edge;
                        edge = edge2;
                        edge2 = edge3;
                    }
                }
                lst2.addLast(new Edge[]{edge, edge2});
                n = 1;
                bS.set(i);
                break;
            }
            if (n != 0) continue;
            lst3.addLast(edge);
        }
        n2 = lst2.size();
        if (bl || n4 == 6 && n2 != 3 || n4 == 5 && n2 == 0) {
            return "";
        }
        edgeArray = (Edge[])lst2.get(0);
        edge = edgeArray[0];
        nodeArray[0] = edge.getOtherAtomNode(node);
        lst.clear();
        lst.addLast(edge);
        if (n2 > 1) {
            lst3.addLast(((Edge[])lst2.get(1))[0]);
        }
        if (n2 == 3) {
            lst3.addLast(((Edge[])lst2.get(2))[0]);
        }
        if (n2 > 1) {
            lst3.addLast(((Edge[])lst2.get(1))[1]);
        }
        if (n2 == 3) {
            lst3.addLast(((Edge[])lst2.get(2))[1]);
        }
        for (n = 0; n < lst3.size(); ++n) {
            edge = (Edge)lst3.get(n);
            lst.addLast(edge);
            nodeArray[n + 1] = edge.getOtherAtomNode(node);
        }
        lst.addLast(edgeArray[1]);
        nodeArray[n4 - 1] = edgeArray[1].getOtherAtomNode(node);
        return SmilesStereo.getStereoFlag(node, nodeArray, n4, vTemp);
    }

    private String checkStereoPairs(Node node, int n, Node[] nodeArray, int n2) {
        if (n2 < 4) {
            return "";
        }
        if (n2 == 4 && node.getElementNumber() == 6) {
            String string = "";
            for (int i = 0; i < 4; ++i) {
                if ((string = this.addStereoCheck(n, nodeArray, i, string)) != null) continue;
                n2 = 10;
                break;
            }
        }
        return n2 > 6 ? "" : SmilesStereo.getStereoFlag(node, nodeArray, n2, this.vTemp);
    }

    private String addStereoCheck(int n, Node[] nodeArray, int n2, String string) {
        int n3;
        int n4 = nodeArray[n2].getAtomicAndIsotopeNumber();
        int n5 = nodeArray[n2].getCovalentBondCount();
        int n6 = n3 = n4 == 6 && !this.explicitH ? nodeArray[n2].getCovalentHydrogenCount() : 0;
        if (n4 == 6 ? n5 != 4 || n3 != 3 : n5 > 1) {
            return string;
        }
        String string2 = ";" + n4 + "/" + n3 + "/" + n5 + ",";
        if (string.indexOf(string2) >= 0) {
            if (n3 == 3) {
                int n7 = 0;
                for (int i = 0; i < n5 && n7 < 3; ++i) {
                    int n8 = nodeArray[n2].getBondedAtomIndex(i);
                    if (n8 == n) continue;
                    n7 += this.atoms[n8].getAtomicAndIsotopeNumber();
                }
                if (n7 > 3) {
                    return string;
                }
            }
            return null;
        }
        return string + string2;
    }

    private String getRingCache(int n, int n2, Map<String, Object[]> map) {
        String string;
        String string2 = SmilesGenerator.getRingKey(n, n2);
        Object[] objectArray = map.get(string2);
        String string3 = string = objectArray == null ? null : (String)objectArray[0];
        if (string == null) {
            this.bsRingKeys.set(++this.nPairs);
            this.nPairsMax = Math.max(this.nPairs, this.nPairsMax);
            Object[] objectArray2 = new Object[3];
            string = this.getRingPointer(this.nPairs);
            objectArray2[0] = string;
            objectArray2[1] = n2;
            objectArray2[2] = this.nPairs;
            map.put(string2, objectArray2);
            if (Logger.debugging) {
                Logger.debug("adding for " + n + " ring key " + this.nPairs + ": " + string2);
            }
        } else {
            map.remove(string2);
            int n3 = (Integer)objectArray[2];
            this.bsRingKeys.clear(n3);
            if (this.bsRingKeys.nextSetBit(0) < 0 && (this.nPairsMax == 2 || this.nPairsMax == 99)) {
                this.nPairs = this.nPairsMax == 99 ? 10 : 0;
                this.nPairsMax = this.nPairs;
            }
            if (Logger.debugging) {
                Logger.debug("using ring key " + string2);
            }
        }
        return string;
    }

    private String getRingPointer(int n) {
        return n < 10 ? "" + n : (n < 100 ? "%" + n : "%(" + n + ")");
    }

    private void dumpRingKeys(SB sB, Map<String, Object[]> map) {
        Logger.info(sB.toString() + "\n\n");
        for (String string : map.keySet()) {
            Logger.info("unmatched ring key: " + string);
        }
    }

    protected static String getRingKey(int n, int n2) {
        return Math.min(n, n2) + "_" + Math.max(n, n2);
    }
}

