/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.Map;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.Quat;
import org.jmol.c.STR;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.Structure;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.modelsetbio.Resolver;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.JC;

public abstract class Monomer
extends Group {
    public BioPolymer bioPolymer;
    protected byte[] offsets;
    int monomerIndex = -1;
    private float phi = Float.NaN;
    private float psi = Float.NaN;
    private float omega = Float.NaN;
    private float straightness = Float.NaN;
    private float mu = Float.NaN;
    private float theta = Float.NaN;

    protected static boolean have(byte[] byArray, byte by) {
        return (byArray[by] & 0xFF) != 255;
    }

    protected Monomer set2(Chain chain, String string, int n, int n2, int n3, byte[] byArray) {
        this.setGroup(chain, string, n, n2, n3);
        this.offsets = byArray;
        this.setLeadAtomIndex();
        return this;
    }

    protected void setLeadAtomIndex() {
        int n = this.offsets[0] & 0xFF;
        if (n != 255) {
            this.leadAtomIndex = this.firstAtomIndex + n;
        }
    }

    void setBioPolymer(BioPolymer bioPolymer, int n) {
        this.bioPolymer = bioPolymer;
        this.monomerIndex = n;
    }

    @Override
    public int getSelectedMonomerCount() {
        return this.bioPolymer == null ? 0 : this.bioPolymer.getSelectedMonomerCount();
    }

    @Override
    public int getSelectedMonomerIndex() {
        return this.bioPolymer == null || !this.bioPolymer.isMonomerSelected(this.monomerIndex) ? -1 : this.monomerIndex;
    }

    @Override
    public int getBioPolymerLength() {
        return this.bioPolymer == null ? 0 : this.bioPolymer.monomerCount;
    }

    @Override
    public int getMonomerIndex() {
        return this.monomerIndex;
    }

    @Override
    public int getAtomIndex(String string, int n) {
        if (this.bioPolymer != null) {
            Monomer[] monomerArray = this.bioPolymer.monomers;
            int n2 = this.monomerIndex + n;
            if (n2 >= 0 && n2 < monomerArray.length) {
                Monomer monomer = monomerArray[n2];
                if (n == 1 && !((Group)monomer).isConnectedPrevious()) {
                    return -1;
                }
                if ("\u0000".equals(string)) {
                    return monomer.leadAtomIndex;
                }
                Atom[] atomArray = this.chain.model.ms.at;
                for (int i = monomer.firstAtomIndex; i <= monomer.lastAtomIndex; ++i) {
                    if (string != null && !string.equalsIgnoreCase(atomArray[i].getAtomName())) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    @Override
    public int getBioPolymerIndexInModel() {
        return this.bioPolymer == null ? -1 : this.bioPolymer.bioPolymerIndexInModel;
    }

    protected static byte[] scanForOffsets(int n, int[] nArray, byte[] byArray) {
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2];
        int n3 = n2;
        while (--n3 >= 0) {
            int n4;
            int n5;
            byte by = byArray[n3];
            if (by < 0) {
                n5 = nArray[~by];
            } else {
                n5 = nArray[by];
                if (n5 < 0) {
                    return null;
                }
            }
            if (n5 < 0) {
                n4 = 255;
            } else {
                n4 = n5 - n;
                if (n4 < 0 || n4 > 254) {
                    Logger.warn("Monomer.scanForOffsets i=" + n3 + " atomID=" + by + " atomIndex:" + n5 + " firstAtomIndex:" + n + " offset out of 0-254 range. Groups aren't organized correctly. Is this really a protein?: " + n4);
                    if (by < 0) {
                        n4 = 255;
                    }
                }
            }
            byArray2[n3] = (byte)n4;
        }
        return byArray2;
    }

    @Override
    public STR getProteinStructureType() {
        return STR.NONE;
    }

    public boolean isHelix() {
        return false;
    }

    public boolean isSheet() {
        return false;
    }

    @Override
    public void setStrucNo(int n) {
    }

    protected final Atom getAtomFromOffsetIndex(int n) {
        if (n > this.offsets.length) {
            return null;
        }
        int n2 = this.offsets[n] & 0xFF;
        return n2 == 255 ? null : this.chain.model.ms.at[this.firstAtomIndex + n2];
    }

    protected final Atom getSpecialAtom(byte[] byArray, byte by) {
        int n = byArray.length;
        while (--n >= 0) {
            byte by2 = byArray[n];
            if (by2 < 0) {
                by2 = -by2;
            }
            if (by != by2) continue;
            int n2 = this.offsets[n] & 0xFF;
            return n2 == 255 ? null : this.chain.model.ms.at[this.firstAtomIndex + n2];
        }
        return null;
    }

    protected final P3 getSpecialAtomPoint(byte[] byArray, byte by) {
        int n = byArray.length;
        while (--n >= 0) {
            byte by2 = byArray[n];
            if (by2 < 0) {
                by2 = -by2;
            }
            if (by != by2) continue;
            int n2 = this.offsets[n] & 0xFF;
            return n2 == 255 ? null : this.chain.model.ms.at[this.firstAtomIndex + n2];
        }
        return null;
    }

    @Override
    public boolean isLeadAtom(int n) {
        return n == this.leadAtomIndex;
    }

    @Override
    public final Atom getLeadAtom() {
        return this.getAtomFromOffsetIndex(0);
    }

    public final Atom getWingAtom() {
        return this.getAtomFromOffsetIndex(1);
    }

    Atom getInitiatorAtom() {
        return this.getLeadAtom();
    }

    Atom getTerminatorAtom() {
        return this.getLeadAtom();
    }

    abstract boolean isConnectedAfter(Monomer var1);

    void findNearestAtomIndex(int n, int n2, Atom[] atomArray, short s, short s2) {
    }

    public Map<String, Object> getMyInfo(P3 p3) {
        Structure structure;
        float f;
        char c;
        Map<String, Object> map = this.getGroupInfo(this.groupIndex, p3);
        map.put("chain", this.chain.getIDStr());
        int n = this.getResno();
        if (n > 0) {
            map.put("sequenceNumber", n);
        }
        if ((c = this.getInsertionCode()) != '\u0000') {
            map.put("insertionCode", "" + c);
        }
        if (!Float.isNaN(f = this.getGroupParameter(1111490569))) {
            map.put("phi", Float.valueOf(f));
        }
        if (!Float.isNaN(f = this.getGroupParameter(1111490570))) {
            map.put("psi", Float.valueOf(f));
        }
        if (!Float.isNaN(f = this.getGroupParameter(1111490565))) {
            map.put("mu", Float.valueOf(f));
        }
        if (!Float.isNaN(f = this.getGroupParameter(1111490576))) {
            map.put("theta", Float.valueOf(f));
        }
        if ((structure = this.getStructure()) instanceof ProteinStructure) {
            map.put("structureId", ((ProteinStructure)structure).strucNo);
            map.put("structureType", ((ProteinStructure)structure).type.getBioStructureTypeName(false));
        }
        map.put("shapeVisibilityFlags", this.shapeVisibilityFlags);
        return map;
    }

    @Override
    public String getStructureId() {
        Structure structure = this.getStructure();
        return structure instanceof ProteinStructure ? ((ProteinStructure)structure).type.getBioStructureTypeName(false) : "";
    }

    final void updateOffsetsForAlternativeLocations(Atom[] atomArray, BS bS) {
        int n = this.offsets.length;
        block0: while (--n >= 0) {
            int n2 = this.offsets[n] & 0xFF;
            if (n2 == 255) continue;
            int n3 = this.firstAtomIndex + n2;
            Atom atom = atomArray[n3];
            byte by = atom.atomID;
            if (atom.altloc == '\u0000') continue;
            int n4 = this.lastAtomIndex - this.firstAtomIndex;
            for (int i = 1; i <= n4; ++i) {
                byte by2;
                int n5;
                int n6 = n3 + i;
                if (n6 > this.lastAtomIndex) {
                    n6 -= n4 + 1;
                }
                if ((n5 = n6 - this.firstAtomIndex) < 0 || n5 > 255 || n6 == n3 || !bS.get(n6) || (by2 = atomArray[n6].atomID) != by || by2 == 0 && !atomArray[n6].getAtomName().equals(atom.getAtomName())) continue;
                this.offsets[n] = (byte)n5;
                atomArray[n6].nBackbonesDisplayed = atom.nBackbonesDisplayed;
                continue block0;
            }
        }
        this.setLeadAtomIndex();
    }

    final void getMonomerSequenceAtoms(BS bS, BS bS2) {
        this.setAtomBits(bS2);
        bS2.and(bS);
    }

    protected static final boolean checkOptional(byte[] byArray, byte by, int n, int n2) {
        if (Monomer.have(byArray, by)) {
            return true;
        }
        if (n2 < 0) {
            return false;
        }
        byArray[by] = (byte)(n2 - n);
        return true;
    }

    P3 getQuaternionFrameCenter(char c) {
        return null;
    }

    protected Object getHelixData2(int n, char c, int n2) {
        Quat quat;
        if (this.monomerIndex < 0) {
            return null;
        }
        int n3 = this.monomerIndex - n2;
        Monomer monomer = n2 < 1 || this.monomerIndex <= 0 ? null : this.bioPolymer.monomers[n3];
        Quat quat2 = this.getQuaternion(c);
        Quat quat3 = n2 < 1 ? Quat.getQuaternionFrameV(JC.axisX, JC.axisY, JC.axisZ, false) : (quat = monomer == null ? null : monomer.getQuaternion(c));
        if (quat == null || quat2 == null) {
            return this.getHelixData(n, c, n2);
        }
        P3 p3 = n2 < 1 ? P3.new3(0.0f, 0.0f, 0.0f) : monomer.getQuaternionFrameCenter(c);
        P3 p32 = this.getQuaternionFrameCenter(c);
        return p3 == null || p32 == null ? this.getHelixData(n, c, n2) : Escape.escapeHelical(n == 135176 ? "helixaxis" + this.getUniqueID() : null, n, p3, p32, Measure.computeHelicalAxis(p3, p32, quat2.div(quat)));
    }

    public String getUniqueID() {
        char c;
        int n = this.chain.chainID;
        Atom atom = this.getLeadAtom();
        String string = (atom == null ? "" : "_" + atom.mi) + "_" + this.getResno() + (n == 0 ? "" : "_" + n);
        char c2 = c = atom == null ? (char)'\u0000' : this.getLeadAtom().altloc;
        if (c != '\u0000') {
            string = string + "_" + c;
        }
        return string;
    }

    @Override
    public boolean isCrossLinked(Group group) {
        for (int i = this.firstAtomIndex; i <= this.lastAtomIndex; ++i) {
            if (!this.getCrossLinkGroup(i, null, group, true, true, false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean getCrossLinkVector(Lst<Integer> lst, boolean bl, boolean bl2) {
        boolean bl3 = lst == null;
        for (int i = this.firstAtomIndex; i <= this.lastAtomIndex; ++i) {
            if (!this.getCrossLinkGroup(i, lst, null, bl, bl2, bl3) || !bl3) continue;
            return true;
        }
        return !bl3 && lst.size() > 0;
    }

    protected boolean getCrossLinkGroup(int n, Lst<Integer> lst, Group group, boolean bl, boolean bl2, boolean bl3) {
        Atom atom = this.chain.model.ms.at[n];
        Bond[] bondArray = atom.bonds;
        int n2 = this.getBioPolymerIndexInModel();
        if (n2 < 0 || bondArray == null) {
            return false;
        }
        boolean bl4 = false;
        boolean bl5 = !bl3 && lst == null && group == null;
        for (int i = 0; i < bondArray.length; ++i) {
            Bond bond = bondArray[i];
            if (bond.isCovalent() ? !bl : !bl2) continue;
            Atom atom2 = bond.getOtherAtom(atom);
            Group group2 = atom2.group;
            if (group != null && group2 != group) continue;
            int n3 = group2.getBioPolymerIndexInModel();
            int n4 = group2.getMonomerIndex();
            if (bl5) {
                if (n3 != n2 || n4 != this.monomerIndex - 1) continue;
                return true;
            }
            if (n3 < 0 || n4 < 0 || n3 == n2 && n4 >= this.monomerIndex - 1 && n4 <= this.monomerIndex + 1) continue;
            bl4 = true;
            if (group != null || lst == null) break;
            lst.addLast(n);
            lst.addLast(atom2.i);
            lst.addLast(group2.leadAtomIndex);
        }
        return bl4;
    }

    @Override
    public boolean isConnectedPrevious() {
        return true;
    }

    void setGroupParameter(int n, float f) {
        switch (n) {
            case 1111490569: {
                this.phi = f;
                break;
            }
            case 1111490570: {
                this.psi = f;
                break;
            }
            case 1111490568: {
                this.omega = f;
                break;
            }
            case 1111490565: {
                this.mu = f;
                break;
            }
            case 1111490576: {
                this.theta = f;
                break;
            }
            case 1111490574: {
                this.straightness = f;
            }
        }
    }

    @Override
    public float getGroupParameter(int n) {
        if (this.bioPolymer == null) {
            return 0.0f;
        }
        if (!this.bioPolymer.haveParameters) {
            this.bioPolymer.calcParameters();
        }
        switch (n) {
            case 0x41400011: {
                return 1.0f;
            }
            case 1111490568: {
                return this.omega;
            }
            case 1111490569: {
                return this.phi;
            }
            case 1111490570: {
                return this.psi;
            }
            case 1111490565: {
                return this.mu;
            }
            case 1111490576: {
                return this.theta;
            }
            case 1111490574: {
                return this.straightness;
            }
        }
        return Float.NaN;
    }

    @Override
    public char getGroup1() {
        int n;
        if (this.groupID < Resolver.predefinedGroup1Names.length) {
            n = Resolver.predefinedGroup1Names[this.groupID];
        } else if (this.group1 > '\u0001') {
            n = this.group1;
        } else if (this.group1 == '\u0001') {
            n = 63;
        } else {
            char c = this.getGroup1b();
            n = c;
            this.group1 = c;
        }
        return (char)n;
    }

    protected char getGroup1b() {
        return '?';
    }

    @Override
    public void setGroupID(String string) {
        this.groupID = Resolver.getGroupIdFor(string);
    }
}

