/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import java.awt.Point;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.OsmMercator;
import org.openstreetmap.gui.jmapviewer.TileXY;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTMSTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TileSourceInfo;

public class TMSTileSource
extends AbstractTMSTileSource {
    protected int maxZoom;
    protected int minZoom;
    protected OsmMercator osmMercator;

    public TMSTileSource(TileSourceInfo tileSourceInfo) {
        super(tileSourceInfo);
        this.minZoom = tileSourceInfo.getMinZoom();
        this.maxZoom = tileSourceInfo.getMaxZoom();
        this.osmMercator = new OsmMercator(this.getTileSize());
    }

    @Override
    public int getMinZoom() {
        return this.minZoom == 0 ? super.getMinZoom() : this.minZoom;
    }

    @Override
    public int getMaxZoom() {
        return this.maxZoom == 0 ? super.getMaxZoom() : this.maxZoom;
    }

    @Override
    public double getDistance(double d, double d2, double d3, double d4) {
        return this.osmMercator.getDistance(d, d2, d3, d4);
    }

    @Override
    public Point latLonToXY(double d, double d2, int n) {
        return new Point((int)this.osmMercator.lonToX(d2, n), (int)this.osmMercator.latToY(d, n));
    }

    @Override
    public ICoordinate xyToLatLon(int n, int n2, int n3) {
        return new Coordinate(this.osmMercator.yToLat(n2, n3), this.osmMercator.xToLon(n, n3));
    }

    @Override
    public TileXY latLonToTileXY(double d, double d2, int n) {
        return new TileXY(this.osmMercator.lonToX(d2, n) / (double)this.getTileSize(), this.osmMercator.latToY(d, n) / (double)this.getTileSize());
    }

    @Override
    public ICoordinate tileXYToLatLon(int n, int n2, int n3) {
        return new Coordinate(this.osmMercator.yToLat(n2 * this.getTileSize(), n3), this.osmMercator.xToLon(n * this.getTileSize(), n3));
    }
}

