/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.openstreetmap.josm.data.preferences.AbstractSetting;
import org.openstreetmap.josm.data.preferences.SettingVisitor;
import org.openstreetmap.josm.tools.Utils;

public class ListListSetting
extends AbstractSetting<List<List<String>>> {
    public ListListSetting(List<List<String>> list) {
        super(list);
        this.consistencyTest();
    }

    public static ListListSetting create(Collection<Collection<String>> collection) {
        if (collection != null) {
            ArrayList<List<String>> arrayList = new ArrayList<List<String>>(collection.size());
            for (Collection<String> collection2 : collection) {
                arrayList.add(new ArrayList<String>(collection2));
            }
            return new ListListSetting((List<List<String>>)arrayList);
        }
        return new ListListSetting(null);
    }

    @Override
    public boolean equalVal(List<List<String>> list) {
        if (this.value == null) {
            return list == null;
        }
        if (list == null) {
            return false;
        }
        if (((List)this.value).size() != list.size()) {
            return false;
        }
        Iterator iterator = ((List)this.value).iterator();
        Iterator<List<String>> iterator2 = list.iterator();
        while (iterator.hasNext()) {
            if (Utils.equalCollection((Collection)iterator.next(), (Collection)iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public ListListSetting copy() {
        if (this.value == null) {
            return new ListListSetting(null);
        }
        ArrayList arrayList = new ArrayList(((List)this.value).size());
        for (Collection collection : (List)this.value) {
            ArrayList arrayList2 = new ArrayList(collection);
            arrayList.add(Collections.unmodifiableList(arrayList2));
        }
        return new ListListSetting(Collections.unmodifiableList(arrayList));
    }

    private void consistencyTest() {
        if (this.value != null) {
            if (((List)this.value).contains(null)) {
                throw new RuntimeException("Error: Null as list element in preference setting");
            }
            for (Collection collection : (List)this.value) {
                if (!collection.contains(null)) continue;
                throw new RuntimeException("Error: Null as inner list element in preference setting");
            }
        }
    }

    @Override
    public void visit(SettingVisitor settingVisitor) {
        settingVisitor.visit(this);
    }

    public ListListSetting getNullInstance() {
        return new ListListSetting(null);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ListListSetting)) {
            return false;
        }
        return this.equalVal((List)((ListListSetting)object).getValue());
    }
}

