/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.format.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.format.nodes.PackNode;
import org.jruby.truffle.format.runtime.PackEncoding;
import org.jruby.truffle.format.runtime.PackFrameDescriptor;
import org.jruby.truffle.format.runtime.PackResult;
import org.jruby.truffle.runtime.RubyLanguage;
import org.jruby.truffle.runtime.array.ArrayUtils;

public class UnpackRootNode
extends RootNode {
    private final String description;
    private final PackEncoding encoding;
    @Node.Child
    private PackNode child;
    @CompilerDirectives.CompilationFinal
    private int expectedLength = ArrayUtils.capacity(0, 0);

    public UnpackRootNode(String description, PackEncoding encoding, PackNode child) {
        super(RubyLanguage.class, SourceSection.createUnavailable("unpack", description), PackFrameDescriptor.FRAME_DESCRIPTOR);
        this.description = description;
        this.encoding = encoding;
        this.child = child;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        boolean taint;
        Object[] output;
        int outputLength;
        frame.setObject(PackFrameDescriptor.SOURCE_SLOT, frame.getArguments()[0]);
        frame.setInt(PackFrameDescriptor.SOURCE_LENGTH_SLOT, (Integer)frame.getArguments()[1]);
        frame.setInt(PackFrameDescriptor.SOURCE_POSITION_SLOT, 0);
        frame.setObject(PackFrameDescriptor.OUTPUT_SLOT, new Object[this.expectedLength]);
        frame.setInt(PackFrameDescriptor.OUTPUT_POSITION_SLOT, 0);
        frame.setBoolean(PackFrameDescriptor.TAINT_SLOT, false);
        this.child.execute(frame);
        try {
            outputLength = frame.getInt(PackFrameDescriptor.OUTPUT_POSITION_SLOT);
        }
        catch (FrameSlotTypeException e) {
            throw new IllegalStateException(e);
        }
        if (outputLength > this.expectedLength) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.expectedLength = ArrayUtils.capacity(this.expectedLength, outputLength);
        }
        try {
            output = (Object[])frame.getObject(PackFrameDescriptor.OUTPUT_SLOT);
        }
        catch (FrameSlotTypeException e) {
            throw new IllegalStateException(e);
        }
        try {
            taint = frame.getBoolean(PackFrameDescriptor.TAINT_SLOT);
        }
        catch (FrameSlotTypeException e) {
            throw new IllegalStateException(e);
        }
        return new PackResult(output, outputLength, taint, this.encoding);
    }

    @Override
    public boolean isCloningAllowed() {
        return true;
    }

    @Override
    public String toString() {
        return this.description;
    }
}

