/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.yield;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.methods.DeclarationContext;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;

@NodeChildren(value={@NodeChild(value="block"), @NodeChild(value="self"), @NodeChild(value="blockArgument"), @NodeChild(value="arguments", type=RubyNode[].class)})
public abstract class CallBlockNode
extends RubyNode {
    private final DeclarationContext declarationContext;

    public CallBlockNode(RubyContext context, SourceSection sourceSection, DeclarationContext declarationContext) {
        super(context, sourceSection);
        this.declarationContext = declarationContext;
    }

    public abstract Object executeCallBlock(VirtualFrame var1, DynamicObject var2, Object var3, DynamicObject var4, Object[] var5);

    @Specialization(guards={"getBlockCallTarget(block) == cachedCallTarget"}, limit="getCacheLimit()")
    protected Object callBlock(VirtualFrame frame, DynamicObject block, Object self, Object blockArgument, Object[] arguments, @Cached(value="getBlockCallTarget(block)") CallTarget cachedCallTarget, @Cached(value="createBlockCallNode(cachedCallTarget)") CallNodeWrapperNode callNode) {
        Object[] frameArguments = this.packArguments(block, self, blockArgument, arguments);
        return callNode.child.call(frame, frameArguments);
    }

    @Specialization
    protected Object callBlockUncached(VirtualFrame frame, DynamicObject block, Object self, Object blockArgument, Object[] arguments, @Cached(value="create()") IndirectCallNode callNode) {
        Object[] frameArguments = this.packArguments(block, self, blockArgument, arguments);
        return callNode.call(frame, CallBlockNode.getBlockCallTarget(block), frameArguments);
    }

    private Object[] packArguments(DynamicObject block, Object self, Object blockArgument, Object[] arguments) {
        return RubyArguments.pack(Layouts.PROC.getDeclarationFrame(block), null, Layouts.PROC.getMethod(block), this.declarationContext, Layouts.PROC.getFrameOnStackMarker(block), self, (DynamicObject)blockArgument, arguments);
    }

    protected static CallTarget getBlockCallTarget(DynamicObject block) {
        return Layouts.PROC.getCallTargetForType(block);
    }

    protected CallNodeWrapperNode createBlockCallNode(CallTarget callTarget) {
        DirectCallNode callNode = Truffle.getRuntime().createDirectCallNode(callTarget);
        CallNodeWrapperNode callNodeWrapperNode = new CallNodeWrapperNode(callNode);
        if (this.getContext().getOptions().YIELD_ALWAYS_CLONE && callNode.isCallTargetCloningAllowed()) {
            callNode.cloneCallTarget();
        }
        if (this.getContext().getOptions().YIELD_ALWAYS_INLINE && callNode.isInlinable()) {
            callNode.forceInlining();
        }
        return callNodeWrapperNode;
    }

    protected int getCacheLimit() {
        return this.getContext().getOptions().YIELD_CACHE;
    }

    static class CallNodeWrapperNode
    extends Node {
        @Node.Child
        DirectCallNode child;

        public CallNodeWrapperNode(DirectCallNode child) {
            this.child = this.insert(child);
        }
    }
}

