/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.om.dsl.processor.layout;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.ObjectType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.jruby.truffle.om.dsl.api.Layout;
import org.jruby.truffle.om.dsl.api.Nullable;
import org.jruby.truffle.om.dsl.api.Volatile;
import org.jruby.truffle.om.dsl.processor.layout.model.LayoutModel;
import org.jruby.truffle.om.dsl.processor.layout.model.NameUtils;
import org.jruby.truffle.om.dsl.processor.layout.model.PropertyBuilder;
import org.jruby.truffle.om.dsl.processor.layout.model.PropertyModel;

public class LayoutParser {
    private String objectTypeSuperclass;
    private LayoutModel superLayout;
    private String name;
    private String packageName;
    private String interfaceFullName;
    private boolean hasObjectTypeGuard;
    private boolean hasObjectGuard;
    private boolean hasDynamicObjectGuard;
    private boolean hasShapeProperties;
    private final List<String> constructorProperties = new ArrayList<String>();
    private final Map<String, PropertyBuilder> properties = new HashMap<String, PropertyBuilder>();

    public void parse(TypeElement layoutElement) {
        if (!layoutElement.getInterfaces().isEmpty()) {
            this.parseSuperLayout((TypeElement)((DeclaredType)layoutElement.getInterfaces().get(0)).asElement());
        }
        this.parseName(layoutElement);
        this.objectTypeSuperclass = layoutElement.getAnnotation(Layout.class).objectTypeSuperclass();
        for (Element element : layoutElement.getEnclosedElements()) {
            String simpleName;
            if (element.getKind() == ElementKind.FIELD) {
                simpleName = element.getSimpleName().toString();
                if (!simpleName.endsWith("_IDENTIFIER")) continue;
                this.parseIdentifier((VariableElement)element);
                continue;
            }
            if (element.getKind() != ElementKind.METHOD) continue;
            simpleName = element.getSimpleName().toString();
            if (simpleName.equals("create" + this.name + "Shape")) {
                this.parseShapeConstructor((ExecutableElement)element);
                continue;
            }
            if (simpleName.equals("create" + this.name)) {
                this.parseConstructor((ExecutableElement)element);
                continue;
            }
            if (simpleName.equals("is" + this.name)) {
                this.parseGuard((ExecutableElement)element);
                continue;
            }
            if (simpleName.startsWith("getAndSet")) {
                this.parseGetAndSet((ExecutableElement)element);
                continue;
            }
            if (simpleName.startsWith("compareAndSet")) {
                this.parseCompareAndSet((ExecutableElement)element);
                continue;
            }
            if (simpleName.startsWith("get")) {
                this.parseGetter((ExecutableElement)element);
                continue;
            }
            if (!simpleName.startsWith("set")) continue;
            this.parseSetter((ExecutableElement)element);
        }
    }

    private void parseIdentifier(VariableElement fieldElement) {
        String name = fieldElement.getSimpleName().toString();
        String propertyName = NameUtils.constantToIdentifier(name.substring(0, name.length() - "_IDENTIFIER".length()));
        this.getProperty(propertyName).setHasIdentifier(true);
    }

    private void parseSuperLayout(TypeElement superTypeElement) {
        LayoutParser superParser = new LayoutParser();
        superParser.parse(superTypeElement);
        this.superLayout = superParser.build();
    }

    private void parseName(TypeElement layoutElement) {
        this.parsePackageName(layoutElement);
        this.interfaceFullName = layoutElement.getQualifiedName().toString();
        String nameString = layoutElement.getSimpleName().toString();
        this.name = nameString.substring(0, nameString.length() - "Layout".length());
    }

    private void parseShapeConstructor(ExecutableElement methodElement) {
        List<? extends VariableElement> parameters = methodElement.getParameters();
        if (this.superLayout != null) {
            parameters = parameters.subList(this.superLayout.getAllShapeProperties().size(), parameters.size());
        }
        for (VariableElement variableElement : parameters) {
            String name = variableElement.getSimpleName().toString();
            this.constructorProperties.add(name);
            PropertyBuilder property = this.getProperty(name);
            this.setPropertyType(property, variableElement.asType());
            this.parseConstructorParameterAnnotations(property, variableElement);
            property.setIsShapeProperty(true);
            this.hasShapeProperties = true;
        }
    }

    private void parseConstructor(ExecutableElement methodElement) {
        List<? extends VariableElement> parameters = methodElement.getParameters();
        if (this.hasShapeProperties || this.superLayout != null && this.superLayout.hasShapeProperties()) {
            parameters = parameters.subList(1, parameters.size());
        }
        if (this.superLayout != null) {
            parameters = parameters.subList(this.superLayout.getAllNonShapeProperties().size(), parameters.size());
        }
        for (VariableElement variableElement : parameters) {
            String name = variableElement.getSimpleName().toString();
            this.constructorProperties.add(name);
            PropertyBuilder property = this.getProperty(name);
            this.setPropertyType(property, variableElement.asType());
            this.parseConstructorParameterAnnotations(property, variableElement);
        }
    }

    private void parsePackageName(TypeElement layoutElement) {
        String[] packageComponents = layoutElement.getQualifiedName().toString().split("\\.");
        StringBuilder packageBuilder = new StringBuilder();
        for (int n = 0; n < packageComponents.length && !Character.isUpperCase(packageComponents[n].charAt(0)); ++n) {
            if (n > 0) {
                packageBuilder.append('.');
            }
            packageBuilder.append(packageComponents[n]);
        }
        this.packageName = packageBuilder.toString();
    }

    private void parseGuard(ExecutableElement methodElement) {
        String type = methodElement.getParameters().get(0).asType().toString();
        if (type.equals(DynamicObject.class.getName())) {
            this.hasDynamicObjectGuard = true;
        } else if (type.equals(ObjectType.class.getName())) {
            this.hasObjectTypeGuard = true;
        } else if (type.equals(Object.class.getName())) {
            this.hasObjectGuard = true;
        }
    }

    private void parseGetter(ExecutableElement methodElement) {
        boolean isFactoryGetter = methodElement.getParameters().get(0).asType().toString().equals(DynamicObjectFactory.class.getName());
        boolean isObjectTypeGetter = methodElement.getParameters().get(0).asType().toString().equals(ObjectType.class.getName());
        String name = this.titleToCamel(methodElement.getSimpleName().toString().substring("get".length()));
        PropertyBuilder property = this.getProperty(name);
        if (isFactoryGetter) {
            property.setHasFactoryGetter(true);
        } else if (isObjectTypeGetter) {
            property.setHasObjectTypeGetter(true);
        } else {
            property.setHasGetter(true);
        }
        this.setPropertyType(property, methodElement.getReturnType());
    }

    private void parseSetter(ExecutableElement methodElement) {
        boolean isFactorySetter = methodElement.getParameters().get(0).asType().toString().equals(DynamicObjectFactory.class.getName());
        boolean isUnsafeSetter = methodElement.getSimpleName().toString().endsWith("Unsafe");
        String name = this.titleToCamel(methodElement.getSimpleName().toString().substring("set".length()));
        if (isUnsafeSetter) {
            name = name.substring(0, name.length() - "Unsafe".length());
        }
        PropertyBuilder property = this.getProperty(name);
        if (isFactorySetter) {
            property.setHasFactorySetter(true);
        } else if (isUnsafeSetter) {
            property.setHasUnsafeSetter(isUnsafeSetter);
        } else {
            property.setHasSetter(true);
        }
        this.setPropertyType(property, methodElement.getParameters().get(1).asType());
    }

    private void parseCompareAndSet(ExecutableElement methodElement) {
        String name = this.titleToCamel(methodElement.getSimpleName().toString().substring("compareAndSet".length()));
        PropertyBuilder property = this.getProperty(name);
        property.setHasCompareAndSet(true);
        this.setPropertyType(property, methodElement.getParameters().get(1).asType());
        this.setPropertyType(property, methodElement.getParameters().get(2).asType());
    }

    private void parseGetAndSet(ExecutableElement methodElement) {
        String name = this.titleToCamel(methodElement.getSimpleName().toString().substring("getAndSet".length()));
        PropertyBuilder property = this.getProperty(name);
        property.setHasGetAndSet(true);
        this.setPropertyType(property, methodElement.getParameters().get(1).asType());
        this.setPropertyType(property, methodElement.getReturnType());
    }

    private String titleToCamel(String name) {
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    private void parseConstructorParameterAnnotations(PropertyBuilder property, Element element) {
        if (element.getAnnotation(Nullable.class) != null) {
            property.setNullable(true);
        }
        if (element.getAnnotation(Volatile.class) != null) {
            property.setVolatile(true);
        }
    }

    private void setPropertyType(PropertyBuilder builder, TypeMirror type) {
        if (builder.getType() == null) {
            builder.setType(type);
        }
    }

    private PropertyBuilder getProperty(String name) {
        PropertyBuilder builder = this.properties.get(name);
        if (builder == null) {
            builder = new PropertyBuilder(name);
            this.properties.put(name, builder);
        }
        return builder;
    }

    public LayoutModel build() {
        boolean hasShapeProperties = false;
        for (PropertyBuilder property : this.properties.values()) {
            if (!property.isShapeProperty()) continue;
            hasShapeProperties = true;
        }
        return new LayoutModel(this.objectTypeSuperclass, this.superLayout, this.name, this.packageName, this.hasObjectTypeGuard, this.hasObjectGuard, this.hasDynamicObjectGuard, this.buildProperties(), this.interfaceFullName, hasShapeProperties);
    }

    private List<PropertyModel> buildProperties() {
        ArrayList<PropertyModel> models = new ArrayList<PropertyModel>();
        for (String propertyName : this.constructorProperties) {
            models.add(this.getProperty(propertyName).build());
        }
        return models;
    }
}

