/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.subsystems;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrument.EvalInstrumentListener;
import com.oracle.truffle.api.instrument.Instrument;
import com.oracle.truffle.api.instrument.Probe;
import com.oracle.truffle.api.instrument.StandardSyntaxTag;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.LineLocation;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.tools.LineToProbesMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.core.BindingNodes;
import org.jruby.truffle.nodes.core.ProcNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;

public class AttachmentsManager {
    public static final Source ATTACHMENT_SOURCE = Source.fromText("(attachment)", "(attachment)").withMimeType("application/x-ruby");
    private final RubyContext context;
    private final LineToProbesMap lineToProbesMap;
    private final Map<LineLocation, List<Instrument>> attachments = new HashMap<LineLocation, List<Instrument>>();

    public AttachmentsManager(RubyContext context) {
        this.context = context;
        this.lineToProbesMap = new LineToProbesMap();
        context.getEnv().instrumenter().install(this.lineToProbesMap);
    }

    public synchronized Instrument attach(String file, int line, DynamicObject block) {
        assert (RubyGuards.isRubyProc(block));
        String info = String.format("Truffle::Primitive.attach@%s:%d", file, line);
        EvalInstrumentListener listener = new EvalInstrumentListener(){

            @Override
            public void onExecution(Node node, VirtualFrame virtualFrame, Object o) {
            }

            @Override
            public void onFailure(Node node, VirtualFrame virtualFrame, Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        };
        Source source = this.context.getSourceCache().getBestSourceFuzzily(file);
        LineLocation lineLocation = source.createLineLocation(line);
        for (Probe probe : this.lineToProbesMap.findProbes(lineLocation)) {
            if (!probe.isTaggedAs(StandardSyntaxTag.STATEMENT)) continue;
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("section", probe.getProbedSourceSection());
            parameters.put("block", block);
            return this.context.getEnv().instrumenter().attach(probe, ATTACHMENT_SOURCE, listener, info, parameters);
        }
        throw new RuntimeException("couldn't find a statement!");
    }

    public static class AttachmentRootNode
    extends RootNode {
        private final RubyContext context;
        private final DynamicObject block;
        @Node.Child
        private DirectCallNode callNode;

        public AttachmentRootNode(Class<? extends TruffleLanguage<?>> language, RubyContext context, SourceSection sourceSection, FrameDescriptor frameDescriptor, DynamicObject block) {
            super(language, sourceSection, frameDescriptor);
            this.context = context;
            this.block = block;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            MaterializedFrame callerFrame = (MaterializedFrame)frame.getArguments()[0];
            DynamicObject binding = BindingNodes.createBinding(this.context, callerFrame);
            if (this.callNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.callNode = this.insert(Truffle.getRuntime().createDirectCallNode(Layouts.PROC.getCallTargetForType(this.block)));
                if (this.callNode.isCallTargetCloningAllowed()) {
                    this.callNode.cloneCallTarget();
                }
                if (this.callNode.isInlinable()) {
                    this.callNode.forceInlining();
                }
            }
            this.callNode.call(frame, ProcNodes.packArguments(this.block, binding));
            return null;
        }
    }
}

