/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.pdf;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.pdf.PdfDescriptorLoadingStatus;
import org.pdfsam.support.ObservableAtomicReference;
import org.pdfsam.support.RequireUtils;
import org.sejda.model.input.PdfFileSource;
import org.sejda.model.pdf.PdfVersion;

public class PdfDocumentDescriptor {
    private ObservableAtomicReference<PdfDescriptorLoadingStatus> loadingStatus = new ObservableAtomicReference<PdfDescriptorLoadingStatus>(PdfDescriptorLoadingStatus.INITIAL);
    private AtomicInteger references = new AtomicInteger(1);
    private ObservableAtomicReference<Integer> pages = new ObservableAtomicReference<Integer>(0);
    private String password;
    private File file;
    private PdfVersion version;
    private Map<String, String> metadata = new HashMap<String, String>();
    private int maxGoToActionDepth = 0;

    private PdfDocumentDescriptor(File file, String password) {
        RequireUtils.requireNotNull(file, "Input file is mandatory");
        this.file = file;
        this.password = password;
    }

    public String getFileName() {
        return this.file.getName();
    }

    public PdfFileSource toPdfFileSource() {
        return PdfFileSource.newInstanceWithPassword(this.file, this.password);
    }

    public String getInformation(String key) {
        return StringUtils.defaultString(this.metadata.get(key));
    }

    public void setInformationDictionary(Map<String, String> info) {
        this.metadata.clear();
        this.metadata.putAll(info);
    }

    public void putInformation(String key, String value) {
        this.metadata.put(key, value);
    }

    public void pages(int newValue) {
        this.pages.set(newValue);
    }

    public ObservableAtomicReference<PdfDescriptorLoadingStatus> loadingStatus() {
        return this.loadingStatus;
    }

    public ObservableAtomicReference<Integer> pages() {
        return this.pages;
    }

    public void moveStatusTo(PdfDescriptorLoadingStatus destination) {
        this.loadingStatus.set(this.loadingStatus.getValue().moveTo(destination));
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean hasPassword() {
        return StringUtils.isNotBlank(this.password);
    }

    public String getVersionString() {
        return Optional.ofNullable(this.version).map(PdfVersion::getVersionString).orElse("");
    }

    public PdfVersion getVersion() {
        return this.version;
    }

    public void setVersion(PdfVersion version) {
        this.version = version;
    }

    public File getFile() {
        return this.file;
    }

    public void setMaxGoToActionDepth(int maxGoToActionDepth) {
        this.maxGoToActionDepth = maxGoToActionDepth;
    }

    public int getMaxGoToActionDepth() {
        return this.maxGoToActionDepth;
    }

    public boolean hasReferences() {
        return this.references.get() > 0;
    }

    public boolean release() {
        return this.references.decrementAndGet() <= 0;
    }

    public void releaseAll() {
        this.references.set(0);
    }

    public PdfDocumentDescriptor retain() {
        this.references.incrementAndGet();
        return this;
    }

    public static PdfDocumentDescriptor newDescriptor(File file, String password) {
        return new PdfDocumentDescriptor(file, password);
    }

    public static PdfDocumentDescriptor newDescriptorNoPassword(File file) {
        return new PdfDocumentDescriptor(file, null);
    }
}

