/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.input;

import java.io.File;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.input.AbstractPdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.validation.constraint.PdfFile;

public final class PdfFileSource
extends AbstractPdfSource<File> {
    @PdfFile
    private final File file;

    private PdfFileSource(File file, String password) {
        super(file.getName(), password);
        this.file = file;
    }

    @Override
    public File getSource() {
        return this.file;
    }

    @Override
    public <T> T open(PdfSourceOpener<T> opener) throws TaskIOException {
        return opener.open(this);
    }

    public static PdfFileSource newInstanceNoPassword(File file) {
        return PdfFileSource.newInstanceWithPassword(file, null);
    }

    public static PdfFileSource newInstanceWithPassword(File file, String password) {
        if (file == null || !file.isFile()) {
            throw new IllegalArgumentException("A not null File instance that isFile is expected.");
        }
        return new PdfFileSource(file, password);
    }

    @Override
    public String toString() {
        return this.file.getAbsolutePath();
    }
}

