// Generated by gmmproc 2.48.0 -- DO NOT MODIFY!
#ifndef _GTKMM_POPOVERMENU_H
#define _GTKMM_POPOVERMENU_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2015 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtkmm/popover.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkPopoverMenu GtkPopoverMenu;
typedef struct _GtkPopoverMenuClass GtkPopoverMenuClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class PopoverMenu_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{
/** A Popover to use as a menu.
 *
 * PopoverMenu is a subclass of Popover that treats its
 * childen like menus and allows switching between them. It is
 * meant to be used primarily together with ModelButton, but
 * any widget can be used, such as SpinButton or Scale.
 * In this respect, PopoverMenu is more flexible than popovers
 * that are created from a Gio::MenuModel.
 *
 * To add a child as a submenu, set the child_property_submenu()
 * to the name of the submenu. To let the user open
 * this submenu, add a ModelButton whose ModelButton::property_menu_name()
 * is set to the name you've given to the submenu.
 *
 * By convention, the first child of a submenu should be a ModelButton
 * to switch back to the parent menu. Such a button should use
 * ModelButton::property_inverted() and ModelButton::property_centered()
 * to achieve a title-like appearance and place the submenu indicator
 * at the opposite side. To switch back to the main menu, use "main"
 * as the menu name.
 *
 * @newin{3,18}
 *
 * @ingroup Widgets
 * @ingroup Containers
 * @ingroup Menus
 */

class PopoverMenu : public Popover
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef PopoverMenu CppObjectType;
  typedef PopoverMenu_Class CppClassType;
  typedef GtkPopoverMenu BaseObjectType;
  typedef GtkPopoverMenuClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  PopoverMenu(PopoverMenu&& src) noexcept;
  PopoverMenu& operator=(PopoverMenu&& src) noexcept;

  // noncopyable
  PopoverMenu(const PopoverMenu&) = delete;
  PopoverMenu& operator=(const PopoverMenu&) = delete;

  ~PopoverMenu() noexcept override;

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class PopoverMenu_Class;
  static CppClassType popovermenu_class_;

protected:
  explicit PopoverMenu(const Glib::ConstructParams& construct_params);
  explicit PopoverMenu(GtkPopoverMenu* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkPopoverMenu*       gobj()       { return reinterpret_cast<GtkPopoverMenu*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkPopoverMenu* gobj() const { return reinterpret_cast<GtkPopoverMenu*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


private:


public:
  PopoverMenu();

  
  /** Opens a submenu of the @a popover. The @a name
   * must be one of the names given to the submenus
   * of @a popover with Gtk::PopoverMenu::property_submenu(), or
   * "main" to switch back to the main menu.
   * 
   * Gtk::ModelButton will open submenus automatically
   * when the Gtk::ModelButton::property_menu_name() property is set,
   * so this function is only needed when you are using
   * other kinds of widgets to initiate menu changes.
   * 
   * @newin{3,16}
   * 
   * @param name The name of the menu to switch to.
   */
  void open_submenu(const Glib::ustring& name);

  /** The name of the visible submenu.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_visible_submenu() ;

/** The name of the visible submenu.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_visible_submenu() const;


  /** The submenu child property specifies the name of the submenu
   * If it is <tt>nullptr</tt> or "main", the child is used as the main menu,
   * which is shown initially when the popover is mapped.
   * 
   * @newin{3,16}
   *
   * @return A ChildPropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Gtk::ChildPropertyProxy< Glib::ustring > child_property_submenu(Gtk::Widget& child) ;

/** The submenu child property specifies the name of the submenu
   * If it is <tt>nullptr</tt> or "main", the child is used as the main menu,
   * which is shown initially when the popover is mapped.
   * 
   * @newin{3,16}
   *
   * @return A ChildPropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Gtk::ChildPropertyProxy_ReadOnly< Glib::ustring > child_property_submenu(const Gtk::Widget& child) const;

  /** The index of the child in the parent.
   *
   * @return A ChildPropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Gtk::ChildPropertyProxy< int > child_property_position(Gtk::Widget& child) ;

/** The index of the child in the parent.
   *
   * @return A ChildPropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Gtk::ChildPropertyProxy_ReadOnly< int > child_property_position(const Gtk::Widget& child) const;


  // PopoverMenu has no signals nor vfuncs.


};

} //namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::PopoverMenu
   */
  Gtk::PopoverMenu* wrap(GtkPopoverMenu* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_POPOVERMENU_H */

