/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.output;

import java.awt.Image;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.layouting.input.style.parser.CSSValueFactory;
import org.jfree.layouting.input.style.parser.StyleSheetParserUtil;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.layouter.style.CSSValueResolverUtility;
import org.jfree.layouting.namespace.NamespaceDefinition;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.layouting.util.LazyAttributeMap;
import org.jfree.report.DataFlags;
import org.jfree.report.DataSourceException;
import org.jfree.report.JFreeReportBoot;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.flow.AbstractReportTarget;
import org.jfree.report.flow.ReportJob;
import org.jfree.report.flow.ReportStructureRoot;
import org.jfree.report.flow.ReportTargetUtil;
import org.jfree.report.structure.Element;
import org.jfree.report.structure.Section;
import org.jfree.report.util.AttributeNameGenerator;
import org.jfree.report.util.IntegerCache;
import org.jfree.report.util.MemoryByteArrayOutputStream;
import org.libreoffice.report.DataSourceFactory;
import org.libreoffice.report.ImageService;
import org.libreoffice.report.InputRepository;
import org.libreoffice.report.OutputRepository;
import org.libreoffice.report.pentaho.layoutprocessor.ImageElementContext;
import org.libreoffice.report.pentaho.model.OfficeDocument;
import org.libreoffice.report.pentaho.model.OfficeStyle;
import org.libreoffice.report.pentaho.model.OfficeStyles;
import org.libreoffice.report.pentaho.model.OfficeStylesCollection;
import org.libreoffice.report.pentaho.output.ImageProducer;
import org.libreoffice.report.pentaho.output.OleProducer;
import org.libreoffice.report.pentaho.output.StyleUtilities;
import org.libreoffice.report.pentaho.output.StylesWriter;
import org.libreoffice.report.pentaho.styles.LengthCalculator;
import org.libreoffice.report.pentaho.styles.StyleMapper;
import org.pentaho.reporting.libraries.base.util.FastStack;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriterSupport;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public abstract class OfficeDocumentReportTarget
extends AbstractReportTarget {
    protected static final Log LOGGER = LogFactory.getLog(OfficeDocumentReportTarget.class);
    public static final String HORIZONTAL_POS = "horizontal-pos";
    public static final String TAG_DEF_PREFIX = "org.libreoffice.report.pentaho.output.";
    private static final int ROLE_NONE = 0;
    public static final int ROLE_REPORT_HEADER = 1;
    public static final int ROLE_REPORT_FOOTER = 2;
    public static final int ROLE_GROUP_HEADER = 3;
    public static final int ROLE_GROUP_FOOTER = 4;
    public static final int ROLE_REPEATING_GROUP_HEADER = 5;
    public static final int ROLE_REPEATING_GROUP_FOOTER = 6;
    public static final int ROLE_PAGE_HEADER = 7;
    public static final int ROLE_PAGE_FOOTER = 8;
    public static final int ROLE_DETAIL = 9;
    public static final int ROLE_VARIABLES = 10;
    public static final int ROLE_TEMPLATE = 11;
    public static final int ROLE_SPREADSHEET_PAGE_HEADER = 12;
    public static final int ROLE_SPREADSHEET_PAGE_FOOTER = 13;
    private static final int STATE_IN_DOCUMENT = 0;
    private static final int STATE_IN_BODY = 1;
    private static final int STATE_IN_CONTENT = 2;
    private static final int STATE_IN_GROUP = 3;
    private static final int STATE_IN_GROUP_BODY = 4;
    private static final int STATE_IN_SECTION = 5;
    private static final int STATE_IN_OTHER = 6;
    private static final int STATE_IN_GROUP_INSTANCE = 7;
    public static final String FAILED = "Failed";
    public static final String VERTICAL_POS = "vertical-pos";
    private static final String ZERO_CM = "0cm";
    public static final String ODF_VERSION = "1.2";
    private final FastStack states;
    private int currentRole;
    private final FastStack xmlWriters;
    private XmlWriter rootXmlWriter;
    private OfficeStylesCollection predefinedStylesCollection;
    private OfficeStylesCollection globalStylesCollection;
    private OfficeStylesCollection contentStylesCollection;
    private final OutputRepository outputRepository;
    private final InputRepository inputRepository;
    private final AttributeNameGenerator tableNameGenerator;
    private final AttributeNameGenerator frameNameGenerator;
    private final AttributeNameGenerator autoStyleNameGenerator;
    private final String target;
    private static final int INITIAL_BUFFER_SIZE = 40960;
    private StyleMapper styleMapper;
    private StyleSheetParserUtil styleSheetParserUtil;
    private final AttributeNameGenerator imageNames;
    private final ImageProducer imageProducer;
    private final OleProducer oleProducer;
    private GroupContext groupContext;
    private static final boolean DEBUG_ELEMENTS = JFreeReportBoot.getInstance().getExtendedConfig().getBoolProperty("org.libreoffice.report.pentaho.output.DebugElements");

    protected OfficeDocumentReportTarget(ReportJob reportJob, ResourceManager resourceManager, ResourceKey baseResource, InputRepository inputRepository, OutputRepository outputRepository, String target, ImageService imageService, DataSourceFactory datasourcefactory) throws ReportProcessingException {
        super(reportJob, resourceManager, baseResource);
        if (imageService == null) {
            throw new NullPointerException("ImageService must not be null");
        }
        if (target == null) {
            throw new NullPointerException("Target-Name must not be null");
        }
        this.target = target;
        this.tableNameGenerator = new AttributeNameGenerator();
        this.frameNameGenerator = new AttributeNameGenerator();
        this.autoStyleNameGenerator = new AttributeNameGenerator();
        this.outputRepository = outputRepository;
        this.inputRepository = inputRepository;
        this.states = new FastStack();
        this.xmlWriters = new FastStack();
        this.imageNames = new AttributeNameGenerator();
        this.imageProducer = new ImageProducer(inputRepository, outputRepository, imageService);
        this.oleProducer = new OleProducer(inputRepository, outputRepository, imageService, datasourcefactory, (Integer)reportJob.getParameters().get("MaxRows"));
        try {
            ResourceManager realResourceManager = this.getResourceManager();
            this.styleMapper = StyleMapper.loadInstance(realResourceManager);
        }
        catch (ResourceException e) {
            throw new ReportProcessingException("Failed to load style-mapper", (Exception)((Object)e));
        }
    }

    protected abstract String getTargetMimeType();

    protected OutputRepository getOutputRepository() {
        return this.outputRepository;
    }

    private InputRepository getInputRepository() {
        return this.inputRepository;
    }

    public void startReport(ReportStructureRoot report) throws DataSourceException, ReportProcessingException {
        this.imageNames.reset();
        this.groupContext = new GroupContext(null);
        DefaultTagDescription tagDescription = this.createTagDescription();
        try {
            OutputStream outputStream = this.outputRepository.createOutputStream(this.target, "text/xml");
            OutputStreamWriter writer = new OutputStreamWriter(outputStream, "UTF-8");
            this.rootXmlWriter = new XmlWriter((Writer)writer, (TagDescription)tagDescription);
            this.rootXmlWriter.setAlwaysAddNamespace(true);
            AttributeList rootAttributes = new AttributeList();
            rootAttributes.addNamespaceDeclaration("office", "urn:oasis:names:tc:opendocument:xmlns:office:1.0");
            rootAttributes.addNamespaceDeclaration("style", "urn:oasis:names:tc:opendocument:xmlns:style:1.0");
            rootAttributes.addNamespaceDeclaration("text", "urn:oasis:names:tc:opendocument:xmlns:text:1.0");
            rootAttributes.addNamespaceDeclaration("table", "urn:oasis:names:tc:opendocument:xmlns:table:1.0");
            rootAttributes.addNamespaceDeclaration("draw", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0");
            rootAttributes.addNamespaceDeclaration("fo", "urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0");
            rootAttributes.addNamespaceDeclaration("xlink", "http://www.w3.org/1999/xlink");
            rootAttributes.addNamespaceDeclaration("dc", "http://purl.org/dc/elements/1.1/");
            rootAttributes.addNamespaceDeclaration("meta", "urn:oasis:names:tc:opendocument:xmlns:meta:1.0");
            rootAttributes.addNamespaceDeclaration("number", "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0");
            rootAttributes.addNamespaceDeclaration("svg", "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0");
            rootAttributes.addNamespaceDeclaration("chart", "urn:oasis:names:tc:opendocument:xmlns:chart:1.0");
            rootAttributes.addNamespaceDeclaration("chartooo", "http://openoffice.org/2010/chart");
            rootAttributes.addNamespaceDeclaration("dr3d", "urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0");
            rootAttributes.addNamespaceDeclaration("math", "http://www.w3.org/1998/Math/MathML");
            rootAttributes.addNamespaceDeclaration("form", "urn:oasis:names:tc:opendocument:xmlns:form:1.0");
            rootAttributes.addNamespaceDeclaration("script", "urn:oasis:names:tc:opendocument:xmlns:script:1.0");
            rootAttributes.addNamespaceDeclaration("ooo", "http://openoffice.org/2004/office");
            rootAttributes.addNamespaceDeclaration("ooow", "http://openoffice.org/2004/writer");
            rootAttributes.addNamespaceDeclaration("oooc", "http://openoffice.org/2004/calc");
            rootAttributes.addNamespaceDeclaration("dom", "http://www.w3.org/2001/xml-events");
            rootAttributes.addNamespaceDeclaration("xforms", "http://www.w3.org/2002/xforms");
            rootAttributes.addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
            rootAttributes.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            rootAttributes.addNamespaceDeclaration("grddl", "http://www.w3.org/2003/g/data-view#");
            rootAttributes.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "version", ODF_VERSION);
            this.rootXmlWriter.writeXmlDeclaration("UTF-8");
            this.rootXmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "document-content", rootAttributes, false);
            this.states.push((Object)IntegerCache.getInteger(0));
            this.autoStyleNameGenerator.reset();
            this.tableNameGenerator.reset();
            this.frameNameGenerator.reset();
            OfficeDocument reportDoc = (OfficeDocument)report;
            this.predefinedStylesCollection = reportDoc.getStylesCollection();
            OfficeStyles commonStyles = this.predefinedStylesCollection.getCommonStyles();
            if (!commonStyles.containsStyle("graphic", "Graphics")) {
                OfficeStyle graphicsDefaultStyle = new OfficeStyle();
                graphicsDefaultStyle.setStyleFamily("graphic");
                graphicsDefaultStyle.setStyleName("Graphics");
                Element graphicProperties = this.produceFirstChild(graphicsDefaultStyle, "urn:oasis:names:tc:opendocument:xmlns:style:1.0", "graphic-properties");
                graphicProperties.setAttribute("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "anchor-type", "paragraph");
                graphicProperties.setAttribute("urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", "x", ZERO_CM);
                graphicProperties.setAttribute("urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", "y", ZERO_CM);
                graphicProperties.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "wrap", "dynamic");
                graphicProperties.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "number-wrapped-paragraphs", "no-limit");
                graphicProperties.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "wrap-contour", "false");
                graphicProperties.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", VERTICAL_POS, "from-top");
                graphicProperties.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "vertical-rel", "paragraph");
                graphicProperties.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", HORIZONTAL_POS, "from-left");
                graphicProperties.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "horizontal-rel", "paragraph");
                commonStyles.addStyle(graphicsDefaultStyle);
            }
            this.fillStyleNameGenerator(this.predefinedStylesCollection);
            this.contentStylesCollection = new OfficeStylesCollection();
            this.globalStylesCollection = new OfficeStylesCollection();
            this.startBuffering(this.contentStylesCollection, true);
        }
        catch (IOException e) {
            throw new ReportProcessingException(FAILED, e);
        }
    }

    protected AttributeNameGenerator getAutoStyleNameGenerator() {
        return this.autoStyleNameGenerator;
    }

    private void fillStyleNameGenerator(OfficeStylesCollection stylesCollection) {
        OfficeStyles commonStyles = stylesCollection.getCommonStyles();
        OfficeStyle[] allCommonStyles = commonStyles.getAllStyles();
        for (int i = 0; i < allCommonStyles.length; ++i) {
            OfficeStyle style = allCommonStyles[i];
            this.autoStyleNameGenerator.generateName(style.getStyleName());
        }
        OfficeStyles autoStyles = stylesCollection.getAutomaticStyles();
        OfficeStyle[] allAutoStyles = autoStyles.getAllStyles();
        for (int i = 0; i < allAutoStyles.length; ++i) {
            OfficeStyle style = allAutoStyles[i];
            this.autoStyleNameGenerator.generateName(style.getStyleName());
        }
    }

    public OfficeStylesCollection getPredefinedStylesCollection() {
        return this.predefinedStylesCollection;
    }

    public OfficeStylesCollection getGlobalStylesCollection() {
        return this.globalStylesCollection;
    }

    public OfficeStylesCollection getContentStylesCollection() {
        return this.contentStylesCollection;
    }

    protected DefaultTagDescription createTagDescription() {
        DefaultTagDescription tagDescription = new DefaultTagDescription();
        tagDescription.configure(JFreeReportBoot.getInstance().getGlobalConfig(), TAG_DEF_PREFIX);
        return tagDescription;
    }

    private int getCurrentState() {
        if (this.states.isEmpty()) {
            throw new IllegalStateException();
        }
        Integer o = (Integer)this.states.peek();
        return o;
    }

    public final void startElement(AttributeMap roAttrs) throws DataSourceException, ReportProcessingException {
        LazyAttributeMap attrs = new LazyAttributeMap(roAttrs);
        if (DEBUG_ELEMENTS) {
            LOGGER.debug("Starting " + this.getCurrentState() + '/' + this.states.size() + ' ' + ReportTargetUtil.getNamespaceFromAttribute((AttributeMap)attrs) + " -> " + ReportTargetUtil.getElemenTypeFromAttribute((AttributeMap)attrs));
        }
        try {
            switch (this.getCurrentState()) {
                case 0: {
                    if (ReportTargetUtil.isElementOfType("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "body", (AttributeMap)attrs)) {
                        this.states.push((Object)IntegerCache.getInteger(1));
                        this.startBody();
                        break;
                    }
                    this.states.push((Object)IntegerCache.getInteger(6));
                    if (!this.isFilteredNamespace(ReportTargetUtil.getNamespaceFromAttribute((AttributeMap)attrs))) {
                        this.startOther((AttributeMap)attrs);
                    }
                    break;
                }
                case 1: {
                    if (ReportTargetUtil.isElementOfType("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "report", (AttributeMap)attrs)) {
                        this.states.push((Object)IntegerCache.getInteger(2));
                        this.startContent((AttributeMap)attrs);
                        break;
                    }
                    throw new IllegalStateException("The 'office:body' element must have exactly one child of type 'report'");
                }
                case 2: {
                    if (ReportTargetUtil.isElementOfType("http://jfreereport.sourceforge.net/namespaces/engine", "report-body", (AttributeMap)attrs)) {
                        this.states.push((Object)IntegerCache.getInteger(4));
                        break;
                    }
                    this.states.push((Object)IntegerCache.getInteger(5));
                    if (ReportTargetUtil.isElementOfType("http://jfreereport.sourceforge.net/namespaces/engine", "template", (AttributeMap)attrs)) {
                        this.currentRole = 11;
                    } else if (ReportTargetUtil.isElementOfType("http://openoffice.org/2005/report", "page-header", (AttributeMap)attrs)) {
                        this.currentRole = "spreadsheet-section".equals(attrs.getAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "role")) ? 12 : 7;
                    } else if (ReportTargetUtil.isElementOfType("http://openoffice.org/2005/report", "page-footer", (AttributeMap)attrs)) {
                        this.currentRole = "spreadsheet-section".equals(attrs.getAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "role")) ? 13 : 8;
                    } else if (ReportTargetUtil.isElementOfType("http://openoffice.org/2005/report", "report-header", (AttributeMap)attrs)) {
                        this.currentRole = 1;
                    } else if (ReportTargetUtil.isElementOfType("http://openoffice.org/2005/report", "report-footer", (AttributeMap)attrs)) {
                        this.currentRole = 2;
                    } else if (ReportTargetUtil.isElementOfType("http://jfreereport.sourceforge.net/namespaces/engine", "variables-section", (AttributeMap)attrs)) {
                        this.currentRole = 10;
                    } else {
                        throw new IllegalStateException("Expected either 'template', 'report-body', 'report-header', 'report-footer', 'variables-section', 'page-header' or 'page-footer'");
                    }
                    this.startReportSection((AttributeMap)attrs, this.currentRole);
                    break;
                }
                case 4: {
                    if (ReportTargetUtil.isElementOfType("http://openoffice.org/2005/report", "group", (AttributeMap)attrs)) {
                        this.states.push((Object)IntegerCache.getInteger(3));
                        this.groupContext = new GroupContext(this.groupContext);
                        this.startGroup((AttributeMap)attrs);
                        break;
                    }
                    this.states.push((Object)IntegerCache.getInteger(5));
                    if (ReportTargetUtil.isElementOfType("http://openoffice.org/2005/report", "detail", (AttributeMap)attrs)) {
                        this.currentRole = 9;
                    } else if (ReportTargetUtil.isElementOfType("http://jfreereport.sourceforge.net/namespaces/engine", "variables-section", (AttributeMap)attrs)) {
                        this.currentRole = 10;
                    } else {
                        throw new IllegalStateException("Expected either 'group', 'detail' or 'variables-section'");
                    }
                    this.startReportSection((AttributeMap)attrs, this.currentRole);
                    break;
                }
                case 3: {
                    if (ReportTargetUtil.isElementOfType("http://jfreereport.sourceforge.net/namespaces/engine", "group-instance", (AttributeMap)attrs)) {
                        this.states.push((Object)IntegerCache.getInteger(7));
                        this.startGroupInstance((AttributeMap)attrs);
                        break;
                    }
                    this.states.push((Object)IntegerCache.getInteger(5));
                    if (ReportTargetUtil.isElementOfType("http://openoffice.org/2005/report", "group-header", (AttributeMap)attrs) && "true".equals(attrs.getAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "repeated-section"))) {
                        this.currentRole = 5;
                    } else if (ReportTargetUtil.isElementOfType("http://openoffice.org/2005/report", "group-footer", (AttributeMap)attrs) && "true".equals(attrs.getAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "repeated-section"))) {
                        this.currentRole = 6;
                    } else {
                        throw new IllegalStateException("Expected either 'group-instance', 'repeating group-header' or 'repeating group-footer'");
                    }
                    this.startReportSection((AttributeMap)attrs, this.currentRole);
                    break;
                }
                case 7: {
                    if (ReportTargetUtil.isElementOfType("http://jfreereport.sourceforge.net/namespaces/engine", "group-body", (AttributeMap)attrs)) {
                        this.states.push((Object)IntegerCache.getInteger(4));
                        break;
                    }
                    this.states.push((Object)IntegerCache.getInteger(5));
                    if (ReportTargetUtil.isElementOfType("http://openoffice.org/2005/report", "group-header", (AttributeMap)attrs)) {
                        this.currentRole = 3;
                    } else if (ReportTargetUtil.isElementOfType("http://openoffice.org/2005/report", "group-footer", (AttributeMap)attrs)) {
                        this.currentRole = 4;
                    } else if (ReportTargetUtil.isElementOfType("http://jfreereport.sourceforge.net/namespaces/engine", "variables-section", (AttributeMap)attrs)) {
                        this.currentRole = 10;
                    } else {
                        throw new IllegalStateException("Expected either 'group-body', 'group-header', 'group-footer' or 'variables-section'");
                    }
                    this.startReportSection((AttributeMap)attrs, this.currentRole);
                    break;
                }
                case 5: 
                case 6: {
                    this.states.push((Object)IntegerCache.getInteger(6));
                    this.startOther((AttributeMap)attrs);
                    break;
                }
                default: {
                    throw new IllegalStateException("Failure: " + this.getCurrentState());
                }
            }
        }
        catch (IOException ioe) {
            LOGGER.error("ReportProcessing failed", ioe);
            throw new ReportProcessingException("Failed to write content", ioe);
        }
    }

    protected GroupContext getGroupContext() {
        return this.groupContext;
    }

    protected void performStyleProcessing(AttributeMap attrs) throws ReportProcessingException {
        OfficeStylesCollection stylesCollection = this.getStylesCollection();
        OfficeStylesCollection predefCollection = this.getPredefinedStylesCollection();
        OfficeStylesCollection globalStylesCollection = this.getGlobalStylesCollection();
        String elementNamespace = ReportTargetUtil.getNamespaceFromAttribute(attrs);
        String elementName = ReportTargetUtil.getElemenTypeFromAttribute(attrs);
        String[] namespaces = attrs.getNameSpaces();
        for (int i = 0; i < namespaces.length; ++i) {
            String attrNamespace = namespaces[i];
            if (this.isFilteredNamespace(attrNamespace)) continue;
            Map attributes = attrs.getAttributes(attrNamespace);
            for (Map.Entry entry : attributes.entrySet()) {
                String attrName = (String)entry.getKey();
                String attrValue = String.valueOf(entry.getValue());
                String styleFamily = this.styleMapper.getStyleFamilyFor(elementNamespace, elementName, attrNamespace, attrName);
                if (styleFamily == null) continue;
                if (this.styleMapper.isListOfStyles(elementNamespace, elementName, attrNamespace, attrName)) {
                    LOGGER.warn("List of styles is not yet implemented.");
                    continue;
                }
                StyleUtilities.copyStyle(styleFamily, attrValue, stylesCollection, globalStylesCollection, predefCollection);
            }
        }
    }

    private void startBody() throws IOException {
        this.getXmlWriter().writeTag("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "body", false);
    }

    private final boolean allowBuffering(int role) {
        return role == 6 || role == 5 || role == 11;
    }

    protected void startReportSection(AttributeMap attrs, int role) throws ReportProcessingException {
        if (this.allowBuffering(role)) {
            this.startBuffering(new OfficeStylesCollection(), true);
        }
    }

    protected abstract void startContent(AttributeMap var1) throws IOException, DataSourceException, ReportProcessingException;

    protected void startGroup(AttributeMap attrs) {
        Object iterationCount;
        Object repeatingHeaderOrFooter = attrs.getAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "repeating-header-or-footer");
        if ("true".equals(repeatingHeaderOrFooter)) {
            this.getGroupContext().setGroupWithRepeatingSection(true);
        }
        if ((iterationCount = attrs.getAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "iteration-count")) instanceof Number) {
            Number itNumber = (Number)iterationCount;
            this.getGroupContext().setIterationCount(itNumber.intValue());
        }
    }

    protected void startGroupInstance(AttributeMap attrs) {
    }

    protected abstract void startOther(AttributeMap var1) throws IOException, DataSourceException, ReportProcessingException;

    public void processText(String text) throws DataSourceException, ReportProcessingException {
        try {
            XmlWriter xmlWriter = this.getXmlWriter();
            BufferedReader br = new BufferedReader(new StringReader(text));
            String line = br.readLine();
            while (line != null) {
                xmlWriter.writeTextNormalized(line, false);
                line = br.readLine();
                if (line == null) continue;
                xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "line-break", true);
            }
        }
        catch (IOException e) {
            throw new ReportProcessingException(FAILED, e);
        }
    }

    protected boolean isFilteredNamespace(String namespace) {
        if ("http://jfreereport.sourceforge.net/namespaces/layout".equals(namespace)) {
            return true;
        }
        if ("http://jfreereport.sourceforge.net/namespaces/engine".equals(namespace)) {
            return true;
        }
        if ("http://jfreereport.sourceforge.net/namespaces/engine".equals(namespace)) {
            return true;
        }
        if ("http://jfreereport.sourceforge.net/namespaces/engine/compatibility".equals(namespace)) {
            return true;
        }
        return "http://openoffice.org/2005/report".equals(namespace);
    }

    public void processContent(DataFlags value) throws DataSourceException, ReportProcessingException {
        Object rawvalue = value.getValue();
        if (rawvalue == null) {
            return;
        }
        if (rawvalue instanceof Image) {
            return;
        }
        XmlWriter xmlWriter = this.getXmlWriter();
        String text = String.valueOf(rawvalue);
        try {
            BufferedReader br = new BufferedReader(new StringReader(text));
            String line = br.readLine();
            while (line != null) {
                xmlWriter.writeTextNormalized(line, false);
                line = br.readLine();
                if (line == null) continue;
                xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "line-break", true);
            }
        }
        catch (IOException e) {
            throw new ReportProcessingException(FAILED, e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void endElement(AttributeMap roAttrs) throws DataSourceException, ReportProcessingException {
        LazyAttributeMap attrs = new LazyAttributeMap(roAttrs);
        try {
            switch (this.getCurrentState()) {
                case 6: {
                    this.endOther((AttributeMap)attrs);
                    return;
                }
                case 5: {
                    this.endReportSection((AttributeMap)attrs, this.currentRole);
                    this.currentRole = 0;
                    return;
                }
                case 3: {
                    this.endGroup((AttributeMap)attrs);
                    this.groupContext = this.groupContext.getParent();
                    return;
                }
                case 7: {
                    return;
                }
                case 4: {
                    this.endGroupBody((AttributeMap)attrs);
                    return;
                }
                case 2: {
                    this.endContent((AttributeMap)attrs);
                    return;
                }
                case 1: {
                    this.endBody();
                    return;
                }
                case 0: {
                    throw new IllegalStateException("This cannot be.");
                }
                default: {
                    throw new IllegalStateException("Invalid state encountered.");
                }
            }
        }
        catch (IOException ioe) {
            throw new ReportProcessingException("IO Error while writing content", ioe);
        }
        finally {
            this.states.pop();
            if (DEBUG_ELEMENTS) {
                LOGGER.debug("Finished " + this.getCurrentState() + "/" + this.states.size() + " " + ReportTargetUtil.getNamespaceFromAttribute((AttributeMap)attrs) + ":" + ReportTargetUtil.getElemenTypeFromAttribute((AttributeMap)attrs));
            }
        }
    }

    protected void endGroupBody(AttributeMap attrs) throws IOException {
    }

    public int getCurrentRole() {
        return this.currentRole;
    }

    protected abstract void endOther(AttributeMap var1) throws IOException, DataSourceException, ReportProcessingException;

    protected void endReportSection(AttributeMap attrs, int role) throws IOException, ReportProcessingException {
        if (this.allowBuffering(role)) {
            this.finishBuffering();
        }
    }

    protected void endGroup(AttributeMap attrs) throws ReportProcessingException {
    }

    protected abstract void endContent(AttributeMap var1) throws IOException, DataSourceException, ReportProcessingException;

    private void endBody() throws IOException {
        this.getXmlWriter().writeCloseTag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyMeta() {
        if (this.getInputRepository().isReadable("meta.xml")) {
            InputStream inputStream = null;
            try {
                inputStream = this.getInputRepository().createInputStream("meta.xml");
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document document = dBuilder.parse(new InputSource(inputStream));
                document.getElementsByTagName("document-meta/meta/generator");
                Node node = document.getFirstChild().getFirstChild().getFirstChild().getFirstChild();
                String creator = node.getNodeValue();
                node.setNodeValue(creator + "/report_builder");
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("method", "xml");
                OutputStream outputMetaStream = this.getOutputRepository().createOutputStream("meta.xml", "text/xml");
                StreamResult result = new StreamResult(outputMetaStream);
                DOMSource source = new DOMSource(document);
                transformer.transform(source, result);
                outputMetaStream.flush();
                outputMetaStream.close();
            }
            catch (Exception ex) {
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(OfficeDocumentReportTarget.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
    }

    public void endReport(ReportStructureRoot report) throws DataSourceException, ReportProcessingException {
        if (this.xmlWriters.size() != 1) {
            throw new IllegalStateException("Invalid writer-stack state");
        }
        try {
            StylesWriter inlineStylesWriter = new StylesWriter(this.rootXmlWriter);
            inlineStylesWriter.writeContentStyles(this.contentStylesCollection);
            BufferState state = this.finishBuffering();
            this.rootXmlWriter.writeStream(state.getXmlAsReader());
            OutputStream stylesOutStream = this.outputRepository.createOutputStream("styles.xml", "text/xml");
            OutputStreamWriter osw = new OutputStreamWriter(stylesOutStream, "UTF-8");
            StylesWriter stylesWriter = new StylesWriter(osw);
            stylesWriter.writeGlobalStyles(this.globalStylesCollection);
            stylesWriter.close();
            this.rootXmlWriter.writeCloseTag();
            this.rootXmlWriter.close();
        }
        catch (IOException e) {
            throw new ReportProcessingException(FAILED, e);
        }
    }

    public XmlWriter getXmlWriter() {
        BufferState bufferState = (BufferState)this.xmlWriters.peek();
        return bufferState.getXmlWriter();
    }

    public OfficeStylesCollection getStylesCollection() {
        BufferState bufferState = (BufferState)this.xmlWriters.peek();
        return bufferState.getStylesCollection();
    }

    public void startBuffering(OfficeStylesCollection stylesCollection, boolean indent) throws ReportProcessingException {
        XmlWriter currentWriter;
        if (this.xmlWriters.isEmpty()) {
            currentWriter = this.rootXmlWriter;
        } else {
            BufferState bufferState = (BufferState)this.xmlWriters.peek();
            currentWriter = bufferState.getXmlWriter();
        }
        try {
            MemoryByteArrayOutputStream out = new MemoryByteArrayOutputStream(40960, 0xA00000);
            DeflaterOutputStream deflateOut = new DeflaterOutputStream(out);
            OutputStreamWriter xmlBuffer = new OutputStreamWriter((OutputStream)deflateOut, "UTF-16");
            XmlWriter contentXmlWriter = new XmlWriter((Writer)xmlBuffer, (TagDescription)this.createTagDescription());
            contentXmlWriter.copyNamespaces((XmlWriterSupport)currentWriter);
            if (indent) {
                contentXmlWriter.setAdditionalIndent(currentWriter.getCurrentIndentLevel());
                contentXmlWriter.setWriteFinalLinebreak(true);
            } else {
                contentXmlWriter.setWriteFinalLinebreak(false);
            }
            contentXmlWriter.setAlwaysAddNamespace(true);
            this.xmlWriters.push((Object)new BufferState(contentXmlWriter, out, stylesCollection));
        }
        catch (IOException ioe) {
            throw new ReportProcessingException("Unable to create the buffer", ioe);
        }
    }

    public BufferState finishBuffering() {
        BufferState state = (BufferState)this.xmlWriters.pop();
        try {
            state.getXmlWriter().close();
        }
        catch (IOException e) {
            LOGGER.error("ReportProcessing failed", e);
        }
        return state;
    }

    public void commit() throws ReportProcessingException {
    }

    public NamespaceDefinition getNamespaceByUri(String uri) {
        return null;
    }

    protected AttributeList buildAttributeList(AttributeMap attrs) {
        String elementType = ReportTargetUtil.getElemenTypeFromAttribute(attrs);
        AttributeList attrList = new AttributeList();
        String[] namespaces = attrs.getNameSpaces();
        for (int i = 0; i < namespaces.length; ++i) {
            String attrNamespace = namespaces[i];
            if (this.isFilteredNamespace(attrNamespace)) continue;
            Map localAttributes = attrs.getAttributes(attrNamespace);
            for (Map.Entry entry : localAttributes.entrySet()) {
                String key = String.valueOf(entry.getKey());
                if ("urn:oasis:names:tc:opendocument:xmlns:table:1.0".equals(attrNamespace) && "name".equals(key)) {
                    String tableName = String.valueOf(entry.getValue());
                    String saneName = this.sanitizeName(tableName);
                    attrList.setAttribute(attrNamespace, key, this.tableNameGenerator.generateName(saneName));
                    continue;
                }
                if ("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0".equals(attrNamespace) && "name".equals(key) && !"equation".equals(elementType)) {
                    String objectName = String.valueOf(entry.getValue());
                    attrList.setAttribute(attrNamespace, key, this.frameNameGenerator.generateName(objectName));
                    continue;
                }
                attrList.setAttribute(attrNamespace, key, String.valueOf(entry.getValue()));
            }
        }
        return attrList;
    }

    private String sanitizeName(String name) {
        if (name == null) {
            return "";
        }
        char[] chars = name.toCharArray();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < chars.length; ++i) {
            char aChar = chars[i];
            if (Character.isWhitespace(aChar)) {
                buffer.append('_');
                continue;
            }
            buffer.append(aChar);
        }
        return buffer.toString();
    }

    protected CSSNumericValue parseLength(String text) {
        if (this.styleSheetParserUtil == null) {
            this.styleSheetParserUtil = StyleSheetParserUtil.getInstance();
        }
        LexicalUnit cssValue = this.styleSheetParserUtil.parseLexicalStyleValue(text);
        return CSSValueFactory.createLengthValue((LexicalUnit)cssValue);
    }

    protected boolean isRepeatingSection() {
        return this.currentRole == 6 || this.currentRole == 5 || this.currentRole == 8 || this.currentRole == 7 || this.currentRole == 10;
    }

    protected OfficeStyle deriveStyle(String styleFamily, String styleName) throws ReportProcessingException {
        OfficeStyle style = StyleUtilities.deriveStyle(styleFamily, styleName, this.getStylesCollection(), this.getGlobalStylesCollection(), this.getPredefinedStylesCollection(), this.getAutoStyleNameGenerator());
        return style;
    }

    protected void startImageProcessing(AttributeMap attrs) throws ReportProcessingException {
        boolean preserveIRI;
        Object imageData = attrs.getAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "image-data");
        ImageProducer.OfficeImage image = this.imageProducer.produceImage(imageData, preserveIRI = "true".equals(attrs.getAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "preserve-IRI")));
        if (image != null) {
            CSSNumericValue imageAreaHeightVal;
            CSSNumericValue imageAreaWidthVal;
            ImageElementContext imageContext = (ImageElementContext)attrs.getAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "image-context");
            CSSNumericValue width = image.getWidth();
            CSSNumericValue height = image.getHeight();
            LOGGER.debug("Image " + imageData + " Width: " + width + ", Height: " + height);
            if (width == null || height == null) {
                return;
            }
            CSSNumericValue posX = CSSNumericValue.createValue((CSSNumericType)CSSNumericType.CM, (double)0.0);
            CSSNumericValue posY = CSSNumericValue.createValue((CSSNumericType)CSSNumericType.CM, (double)0.0);
            String styleName = null;
            if (imageContext != null) {
                imageAreaWidthVal = this.computeImageWidth(imageContext);
                imageAreaHeightVal = this.computeImageHeight(imageContext);
                if (imageAreaWidthVal == null || imageAreaHeightVal == null) {
                    LOGGER.debug("Image data returned from context is invalid. Maybe this is not an image?");
                    return;
                }
                CSSNumericValue normalizedImageWidth = CSSValueResolverUtility.convertLength((CSSNumericValue)width, (CSSNumericType)imageAreaWidthVal.getType());
                CSSNumericValue normalizedImageHeight = CSSValueResolverUtility.convertLength((CSSNumericValue)height, (CSSNumericType)imageAreaHeightVal.getType());
                String scale = (String)attrs.getAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "scale");
                if ("none".equals(scale) && normalizedImageWidth.getValue() > 0.0 && normalizedImageHeight.getValue() > 0.0) {
                    double clipWidth = normalizedImageWidth.getValue() - imageAreaWidthVal.getValue();
                    double clipHeight = normalizedImageHeight.getValue() - imageAreaHeightVal.getValue();
                    if (clipWidth > 0.0 && clipHeight > 0.0) {
                        OfficeStyle imageStyle = this.deriveStyle("graphic", "Graphics");
                        Element graphProperties = this.produceFirstChild(imageStyle, "urn:oasis:names:tc:opendocument:xmlns:style:1.0", "graphic-properties");
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("rect(");
                        buffer.append(clipHeight / 2.0);
                        buffer.append(imageAreaHeightVal.getType().getType());
                        buffer.append(' ');
                        buffer.append(clipWidth / 2.0);
                        buffer.append(imageAreaWidthVal.getType().getType());
                        buffer.append(' ');
                        buffer.append(clipHeight / 2.0);
                        buffer.append(imageAreaHeightVal.getType().getType());
                        buffer.append(' ');
                        buffer.append(clipWidth / 2.0);
                        buffer.append(imageAreaWidthVal.getType().getType());
                        buffer.append(')');
                        graphProperties.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "clip", buffer.toString());
                        styleName = imageStyle.getStyleName();
                        this.getStylesCollection().getAutomaticStyles().addStyle(imageStyle);
                    } else if (clipWidth > 0.0) {
                        OfficeStyle imageStyle = this.deriveStyle("graphic", "Graphics");
                        Element graphProperties = this.produceFirstChild(imageStyle, "urn:oasis:names:tc:opendocument:xmlns:style:1.0", "graphic-properties");
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("rect(0cm ");
                        buffer.append(clipWidth / 2.0);
                        buffer.append(imageAreaWidthVal.getType().getType());
                        buffer.append(" 0cm ");
                        buffer.append(clipWidth / 2.0);
                        buffer.append(imageAreaWidthVal.getType().getType());
                        buffer.append(')');
                        graphProperties.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "clip", buffer.toString());
                        styleName = imageStyle.getStyleName();
                        this.getStylesCollection().getAutomaticStyles().addStyle(imageStyle);
                        imageAreaHeightVal = normalizedImageHeight;
                    } else if (clipHeight > 0.0) {
                        OfficeStyle imageStyle = this.deriveStyle("graphic", "Graphics");
                        Element graphProperties = this.produceFirstChild(imageStyle, "urn:oasis:names:tc:opendocument:xmlns:style:1.0", "graphic-properties");
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("rect(");
                        buffer.append(clipHeight / 2.0);
                        buffer.append(imageAreaHeightVal.getType().getType());
                        buffer.append(" 0cm ");
                        buffer.append(clipHeight / 2.0);
                        buffer.append(imageAreaHeightVal.getType().getType());
                        buffer.append(" 0cm)");
                        graphProperties.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "clip", buffer.toString());
                        styleName = imageStyle.getStyleName();
                        this.getStylesCollection().getAutomaticStyles().addStyle(imageStyle);
                        imageAreaWidthVal = normalizedImageWidth;
                    } else {
                        imageAreaWidthVal = normalizedImageWidth;
                        imageAreaHeightVal = normalizedImageHeight;
                    }
                } else if ("isotropic".equals(scale)) {
                    double[] ret = OfficeDocumentReportTarget.calcPaintSize(imageAreaWidthVal, imageAreaHeightVal, normalizedImageWidth, normalizedImageHeight);
                    posX = CSSNumericValue.createValue((CSSNumericType)imageAreaWidthVal.getType(), (double)((imageAreaWidthVal.getValue() - ret[0]) * 0.5));
                    posY = CSSNumericValue.createValue((CSSNumericType)imageAreaHeightVal.getType(), (double)((imageAreaHeightVal.getValue() - ret[1]) * 0.5));
                    imageAreaWidthVal = CSSNumericValue.createValue((CSSNumericType)imageAreaWidthVal.getType(), (double)ret[0]);
                    imageAreaHeightVal = CSSNumericValue.createValue((CSSNumericType)imageAreaHeightVal.getType(), (double)ret[1]);
                }
            } else {
                LOGGER.debug("There is no image-context, so we have to rely on the image's natural bounds. This may go awfully wrong.");
                imageAreaWidthVal = image.getWidth();
                imageAreaHeightVal = image.getHeight();
            }
            AttributeList frameList = new AttributeList();
            frameList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "name", this.imageNames.generateName("Image"));
            if (styleName != null) {
                frameList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "style-name", styleName);
            }
            frameList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "anchor-type", "paragraph");
            frameList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", "z-index", "0");
            frameList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", "x", posX.getValue() + posX.getType().getType());
            frameList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", "y", posY.getValue() + posY.getType().getType());
            LOGGER.debug("Image " + imageData + " A-Width: " + imageAreaWidthVal + ", A-Height: " + imageAreaHeightVal);
            if (imageAreaWidthVal != null) {
                frameList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", "width", imageAreaWidthVal.getValue() + imageAreaWidthVal.getType().getType());
            }
            if (imageAreaHeightVal != null) {
                frameList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", "height", imageAreaHeightVal.getValue() + imageAreaHeightVal.getType().getType());
            }
            AttributeList imageList = new AttributeList();
            imageList.setAttribute("http://www.w3.org/1999/xlink", "href", image.getEmbeddableLink());
            imageList.setAttribute("http://www.w3.org/1999/xlink", "type", "simple");
            imageList.setAttribute("http://www.w3.org/1999/xlink", "show", "embed");
            imageList.setAttribute("http://www.w3.org/1999/xlink", "actuate", "onLoad");
            try {
                this.getXmlWriter().writeTag("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "frame", frameList, false);
                this.getXmlWriter().writeTag("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "image", imageList, true);
                this.getXmlWriter().writeCloseTag();
            }
            catch (IOException ioe) {
                throw new ReportProcessingException(FAILED, ioe);
            }
        }
    }

    private CSSNumericValue computeImageWidth(ImageElementContext imageElementContext) {
        LengthCalculator calculator = new LengthCalculator();
        String[] strings = imageElementContext.getColStyles();
        for (int i = 0; i < strings.length; ++i) {
            String styleName = strings[i];
            CSSNumericValue value = this.computeColumnWidth(styleName);
            if (value == null) continue;
            calculator.add(value);
        }
        return calculator.getResult();
    }

    private CSSNumericValue computeImageHeight(ImageElementContext imageElementContext) {
        LengthCalculator calculator = new LengthCalculator();
        String[] strings = imageElementContext.getRowStyles();
        for (int i = 0; i < strings.length; ++i) {
            String styleName = strings[i];
            CSSNumericValue value = this.computeRowHeight(styleName);
            if (value == null) continue;
            calculator.add(value);
        }
        return calculator.getResult();
    }

    protected CSSNumericValue computeRowHeight(String rowStyle) {
        OfficeStylesCollection predefStyles;
        OfficeStyle predefStyle;
        OfficeStylesCollection globalStyles;
        OfficeStyle globalStyle;
        OfficeStylesCollection contentStyles = this.getContentStylesCollection();
        OfficeStyle style = contentStyles.getStyle("table-row", rowStyle);
        if (style != null) {
            String height;
            Element element = style.getTableRowProperties();
            if (element != null && (height = (String)element.getAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "row-height")) != null) {
                return this.parseLength(height);
            }
            String styleParent = style.getStyleParent();
            if (styleParent != null) {
                return this.computeRowHeight(styleParent);
            }
        }
        if ((globalStyle = (globalStyles = this.getGlobalStylesCollection()).getStyle("table-row", rowStyle)) != null) {
            String height;
            Element element = globalStyle.getTableRowProperties();
            if (element != null && (height = (String)element.getAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "row-height")) != null) {
                return this.parseLength(height);
            }
            String styleParent = globalStyle.getStyleParent();
            if (styleParent != null) {
                return this.computeRowHeight(styleParent);
            }
        }
        if ((predefStyle = (predefStyles = this.getPredefinedStylesCollection()).getStyle("table-row", rowStyle)) != null) {
            String height;
            Element element = predefStyle.getTableRowProperties();
            if (element != null && (height = (String)element.getAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "row-height")) != null) {
                return this.parseLength(height);
            }
            String styleParent = predefStyle.getStyleParent();
            if (styleParent != null) {
                return this.computeRowHeight(styleParent);
            }
        }
        return null;
    }

    private CSSNumericValue computeColumnWidth(String colStyle) {
        OfficeStylesCollection predefStyles;
        OfficeStyle predefStyle;
        OfficeStylesCollection globalStyles;
        OfficeStyle globalStyle;
        OfficeStylesCollection contentStyles = this.getContentStylesCollection();
        OfficeStyle style = contentStyles.getStyle("table-column", colStyle);
        if (style != null) {
            String height;
            Element element = style.getTableColumnProperties();
            if (element != null && (height = (String)element.getAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "column-width")) != null) {
                return this.parseLength(height);
            }
            String styleParent = style.getStyleParent();
            if (styleParent != null) {
                return this.computeRowHeight(styleParent);
            }
        }
        if ((globalStyle = (globalStyles = this.getGlobalStylesCollection()).getStyle("table-column", colStyle)) != null) {
            String height;
            Element element = globalStyle.getTableColumnProperties();
            if (element != null && (height = (String)element.getAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "column-width")) != null) {
                return this.parseLength(height);
            }
            String styleParent = globalStyle.getStyleParent();
            if (styleParent != null) {
                return this.computeRowHeight(styleParent);
            }
        }
        if ((predefStyle = (predefStyles = this.getPredefinedStylesCollection()).getStyle("table-column", colStyle)) != null) {
            String height;
            Element element = predefStyle.getTableColumnProperties();
            if (element != null && (height = (String)element.getAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "column-width")) != null) {
                return this.parseLength(height);
            }
            String styleParent = predefStyle.getStyleParent();
            if (styleParent != null) {
                return this.computeRowHeight(styleParent);
            }
        }
        return null;
    }

    protected Element produceFirstChild(Section style, String nameSpace, String type) {
        Element paragraphProps = style.findFirstChild(nameSpace, type);
        if (paragraphProps == null) {
            paragraphProps = new Section();
            paragraphProps.setNamespace(nameSpace);
            paragraphProps.setType(type);
            style.addNode(paragraphProps);
        }
        return paragraphProps;
    }

    protected void startChartProcessing(AttributeMap attrs) throws ReportProcessingException {
        String classId = (String)attrs.getAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "class-id");
        String chartUrl = (String)attrs.getAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "href");
        ArrayList masterColumns = (ArrayList)attrs.getAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "master-columns");
        ArrayList masterValues = (ArrayList)attrs.getAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "master-values");
        ArrayList detailColumns = (ArrayList)attrs.getAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "detail-columns");
        String href = this.oleProducer.produceOle(chartUrl, masterColumns, masterValues, detailColumns);
        AttributeList oleList = new AttributeList();
        oleList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "class-id", classId);
        oleList.setAttribute("http://www.w3.org/1999/xlink", "href", "./" + href);
        oleList.setAttribute("http://www.w3.org/1999/xlink", "type", "simple");
        oleList.setAttribute("http://www.w3.org/1999/xlink", "show", "embed");
        oleList.setAttribute("http://www.w3.org/1999/xlink", "actuate", "onLoad");
        try {
            this.getXmlWriter().writeTag("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "object-ole", oleList, true);
        }
        catch (IOException ioe) {
            throw new ReportProcessingException(FAILED, ioe);
        }
    }

    private static double[] calcPaintSize(CSSNumericValue areaWidth, CSSNumericValue areaHeight, CSSNumericValue imageWidth, CSSNumericValue imageHeight) {
        double ratioX = areaWidth.getValue() / imageWidth.getValue();
        double ratioY = areaHeight.getValue() / imageHeight.getValue();
        double ratioMin = Math.min(ratioX, ratioY);
        double[] ret = new double[]{imageWidth.getValue() * ratioMin, imageHeight.getValue() * ratioMin};
        return ret;
    }

    protected void writeNullDate() throws IOException {
        XmlWriter xmlWriter = this.getXmlWriter();
        xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "calculation-settings", null, false);
        AttributeMap nullDateAttributes = new AttributeMap();
        nullDateAttributes.setAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "date-value", (Object)"1899-12-30");
        xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "null-date", this.buildAttributeList(nullDateAttributes), true);
        xmlWriter.writeCloseTag();
    }

    public static class GroupContext {
        private final GroupContext parent;
        private int iterationCount;
        private boolean groupWithRepeatingSection;

        private GroupContext(GroupContext parent) {
            this.parent = parent;
        }

        public GroupContext getParent() {
            return this.parent;
        }

        public int getIterationCount() {
            return this.iterationCount;
        }

        private void setIterationCount(int iterationCount) {
            this.iterationCount = iterationCount;
        }

        public boolean isGroupWithRepeatingSection() {
            return this.groupWithRepeatingSection;
        }

        private void setGroupWithRepeatingSection(boolean groupWithRepeatingSection) {
            this.groupWithRepeatingSection = groupWithRepeatingSection;
        }

        public String toString() {
            return "GroupContext{parent=" + this.parent + ", iterationCount=" + this.iterationCount + ", groupWithRepeatingSection=" + this.groupWithRepeatingSection + '}';
        }
    }

    protected static class BufferState {
        private final XmlWriter xmlWriter;
        private final MemoryByteArrayOutputStream xmlBuffer;
        private final OfficeStylesCollection stylesCollection;

        private BufferState(XmlWriter xmlWriter, MemoryByteArrayOutputStream xmlBuffer, OfficeStylesCollection stylesCollection) {
            this.stylesCollection = stylesCollection;
            this.xmlWriter = xmlWriter;
            this.xmlBuffer = xmlBuffer;
        }

        public OfficeStylesCollection getStylesCollection() {
            return this.stylesCollection;
        }

        public XmlWriter getXmlWriter() {
            return this.xmlWriter;
        }

        public String getXmlBuffer() throws ReportProcessingException {
            try {
                byte[] zippedData = this.xmlBuffer.getRaw();
                InputStreamReader reader = new InputStreamReader((InputStream)new InflaterInputStream(new ByteArrayInputStream(zippedData, 0, this.xmlBuffer.getLength())), "UTF-16");
                StringWriter writer = new StringWriter(zippedData.length / 2 + 1);
                IOUtils.getInstance().copyWriter((Reader)reader, (Writer)writer);
                return writer.toString();
            }
            catch (IOException e) {
                throw new ReportProcessingException("Failed to copy buffer", e);
            }
        }

        public Reader getXmlAsReader() throws ReportProcessingException {
            try {
                byte[] zippedData = this.xmlBuffer.getRaw();
                return new InputStreamReader((InputStream)new InflaterInputStream(new ByteArrayInputStream(zippedData, 0, this.xmlBuffer.getLength())), "UTF-16");
            }
            catch (IOException e) {
                throw new ReportProcessingException("Failed to copy buffer", e);
            }
        }
    }
}

