/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.adapter;

import com.sun.star.io.IOException;
import com.sun.star.io.XInputStream;
import java.io.InputStream;

public final class InputStreamToXInputStreamAdapter
implements XInputStream {
    private final InputStream iIn;

    public InputStreamToXInputStreamAdapter(InputStream in) {
        this.iIn = in;
    }

    public int available() throws IOException {
        int bytesAvail;
        try {
            bytesAvail = this.iIn.available();
        }
        catch (java.io.IOException e) {
            throw new IOException(e);
        }
        return bytesAvail;
    }

    public void closeInput() throws IOException {
        try {
            this.iIn.close();
        }
        catch (java.io.IOException e) {
            throw new IOException(e);
        }
    }

    public int readBytes(byte[][] b, int len) throws IOException {
        try {
            long bytesRead = len > this.iIn.available() ? (long)this.iIn.read(b[0], 0, this.iIn.available()) : (long)this.iIn.read(b[0], 0, len);
            if (bytesRead <= 0L) {
                return 0;
            }
            return (int)bytesRead;
        }
        catch (java.io.IOException e) {
            throw new IOException("reader error", (Object)e);
        }
    }

    public int readSomeBytes(byte[][] b, int len) throws IOException {
        try {
            long bytesRead = len > this.iIn.available() ? (long)this.iIn.read(b[0], 0, this.iIn.available()) : (long)this.iIn.read(b[0], 0, len);
            if (bytesRead <= 0L) {
                return 0;
            }
            return (int)bytesRead;
        }
        catch (java.io.IOException e) {
            throw new IOException("reader error", (Object)e);
        }
    }

    public void skipBytes(int n) throws IOException {
        int tmpLongVal = n;
        try {
            this.iIn.available();
        }
        catch (java.io.IOException e) {
            throw new IOException(e);
        }
        do {
            int tmpIntVal = tmpLongVal >= Integer.MAX_VALUE ? Integer.MAX_VALUE : tmpLongVal;
            tmpLongVal -= tmpIntVal;
            try {
                this.iIn.skip(tmpIntVal);
            }
            catch (java.io.IOException e) {
                throw new IOException(e);
            }
        } while (tmpLongVal > 0);
    }
}

