/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.modules.autoupdate.services.UpdateManagerImpl;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;

public class DependencyAggregator {
    private static Map<DependencyDecoratorKey, DependencyAggregator> key2dependency = new HashMap<DependencyDecoratorKey, DependencyAggregator>(11, 11.0f);
    private Collection<ModuleInfo> depending = new HashSet<ModuleInfo>();
    private final DependencyDecoratorKey key;
    private static final Object LOCK = new Object();

    private DependencyAggregator(DependencyDecoratorKey dependencyDecoratorKey) {
        this.key = dependencyDecoratorKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DependencyAggregator getAggregator(Dependency dependency) {
        DependencyDecoratorKey dependencyDecoratorKey = new DependencyDecoratorKey(dependency.getName(), dependency.getType(), dependency.getComparison());
        Object object = LOCK;
        synchronized (object) {
            DependencyAggregator dependencyAggregator = key2dependency.get(dependencyDecoratorKey);
            if (dependencyAggregator == null) {
                dependencyAggregator = new DependencyAggregator(dependencyDecoratorKey);
                key2dependency.put(dependencyDecoratorKey, dependencyAggregator);
            }
            return dependencyAggregator;
        }
    }

    public int getType() {
        return this.key.type;
    }

    public String getName() {
        return this.key.name;
    }

    public boolean addDependee(ModuleInfo moduleInfo) {
        return this.depending.add(moduleInfo);
    }

    public Collection<ModuleInfo> getDependening() {
        return this.depending;
    }

    static void clearMaps() {
        key2dependency = new HashMap<DependencyDecoratorKey, DependencyAggregator>(11, 11.0f);
    }

    public String toString() {
        return "DependencyDecorator[" + this.key.toString() + "]";
    }

    public static Collection<UpdateUnit> getRequested(Dependency dependency) {
        switch (dependency.getType()) {
            case 1: {
                return Collections.singleton(UpdateManagerImpl.getInstance().getUpdateUnit(dependency.getName()));
            }
            case 5: 
            case 6: 
            case 7: {
                HashSet<UpdateUnit> hashSet = new HashSet<UpdateUnit>();
                Collection<ModuleInfo> collection = UpdateManagerImpl.getInstance().getInstalledProviders(dependency.getName());
                if (collection.isEmpty()) {
                    Collection<ModuleInfo> collection2 = UpdateManagerImpl.getInstance().getAvailableProviders(dependency.getName());
                    if (collection2.isEmpty()) {
                        return null;
                    }
                    for (ModuleInfo moduleInfo : collection2) {
                        UpdateUnit updateUnit = UpdateManagerImpl.getInstance().getUpdateUnit(moduleInfo.getCodeNameBase());
                        if (updateUnit == null) continue;
                        hashSet.add(updateUnit);
                    }
                    return hashSet;
                }
                for (ModuleInfo moduleInfo : collection) {
                    UpdateUnit updateUnit = UpdateManagerImpl.getInstance().getUpdateUnit(moduleInfo.getCodeNameBase());
                    if (updateUnit == null) continue;
                    hashSet.add(updateUnit);
                }
                return hashSet;
            }
        }
        return null;
    }

    public static class DependencyDecoratorKey {
        private final String name;
        private final int type;
        private final int hashCode;

        public DependencyDecoratorKey(String string, int n, int n2) {
            this.name = string;
            this.type = n;
            this.hashCode = 0xBC7E3 ^ this.type ^ string.hashCode();
        }

        public boolean equals(Object object) {
            if (object.getClass() != DependencyDecoratorKey.class) {
                return false;
            }
            DependencyDecoratorKey dependencyDecoratorKey = (DependencyDecoratorKey)object;
            return this.type == dependencyDecoratorKey.type && this.name.equals(dependencyDecoratorKey.name);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(100);
            stringBuilder.append("Key[");
            if (this.type == 1) {
                stringBuilder.append("module ");
            } else if (this.type == 2) {
                stringBuilder.append("package ");
            } else if (this.type == 5) {
                stringBuilder.append("requires ");
            } else if (this.type == 6) {
                stringBuilder.append("needs ");
            } else if (this.type == 7) {
                stringBuilder.append("recommends ");
            }
            stringBuilder.append(this.name);
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }
}

