/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.charts.ChartComponent;
import org.netbeans.lib.profiler.charts.ChartConfigurationListener;
import org.netbeans.lib.profiler.charts.ChartSelectionModel;
import org.netbeans.lib.profiler.charts.Timeline;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemsModel;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.snaptracer.impl.options.TracerOptions;
import org.netbeans.modules.profiler.snaptracer.impl.swing.ScrollBar;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.Bundle;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.RowBackgroundDecorator;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.RowBoundsDecorator;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.RowForegroundDecorator;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineAxis;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineChart;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineSelectionOverlay;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineSupport;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.XChartSelectionOverlay;

final class ChartPanel
extends JPanel {
    private static final Icon ZOOM_IN_ICON = Icons.getIcon((String)"GeneralIcons.ZoomIn");
    private static final Icon ZOOM_OUT_ICON = Icons.getIcon((String)"GeneralIcons.ZoomOut");
    private static final Icon FIXED_SCALE_ICON = Icons.getIcon((String)"GeneralIcons.Zoom");
    private static final Icon SCALE_TO_FIT_ICON = Icons.getIcon((String)"GeneralIcons.ScaleToFit");
    private static final Icon ZMWHEEL_ICON = Icons.getIcon((String)"TracerIcons.MouseWheelZoom");
    private static final Icon HMWHEEL_ICON = Icons.getIcon((String)"TracerIcons.MouseWheelHorizontal");
    private static final Icon VMWHEEL_ICON = Icons.getIcon((String)"TracerIcons.MouseWheelVertical");
    private final TimelineChart chart;
    private ZoomInAction zoomInAction;
    private ZoomOutAction zoomOutAction;
    private ToggleViewAction toggleViewAction;
    private final JScrollBar hScrollBar;
    private final JScrollBar vScrollBar;
    private final MouseWheelListener defaultWheelHandler;
    private AbstractButton mouseZoom;
    private AbstractButton mouseHScroll;
    private AbstractButton mouseVScroll;

    ChartPanel(TimelineChart timelineChart, TimelineSupport timelineSupport) {
        this.chart = timelineChart;
        boolean bl = Utils.forceSpeed();
        timelineChart.setBackground(Color.WHITE);
        if (bl && TracerOptions.getInstance().isRowsSelectionEnabled()) {
            timelineChart.addPreDecorator(new RowBackgroundDecorator(timelineChart));
        }
        timelineChart.addPreDecorator(new RowBoundsDecorator(timelineChart));
        timelineChart.addPostDecorator(new RowForegroundDecorator(timelineChart, TracerOptions.getInstance().isRowsDecorationEnabled(), bl ? false : TracerOptions.getInstance().isRowsSelectionEnabled()));
        TimelineSelectionOverlay timelineSelectionOverlay = new TimelineSelectionOverlay();
        timelineChart.addOverlayComponent(timelineSelectionOverlay);
        timelineSelectionOverlay.registerChart(timelineSupport);
        XChartSelectionOverlay xChartSelectionOverlay = new XChartSelectionOverlay(timelineSupport);
        xChartSelectionOverlay.setLineMode(false, false, false, false);
        timelineChart.addOverlayComponent(xChartSelectionOverlay);
        xChartSelectionOverlay.registerChart((ChartComponent)timelineChart);
        ChartSelectionModel chartSelectionModel = timelineChart.getSelectionModel();
        if (chartSelectionModel != null) {
            chartSelectionModel.setHoverMode(102);
            chartSelectionModel.setMoveMode(1);
            chartSelectionModel.setDragMode(4);
        }
        TimelineAxis timelineAxis = new TimelineAxis(timelineChart, timelineSupport);
        this.hScrollBar = new ScrollBar(0);
        this.hScrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (ChartPanel.this.hScrollBar.getValueIsAdjusting()) {
                    ChartPanel.this.chart.updateSelection(false, ChartPanel.this.hScrollBar);
                } else {
                    ChartPanel.this.chart.updateSelection(true, ChartPanel.this.hScrollBar);
                }
            }
        });
        timelineChart.attachHorizontalScrollBar(this.hScrollBar);
        this.vScrollBar = new ScrollBar(1){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.height = 1;
                return dimension;
            }
        };
        this.vScrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (ChartPanel.this.vScrollBar.getValueIsAdjusting()) {
                    ChartPanel.this.chart.updateSelection(false, ChartPanel.this.vScrollBar);
                } else {
                    ChartPanel.this.chart.updateSelection(true, ChartPanel.this.vScrollBar);
                }
            }
        });
        timelineChart.attachVerticalScrollBar(this.vScrollBar);
        this.defaultWheelHandler = timelineChart.getMouseWheelListeners()[0];
        timelineChart.addConfigurationListener((ChartConfigurationListener)new VisibleBoundsListener());
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.add((Component)timelineAxis, "North");
        this.add((Component)((Object)timelineChart), "Center");
        this.add((Component)this.vScrollBar, "East");
        this.add((Component)this.hScrollBar, "South");
        this.resetChart();
    }

    void resetChart() {
        this.chart.setScale(0.02, 1.0);
        this.chart.setOffset(0L, 0L);
    }

    boolean resetSelection() {
        this.chart.getSelectionModel().setSelectionBounds(null);
        return false;
    }

    void updateActions() {
        if (this.zoomInAction != null) {
            this.zoomInAction.updateAction();
        }
        if (this.zoomOutAction != null) {
            this.zoomOutAction.updateAction();
        }
        if (this.toggleViewAction != null) {
            this.toggleViewAction.updateAction();
        }
    }

    Action zoomInAction() {
        if (this.zoomInAction == null) {
            this.zoomInAction = new ZoomInAction();
        }
        return this.zoomInAction;
    }

    Action zoomOutAction() {
        if (this.zoomOutAction == null) {
            this.zoomOutAction = new ZoomOutAction();
        }
        return this.zoomOutAction;
    }

    Action toggleViewAction() {
        if (this.toggleViewAction == null) {
            this.toggleViewAction = new ToggleViewAction();
            if (TracerOptions.getInstance().getZoomMode().equals("scale to fit")) {
                this.toggleViewAction.actionPerformed(null);
            }
        }
        return this.toggleViewAction;
    }

    AbstractButton mouseZoom() {
        if (this.mouseZoom == null) {
            this.mouseZoom = new OneWayToggleButton(ZMWHEEL_ICON, Bundle.ACTION_WheelZooms_name()){

                @Override
                protected void performAction() {
                    ChartPanel.this.mouseZoomImpl();
                }
            };
            if (TracerOptions.getInstance().getMouseWheelAction().equals("zoom")) {
                this.mouseZoom.setSelected(true);
                this.mouseZoomImpl();
            }
        }
        return this.mouseZoom;
    }

    AbstractButton mouseHScroll() {
        if (this.mouseHScroll == null) {
            this.mouseHScroll = new OneWayToggleButton(HMWHEEL_ICON, Bundle.ACTION_WheelHScrolls_name()){

                @Override
                protected void performAction() {
                    ChartPanel.this.mouseHScrollImpl();
                }
            };
            if (TracerOptions.getInstance().getMouseWheelAction().equals("horizontal scroll")) {
                this.mouseHScroll.setSelected(true);
                this.mouseHScrollImpl();
            }
        }
        return this.mouseHScroll;
    }

    AbstractButton mouseVScroll() {
        if (this.mouseVScroll == null) {
            this.mouseVScroll = new OneWayToggleButton(VMWHEEL_ICON, Bundle.ACTION_WheelVScrolls_name()){

                @Override
                protected void performAction() {
                    ChartPanel.this.mouseVScrollImpl();
                }
            };
            if (TracerOptions.getInstance().getMouseWheelAction().equals("vertical scroll")) {
                this.mouseVScroll.setSelected(true);
                this.mouseVScrollImpl();
            }
        }
        return this.mouseVScroll;
    }

    void vScroll(MouseWheelEvent mouseWheelEvent) {
        ChartPanel.scroll(this.vScrollBar, mouseWheelEvent);
    }

    private void mouseZoomImpl() {
        this.clearWheelHandlers();
        this.chart.setMouseZoomingEnabled(true);
        this.chart.addMouseWheelListener(this.defaultWheelHandler);
    }

    private void mouseHScrollImpl() {
        this.chart.setMouseZoomingEnabled(false);
        this.clearWheelHandlers();
        this.setWheelScrollHandler(this.hScrollBar);
    }

    private void mouseVScrollImpl() {
        this.chart.setMouseZoomingEnabled(false);
        this.clearWheelHandlers();
        this.setWheelScrollHandler(this.vScrollBar);
    }

    private void clearWheelHandlers() {
        MouseWheelListener[] mouseWheelListenerArray;
        for (MouseWheelListener mouseWheelListener : mouseWheelListenerArray = this.chart.getMouseWheelListeners()) {
            this.chart.removeMouseWheelListener(mouseWheelListener);
        }
    }

    private void setWheelScrollHandler(final JScrollBar jScrollBar) {
        this.chart.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                ChartPanel.scroll(jScrollBar, mouseWheelEvent);
            }
        });
    }

    private static void scroll(JScrollBar jScrollBar, MouseWheelEvent mouseWheelEvent) {
        if (mouseWheelEvent.getScrollType() == 0) {
            int n;
            int n2 = mouseWheelEvent.getUnitsToScroll();
            int n3 = n = n2 < 0 ? -1 : 1;
            if (n2 != 0) {
                int n4 = jScrollBar.getUnitIncrement(n);
                int n5 = jScrollBar.getValue();
                int n6 = n5 + n4 * n2;
                if (n5 != (n6 = Math.max(Math.min(n6, jScrollBar.getMaximum() - jScrollBar.getVisibleAmount()), jScrollBar.getMinimum()))) {
                    jScrollBar.setValue(n6);
                }
            }
        }
    }

    private class VisibleBoundsListener
    extends ChartConfigurationListener.Adapter {
        private VisibleBoundsListener() {
        }

        public void dataBoundsChanged(long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8) {
            if (ChartPanel.this.zoomInAction != null) {
                ChartPanel.this.zoomInAction.updateAction();
            }
            if (ChartPanel.this.zoomOutAction != null) {
                ChartPanel.this.zoomOutAction.updateAction();
            }
        }

        public void scaleChanged(double d, double d2, double d3, double d4) {
            if (ChartPanel.this.zoomInAction != null) {
                ChartPanel.this.zoomInAction.updateAction();
            }
            if (ChartPanel.this.zoomOutAction != null) {
                ChartPanel.this.zoomOutAction.updateAction();
            }
        }
    }

    private static abstract class OneWayToggleButton
    extends JToggleButton {
        private boolean action;

        public OneWayToggleButton(Icon icon, String string) {
            super(icon);
            this.setToolTipText(string);
        }

        @Override
        protected void processMouseEvent(MouseEvent mouseEvent) {
            if (this.isSelected()) {
                mouseEvent.consume();
                this.action = false;
            } else {
                this.action = true;
            }
            super.processMouseEvent(mouseEvent);
        }

        @Override
        protected void processKeyEvent(KeyEvent keyEvent) {
            if (this.isSelected()) {
                keyEvent.consume();
                this.action = false;
            } else {
                this.action = true;
            }
            super.processKeyEvent(keyEvent);
        }

        @Override
        protected final void fireActionPerformed(ActionEvent actionEvent) {
            if (this.action) {
                this.performAction();
            }
        }

        protected abstract void performAction();
    }

    private class ToggleViewAction
    extends AbstractAction {
        private long origOffsetX = -1L;
        private double origScaleX = -1.0;

        public ToggleViewAction() {
            this.updateAction();
            ChartPanel.this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                        ToggleViewAction.this.actionPerformed(null);
                    }
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = ChartPanel.this.chart.fitsWidth();
            if (!bl) {
                this.origOffsetX = ChartPanel.this.chart.getOffsetX();
                if (ChartPanel.this.chart.tracksDataWidth() && this.origOffsetX == ChartPanel.this.chart.maxOffsetX()) {
                    this.origOffsetX = Long.MAX_VALUE;
                }
                this.origScaleX = ChartPanel.this.chart.getScaleX();
            }
            ChartPanel.this.chart.setFitsWidth(!bl);
            if (bl && this.origOffsetX != -1L && this.origScaleX != -1.0) {
                ChartPanel.this.chart.setScale(this.origScaleX, ChartPanel.this.chart.getScaleY());
                ChartPanel.this.chart.setOffset(this.origOffsetX, ChartPanel.this.chart.getOffsetY());
            }
            this.updateAction();
            if (ChartPanel.this.zoomInAction != null) {
                ChartPanel.this.zoomInAction.updateAction();
            }
            if (ChartPanel.this.zoomOutAction != null) {
                ChartPanel.this.zoomOutAction.updateAction();
            }
            ChartPanel.this.chart.repaintDirty();
        }

        private void updateAction() {
            boolean bl = ChartPanel.this.chart.fitsWidth();
            Icon icon = bl ? FIXED_SCALE_ICON : SCALE_TO_FIT_ICON;
            String string = bl ? Bundle.ACTION_FixedScale_name() : Bundle.ACTION_ScaleToFit_name();
            this.putValue("ShortDescription", string);
            this.putValue("SmallIcon", icon);
        }
    }

    private class ZoomOutAction
    extends AbstractAction {
        private static final float USED_CHART_WIDTH_THRESHOLD = 0.33f;

        public ZoomOutAction() {
            this.putValue("ShortDescription", Bundle.ACTION_ZoomOut_name());
            this.putValue("SmallIcon", ZOOM_OUT_ICON);
            this.updateAction();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = ChartPanel.this.chart.currentlyFollowingDataWidth();
            ChartPanel.this.chart.zoom(ChartPanel.this.getWidth() / 2, ChartPanel.this.getHeight() / 2, 0.5);
            if (bl) {
                ChartPanel.this.chart.setOffset(ChartPanel.this.chart.maxOffsetX(), ChartPanel.this.chart.getOffsetY());
            }
            ChartPanel.this.chart.repaintDirty();
        }

        private void updateAction() {
            Timeline timeline = ((SynchronousXYItemsModel)ChartPanel.this.chart.getItemsModel()).getTimeline();
            this.setEnabled(timeline.getTimestampsCount() > 0 && !ChartPanel.this.chart.fitsWidth() && (float)ChartPanel.this.chart.getContentsWidth() > (float)ChartPanel.this.getWidth() * 0.33f);
        }
    }

    private class ZoomInAction
    extends AbstractAction {
        private static final int ONE_SECOND_WIDTH_THRESHOLD = 200;

        public ZoomInAction() {
            this.putValue("ShortDescription", Bundle.ACTION_ZoomIn_name());
            this.putValue("SmallIcon", ZOOM_IN_ICON);
            this.updateAction();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = ChartPanel.this.chart.currentlyFollowingDataWidth();
            ChartPanel.this.chart.zoom(ChartPanel.this.getWidth() / 2, ChartPanel.this.getHeight() / 2, 2.0);
            if (bl) {
                ChartPanel.this.chart.setOffset(ChartPanel.this.chart.maxOffsetX(), ChartPanel.this.chart.getOffsetY());
            }
            ChartPanel.this.chart.repaintDirty();
        }

        private void updateAction() {
            Timeline timeline = ((SynchronousXYItemsModel)ChartPanel.this.chart.getItemsModel()).getTimeline();
            this.setEnabled(timeline.getTimestampsCount() > 1 && !ChartPanel.this.chart.fitsWidth() && ChartPanel.this.chart.viewWidth(1000.0) < 200.0);
        }
    }
}

