/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.lang.management.ThreadInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.lib.profiler.global.InstrumentationFilter;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.cpu.CPUCallGraphBuilder;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.InstrTimingData;
import org.netbeans.lib.profiler.results.cpu.MethodInfoMapper;
import org.netbeans.lib.profiler.results.cpu.TimingAdjusterOld;

public class StackTraceSnapshotBuilder {
    private static final StackTraceElement[] NO_STACK_TRACE = new StackTraceElement[0];
    private static final boolean COLLECT_TWO_TIMESTAMPS = true;
    private static final List<MethodInfo> knownBLockingMethods = Arrays.asList(new MethodInfo("java.net.PlainSocketImpl", "socketAccept[native]"), new MethodInfo("java.net.PlainSocketImpl", "socketAccept(java.net.SocketImpl) : void"), new MethodInfo("sun.awt.windows.WToolkit", "eventLoop[native]"), new MethodInfo("sun.awt.windows.WToolkit", "eventLoop() : void"), new MethodInfo("java.lang.UNIXProcess", "waitForProcessExit[native]"), new MethodInfo("java.lang.UNIXProcess", "waitForProcessExit(int) : int"), new MethodInfo("sun.awt.X11.XToolkit", "waitForEvents[native]"), new MethodInfo("sun.awt.X11.XToolkit", "waitForEvents(long) : void"), new MethodInfo("apple.awt.CToolkit", "doAWTRunLoop[native]"), new MethodInfo("apple.awt.CToolkit", "doAWTRunLoop(long, boolean, boolean) : void"), new MethodInfo("java.lang.Object", "wait[native]"), new MethodInfo("java.lang.Object", "wait(long) : void"), new MethodInfo("java.lang.Thread", "sleep[native]"), new MethodInfo("java.lang.Thread", "sleep(long) : void"), new MethodInfo("sun.net.dns.ResolverConfigurationImpl", "notifyAddrChange0[native]"), new MethodInfo("sun.net.dns.ResolverConfigurationImpl", "notifyAddrChange0() : int"), new MethodInfo("java.lang.ProcessImpl", "waitFor[native]"), new MethodInfo("java.lang.ProcessImpl", "waitFor() : int"), new MethodInfo("sun.nio.ch.EPollArrayWrapper", "epollWait[native]"), new MethodInfo("sun.nio.ch.EPollArrayWrapper", "epollWait(long, int, long, int) : int"), new MethodInfo("java.net.DualStackPlainSocketImpl", "accept0[native]"), new MethodInfo("java.net.DualStackPlainSocketImpl", "accept0(int, java.net.InetSocketAddress[]) : int"), new MethodInfo("java.lang.ProcessImpl", "waitForInterruptibly[native]"), new MethodInfo("java.lang.ProcessImpl", "waitForInterruptibly(long) : void"), new MethodInfo("sun.print.Win32PrintServiceLookup", "notifyPrinterChange[native]"), new MethodInfo("sun.print.Win32PrintServiceLookup", "notifyPrinterChange(long) : int"), new MethodInfo("java.net.DualStackPlainSocketImpl", "waitForConnect[native]"), new MethodInfo("java.net.DualStackPlainSocketImpl", "waitForConnect(int, int) : void"));
    private InstrumentationFilter filter;
    final List<Long> threadIds = new ArrayList<Long>();
    final List<String> threadNames = new ArrayList<String>();
    final List<byte[]> threadCompactData = new ArrayList<byte[]>();
    final List<MethodInfo> methodInfos = new ArrayList<MethodInfo>();
    final Map<MethodInfo, Integer> methodInfoMap = new HashMap<MethodInfo, Integer>();
    final MethodInfoMapper mapper = new MethodInfoMapper(){

        @Override
        public String getInstrMethodClass(int n) {
            return StackTraceSnapshotBuilder.this.methodInfos.get((int)n).className;
        }

        @Override
        public String getInstrMethodName(int n) {
            return StackTraceSnapshotBuilder.this.methodInfos.get((int)n).methodName;
        }

        @Override
        public String getInstrMethodSignature(int n) {
            return StackTraceSnapshotBuilder.this.methodInfos.get((int)n).signature;
        }

        @Override
        public int getMaxMethodId() {
            return StackTraceSnapshotBuilder.this.methodInfos.size();
        }

        @Override
        public int getMinMethodId() {
            return 0;
        }
    };
    final CPUCallGraphBuilder ccgb;
    final ProfilingSessionStatus status;
    final Object lock = new Object();
    final Object stampLock = new Object();
    long currentDumpTimeStamp = -1L;
    final AtomicReference<Map<Long, SampledThreadInfo>> lastStackTrace = new AtomicReference<Map>(Collections.EMPTY_MAP);
    int stackTraceCount = 0;
    final Set<String> ignoredThreadNames = new HashSet<String>();
    final Map<Long, Long> threadtimes = new HashMap<Long, Long>();

    public StackTraceSnapshotBuilder() {
        this(1, null);
    }

    StackTraceSnapshotBuilder(CPUCallGraphBuilder cPUCallGraphBuilder, InstrumentationFilter instrumentationFilter, ProfilingSessionStatus profilingSessionStatus) {
        this.registerNewMethodInfo(new MethodInfo("Thread", ""));
        this.filter = instrumentationFilter;
        this.setDefaultTiming();
        this.ccgb = cPUCallGraphBuilder;
        this.status = profilingSessionStatus;
    }

    public StackTraceSnapshotBuilder(int n, InstrumentationFilter instrumentationFilter) {
        this.registerNewMethodInfo(new MethodInfo("Thread", ""));
        this.filter = instrumentationFilter;
        this.setDefaultTiming();
        this.ccgb = new StackTraceCallGraphBuilder(this.mapper);
        this.status = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setIgnoredThreads(Set<String> set) {
        Object object = this.lock;
        synchronized (object) {
            this.ignoredThreadNames.clear();
            this.ignoredThreadNames.addAll(set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addStacktrace(SampledThreadInfo[] sampledThreadInfoArray, long l) throws IllegalStateException {
        long l2 = this.processDumpTimeStamp(l);
        if (l2 < 0L) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            HashMap<Long, SampledThreadInfo> hashMap = new HashMap<Long, SampledThreadInfo>();
            for (SampledThreadInfo sampledThreadInfo : sampledThreadInfoArray) {
                hashMap.put(sampledThreadInfo.getThreadId(), sampledThreadInfo);
            }
            this.processThreadDump(l2, l, hashMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addStacktrace(ThreadInfo[] threadInfoArray, long l) throws IllegalStateException {
        long l2 = this.processDumpTimeStamp(l);
        if (l2 < 0L) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            HashMap<Long, SampledThreadInfo> hashMap = new HashMap<Long, SampledThreadInfo>();
            for (ThreadInfo threadInfo : threadInfoArray) {
                if (threadInfo == null) continue;
                hashMap.put(threadInfo.getThreadId(), new SampledThreadInfo(threadInfo, this.filter));
            }
            this.processThreadDump(l2, l, hashMap);
        }
    }

    private void processThreadDump(long l, long l2, Map<Long, SampledThreadInfo> map) throws IllegalStateException {
        Thread.State state;
        Object object;
        Iterator<Map.Entry<Long, SampledThreadInfo>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, SampledThreadInfo> entry = iterator.next();
            SampledThreadInfo sampledThreadInfo = entry.getValue();
            object = sampledThreadInfo.getThreadName();
            if (this.ignoredThreadNames.contains(object)) {
                iterator.remove();
                continue;
            }
            state = sampledThreadInfo.getThreadState();
            if (Thread.State.NEW.equals((Object)state)) {
                iterator.remove();
                continue;
            }
            long l3 = sampledThreadInfo.getThreadId();
            if (!this.threadIds.contains(l3)) {
                this.threadIds.add(l3);
                this.threadNames.add((String)object);
                this.ccgb.newThread((int)l3, (String)object, "<none>");
                this.threadtimes.put(l3, l2);
            }
            StackTraceElement[] stackTraceElementArray = sampledThreadInfo.getStackTrace();
            SampledThreadInfo sampledThreadInfo2 = this.lastStackTrace.get().get(l3);
            StackTraceElement[] stackTraceElementArray2 = NO_STACK_TRACE;
            Thread.State state2 = Thread.State.NEW;
            if (sampledThreadInfo2 != null) {
                stackTraceElementArray2 = sampledThreadInfo2.getStackTrace();
                state2 = sampledThreadInfo2.getThreadState();
            }
            this.processDiffs((int)l3, stackTraceElementArray2, stackTraceElementArray, l2, l, state2, state);
        }
        for (SampledThreadInfo sampledThreadInfo : this.lastStackTrace.get().values()) {
            if (map.containsKey(sampledThreadInfo.getThreadId())) continue;
            object = sampledThreadInfo.getThreadState();
            state = Thread.State.TERMINATED;
            this.processDiffs((int)sampledThreadInfo.getThreadId(), sampledThreadInfo.getStackTrace(), NO_STACK_TRACE, l2, l, (Thread.State)((Object)object), state);
        }
        this.lastStackTrace.set(map);
        ++this.stackTraceCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long processDumpTimeStamp(long l) {
        long l2;
        Object object = this.stampLock;
        synchronized (object) {
            if (l <= this.currentDumpTimeStamp) {
                return -1L;
            }
            l2 = l - this.currentDumpTimeStamp;
            this.currentDumpTimeStamp = l;
        }
        return l2;
    }

    private void processDiffs(int n, StackTraceElement[] stackTraceElementArray, StackTraceElement[] stackTraceElementArray2, long l, long l2, Thread.State state, Thread.State state2) throws IllegalStateException {
        assert (state2 != Thread.State.NEW) : "Invalid thread state " + state2.name() + " for taking a stack trace";
        if (state == Thread.State.TERMINATED && state2 != Thread.State.TERMINATED) {
            throw new IllegalStateException("Thread has already been set to " + Thread.State.TERMINATED.name() + " - stack trace can not be taken");
        }
        long l3 = this.threadtimes.get(n);
        if (state == Thread.State.RUNNABLE) {
            this.threadtimes.put(Long.valueOf(n), l3 += l2);
        }
        this.processDiffs(n, stackTraceElementArray, stackTraceElementArray2, l, l3);
    }

    private void processDiffs(int n, StackTraceElement[] stackTraceElementArray, StackTraceElement[] stackTraceElementArray2, long l, long l2) throws IllegalStateException {
        if (stackTraceElementArray.length == 0 && stackTraceElementArray2.length == 0) {
            return;
        }
        int n2 = stackTraceElementArray2.length - 1;
        int n3 = stackTraceElementArray.length - 1;
        int n4 = Math.max(n3, n2);
        List<StackTraceElement> list = Collections.EMPTY_LIST;
        List<StackTraceElement> list2 = Collections.EMPTY_LIST;
        for (int i = 0; i <= n4; ++i) {
            StackTraceElement stackTraceElement;
            StackTraceElement stackTraceElement2 = n3 >= i ? stackTraceElementArray[n3 - i] : null;
            StackTraceElement stackTraceElement3 = stackTraceElement = n2 >= i ? stackTraceElementArray2[n2 - i] : null;
            if (stackTraceElement2 != null && stackTraceElement != null) {
                if (stackTraceElement2.equals(stackTraceElement)) continue;
                if (this.hasSameMethodInfo(stackTraceElement2, stackTraceElement)) {
                    ++i;
                }
                list = Arrays.asList(stackTraceElementArray2).subList(0, n2 - i + 1);
                list2 = Arrays.asList(stackTraceElementArray).subList(0, n3 - i + 1);
                break;
            }
            if (stackTraceElement2 == null && stackTraceElement != null) {
                list = Arrays.asList(stackTraceElementArray2).subList(0, n2 - i + 1);
                break;
            }
            if (stackTraceElement2 == null || stackTraceElement != null) continue;
            list2 = Arrays.asList(stackTraceElementArray).subList(0, n3 - i + 1);
            break;
        }
        this.addMethodExits(n, list2, l, l2, stackTraceElementArray2.length == 0);
        this.addMethodEntries(n, list, l, l2, stackTraceElementArray.length == 0);
    }

    private void addMethodEntries(int n, List<StackTraceElement> list, long l, long l2, boolean bl) throws IllegalStateException {
        boolean bl2 = false;
        ListIterator<StackTraceElement> listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            StackTraceElement stackTraceElement = listIterator.previous();
            MethodInfo methodInfo = new MethodInfo(stackTraceElement);
            Integer n2 = this.methodInfoMap.get(methodInfo);
            if (n2 == null) {
                n2 = this.registerNewMethodInfo(methodInfo);
                if (this.status != null) {
                    String string = methodInfo.methodName;
                    int n3 = string.indexOf(40);
                    if (n3 > 0) {
                        string = string.substring(0, n3);
                    }
                    this.status.updateInstrMethodsInfo(methodInfo.className, 0, string, methodInfo.signature);
                }
            }
            if (bl && !bl2) {
                bl2 = true;
                this.ccgb.methodEntry(n2, n, 2, l, l2);
                continue;
            }
            this.ccgb.methodEntry(n2, n, 1, l, l2);
        }
    }

    private Integer registerNewMethodInfo(MethodInfo methodInfo) {
        Integer n = this.methodInfos.size();
        this.methodInfos.add(methodInfo);
        this.methodInfoMap.put(methodInfo, n);
        return n;
    }

    private void addMethodExits(int n, List<StackTraceElement> list, long l, long l2, boolean bl) throws IllegalStateException {
        int n2 = list.size();
        for (StackTraceElement stackTraceElement : list) {
            MethodInfo methodInfo = new MethodInfo(stackTraceElement);
            Integer n3 = this.methodInfoMap.get(methodInfo);
            if (n3 == null) {
                System.err.println("*** Not found: " + methodInfo);
                throw new IllegalStateException();
            }
            if (bl && --n2 == 0) {
                this.ccgb.methodExit(n3, n, 2, l, l2);
                continue;
            }
            this.ccgb.methodExit(n3, n, 1, l, l2);
        }
    }

    private boolean hasSameMethodInfo(StackTraceElement stackTraceElement, StackTraceElement stackTraceElement2) {
        MethodInfo methodInfo = new MethodInfo(stackTraceElement);
        MethodInfo methodInfo2 = new MethodInfo(stackTraceElement2);
        return methodInfo.equals(methodInfo2);
    }

    private void setDefaultTiming() {
        ProfilingSessionStatus profilingSessionStatus = new ProfilingSessionStatus();
        profilingSessionStatus.timerCountsInSecond[0] = InstrTimingData.DEFAULT.timerCountsInSecond0;
        profilingSessionStatus.timerCountsInSecond[1] = InstrTimingData.DEFAULT.timerCountsInSecond1;
        profilingSessionStatus.currentInstrType = 3;
        profilingSessionStatus.absoluteTimerOn = true;
        profilingSessionStatus.threadCPUTimerOn = true;
        TimingAdjusterOld.getInstance(profilingSessionStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CPUResultsSnapshot createSnapshot(long l) throws CPUResultsSnapshot.NoDataAvailableException {
        if (this.stackTraceCount < 1) {
            throw new CPUResultsSnapshot.NoDataAvailableException();
        }
        Object object = this.lock;
        synchronized (object) {
            int n = this.methodInfos.size();
            String[] stringArray = new String[this.methodInfos.size()];
            String[] stringArray2 = new String[this.methodInfos.size()];
            String[] stringArray3 = new String[this.methodInfos.size()];
            int n2 = 0;
            for (MethodInfo methodInfo : this.methodInfos) {
                stringArray[n2] = methodInfo.className;
                stringArray2[n2] = methodInfo.methodName;
                stringArray3[n2] = "";
                ++n2;
            }
            this.addStacktrace(new ThreadInfo[0], this.currentDumpTimeStamp + 1L);
            return new CPUResultsSnapshot(l, System.currentTimeMillis(), this.ccgb, this.ccgb.isCollectingTwoTimeStamps(), stringArray, stringArray2, stringArray3, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.ccgb.reset();
            if (this.status != null) {
                this.status.resetInstrClassAndMethodInfo();
            }
            this.methodInfos.clear();
            this.methodInfoMap.clear();
            this.threadIds.clear();
            this.threadNames.clear();
            this.stackTraceCount = 0;
            this.lastStackTrace.set(Collections.EMPTY_MAP);
            this.registerNewMethodInfo(new MethodInfo("Thread", ""));
            Object object2 = this.stampLock;
            synchronized (object2) {
                this.currentDumpTimeStamp = -1L;
            }
        }
    }

    public MethodInfoMapper getMapper() {
        return this.mapper;
    }

    public RuntimeCCTNode getAppRootNode() {
        return this.ccgb.getAppRootNode();
    }

    public boolean collectionTwoTimeStamps() {
        return true;
    }

    public InstrumentationFilter getFilter() {
        return this.filter;
    }

    private class StackTraceCallGraphBuilder
    extends CPUCallGraphBuilder {
        StackTraceCallGraphBuilder(MethodInfoMapper methodInfoMapper) {
            this.setFilter(InstrumentationFilter.getDefault());
            this.setMethodInfoMapper(methodInfoMapper);
        }

        @Override
        protected boolean isCollectingTwoTimeStamps() {
            return true;
        }

        @Override
        protected boolean isReady() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected long getDumpAbsTimeStamp() {
            Object object = StackTraceSnapshotBuilder.this.stampLock;
            synchronized (object) {
                return StackTraceSnapshotBuilder.this.currentDumpTimeStamp;
            }
        }
    }

    static class SampledThreadInfo {
        private StackTraceElement[] stackTrace;
        private Thread.State state;
        private String threadName;
        private long threadId;

        SampledThreadInfo(String string, long l, Thread.State state, StackTraceElement[] stackTraceElementArray, InstrumentationFilter instrumentationFilter) {
            this.threadName = string;
            this.threadId = l;
            this.state = state;
            this.stackTrace = stackTraceElementArray;
            if (this.state == Thread.State.RUNNABLE && SampledThreadInfo.containsKnownBlockingMethod(stackTraceElementArray)) {
                this.state = Thread.State.WAITING;
            }
            if (instrumentationFilter != null) {
                int n;
                for (n = 0; n < stackTraceElementArray.length; ++n) {
                    StackTraceElement stackTraceElement = stackTraceElementArray[n];
                    if (!instrumentationFilter.passesFilter(stackTraceElement.getClassName().replace('.', '/'))) continue;
                    if (n <= 1) break;
                    this.stackTrace = new StackTraceElement[stackTraceElementArray.length - n + 1];
                    System.arraycopy(stackTraceElementArray, n - 1, this.stackTrace, 0, this.stackTrace.length);
                    break;
                }
                if (n == stackTraceElementArray.length) {
                    this.stackTrace = NO_STACK_TRACE;
                }
            }
        }

        SampledThreadInfo(ThreadInfo threadInfo, InstrumentationFilter instrumentationFilter) {
            this(threadInfo.getThreadName(), threadInfo.getThreadId(), threadInfo.getThreadState(), threadInfo.getStackTrace(), instrumentationFilter);
        }

        private static boolean containsKnownBlockingMethod(StackTraceElement[] stackTraceElementArray) {
            if (stackTraceElementArray.length > 0) {
                MethodInfo methodInfo = new MethodInfo(stackTraceElementArray[0]);
                return knownBLockingMethods.contains(methodInfo);
            }
            return false;
        }

        private StackTraceElement[] getStackTrace() {
            return this.stackTrace;
        }

        Thread.State getThreadState() {
            return this.state;
        }

        private String getThreadName() {
            return this.threadName;
        }

        private long getThreadId() {
            return this.threadId;
        }
    }

    static class MethodInfo {
        final String className;
        final String methodName;
        final String signature;

        MethodInfo(String string, String string2) {
            this.className = string;
            this.methodName = string2;
            this.signature = "";
        }

        MethodInfo(StackTraceElement stackTraceElement) {
            String string = "";
            this.className = stackTraceElement.getClassName();
            this.methodName = stackTraceElement.getMethodName() + (stackTraceElement.isNativeMethod() ? "[native]" : "");
            if (stackTraceElement.getLineNumber() == -1 && (string = stackTraceElement.getFileName()) == null) {
                string = "";
            }
            this.signature = string;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            MethodInfo methodInfo = (MethodInfo)object;
            if (this.className == null ? methodInfo.className != null : !this.className.equals(methodInfo.className)) {
                return false;
            }
            return !(this.methodName == null ? methodInfo.methodName != null : !this.methodName.equals(methodInfo.methodName));
        }

        public int hashCode() {
            int n = 5;
            n = 29 * n + (this.className != null ? this.className.hashCode() : 0);
            n = 29 * n + (this.methodName != null ? this.methodName.hashCode() : 0);
            return n;
        }

        public String toString() {
            return this.className + "." + this.methodName + "()";
        }
    }
}

