/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.ConditionalExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FunctionalExpression;
import org.eclipse.jdt.internal.compiler.ast.Invocation;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.NullAnnotationMatching;
import org.eclipse.jdt.internal.compiler.ast.ReferenceExpression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.BoundSet;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding18;
import org.eclipse.jdt.internal.compiler.lookup.ConstraintExceptionFormula;
import org.eclipse.jdt.internal.compiler.lookup.ConstraintExpressionFormula;
import org.eclipse.jdt.internal.compiler.lookup.ConstraintFormula;
import org.eclipse.jdt.internal.compiler.lookup.ConstraintTypeFormula;
import org.eclipse.jdt.internal.compiler.lookup.InferenceFailureException;
import org.eclipse.jdt.internal.compiler.lookup.InferenceSubstitution;
import org.eclipse.jdt.internal.compiler.lookup.InferenceVariable;
import org.eclipse.jdt.internal.compiler.lookup.IntersectionCastTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBound;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.jdt.internal.compiler.util.Sorting;

public class InferenceContext18 {
    static final boolean SIMULATE_BUG_JDK_8026527 = true;
    static final boolean ARGUMENT_CONSTRAINTS_ARE_SOFT = false;
    InvocationSite currentInvocation;
    Expression[] invocationArguments;
    InferenceVariable[] inferenceVariables;
    int variableCount = 0;
    ConstraintFormula[] initialConstraints;
    BoundSet currentBounds;
    BoundSet storedSolution;
    Map<TypeBinding, Solution> solutionsPerTargetType = new HashMap<TypeBinding, Solution>();
    int inferenceKind;
    public int stepCompleted = 0;
    public static final int NOT_INFERRED = 0;
    public static final int APPLICABILITY_INFERRED = 1;
    public static final int TYPE_INFERRED = 2;
    public static final int BINDINGS_UPDATED = 3;
    public List<ConstraintFormula> constraintsWithUncheckedConversion;
    List<InvocationSite> innerPolies = new ArrayList<InvocationSite>();
    public InferenceContext18 outerContext;
    private ArrayList<MethodBinding> problemMethods;
    Scope scope;
    LookupEnvironment environment;
    ReferenceBinding object;
    public static final int CHECK_STRICT = 1;
    public static final int CHECK_LOOSE = 2;
    public static final int CHECK_VARARG = 3;
    int captureId = 0;

    public InferenceContext18(Scope scope, Expression[] expressionArray, InvocationSite invocationSite) {
        this.scope = scope;
        this.environment = scope.environment();
        this.object = scope.getJavaLangObject();
        this.invocationArguments = expressionArray;
        this.currentInvocation = invocationSite;
    }

    public InferenceContext18(Scope scope) {
        this.scope = scope;
        this.environment = scope.environment();
        this.object = scope.getJavaLangObject();
    }

    public InferenceVariable[] createInitialBoundSet(TypeVariableBinding[] typeVariableBindingArray) {
        if (this.currentBounds == null) {
            this.currentBounds = new BoundSet();
        }
        if (typeVariableBindingArray != null) {
            InferenceVariable[] inferenceVariableArray = this.addInitialTypeVariableSubstitutions(typeVariableBindingArray);
            this.currentBounds.addBoundsFromTypeParameters(this, typeVariableBindingArray, inferenceVariableArray);
            return inferenceVariableArray;
        }
        return Binding.NO_INFERENCE_VARIABLES;
    }

    public TypeBinding substitute(TypeBinding typeBinding) {
        InferenceSubstitution inferenceSubstitution = new InferenceSubstitution(this.environment, this.inferenceVariables);
        return inferenceSubstitution.substitute((Substitution)inferenceSubstitution, typeBinding);
    }

    public void createInitialConstraintsForParameters(TypeBinding[] typeBindingArray, boolean bl, TypeBinding typeBinding, MethodBinding methodBinding) {
        if (this.invocationArguments == null) {
            return;
        }
        int n = bl ? typeBindingArray.length - 1 : Math.min(typeBindingArray.length, this.invocationArguments.length);
        int n2 = bl ? this.invocationArguments.length : n;
        int n3 = 0;
        if (this.initialConstraints == null) {
            this.initialConstraints = new ConstraintFormula[n2];
        } else {
            n3 = this.initialConstraints.length;
            this.initialConstraints = new ConstraintFormula[n2 += n3];
            System.arraycopy(this.initialConstraints, 0, this.initialConstraints, 0, n3);
        }
        for (int i = 0; i < n; ++i) {
            if (!this.invocationArguments[i].isPertinentToApplicability(typeBindingArray[i], methodBinding)) continue;
            TypeBinding typeBinding2 = this.substitute(typeBindingArray[i]);
            this.initialConstraints[n3++] = new ConstraintExpressionFormula(this.invocationArguments[i], typeBinding2, 1, false);
        }
        if (bl && typeBinding instanceof ArrayBinding) {
            TypeBinding typeBinding3 = this.substitute(((ArrayBinding)typeBinding).elementsType());
            for (int i = n; i < this.invocationArguments.length; ++i) {
                if (!this.invocationArguments[i].isPertinentToApplicability(typeBinding, methodBinding)) continue;
                this.initialConstraints[n3++] = new ConstraintExpressionFormula(this.invocationArguments[i], typeBinding3, 1, false);
            }
        }
        if (n3 == 0) {
            this.initialConstraints = ConstraintFormula.NO_CONSTRAINTS;
        } else if (n3 < n2) {
            this.initialConstraints = new ConstraintFormula[n3];
            System.arraycopy(this.initialConstraints, 0, this.initialConstraints, 0, n3);
        }
    }

    private InferenceVariable[] addInitialTypeVariableSubstitutions(TypeBinding[] typeBindingArray) {
        int n;
        int n2 = typeBindingArray.length;
        if (n2 == 0) {
            if (this.inferenceVariables == null) {
                this.inferenceVariables = Binding.NO_INFERENCE_VARIABLES;
            }
            return Binding.NO_INFERENCE_VARIABLES;
        }
        InferenceVariable[] inferenceVariableArray = new InferenceVariable[n2];
        for (n = 0; n < n2; ++n) {
            inferenceVariableArray[n] = new InferenceVariable(typeBindingArray[n], this.variableCount++, this.currentInvocation, this.environment, this.object);
        }
        if (this.inferenceVariables == null || this.inferenceVariables.length == 0) {
            this.inferenceVariables = inferenceVariableArray;
        } else {
            n = this.inferenceVariables.length;
            this.inferenceVariables = new InferenceVariable[n2 + n];
            System.arraycopy(this.inferenceVariables, 0, this.inferenceVariables, 0, n);
            System.arraycopy(inferenceVariableArray, 0, this.inferenceVariables, n, n2);
        }
        return inferenceVariableArray;
    }

    public InferenceVariable[] addTypeVariableSubstitutions(TypeBinding[] typeBindingArray) {
        int n;
        int n2 = typeBindingArray.length;
        InferenceVariable[] inferenceVariableArray = new InferenceVariable[n2];
        for (n = 0; n < typeBindingArray.length; ++n) {
            inferenceVariableArray[n] = typeBindingArray[n] instanceof InferenceVariable ? (InferenceVariable)typeBindingArray[n] : new InferenceVariable(typeBindingArray[n], this.variableCount++, this.currentInvocation, this.environment, this.object);
        }
        n = 0;
        if (this.inferenceVariables != null) {
            int n3 = this.inferenceVariables.length;
            this.inferenceVariables = new InferenceVariable[n3 + n2];
            System.arraycopy(this.inferenceVariables, 0, this.inferenceVariables, 0, n3);
            n = n3;
        } else {
            this.inferenceVariables = new InferenceVariable[n2];
        }
        System.arraycopy(inferenceVariableArray, 0, this.inferenceVariables, n, n2);
        return inferenceVariableArray;
    }

    public void addThrowsContraints(TypeBinding[] typeBindingArray, InferenceVariable[] inferenceVariableArray, ReferenceBinding[] referenceBindingArray) {
        block0: for (int i = 0; i < typeBindingArray.length; ++i) {
            TypeBinding typeBinding = typeBindingArray[i];
            for (int j = 0; j < referenceBindingArray.length; ++j) {
                if (!TypeBinding.equalsEquals(typeBinding, referenceBindingArray[j])) continue;
                this.currentBounds.inThrows.add(inferenceVariableArray[i]);
                continue block0;
            }
        }
    }

    public void inferInvocationApplicability(MethodBinding methodBinding, TypeBinding[] typeBindingArray, boolean bl) {
        ConstraintExpressionFormula.inferInvocationApplicability(this, methodBinding, typeBindingArray, bl, this.inferenceKind);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BoundSet inferInvocationType(BoundSet boundSet, TypeBinding typeBinding, InvocationSite invocationSite, MethodBinding methodBinding) throws InferenceFailureException {
        if (typeBinding == null && methodBinding.returnType != null) {
            this.substitute(methodBinding.returnType);
        }
        BoundSet boundSet2 = this.currentBounds.copy();
        this.currentBounds = boundSet;
        try {
            Object object;
            Object object2;
            if (typeBinding != null && typeBinding != TypeBinding.VOID && invocationSite instanceof Expression && ((Expression)((Object)invocationSite)).isPolyExpression(methodBinding) && !ConstraintExpressionFormula.inferPolyInvocationType(this, invocationSite, typeBinding, methodBinding)) {
                BoundSet boundSet3 = null;
                return boundSet3;
            }
            HashSet<ConstraintFormula> hashSet = new HashSet<ConstraintFormula>();
            if (!this.addConstraintsToC(this.invocationArguments, hashSet, methodBinding, this.inferenceKind)) {
                BoundSet boundSet4 = null;
                return boundSet4;
            }
            while (!hashSet.isEmpty()) {
                object2 = this.findBottomSet(hashSet, this.allOutputVariables(hashSet));
                if (object2.isEmpty()) {
                    object2.add(this.pickFromCycle(hashSet));
                }
                hashSet.removeAll((Collection<?>)object2);
                object = new HashSet();
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    object.addAll(((ConstraintFormula)iterator.next()).inputVariables(this));
                }
                InferenceVariable[] inferenceVariableArray = object.toArray(new InferenceVariable[object.size()]);
                this.currentBounds.incorporate(this);
                BoundSet boundSet5 = this.resolve(inferenceVariableArray);
                if (boundSet5 == null) {
                    boundSet5 = this.resolve(this.inferenceVariables);
                }
                iterator = object2.iterator();
                while (iterator.hasNext()) {
                    ConstraintFormula constraintFormula = (ConstraintFormula)iterator.next();
                    if (boundSet5 != null && !constraintFormula.applySubstitution(boundSet5, inferenceVariableArray)) {
                        BoundSet boundSet6 = null;
                        return boundSet6;
                    }
                    if (this.currentBounds.reduceOneConstraint(this, constraintFormula)) continue;
                    BoundSet boundSet7 = null;
                    return boundSet7;
                }
            }
            object2 = this.solve();
            if (object2 == null || !this.isResolved((BoundSet)object2)) {
                this.currentBounds = boundSet2;
                object = null;
                return object;
            }
            this.reportUncheckedConversions((BoundSet)object2);
            object = this.currentBounds = object2;
            return object;
        }
        finally {
            this.stepCompleted = 2;
        }
    }

    private boolean addConstraintsToC(Expression[] expressionArray, Set<ConstraintFormula> set, MethodBinding methodBinding, int n) {
        if (expressionArray != null) {
            TypeBinding[] typeBindingArray;
            int n2 = expressionArray.length;
            int n3 = methodBinding.parameters.length;
            if (n2 < (methodBinding.isVarargs() ? n3 - 1 : n3)) {
                return false;
            }
            switch (n) {
                case 1: 
                case 2: {
                    typeBindingArray = methodBinding.parameters;
                    break;
                }
                case 3: {
                    typeBindingArray = this.varArgTypes(methodBinding.parameters, n2);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected checkKind " + this.inferenceKind);
                }
            }
            for (int i = 0; i < n2; ++i) {
                TypeBinding typeBinding;
                TypeBinding typeBinding2 = typeBindingArray[Math.min(i, n3 - 1)];
                if (this.addConstraintsToC_OneExpr(expressionArray[i], set, typeBinding2, typeBinding = this.substitute(typeBinding2), methodBinding)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean addConstraintsToC_OneExpr(Expression expression, Set<ConstraintFormula> set, TypeBinding typeBinding, TypeBinding typeBinding2, MethodBinding methodBinding) {
        if (!expression.isPertinentToApplicability(typeBinding, methodBinding)) {
            set.add(new ConstraintExpressionFormula(expression, typeBinding2, 1, false));
        }
        if (expression instanceof FunctionalExpression) {
            set.add(new ConstraintExceptionFormula((FunctionalExpression)expression, typeBinding2));
        } else if (expression instanceof Invocation && expression.isPolyExpression()) {
            InferenceContext18 inferenceContext18;
            Invocation invocation = (Invocation)((Object)expression);
            MethodBinding methodBinding2 = invocation.binding(null, false, null);
            if (methodBinding2 instanceof ParameterizedGenericMethodBinding && (inferenceContext18 = invocation.getInferenceContext((ParameterizedMethodBinding)methodBinding2)) != null) {
                return this.addConstraintsToC(invocation.arguments(), set, methodBinding2.genericMethod(), inferenceContext18.inferenceKind);
            }
        } else if (expression instanceof ConditionalExpression) {
            ConditionalExpression conditionalExpression = (ConditionalExpression)expression;
            return this.addConstraintsToC_OneExpr(conditionalExpression.valueIfTrue, set, typeBinding, typeBinding2, methodBinding) && this.addConstraintsToC_OneExpr(conditionalExpression.valueIfFalse, set, typeBinding, typeBinding2, methodBinding);
        }
        return true;
    }

    MethodBinding inferInvocationType(Invocation invocation, TypeBinding[] typeBindingArray, ParameterizedGenericMethodBinding parameterizedGenericMethodBinding) {
        MethodBinding methodBinding;
        boolean bl;
        TypeBinding typeBinding = invocation.invocationTargetType();
        ParameterizedGenericMethodBinding parameterizedGenericMethodBinding2 = null;
        ParameterizedGenericMethodBinding parameterizedGenericMethodBinding3 = parameterizedGenericMethodBinding;
        boolean bl2 = bl = typeBinding != null && typeBinding.isProperType(true);
        if (bl || !invocation.getExpressionContext().definesTargetType()) {
            TypeBinding[] typeBindingArray2;
            BoundSet boundSet;
            methodBinding = parameterizedGenericMethodBinding.originalMethod;
            Solution solution = this.solutionsPerTargetType.get(typeBinding);
            BoundSet boundSet2 = boundSet = solution != null ? solution.bounds : null;
            if (boundSet == null) {
                try {
                    boundSet = this.inferInvocationType(this.currentBounds, typeBinding, invocation, methodBinding);
                }
                catch (InferenceFailureException inferenceFailureException) {
                    // empty catch block
                }
            }
            if (boundSet != null && (typeBindingArray2 = this.getSolutions(methodBinding.typeVariables(), invocation, boundSet)) != null) {
                parameterizedGenericMethodBinding2 = this.environment.createParameterizedGenericMethod(methodBinding, typeBindingArray2);
                if (this.scope.compilerOptions().isAnnotationBasedNullAnalysisEnabled) {
                    NullAnnotationMatching.checkForContraditions(parameterizedGenericMethodBinding2, invocation, this.scope);
                }
                invocation.registerInferenceContext(parameterizedGenericMethodBinding2, this);
                this.solutionsPerTargetType.put(typeBinding, new Solution(parameterizedGenericMethodBinding2, boundSet));
            }
            if (parameterizedGenericMethodBinding2 != null) {
                parameterizedGenericMethodBinding3 = parameterizedGenericMethodBinding2;
            }
        } else {
            parameterizedGenericMethodBinding2 = parameterizedGenericMethodBinding;
        }
        methodBinding = parameterizedGenericMethodBinding3.boundCheck18(this.scope, typeBindingArray);
        if (methodBinding != null) {
            return methodBinding;
        }
        if (!bl && invocation.getExpressionContext().definesTargetType()) {
            return parameterizedGenericMethodBinding;
        }
        if (parameterizedGenericMethodBinding2 != null && this.rebindInnerPolies(parameterizedGenericMethodBinding2, invocation)) {
            return parameterizedGenericMethodBinding2;
        }
        return this.getReturnProblemMethodIfNeeded(typeBinding, parameterizedGenericMethodBinding);
    }

    public MethodBinding inferInvocationType(Invocation invocation, ParameterizedGenericMethodBinding parameterizedGenericMethodBinding) {
        TypeBinding[] typeBindingArray = null;
        Expression[] expressionArray = invocation.arguments();
        if (expressionArray != null) {
            typeBindingArray = new TypeBinding[expressionArray.length];
            for (int i = 0; i < expressionArray.length; ++i) {
                typeBindingArray[i] = expressionArray[i].resolvedType;
            }
        }
        return this.inferInvocationType(invocation, typeBindingArray, parameterizedGenericMethodBinding);
    }

    public boolean hasResultFor(TypeBinding typeBinding) {
        if (typeBinding == null) {
            return this.stepCompleted >= 2;
        }
        return this.solutionsPerTargetType.containsKey(typeBinding);
    }

    public boolean registerSolution(TypeBinding typeBinding, MethodBinding methodBinding) {
        Solution solution = this.solutionsPerTargetType.get(typeBinding);
        if (solution != null) {
            return false;
        }
        this.solutionsPerTargetType.put(typeBinding, new Solution(methodBinding, null));
        this.stepCompleted = Math.max(this.stepCompleted, 2);
        return true;
    }

    public ReferenceBinding inferFunctionalInterfaceParameterization(LambdaExpression lambdaExpression, BlockScope blockScope, ParameterizedTypeBinding parameterizedTypeBinding) {
        TypeBinding[] typeBindingArray = this.createBoundsForFunctionalInterfaceParameterizationInference(parameterizedTypeBinding);
        if (typeBindingArray != null && typeBindingArray.length == lambdaExpression.arguments().length && this.reduceWithEqualityConstraints(lambdaExpression.argumentTypes(), typeBindingArray)) {
            ReferenceBinding referenceBinding = parameterizedTypeBinding.genericType();
            TypeBinding[] typeBindingArray2 = parameterizedTypeBinding.arguments;
            TypeBinding[] typeBindingArray3 = this.getFunctionInterfaceArgumentSolutions(typeBindingArray2);
            return blockScope.environment().createParameterizedType(referenceBinding, typeBindingArray3, referenceBinding.enclosingType());
        }
        return parameterizedTypeBinding;
    }

    TypeBinding[] createBoundsForFunctionalInterfaceParameterizationInference(ParameterizedTypeBinding parameterizedTypeBinding) {
        TypeBinding[] typeBindingArray;
        if (this.currentBounds == null) {
            this.currentBounds = new BoundSet();
        }
        if ((typeBindingArray = parameterizedTypeBinding.arguments) == null) {
            return null;
        }
        InferenceVariable[] inferenceVariableArray = this.addInitialTypeVariableSubstitutions(typeBindingArray);
        for (int i = 0; i < typeBindingArray.length; ++i) {
            TypeBound typeBound;
            block9: {
                block8: {
                    if (typeBindingArray[i].kind() != 516) break block8;
                    WildcardBinding wildcardBinding = (WildcardBinding)typeBindingArray[i];
                    switch (wildcardBinding.boundKind) {
                        case 1: {
                            typeBound = new TypeBound(inferenceVariableArray[i], wildcardBinding.allBounds(), 2);
                            break block9;
                        }
                        case 2: {
                            typeBound = new TypeBound(inferenceVariableArray[i], wildcardBinding.bound, 3);
                            break block9;
                        }
                        case 0: {
                            typeBound = new TypeBound(inferenceVariableArray[i], this.object, 2);
                            break block9;
                        }
                    }
                    continue;
                }
                typeBound = new TypeBound(inferenceVariableArray[i], typeBindingArray[i], 4);
            }
            this.currentBounds.addBound(typeBound, this.environment);
        }
        TypeBinding typeBinding = this.substitute(parameterizedTypeBinding);
        return typeBinding.getSingleAbstractMethod((Scope)this.scope, (boolean)true).parameters;
    }

    public boolean reduceWithEqualityConstraints(TypeBinding[] typeBindingArray, TypeBinding[] typeBindingArray2) {
        if (typeBindingArray != null) {
            for (int i = 0; i < typeBindingArray.length; ++i) {
                try {
                    if (this.reduceAndIncorporate(ConstraintTypeFormula.create(typeBindingArray[i], typeBindingArray2[i], 4))) continue;
                    return false;
                }
                catch (InferenceFailureException inferenceFailureException) {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isMoreSpecificThan(MethodBinding methodBinding, MethodBinding methodBinding2, boolean bl, boolean bl2) {
        int n;
        if (bl != bl2) {
            return bl2;
        }
        Expression[] expressionArray = this.invocationArguments;
        int n2 = expressionArray == null ? 0 : expressionArray.length;
        TypeVariableBinding[] typeVariableBindingArray = methodBinding2.typeVariables();
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        TypeBinding[] typeBindingArray2 = new TypeBinding[methodBinding2.parameters.length];
        this.createInitialBoundSet(typeVariableBindingArray);
        for (n = 0; n < typeBindingArray2.length; ++n) {
            typeBindingArray2[n] = this.substitute(methodBinding2.parameters[n]);
        }
        try {
            TypeBinding typeBinding;
            TypeBinding typeBinding2;
            for (n = 0; n < n2; ++n) {
                TypeBinding typeBinding3;
                typeBinding2 = InferenceContext18.getParameter(typeBindingArray, n, bl);
                Boolean bl3 = this.moreSpecificMain(typeBinding2, typeBinding3 = InferenceContext18.getParameter(typeBindingArray2, n, bl), this.invocationArguments[n]);
                if (bl3 == Boolean.FALSE) {
                    return false;
                }
                if (bl3 != null || this.reduceAndIncorporate(ConstraintTypeFormula.create(typeBinding2, typeBinding3, 2))) continue;
                return false;
            }
            if (typeBindingArray2.length == n2 + 1 && !this.reduceAndIncorporate(ConstraintTypeFormula.create(typeBinding = InferenceContext18.getParameter(typeBindingArray, n2, true), typeBinding2 = InferenceContext18.getParameter(typeBindingArray2, n2, true), 2))) {
                return false;
            }
            return this.solve() != null;
        }
        catch (InferenceFailureException inferenceFailureException) {
            return false;
        }
    }

    private Boolean moreSpecificMain(TypeBinding typeBinding, TypeBinding typeBinding2, Expression expression) throws InferenceFailureException {
        TypeBinding typeBinding3;
        if (typeBinding.isProperType(true) && typeBinding2.isProperType(true)) {
            return expression.sIsMoreSpecific(typeBinding, typeBinding2, this.scope) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (typeBinding.isFunctionalInterface(this.scope) && (typeBinding3 = typeBinding2.original()).isFunctionalInterface(this.scope)) {
            Object object;
            if (this.siSuperI(typeBinding, typeBinding3) || this.siSubI(typeBinding, typeBinding3)) {
                return null;
            }
            if (typeBinding instanceof IntersectionCastTypeBinding) {
                int n;
                block7: {
                    object = ((IntersectionCastTypeBinding)typeBinding).intersectingTypes;
                    for (n = 0; n < ((ReferenceBinding[])object).length; ++n) {
                        if (this.siSuperI(object[n], typeBinding3)) {
                            continue;
                        }
                        break block7;
                    }
                    return null;
                }
                for (n = 0; n < ((Object)object).length; ++n) {
                    if (!this.siSubI((TypeBinding)object[n], typeBinding3)) continue;
                    return null;
                }
            }
            object = typeBinding.capture(this.scope, this.captureId++);
            MethodBinding methodBinding = ((TypeBinding)object).getSingleAbstractMethod(this.scope, false);
            TypeBinding[] typeBindingArray = methodBinding.parameters;
            TypeBinding typeBinding4 = methodBinding.isConstructor() ? methodBinding.declaringClass : methodBinding.returnType;
            methodBinding = typeBinding2.getSingleAbstractMethod(this.scope, true);
            TypeBinding[] typeBindingArray2 = methodBinding.parameters;
            TypeBinding typeBinding5 = methodBinding.isConstructor() ? methodBinding.declaringClass : methodBinding.returnType;
            return this.checkExpression(expression, typeBindingArray, typeBinding4, typeBindingArray2, typeBinding5);
        }
        return null;
    }

    private boolean checkExpression(Expression expression, TypeBinding[] typeBindingArray, TypeBinding typeBinding, TypeBinding[] typeBindingArray2, TypeBinding typeBinding2) throws InferenceFailureException {
        if (expression instanceof LambdaExpression && !((LambdaExpression)expression).argumentsTypeElided()) {
            block17: {
                int n;
                Expression[] expressionArray;
                block16: {
                    if (typeBinding2.id == 6) {
                        return true;
                    }
                    LambdaExpression lambdaExpression = (LambdaExpression)expression;
                    expressionArray = lambdaExpression.resultExpressions();
                    if (typeBinding.isFunctionalInterface(this.scope) && typeBinding2.isFunctionalInterface(this.scope) && !typeBinding.isCompatibleWith(typeBinding2) && !typeBinding2.isCompatibleWith(typeBinding)) {
                        for (int i = 0; i < expressionArray.length; ++i) {
                            if (this.checkExpression(expressionArray[i], typeBindingArray, typeBinding, typeBindingArray2, typeBinding2)) continue;
                            return false;
                        }
                        return true;
                    }
                    if (typeBinding.isPrimitiveType() && !typeBinding2.isPrimitiveType()) {
                        for (n = 0; n < expressionArray.length; ++n) {
                            if (!expressionArray[n].isPolyExpression() && (expressionArray[n].resolvedType == null || expressionArray[n].resolvedType.isPrimitiveType())) {
                                continue;
                            }
                            break block16;
                        }
                        return true;
                    }
                }
                if (typeBinding2.isPrimitiveType() && !typeBinding.isPrimitiveType()) {
                    for (n = 0; n < expressionArray.length; ++n) {
                        if (!expressionArray[n].isPolyExpression() && expressionArray[n].resolvedType != null && !expressionArray[n].resolvedType.isPrimitiveType() || expressionArray[n].isPolyExpression()) {
                            continue;
                        }
                        break block17;
                    }
                    return true;
                }
            }
            return this.reduceAndIncorporate(ConstraintTypeFormula.create(typeBinding, typeBinding2, 2));
        }
        if (expression instanceof ReferenceExpression && ((ReferenceExpression)expression).isExactMethodReference()) {
            for (int i = 0; i < typeBindingArray.length; ++i) {
                TypeBinding typeBinding3;
                ReferenceExpression referenceExpression = (ReferenceExpression)expression;
                if (!this.reduceAndIncorporate(ConstraintTypeFormula.create(typeBindingArray[i], typeBindingArray2[i], 4))) {
                    return false;
                }
                if (typeBinding2.id == 6) {
                    return true;
                }
                MethodBinding methodBinding = referenceExpression.findCompileTimeMethodTargeting(null, this.scope);
                TypeBinding typeBinding4 = typeBinding3 = methodBinding.isConstructor() ? methodBinding.declaringClass : methodBinding.returnType;
                if (typeBinding.isPrimitiveType() && !typeBinding2.isPrimitiveType() && typeBinding3.isPrimitiveType()) {
                    return true;
                }
                if (!typeBinding2.isPrimitiveType() || typeBinding.isPrimitiveType() || typeBinding3.isPrimitiveType()) continue;
                return true;
            }
            return this.reduceAndIncorporate(ConstraintTypeFormula.create(typeBinding, typeBinding2, 2));
        }
        if (expression instanceof ConditionalExpression) {
            ConditionalExpression conditionalExpression = (ConditionalExpression)expression;
            return this.checkExpression(conditionalExpression.valueIfTrue, typeBindingArray, typeBinding, typeBindingArray2, typeBinding2) && this.checkExpression(conditionalExpression.valueIfFalse, typeBindingArray, typeBinding, typeBindingArray2, typeBinding2);
        }
        return false;
    }

    private boolean siSuperI(TypeBinding typeBinding, TypeBinding typeBinding2) {
        if (TypeBinding.equalsEquals(typeBinding, typeBinding2) || TypeBinding.equalsEquals(typeBinding.original(), typeBinding2)) {
            return true;
        }
        ReferenceBinding[] referenceBindingArray = typeBinding2.superInterfaces();
        if (referenceBindingArray == null) {
            return false;
        }
        for (int i = 0; i < referenceBindingArray.length; ++i) {
            if (!this.siSuperI(typeBinding, referenceBindingArray[i])) continue;
            return true;
        }
        return false;
    }

    private boolean siSubI(TypeBinding typeBinding, TypeBinding typeBinding2) {
        if (TypeBinding.equalsEquals(typeBinding, typeBinding2) || TypeBinding.equalsEquals(typeBinding.original(), typeBinding2)) {
            return true;
        }
        ReferenceBinding[] referenceBindingArray = typeBinding.superInterfaces();
        if (referenceBindingArray == null) {
            return false;
        }
        for (int i = 0; i < referenceBindingArray.length; ++i) {
            if (!this.siSubI(referenceBindingArray[i], typeBinding2)) continue;
            return true;
        }
        return false;
    }

    public BoundSet solve() throws InferenceFailureException {
        if (!this.reduce()) {
            return null;
        }
        if (!this.currentBounds.incorporate(this)) {
            return null;
        }
        return this.resolve(this.inferenceVariables);
    }

    public BoundSet solve(InferenceVariable[] inferenceVariableArray) throws InferenceFailureException {
        if (!this.reduce()) {
            return null;
        }
        if (!this.currentBounds.incorporate(this)) {
            return null;
        }
        return this.resolve(inferenceVariableArray);
    }

    private boolean reduce() throws InferenceFailureException {
        if (this.initialConstraints != null) {
            for (int i = 0; i < this.initialConstraints.length; ++i) {
                if (this.currentBounds.reduceOneConstraint(this, this.initialConstraints[i])) continue;
                return false;
            }
        }
        this.initialConstraints = null;
        return true;
    }

    public boolean isResolved(BoundSet boundSet) {
        if (this.inferenceVariables != null) {
            for (int i = 0; i < this.inferenceVariables.length; ++i) {
                if (boundSet.isInstantiated(this.inferenceVariables[i])) continue;
                return false;
            }
        }
        return true;
    }

    public TypeBinding[] getSolutions(TypeVariableBinding[] typeVariableBindingArray, InvocationSite invocationSite, BoundSet boundSet) {
        int n = typeVariableBindingArray.length;
        TypeBinding[] typeBindingArray = new TypeBinding[n];
        for (int i = 0; i < typeVariableBindingArray.length; ++i) {
            for (int j = 0; j < this.inferenceVariables.length; ++j) {
                InferenceVariable inferenceVariable = this.inferenceVariables[j];
                if (inferenceVariable.site != invocationSite || !TypeBinding.equalsEquals(inferenceVariable.typeParameter, typeVariableBindingArray[i])) continue;
                typeBindingArray[i] = boundSet.getInstantiation(inferenceVariable, this.environment);
                break;
            }
            if (typeBindingArray[i] != null) continue;
            return null;
        }
        return typeBindingArray;
    }

    public boolean reduceAndIncorporate(ConstraintFormula constraintFormula) throws InferenceFailureException {
        return this.currentBounds.reduceOneConstraint(this, constraintFormula);
    }

    private BoundSet resolve(InferenceVariable[] inferenceVariableArray) throws InferenceFailureException {
        this.captureId = 0;
        Object object = this.currentBounds;
        if (this.inferenceVariables != null) {
            Set<InferenceVariable> set;
            while ((set = this.getSmallestVariableSet((BoundSet)object, inferenceVariableArray)) != null) {
                Iterator iterator;
                TypeBinding[] typeBindingArray;
                Object object2;
                TypeBinding[] typeBindingArray2;
                Object object3;
                int n;
                CaptureBinding18[] captureBinding18Array;
                InferenceVariable[] inferenceVariableArray2;
                int n2;
                int n3;
                block24: {
                    n3 = ((BoundSet)object).numUninstantiatedVariables(this.inferenceVariables);
                    n2 = set.size();
                    if (n2 <= 0) continue;
                    inferenceVariableArray2 = set.toArray(new InferenceVariable[n2]);
                    if (!((BoundSet)object).hasCaptureBound(set)) {
                        captureBinding18Array = object;
                        object = ((BoundSet)object).copy();
                        for (n = 0; n < inferenceVariableArray2.length; ++n) {
                            InferenceVariable inferenceVariable = inferenceVariableArray2[n];
                            object3 = ((BoundSet)object).lowerBounds(inferenceVariable, true);
                            if (object3 != Binding.NO_TYPES) {
                                typeBindingArray2 = this.scope.lowerUpperBound((TypeBinding[])object3);
                                if (typeBindingArray2 == TypeBinding.VOID || typeBindingArray2 == null) {
                                    return null;
                                }
                                ((BoundSet)object).addBound(new TypeBound(inferenceVariable, (TypeBinding)typeBindingArray2, 4), this.environment);
                                continue;
                            }
                            typeBindingArray2 = ((BoundSet)object).upperBounds(inferenceVariable, true);
                            if (((BoundSet)object).inThrows.contains(inferenceVariable) && ((BoundSet)object).hasOnlyTrivialExceptionBounds(inferenceVariable, typeBindingArray2)) {
                                object2 = this.scope.getType(TypeConstants.JAVA_LANG_RUNTIMEEXCEPTION, 3);
                                ((BoundSet)object).addBound(new TypeBound(inferenceVariable, (TypeBinding)object2, 4), this.environment);
                                continue;
                            }
                            object2 = this.object;
                            if (typeBindingArray2 != Binding.NO_TYPES) {
                                if (typeBindingArray2.length == 1) {
                                    object2 = typeBindingArray2[0];
                                } else {
                                    typeBindingArray = Scope.greaterLowerBound((ReferenceBinding[])typeBindingArray2);
                                    if (typeBindingArray == null) {
                                        throw new UnsupportedOperationException("no glb for " + Arrays.asList(typeBindingArray2));
                                    }
                                    if (typeBindingArray.length == 1) {
                                        object2 = typeBindingArray[0];
                                    } else {
                                        iterator = new IntersectionCastTypeBinding((ReferenceBinding[])typeBindingArray, this.environment);
                                        if (!ReferenceBinding.isConsistentIntersection(((IntersectionCastTypeBinding)((Object)iterator)).intersectingTypes)) {
                                            object = captureBinding18Array;
                                            break block24;
                                        }
                                        object2 = iterator;
                                    }
                                }
                            }
                            ((BoundSet)object).addBound(new TypeBound(inferenceVariable, (TypeBinding)object2, 4), this.environment);
                        }
                        if (((BoundSet)object).incorporate(this)) continue;
                        object = captureBinding18Array;
                    }
                }
                Sorting.sortInferenceVariables(inferenceVariableArray2);
                captureBinding18Array = new CaptureBinding18[n2];
                for (n = 0; n < n2; ++n) {
                    captureBinding18Array[n] = this.freshCapture(inferenceVariableArray2[n]);
                }
                Substitution substitution = new Substitution(){

                    @Override
                    public LookupEnvironment environment() {
                        return InferenceContext18.this.environment;
                    }

                    @Override
                    public boolean isRawSubstitution() {
                        return false;
                    }

                    @Override
                    public TypeBinding substitute(TypeVariableBinding typeVariableBinding) {
                        for (int i = 0; i < n2; ++i) {
                            if (inferenceVariableArray2[i] != typeVariableBinding) continue;
                            return captureBinding18Array[i];
                        }
                        return typeVariableBinding;
                    }
                };
                for (int i = 0; i < n2; ++i) {
                    object3 = inferenceVariableArray2[i];
                    typeBindingArray2 = captureBinding18Array[i];
                    object2 = ((BoundSet)object).lowerBounds((InferenceVariable)object3, true);
                    if (object2 != Binding.NO_TYPES && (typeBindingArray = this.scope.lowerUpperBound((TypeBinding[])(object2 = Scope.substitute(substitution, object2)))) != TypeBinding.VOID && typeBindingArray != null) {
                        typeBindingArray2.lowerBound = typeBindingArray;
                    }
                    if ((typeBindingArray = ((BoundSet)object).upperBounds((InferenceVariable)object3, false)) != Binding.NO_TYPES) {
                        for (int j = 0; j < typeBindingArray.length; ++j) {
                            typeBindingArray[j] = Scope.substitute(substitution, typeBindingArray[j]);
                        }
                        if (!this.setUpperBounds((CaptureBinding18)typeBindingArray2, typeBindingArray)) continue;
                    }
                    if (object == this.currentBounds) {
                        object = ((BoundSet)object).copy();
                    }
                    iterator = ((BoundSet)object).captures.keySet().iterator();
                    HashSet<ParameterizedTypeBinding> hashSet = new HashSet<ParameterizedTypeBinding>();
                    block5: while (iterator.hasNext()) {
                        ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)iterator.next();
                        int n4 = parameterizedTypeBinding.arguments.length;
                        for (int j = 0; j < n4; ++j) {
                            if (parameterizedTypeBinding.arguments[j] != object3) continue;
                            hashSet.add(parameterizedTypeBinding);
                            continue block5;
                        }
                    }
                    iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        ((BoundSet)object).captures.remove(iterator.next());
                    }
                    ((BoundSet)object).addBound(new TypeBound((InferenceVariable)object3, (TypeBinding)typeBindingArray2, 4), this.environment);
                }
                if (((BoundSet)object).incorporate(this)) {
                    if (((BoundSet)object).numUninstantiatedVariables(this.inferenceVariables) != n3) continue;
                    return null;
                }
                return null;
            }
        }
        return object;
    }

    private CaptureBinding18 freshCapture(InferenceVariable inferenceVariable) {
        int n = this.captureId++;
        char[] cArray = CharOperation.concat("Z".toCharArray(), '#', String.valueOf(n).toCharArray(), '-', inferenceVariable.sourceName);
        int n2 = this.currentInvocation != null ? this.currentInvocation.sourceStart() : 0;
        return new CaptureBinding18(this.scope.enclosingSourceType(), cArray, inferenceVariable.typeParameter.shortReadableName(), n2, n, this.environment);
    }

    private boolean setUpperBounds(CaptureBinding18 captureBinding18, TypeBinding[] typeBindingArray) {
        if (typeBindingArray.length == 1) {
            captureBinding18.setUpperBounds(typeBindingArray, this.object);
        } else {
            TypeBinding[] typeBindingArray2 = Scope.greaterLowerBound(typeBindingArray, this.scope, this.environment);
            if (typeBindingArray2 == null) {
                return false;
            }
            if (captureBinding18.lowerBound != null) {
                for (int i = 0; i < typeBindingArray2.length; ++i) {
                    if (captureBinding18.lowerBound.isCompatibleWith(typeBindingArray2[i])) continue;
                    return false;
                }
            }
            InferenceContext18.sortTypes(typeBindingArray2);
            if (!captureBinding18.setUpperBounds(typeBindingArray2, this.object)) {
                return false;
            }
        }
        return true;
    }

    static void sortTypes(TypeBinding[] typeBindingArray) {
        Arrays.sort(typeBindingArray, new Comparator<TypeBinding>(){

            @Override
            public int compare(TypeBinding typeBinding, TypeBinding typeBinding2) {
                int n = typeBinding.id;
                int n2 = typeBinding2.id;
                return n < n2 ? -1 : (n == n2 ? 0 : 1);
            }
        });
    }

    private Set<InferenceVariable> getSmallestVariableSet(BoundSet boundSet, InferenceVariable[] inferenceVariableArray) {
        int n = Integer.MAX_VALUE;
        HashSet<InferenceVariable> hashSet = null;
        for (int i = 0; i < inferenceVariableArray.length; ++i) {
            HashSet<InferenceVariable> hashSet2;
            InferenceVariable inferenceVariable = inferenceVariableArray[i];
            if (boundSet.isInstantiated(inferenceVariable) || !this.addDependencies(boundSet, hashSet2 = new HashSet<InferenceVariable>(), inferenceVariable, n)) continue;
            int n2 = hashSet2.size();
            if (n2 == 1) {
                return hashSet2;
            }
            if (n2 >= n) continue;
            hashSet = hashSet2;
            n = n2;
        }
        return hashSet;
    }

    private boolean addDependencies(BoundSet boundSet, Set<InferenceVariable> set, InferenceVariable inferenceVariable, int n) {
        if (set.size() >= n) {
            return false;
        }
        if (boundSet.isInstantiated(inferenceVariable)) {
            return true;
        }
        if (!set.add(inferenceVariable)) {
            return true;
        }
        for (int i = 0; i < this.inferenceVariables.length; ++i) {
            InferenceVariable inferenceVariable2 = this.inferenceVariables[i];
            if (inferenceVariable2 == inferenceVariable || !boundSet.dependsOnResolutionOf(inferenceVariable, inferenceVariable2) || this.addDependencies(boundSet, set, inferenceVariable2, n)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private ConstraintFormula pickFromCycle(Set<ConstraintFormula> set) {
        void var5_8;
        Map.Entry entry2;
        Object object4;
        HashSet<InferenceVariable> hashSet;
        HashMap<ConstraintFormula, Set<ConstraintFormula>> hashMap = new HashMap<ConstraintFormula, Set<ConstraintFormula>>();
        HashSet hashSet2 = new HashSet();
        for (ConstraintFormula set32 : set) {
            hashSet = set32.inputVariables(this);
            for (ConstraintFormula constraintFormula : set) {
                if (constraintFormula == set32 || !this.dependsOn(hashSet, constraintFormula.outputVariables(this))) continue;
                object4 = (Set)hashMap.get(set32);
                if (object4 == null) {
                    object4 = new HashSet<ConstraintFormula>();
                    hashMap.put(set32, (Set<ConstraintFormula>)object4);
                }
                object4.add(constraintFormula);
                entry2 = new HashSet();
                if (!this.isReachable(hashMap, constraintFormula, set32, new HashSet<ConstraintFormula>(), (Set<ConstraintFormula>)((Object)entry2))) continue;
                hashSet2.addAll(entry2);
            }
        }
        HashSet<ConstraintFormula> hashSet22 = new HashSet<ConstraintFormula>(set);
        hashSet22.removeAll(hashSet2);
        HashSet hashSet3 = new HashSet();
        block2: for (Object object2 : hashSet2) {
            Collection<InferenceVariable> collection = ((ConstraintFormula)object2).inputVariables(this);
            object4 = hashSet22.iterator();
            while (object4.hasNext()) {
                entry2 = (ConstraintFormula)object4.next();
                if (!this.dependsOn(collection, ((ConstraintFormula)((Object)entry2)).outputVariables(this))) continue;
                continue block2;
            }
            hashSet3.add(object2);
        }
        if (hashSet3.isEmpty()) {
            Set<ConstraintFormula> set2 = set;
        }
        hashSet = new HashSet<InferenceVariable>();
        for (ConstraintFormula constraintFormula : var5_8) {
            if (!(constraintFormula instanceof ConstraintExpressionFormula)) continue;
            hashSet.add((InferenceVariable)((Object)constraintFormula));
        }
        if (hashSet.isEmpty()) {
            hashSet = var5_8;
        } else {
            Object object3;
            Object object2;
            object2 = new HashMap();
            for (Object object4 : hashSet) {
                entry2 = (ConstraintExpressionFormula)object4;
                object3 = ((ConstraintExpressionFormula)((Object)entry2)).left;
                for (ConstraintFormula constraintFormula : hashSet) {
                    ConstraintExpressionFormula constraintExpressionFormula;
                    if (object4 == constraintFormula) continue;
                    ConstraintExpressionFormula constraintExpressionFormula2 = (ConstraintExpressionFormula)constraintFormula;
                    Expression expression = constraintExpressionFormula2.left;
                    if (!this.doesExpressionContain((Expression)object3, expression) || (constraintExpressionFormula = (ConstraintExpressionFormula)object2.get(constraintFormula)) != null && !this.doesExpressionContain(constraintExpressionFormula.left, (Expression)object3)) continue;
                    object2.put(constraintExpressionFormula2, entry2);
                }
            }
            HashMap<ConstraintExpressionFormula, Set<ConstraintExpressionFormula>> hashMap2 = new HashMap<ConstraintExpressionFormula, Set<ConstraintExpressionFormula>>();
            for (Map.Entry entry2 : object2.entrySet()) {
                object3 = (ConstraintExpressionFormula)entry2.getValue();
                Object object5 = (Set)hashMap2.get(object3);
                if (object5 == null) {
                    object5 = new HashSet();
                    hashMap2.put((ConstraintExpressionFormula)object3, (Set<ConstraintExpressionFormula>)object5);
                }
                object5.add(entry2.getKey());
            }
            int n = -1;
            entry2 = null;
            for (Object object5 : hashMap2.keySet()) {
                int n2 = this.rankNode((ConstraintExpressionFormula)object5, (Map<ConstraintExpressionFormula, ConstraintExpressionFormula>)object2, hashMap2);
                if (n2 <= n) continue;
                n = n2;
                entry2 = object5;
            }
            if (entry2 != null) {
                return entry2;
            }
        }
        if (hashSet.isEmpty()) {
            throw new IllegalStateException("cannot pick constraint from cyclic set");
        }
        return (ConstraintFormula)hashSet.iterator().next();
    }

    private boolean dependsOn(Collection<InferenceVariable> collection, Collection<InferenceVariable> collection2) {
        for (InferenceVariable inferenceVariable : collection) {
            for (InferenceVariable inferenceVariable2 : collection2) {
                if (!this.currentBounds.dependsOnResolutionOf(inferenceVariable, inferenceVariable2)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isReachable(Map<ConstraintFormula, Set<ConstraintFormula>> map, ConstraintFormula constraintFormula, ConstraintFormula constraintFormula2, Set<ConstraintFormula> set, Set<ConstraintFormula> set2) {
        if (constraintFormula == constraintFormula2) {
            set2.add(constraintFormula);
            return true;
        }
        if (!set.add(constraintFormula)) {
            return false;
        }
        Set<ConstraintFormula> set3 = map.get(constraintFormula);
        if (set3 != null) {
            for (ConstraintFormula constraintFormula3 : set3) {
                if (!this.isReachable(map, constraintFormula3, constraintFormula2, set, set2)) continue;
                set2.add(constraintFormula);
                return true;
            }
        }
        return false;
    }

    private boolean doesExpressionContain(Expression expression, Expression expression2) {
        if (expression2.sourceStart > expression.sourceStart) {
            return expression2.sourceEnd <= expression.sourceEnd;
        }
        if (expression2.sourceStart == expression.sourceStart) {
            return expression2.sourceEnd < expression.sourceEnd;
        }
        return false;
    }

    private int rankNode(ConstraintExpressionFormula constraintExpressionFormula, Map<ConstraintExpressionFormula, ConstraintExpressionFormula> map, Map<ConstraintExpressionFormula, Set<ConstraintExpressionFormula>> map2) {
        if (map.get(constraintExpressionFormula) != null) {
            return -1;
        }
        Set<ConstraintExpressionFormula> set = map2.get(constraintExpressionFormula);
        if (set == null) {
            return 1;
        }
        int n = 1;
        for (ConstraintExpressionFormula constraintExpressionFormula2 : set) {
            int n2 = this.rankNode(constraintExpressionFormula2, map, map2);
            if (n2 <= 0) continue;
            n += n2;
        }
        return n;
    }

    private Set<ConstraintFormula> findBottomSet(Set<ConstraintFormula> set, Set<InferenceVariable> set2) {
        HashSet<ConstraintFormula> hashSet = new HashSet<ConstraintFormula>();
        block0: for (ConstraintFormula constraintFormula : set) {
            Iterator<InferenceVariable> iterator = constraintFormula.inputVariables(this).iterator();
            Iterator<InferenceVariable> iterator2 = set2.iterator();
            while (iterator.hasNext()) {
                InferenceVariable inferenceVariable = iterator.next();
                if (set2.contains(inferenceVariable)) continue block0;
                while (iterator2.hasNext()) {
                    if (!this.currentBounds.dependsOnResolutionOf(inferenceVariable, iterator2.next())) continue;
                    continue block0;
                }
            }
            hashSet.add(constraintFormula);
        }
        return hashSet;
    }

    Set<InferenceVariable> allOutputVariables(Set<ConstraintFormula> set) {
        HashSet<InferenceVariable> hashSet = new HashSet<InferenceVariable>();
        Iterator<ConstraintFormula> iterator = set.iterator();
        while (iterator.hasNext()) {
            hashSet.addAll(iterator.next().outputVariables(this));
        }
        return hashSet;
    }

    private TypeBinding[] varArgTypes(TypeBinding[] typeBindingArray, int n) {
        TypeBinding[] typeBindingArray2 = new TypeBinding[n];
        int n2 = typeBindingArray.length - 1;
        System.arraycopy(typeBindingArray, 0, typeBindingArray2, 0, n2);
        TypeBinding typeBinding = ((ArrayBinding)typeBindingArray[n2]).elementsType();
        for (int i = n2; i < n; ++i) {
            typeBindingArray2[i] = typeBinding;
        }
        return typeBindingArray2;
    }

    public SuspendedInferenceRecord enterPolyInvocation(InvocationSite invocationSite, Expression[] expressionArray) {
        SuspendedInferenceRecord suspendedInferenceRecord = new SuspendedInferenceRecord(this.currentInvocation, this.invocationArguments, this.inferenceVariables, this.inferenceKind);
        this.inferenceVariables = null;
        this.invocationArguments = expressionArray;
        this.currentInvocation = invocationSite;
        this.innerPolies.add(invocationSite);
        return suspendedInferenceRecord;
    }

    public SuspendedInferenceRecord enterLambda(LambdaExpression lambdaExpression) {
        SuspendedInferenceRecord suspendedInferenceRecord = new SuspendedInferenceRecord(this.currentInvocation, this.invocationArguments, this.inferenceVariables, this.inferenceKind);
        this.inferenceVariables = null;
        this.invocationArguments = null;
        this.currentInvocation = null;
        return suspendedInferenceRecord;
    }

    public void resumeSuspendedInference(SuspendedInferenceRecord suspendedInferenceRecord) {
        if (this.inferenceVariables == null) {
            this.inferenceVariables = suspendedInferenceRecord.inferenceVariables;
        } else {
            int n = this.inferenceVariables.length;
            int n2 = suspendedInferenceRecord.inferenceVariables.length;
            this.inferenceVariables = new InferenceVariable[n + n2];
            System.arraycopy(this.inferenceVariables, 0, this.inferenceVariables, n2, n);
            System.arraycopy(suspendedInferenceRecord.inferenceVariables, 0, this.inferenceVariables, 0, n2);
        }
        this.currentInvocation = suspendedInferenceRecord.site;
        this.invocationArguments = suspendedInferenceRecord.invocationArguments;
        this.inferenceKind = suspendedInferenceRecord.inferenceKind;
    }

    public boolean rebindInnerPolies(MethodBinding methodBinding, InvocationSite invocationSite) {
        BoundSet boundSet = this.currentBounds;
        TypeBinding typeBinding = invocationSite.invocationTargetType();
        if (typeBinding == null || !typeBinding.isProperType(true)) {
            if (!invocationSite.getExpressionContext().definesTargetType()) {
                Solution solution = this.solutionsPerTargetType.get(typeBinding);
                try {
                    boundSet = solution != null && solution.bounds != null ? solution.bounds : this.inferInvocationType(this.currentBounds, null, invocationSite, methodBinding.shallowOriginal());
                }
                catch (InferenceFailureException inferenceFailureException) {
                    return false;
                }
                if (boundSet == null) {
                    return false;
                }
            }
        } else {
            Solution solution = this.solutionsPerTargetType.get(typeBinding);
            if (solution != null && solution.bounds != null) {
                boundSet = solution.bounds;
            }
        }
        this.rebindInnerPolies(boundSet, methodBinding.parameters);
        return true;
    }

    public void rebindInnerPolies(BoundSet boundSet, TypeBinding[] typeBindingArray) {
        boolean bl = this.inferenceKind == 3;
        this.acceptPendingPolyArguments(boundSet, typeBindingArray, bl);
        int n = this.innerPolies.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            MethodBinding methodBinding;
            Expression expression = (Expression)((Object)this.innerPolies.get(i));
            if (!(expression instanceof Invocation)) continue;
            Invocation invocation = (Invocation)((Object)expression);
            TypeBinding typeBinding = expression.expectedType();
            if (typeBinding != null && !typeBinding.isProperType(true)) {
                typeBinding = null;
            }
            if ((methodBinding = invocation.binding(typeBinding, typeBinding != null, this.scope)) == null) continue;
            MethodBinding methodBinding2 = methodBinding.shallowOriginal();
            if (methodBinding2.isConstructor() && expression.isPolyExpression()) {
                object2 = methodBinding2.declaringClass;
                object = this.getSolutions(object2.typeVariables(), invocation, boundSet);
                object2 = this.environment.createParameterizedType((ReferenceBinding)object2, (TypeBinding[])object, object2.enclosingType());
                methodBinding2 = ((ParameterizedTypeBinding)object2).createParameterizedMethod(methodBinding2);
                expression.checkAgainstFinalTargetType(typeBinding, this.scope);
                if (this.environment.globalOptions.isAnnotationBasedNullAnalysisEnabled) {
                    NullAnnotationMatching.checkForContraditions(methodBinding2, invocation, this.scope);
                }
            }
            if ((object2 = this.getSolutions(methodBinding2.typeVariables(), invocation, boundSet)) == null) {
                if (!(methodBinding instanceof ParameterizedGenericMethodBinding) || (object = invocation.getInferenceContext((ParameterizedGenericMethodBinding)methodBinding)) == null || methodBinding.isValidBinding()) continue;
                ((InferenceContext18)object).reportInvalidInvocation(invocation, methodBinding);
                continue;
            }
            object = this.environment.createParameterizedGenericMethod(methodBinding2, (TypeBinding[])object2);
            if (!invocation.updateBindings((MethodBinding)object, typeBinding)) continue;
            ASTNode.resolvePolyExpressionArguments(invocation, (MethodBinding)object, this.scope);
        }
        this.stepCompleted = 3;
    }

    private void acceptPendingPolyArguments(BoundSet boundSet, TypeBinding[] typeBindingArray, boolean bl) {
        if (boundSet == null || this.invocationArguments == null) {
            return;
        }
        Substitution substitution = this.getResultSubstitution(boundSet);
        for (int i = 0; i < this.invocationArguments.length; ++i) {
            Expression expression;
            TypeBinding typeBinding = InferenceContext18.getParameter(typeBindingArray, i, bl);
            if (!typeBinding.isProperType(true)) {
                typeBinding = Scope.substitute(substitution, typeBinding);
            }
            if ((expression = this.invocationArguments[i]) instanceof Invocation) {
                Invocation invocation = (Invocation)((Object)expression);
                if (!this.innerPolies.contains(invocation)) {
                    MethodBinding methodBinding = invocation.binding(typeBinding, true, this.scope);
                    if (methodBinding instanceof ParameterizedGenericMethodBinding) {
                        ParameterizedGenericMethodBinding parameterizedGenericMethodBinding = (ParameterizedGenericMethodBinding)methodBinding;
                        InferenceContext18 inferenceContext18 = invocation.getInferenceContext(parameterizedGenericMethodBinding);
                        if (inferenceContext18 == null) continue;
                        MethodBinding methodBinding2 = inferenceContext18.inferInvocationType(invocation, parameterizedGenericMethodBinding);
                        if (!methodBinding2.isValidBinding()) {
                            inferenceContext18.reportInvalidInvocation(invocation, methodBinding2);
                        }
                        if (!invocation.updateBindings(methodBinding2, typeBinding)) continue;
                        ASTNode.resolvePolyExpressionArguments(invocation, methodBinding2, this.scope);
                        continue;
                    }
                    if (!(methodBinding instanceof ParameterizedMethodBinding)) continue;
                    expression.checkAgainstFinalTargetType(typeBinding, this.scope);
                    continue;
                }
                expression.setExpectedType(typeBinding);
                continue;
            }
            expression.checkAgainstFinalTargetType(typeBinding, this.scope);
        }
    }

    private Substitution getResultSubstitution(final BoundSet boundSet) {
        return new Substitution(){

            @Override
            public LookupEnvironment environment() {
                return InferenceContext18.this.environment;
            }

            @Override
            public boolean isRawSubstitution() {
                return false;
            }

            @Override
            public TypeBinding substitute(TypeVariableBinding typeVariableBinding) {
                if (typeVariableBinding instanceof InferenceVariable) {
                    return boundSet.getInstantiation((InferenceVariable)typeVariableBinding, InferenceContext18.this.environment);
                }
                return typeVariableBinding;
            }
        };
    }

    public boolean isVarArgs() {
        return this.inferenceKind == 3;
    }

    public static TypeBinding getParameter(TypeBinding[] typeBindingArray, int n, boolean bl) {
        if (bl) {
            if (n >= typeBindingArray.length - 1) {
                return ((ArrayBinding)typeBindingArray[typeBindingArray.length - 1]).elementsType();
            }
        } else if (n >= typeBindingArray.length) {
            return null;
        }
        return typeBindingArray[n];
    }

    public MethodBinding getReturnProblemMethodIfNeeded(TypeBinding typeBinding, MethodBinding methodBinding) {
        if (typeBinding != null && methodBinding.returnType instanceof ReferenceBinding && methodBinding.returnType.erasure().isCompatibleWith(typeBinding)) {
            return methodBinding;
        }
        if (typeBinding == null) {
            return methodBinding;
        }
        ProblemMethodBinding problemMethodBinding = new ProblemMethodBinding(methodBinding, methodBinding.selector, methodBinding.parameters, 23);
        problemMethodBinding.returnType = typeBinding;
        problemMethodBinding.inferenceContext = this;
        return problemMethodBinding;
    }

    public void reportInvalidInvocation(Invocation invocation, MethodBinding methodBinding) {
        if (invocation instanceof MessageSend) {
            this.scope.problemReporter().invalidMethod((MessageSend)invocation, methodBinding);
        } else {
            this.scope.problemReporter().invalidConstructor((Statement)((Object)invocation), methodBinding);
        }
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("Inference Context");
        switch (this.stepCompleted) {
            case 0: {
                stringBuffer.append(" (initial)");
                break;
            }
            case 1: {
                stringBuffer.append(" (applicability inferred)");
                break;
            }
            case 2: {
                stringBuffer.append(" (type inferred)");
                break;
            }
            case 3: {
                stringBuffer.append(" (bindings updated)");
            }
        }
        switch (this.inferenceKind) {
            case 1: {
                stringBuffer.append(" (strict)");
                break;
            }
            case 2: {
                stringBuffer.append(" (loose)");
                break;
            }
            case 3: {
                stringBuffer.append(" (vararg)");
            }
        }
        if (this.currentBounds != null && this.isResolved(this.currentBounds)) {
            stringBuffer.append(" (resolved)");
        }
        stringBuffer.append('\n');
        if (this.inferenceVariables != null) {
            stringBuffer.append("Inference Variables:\n");
            for (n = 0; n < this.inferenceVariables.length; ++n) {
                stringBuffer.append('\t').append(this.inferenceVariables[n].sourceName).append("\t:\t");
                if (this.currentBounds != null && this.currentBounds.isInstantiated(this.inferenceVariables[n])) {
                    stringBuffer.append(this.currentBounds.getInstantiation(this.inferenceVariables[n], this.environment).readableName());
                } else {
                    stringBuffer.append("NOT INSTANTIATED");
                }
                stringBuffer.append('\n');
            }
        }
        if (this.initialConstraints != null) {
            stringBuffer.append("Initial Constraints:\n");
            for (n = 0; n < this.initialConstraints.length; ++n) {
                if (this.initialConstraints[n] == null) continue;
                stringBuffer.append('\t').append(this.initialConstraints[n].toString()).append('\n');
            }
        }
        if (this.currentBounds != null) {
            stringBuffer.append(this.currentBounds.toString());
        }
        return stringBuffer.toString();
    }

    public void addProblemMethod(ProblemMethodBinding problemMethodBinding) {
        if (this.problemMethods == null) {
            this.problemMethods = new ArrayList();
        }
        this.problemMethods.add(problemMethodBinding);
    }

    public static ParameterizedTypeBinding parameterizedWithWildcard(TypeBinding typeBinding) {
        if (typeBinding == null || typeBinding.kind() != 260) {
            return null;
        }
        ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)typeBinding;
        TypeBinding[] typeBindingArray = parameterizedTypeBinding.arguments;
        if (typeBindingArray != null) {
            for (int i = 0; i < typeBindingArray.length; ++i) {
                if (!typeBindingArray[i].isWildcard()) continue;
                return parameterizedTypeBinding;
            }
        }
        return null;
    }

    public TypeBinding[] getFunctionInterfaceArgumentSolutions(TypeBinding[] typeBindingArray) {
        int n = typeBindingArray.length;
        TypeBinding[] typeBindingArray2 = new TypeBinding[n];
        for (int i = 0; i < this.inferenceVariables.length; ++i) {
            InferenceVariable inferenceVariable = this.inferenceVariables[i];
            TypeBinding typeBinding = this.currentBounds.getInstantiation(inferenceVariable, this.environment);
            typeBindingArray2[i] = typeBinding != null ? typeBinding : typeBindingArray[i];
        }
        return typeBindingArray2;
    }

    public void recordUncheckedConversion(ConstraintTypeFormula constraintTypeFormula) {
        if (this.constraintsWithUncheckedConversion == null) {
            this.constraintsWithUncheckedConversion = new ArrayList<ConstraintFormula>();
        }
        this.constraintsWithUncheckedConversion.add(constraintTypeFormula);
    }

    void reportUncheckedConversions(BoundSet boundSet) {
        if (this.constraintsWithUncheckedConversion != null) {
            int n = this.constraintsWithUncheckedConversion.size();
            Substitution substitution = this.getResultSubstitution(boundSet);
            for (int i = 0; i < n; ++i) {
                ConstraintTypeFormula constraintTypeFormula = (ConstraintTypeFormula)this.constraintsWithUncheckedConversion.get(i);
                TypeBinding typeBinding = constraintTypeFormula.right;
                TypeBinding typeBinding2 = constraintTypeFormula.left;
                if (!typeBinding.isProperType(true)) {
                    typeBinding = Scope.substitute(substitution, typeBinding);
                }
                if (typeBinding2.isProperType(true)) continue;
                typeBinding2 = Scope.substitute(substitution, typeBinding2);
            }
        }
    }

    public boolean usesUncheckedConversion() {
        return this.constraintsWithUncheckedConversion != null;
    }

    public static void missingImplementation(String string) {
        throw new UnsupportedOperationException(string);
    }

    static class Solution {
        TypeBinding resolvedType;
        MethodBinding method;
        BoundSet bounds;

        Solution(MethodBinding methodBinding, BoundSet boundSet) {
            this.method = methodBinding;
            this.resolvedType = methodBinding.isConstructor() ? methodBinding.declaringClass : methodBinding.returnType;
            this.bounds = boundSet;
        }
    }

    static class SuspendedInferenceRecord {
        InvocationSite site;
        Expression[] invocationArguments;
        InferenceVariable[] inferenceVariables;
        int inferenceKind;

        SuspendedInferenceRecord(InvocationSite invocationSite, Expression[] expressionArray, InferenceVariable[] inferenceVariableArray, int n) {
            this.site = invocationSite;
            this.invocationArguments = expressionArray;
            this.inferenceVariables = inferenceVariableArray;
            this.inferenceKind = n;
        }
    }
}

