/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.profiler.snaptracer.Positionable;
import org.netbeans.modules.profiler.snaptracer.TracerPackage;
import org.netbeans.modules.profiler.snaptracer.TracerProbeDescriptor;
import org.netbeans.modules.profiler.snaptracer.impl.TracerController;
import org.netbeans.modules.profiler.snaptracer.impl.TracerModel;
import org.netbeans.modules.profiler.snaptracer.impl.TracerSupportImpl;
import org.netbeans.modules.profiler.snaptracer.impl.options.TracerOptions;
import org.netbeans.modules.profiler.snaptracer.impl.probes.ProbeDescriptorComponent;
import org.netbeans.modules.profiler.snaptracer.impl.swing.CategoryList;

final class PackagesView {
    private final TracerModel model;
    private final TracerController controller;

    PackagesView(TracerModel tracerModel, TracerController tracerController) {
        this.model = tracerModel;
        this.controller = tracerController;
    }

    private void loadPackages(final JComponent jComponent) {
        TracerSupportImpl.getInstance().perform(new Runnable(){

            @Override
            public void run() {
                final List<TracerPackage> list = PackagesView.this.model.getPackages();
                if (list != null) {
                    final ArrayList<List<TracerProbeDescriptor>> arrayList = new ArrayList<List<TracerProbeDescriptor>>();
                    for (TracerPackage tracerPackage : list) {
                        TracerProbeDescriptor[] tracerProbeDescriptorArray = tracerPackage.getProbeDescriptors();
                        Arrays.sort(tracerProbeDescriptorArray, Positionable.COMPARATOR);
                        List<TracerProbeDescriptor> list2 = Arrays.asList(tracerProbeDescriptorArray);
                        arrayList.add(list2);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PackagesView.this.displayPackages(list, arrayList, jComponent);
                        }
                    });
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PackagesView.this.displayError(jComponent);
                        }
                    });
                }
            }
        });
    }

    JComponent getView() {
        JComponent jComponent = this.createComponents();
        this.initListeners(jComponent);
        this.refreshState(jComponent);
        return jComponent;
    }

    private void refreshState(JComponent jComponent) {
        switch (this.controller.getState()) {
            case 0: {
                jComponent.setEnabled(true);
                break;
            }
            case -2147483648: 
            case -1: 
            case 1: 
            case 0x7FFFFFFF: {
                jComponent.setEnabled(false);
            }
        }
    }

    private void initListeners(final JComponent jComponent) {
        jComponent.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && jComponent.isShowing()) {
                    jComponent.removeHierarchyListener(this);
                    PackagesView.this.loadPackages(jComponent);
                }
            }
        });
        this.controller.addListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PackagesView.this.refreshState(jComponent);
            }
        });
    }

    private void displayPackages(List<TracerPackage> list, List<List<TracerProbeDescriptor>> list2, JComponent jComponent) {
        int n = list2.size();
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        boolean[] blArray = new boolean[n];
        Component[][] componentArray = new Component[n][];
        ProbeDescriptorComponent.SelectionHandler selectionHandler = new ProbeDescriptorComponent.SelectionHandler(){

            @Override
            public void descriptorSelected(TracerPackage tracerPackage, TracerProbeDescriptor tracerProbeDescriptor) {
                PackagesView.this.model.addDescriptor(tracerPackage, tracerProbeDescriptor);
            }

            @Override
            public void descriptorUnselected(TracerPackage tracerPackage, TracerProbeDescriptor tracerProbeDescriptor) {
                PackagesView.this.model.removeDescriptor(tracerPackage, tracerProbeDescriptor);
            }
        };
        int n2 = TracerOptions.getInstance().getProbesApp();
        Boolean bl = null;
        if (n2 == 1) {
            bl = true;
        } else if (n2 == 2) {
            bl = false;
        }
        for (int i = 0; i < n; ++i) {
            TracerPackage tracerPackage = list.get(i);
            stringArray[i] = tracerPackage.getName();
            stringArray2[i] = tracerPackage.getDescription();
            boolean bl2 = blArray[i] = bl == null || bl != false;
            if (bl == null) {
                bl = false;
            }
            List<TracerProbeDescriptor> list3 = list2.get(i);
            int n3 = list3.size();
            componentArray[i] = new Component[n3];
            for (int j = 0; j < n3; ++j) {
                componentArray[i][j] = new ProbeDescriptorComponent(list3.get(j), tracerPackage, selectionHandler);
            }
        }
        jComponent.removeAll();
        jComponent.add(new CategoryList(stringArray, stringArray2, blArray, componentArray));
        jComponent.revalidate();
        jComponent.repaint();
    }

    private void displayError(JComponent jComponent) {
        jComponent.removeAll();
        jComponent.add((Component)new JLabel("Failed to load probes, check the logfile", 0), "Center");
        jComponent.revalidate();
        jComponent.repaint();
    }

    private JComponent createComponents() {
        JPanel jPanel = new JPanel(new BorderLayout()){

            @Override
            public void setEnabled(boolean bl) {
                Component[] componentArray;
                for (Component component : componentArray = this.getComponents()) {
                    component.setEnabled(bl);
                }
            }
        };
        jPanel.setOpaque(false);
        JLabel jLabel = new JLabel("Loading probes...", 0);
        jLabel.setEnabled(false);
        jPanel.add((Component)jLabel, "Center");
        return jPanel;
    }
}

