/*
 * Decompiled with CFR 0.152.
 */
package dguitar.gui;

import common.Util;
import dguitar.codecs.guitarPro.GPDuration;
import dguitar.codecs.guitarPro.GPFormatException;
import dguitar.codecs.guitarPro.GPInputStream;
import dguitar.codecs.guitarPro.GPMeasureTrackPair;
import dguitar.codecs.guitarPro.GPSong;
import dguitar.codecs.guitarPro.GPTrack;
import dguitar.gui.BarMTP;
import dguitar.gui.DisplayOptions;
import dguitar.gui.MusicCursorPosition;
import dguitar.gui.OptionsDisplay;
import dguitar.gui.TrackPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;

public class SongPanel
extends JPanel
implements OptionsDisplay {
    private GridBagLayout gridBagLayout;
    private GPSong piece;
    private List measures;
    private List tracks;
    private int numMeasures;
    private int numTracks;
    private JTabbedPane TabPane;
    private JPanel Panel;
    private int count;
    private boolean hasTracks;
    private boolean viewChange;
    private boolean spacingChange;
    private DisplayOptions displayOptions;
    private MusicCursorPosition musicCursorPosition;
    private int linesOnTop = 2;
    private int linesOnBottom = 3;

    public SongPanel() {
        this.displayOptions = new DisplayOptions();
        this.initComponents();
    }

    public SongPanel(DisplayOptions aDisplayOptions) {
        if (aDisplayOptions == null) {
            throw new NullPointerException("aDisplayOptions is null");
        }
        this.initComponents();
        this.setDisplayOptions(aDisplayOptions);
    }

    public void setDisplayOptions(DisplayOptions dO) {
        this.displayOptions = dO;
        this.displayOptions.TopOffset += this.linesOnTop * this.displayOptions.LS;
        this.displayOptions.BottomOffset += this.linesOnBottom * this.displayOptions.LS;
        if (this.displayOptions.multiTrackView) {
            this.addScrollPane();
        } else {
            this.addTabPane();
        }
    }

    public DisplayOptions getDisplayOptions() {
        return this.displayOptions;
    }

    private void initComponents() {
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.numMeasures = 0;
        this.numTracks = 0;
        this.setLayout(new BorderLayout());
        this.hasTracks = false;
        this.measures = null;
        this.viewChange = false;
        this.spacingChange = true;
    }

    private void addScrollPane() {
        this.gridBagLayout = new GridBagLayout();
        this.Panel = new JPanel(this.gridBagLayout);
        this.Panel.setOpaque(true);
        this.Panel.setBackground(Color.WHITE);
        JScrollPane JSP = new JScrollPane(this.Panel);
        this.add(JSP);
    }

    private void addTabPane() {
        this.TabPane = new JTabbedPane();
        this.add(this.TabPane);
    }

    private void removeScrollPane() {
        this.Panel.removeAll();
        this.remove(0);
    }

    private void removeTabPane() {
        this.TabPane.removeAll();
        this.remove(0);
    }

    public void setMinPieceSpacing(boolean b) {
        if (b != this.displayOptions.minPieceSpacing) {
            this.displayOptions.minPieceSpacing = b;
            this.spacingChange = true;
        }
    }

    public void toggleMinPieceSpacing() {
        this.displayOptions.toggleMinPieceSpacing();
        this.spacingChange = true;
    }

    public void toggleDisplayUnsupportedEffects() {
        this.displayOptions.toggleDisplayUnsupportedEffects();
    }

    public void toggleSingleMusicCursorColor() {
        this.displayOptions.toggleSingleMusicCursorColor();
        this.setMusicCursorSingleColor(this.displayOptions.singleMusicCursorColor);
    }

    public void toggleViewMusicCursors() {
        this.displayOptions.toggleViewMusicCursors();
        this.musicCursorsSetEnable(this.displayOptions.displayMusicCursor);
        this.musicCursorsSetVisible(this.displayOptions.displayMusicCursor);
    }

    public boolean getMinPieceSpacing() {
        return this.displayOptions.minPieceSpacing;
    }

    public GPSong getPiece() {
        return this.piece;
    }

    public void changeView() {
        if (this.viewChange) {
            if (this.displayOptions.multiTrackView) {
                this.removeTabPane();
                this.addScrollPane();
            } else {
                this.removeScrollPane();
                this.addTabPane();
            }
            this.hasTracks = false;
            this.spacingChange = true;
        }
    }

    public void displayPiece() {
        if (this.hasTracks) {
            this.changeView();
        }
        if (!this.hasTracks) {
            this.addTrackMeasures();
            this.hasTracks = true;
        }
        this.setMeasuresTracksPairs();
        this.alignBars();
    }

    public void musicCursorsAlign() {
        TrackPanel TP = this.getFirstTrackPanel();
        while (TP != null) {
            TP.setMusicCursor(1, 1, false);
            TP = this.getNextTrackPanel();
        }
    }

    public void musicCursorsSetVisible(boolean value) {
        TrackPanel TP = this.getFirstTrackPanel();
        while (TP != null) {
            TP.setMusicCursorsVisible(value);
            TP = this.getNextTrackPanel();
        }
    }

    public void musicCursorsSetEnable(boolean value) {
        TrackPanel TP = this.getFirstTrackPanel();
        while (TP != null) {
            TP.setMusicCursorsProcesingEvents(value);
            TP = this.getNextTrackPanel();
        }
    }

    private void multiTrackViewChanged() {
        this.viewChange = true;
        this.changeView();
    }

    public void setMultiTrackView(boolean b) {
        if (b != this.displayOptions.multiTrackView) {
            this.displayOptions.multiTrackView = b;
            this.multiTrackViewChanged();
        }
    }

    public void toggleMultiTrackView() {
        this.displayOptions.toggleMultiTrackView();
        this.multiTrackViewChanged();
    }

    public boolean isMultiTrackView() {
        return this.displayOptions.multiTrackView;
    }

    private void addTrackPanel(GPTrack track) {
        TrackPanel TP = new TrackPanel(this.displayOptions, this.musicCursorPosition);
        if (TP == null) {
            System.err.println("Error adding a new TRACK ..Object 'TrackPanel' could NOT be created");
        } else {
            if (this.measures != null) {
                TP.setTrack(track);
                TP.addBar(this.measures.size());
                TP.setMeasures(this.measures);
            }
            if (this.displayOptions.multiTrackView) {
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = this.Panel.getComponentCount();
                this.Panel.add((Component)TP, gridBagConstraints);
            } else {
                JScrollPane JSP = new JScrollPane(TP);
                this.TabPane.add(track.getName(), JSP);
            }
        }
    }

    public TrackPanel getTrackPanel(int pos) {
        TrackPanel TP = null;
        if (pos < this.numTracks) {
            if (this.displayOptions.multiTrackView) {
                TP = (TrackPanel)this.Panel.getComponent(pos);
            } else {
                JScrollPane JSP = (JScrollPane)this.TabPane.getComponent(pos);
                JViewport JVP = JSP.getViewport();
                TP = (TrackPanel)JVP.getView();
            }
        }
        return TP;
    }

    protected TrackPanel getFirstTrackPanel() {
        this.count = 0;
        TrackPanel TP = null;
        try {
            if (this.displayOptions.multiTrackView) {
                TP = (TrackPanel)this.Panel.getComponent(this.count);
            } else {
                JScrollPane JSP = (JScrollPane)this.TabPane.getComponent(this.count);
                JViewport JVP = JSP.getViewport();
                TP = (TrackPanel)JVP.getView();
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return TP;
    }

    protected TrackPanel getNextTrackPanel() {
        ++this.count;
        TrackPanel TP = null;
        if (this.count < this.numTracks) {
            if (this.displayOptions.multiTrackView) {
                TP = (TrackPanel)this.Panel.getComponent(this.count);
            } else {
                JScrollPane JSP = (JScrollPane)this.TabPane.getComponent(this.count);
                JViewport JVP = JSP.getViewport();
                TP = (TrackPanel)JVP.getView();
            }
        }
        return TP;
    }

    private GPDuration minDurationOfMeasure(int m) {
        GPDuration minDuration = GPDuration.WHOLE;
        TrackPanel TP = this.getFirstTrackPanel();
        while (TP != null) {
            BarMTP BMTP = TP.getTablatureBar(m);
            GPDuration duration = BMTP.minDurationOfBeats();
            if (duration.compareTo(minDuration) < 0) {
                minDuration = duration;
            }
            TP = this.getNextTrackPanel();
        }
        return minDuration;
    }

    private void setMinDuration(GPDuration minDuration, int m) {
        TrackPanel TP = this.getFirstTrackPanel();
        int t = 0;
        while (TP != null) {
            BarMTP BMTP = TP.getTablatureBar(m);
            BMTP.setMinDuration(minDuration);
            TP = this.getNextTrackPanel();
            ++t;
        }
    }

    private void setMinWidth(int min, int m) {
        TrackPanel TP = this.getFirstTrackPanel();
        int t = 0;
        while (TP != null) {
            BarMTP BMTP = TP.getTablatureBar(m);
            BMTP.setMinWidth(min);
            BMTP.invalidate();
            TP = this.getNextTrackPanel();
            ++t;
        }
    }

    private int getMaxWidth(int m) {
        int max = 0;
        TrackPanel TP = this.getFirstTrackPanel();
        int t = 0;
        while (TP != null) {
            BarMTP bar = TP.getTablatureBar(m);
            max = Math.max(max, bar.getWidth());
            TP = this.getNextTrackPanel();
            ++t;
        }
        return max;
    }

    protected void alignBars() {
        if (this.spacingChange) {
            GPDuration minPieceDuration = GPDuration.WHOLE;
            int m = 0;
            while (m < this.numMeasures) {
                GPDuration minDuration = this.minDurationOfMeasure(m);
                if (this.displayOptions.minPieceSpacing) {
                    if (minDuration.compareTo(minPieceDuration) < 0) {
                        minPieceDuration = minDuration;
                    }
                } else {
                    this.setMinDuration(minDuration, m);
                }
                ++m;
            }
            if (this.displayOptions.minPieceSpacing) {
                m = 0;
                while (m < this.numMeasures) {
                    this.setMinDuration(minPieceDuration, m);
                    ++m;
                }
            }
            m = 0;
            while (m < this.numMeasures) {
                this.setMinWidth(this.getMaxWidth(m), m);
                ++m;
            }
            this.spacingChange = false;
        }
    }

    private void setMeasuresTracksPairs() {
        List MTPs = this.piece.getMeasuresTracksPairs();
        if (MTPs != null) {
            int i = 0;
            int m = 0;
            while (m < this.numMeasures) {
                TrackPanel TP = this.getFirstTrackPanel();
                while (TP != null) {
                    TP.setMeasureTrackPair(m, (GPMeasureTrackPair)MTPs.get(i));
                    TP = this.getNextTrackPanel();
                    ++i;
                }
                ++m;
            }
        }
    }

    private void addTrackMeasures() {
        if (this.measures == null) {
            this.measures = this.piece.getMeasures();
        }
        if (this.measures != null) {
            this.numMeasures = this.measures.size();
            if (this.numMeasures > 0) {
                this.tracks = this.piece.getTracks();
                if (this.tracks != null) {
                    this.numTracks = this.tracks.size();
                    if (this.numTracks > 0) {
                        int i = 0;
                        while (i < this.numTracks) {
                            this.addTrackPanel((GPTrack)this.tracks.get(i));
                            ++i;
                        }
                    }
                }
            }
        }
    }

    public boolean hasChanged() {
        boolean changed = false;
        TrackPanel TP = this.getFirstTrackPanel();
        while (!changed && TP != null) {
            changed = TP.hasChanged();
            TP = this.getNextTrackPanel();
        }
        return changed;
    }

    public boolean readPieceFrom(GPInputStream GPis) {
        boolean success = false;
        if (GPis != null) {
            try {
                this.piece = (GPSong)GPis.readObject();
                success = true;
            }
            catch (GPFormatException GFE) {
                Util.showDialogOk(this, "File contains this format Exception ", GFE.toString());
            }
            catch (IOException IOE) {
                IOE.printStackTrace();
            }
        }
        return success;
    }

    public int getNoteSpacing() {
        int ns = -1;
        TrackPanel TP = this.getFirstTrackPanel();
        if (TP != null) {
            ns = TP.getNoteSpacing();
        }
        return ns;
    }

    public void setNoteSpacing(int ns) {
        if (ns > 0) {
            TrackPanel TP = this.getFirstTrackPanel();
            while (TP != null) {
                TP.setNoteSpacing(ns);
                TP = this.getNextTrackPanel();
            }
        }
    }

    public void setMusicCursorSingleColor(boolean single) {
        TrackPanel TP = this.getFirstTrackPanel();
        while (TP != null) {
            TP.setMusicCursorSingleColor(single);
            TP = this.getNextTrackPanel();
        }
    }

    public void validate() {
        this.alignBars();
        TrackPanel TP = this.getFirstTrackPanel();
        while (TP != null) {
            TP.validate();
            TP = this.getNextTrackPanel();
        }
        super.validate();
    }

    protected void scrollOthers(TrackPanel tp) {
        if (!this.displayOptions.multiTrackView) {
            JViewport JVPRef;
            JScrollPane JSP;
            TrackPanel TP;
            int i = 0;
            do {
                JSP = (JScrollPane)this.TabPane.getComponent(i);
                JVPRef = JSP.getViewport();
                TP = (TrackPanel)JVPRef.getView();
            } while (++i < this.numTracks && !TP.equals(tp));
            i = 0;
            do {
                JViewport JVP;
                if ((TP = (TrackPanel)(JVP = (JSP = (JScrollPane)this.TabPane.getComponent(i)).getViewport()).getView()).equals(tp)) continue;
                JViewport JVPAux = new JViewport();
                JVPAux.setView(TP);
                JVPAux.setViewPosition(JVPRef.getViewPosition());
                JSP.setViewport(JVPAux);
            } while (++i < this.numTracks);
        }
    }

    public void setNumTracks(int numTracks) {
        this.numTracks = numTracks;
    }

    public int getNumTracks() {
        return this.numTracks;
    }
}

