/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.dispatch;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import org.jruby.truffle.nodes.dispatch.CachedDispatchNode;
import org.jruby.truffle.nodes.dispatch.DispatchAction;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.methods.InternalMethod;

public class CachedBoxedDispatchNode
extends CachedDispatchNode {
    private final Shape expectedShape;
    private final Assumption validShape;
    private final Assumption unmodifiedAssumption;
    private final InternalMethod method;
    @Node.Child
    private DirectCallNode callNode;

    public CachedBoxedDispatchNode(RubyContext context, Object cachedName, DispatchNode next, Shape expectedShape, DynamicObject expectedClass, InternalMethod method, DispatchAction dispatchAction) {
        super(context, cachedName, next, dispatchAction);
        this.expectedShape = expectedShape;
        this.validShape = expectedShape.getValidAssumption();
        this.unmodifiedAssumption = Layouts.MODULE.getFields(expectedClass).getUnmodifiedAssumption();
        this.next = next;
        this.method = method;
        this.callNode = Truffle.getRuntime().createDirectCallNode(method.getCallTarget());
        this.applySplittingInliningStrategy(this.callNode, method);
    }

    @Override
    public boolean guard(Object methodName, Object receiver) {
        return this.guardName(methodName) && receiver instanceof DynamicObject && ((DynamicObject)receiver).getShape() == this.expectedShape;
    }

    @Override
    public Object executeDispatch(VirtualFrame frame, Object receiverObject, Object methodName, DynamicObject blockObject, Object[] argumentsObjects) {
        try {
            this.validShape.check();
            this.unmodifiedAssumption.check();
        }
        catch (InvalidAssumptionException e) {
            return this.resetAndDispatch(frame, receiverObject, methodName, blockObject, argumentsObjects, "class modified");
        }
        if (!this.guard(methodName, receiverObject)) {
            return this.next.executeDispatch(frame, receiverObject, methodName, blockObject, argumentsObjects);
        }
        switch (this.getDispatchAction()) {
            case CALL_METHOD: {
                return CachedBoxedDispatchNode.call(this.callNode, frame, this.method, receiverObject, blockObject, argumentsObjects);
            }
            case RESPOND_TO_METHOD: {
                return true;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return String.format("CachedBoxedDispatchNode(:%s, %s@%x, %s)", this.getCachedNameAsSymbol().toString(), this.expectedShape, this.expectedShape.hashCode(), this.method == null ? "null" : this.method.toString());
    }

    public InternalMethod getMethod() {
        return this.method;
    }

    public Assumption getUnmodifiedAssumption() {
        return this.unmodifiedAssumption;
    }
}

