/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish;

import com.netflix.servo.Metric;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.publish.JmxConnector;
import com.netflix.servo.publish.MetricFilter;
import com.netflix.servo.publish.MetricPoller;
import com.netflix.servo.tag.BasicTagList;
import com.netflix.servo.tag.SmallTagMap;
import com.netflix.servo.tag.StandardTagKeys;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.TagList;
import com.netflix.servo.tag.Tags;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JmxMetricPoller
implements MetricPoller {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmxMetricPoller.class);
    private static final Tag CLASS_TAG = Tags.newTag(StandardTagKeys.CLASS_NAME.getKeyName(), JmxMetricPoller.class.getCanonicalName());
    private static final String DOMAIN_KEY = "JmxDomain";
    private static final String COMPOSITE_PATH_KEY = "JmxCompositePath";
    private static final String PROP_KEY_PREFIX = "Jmx";
    private final JmxConnector connector;
    private final List<ObjectName> queries;
    private final MetricFilter counters;
    private final boolean onlyNumericMetrics;
    private final List<Tag> defaultTags;

    public JmxMetricPoller(JmxConnector connector, ObjectName query, MetricFilter counters) {
        this(connector, Collections.singletonList(query), counters, true, null);
    }

    public JmxMetricPoller(JmxConnector connector, List<ObjectName> queries, MetricFilter counters) {
        this(connector, queries, counters, true, null);
    }

    public JmxMetricPoller(JmxConnector connector, List<ObjectName> queries, MetricFilter counters, boolean onlyNumericMetrics, List<Tag> defaultTags) {
        this.connector = connector;
        this.queries = queries;
        this.counters = counters;
        this.onlyNumericMetrics = onlyNumericMetrics;
        this.defaultTags = defaultTags;
    }

    private TagList createTagList(ObjectName name) {
        Hashtable<String, String> props = name.getKeyPropertyList();
        SmallTagMap.Builder tagsBuilder = SmallTagMap.builder();
        for (Map.Entry e : props.entrySet()) {
            String key = "Jmx." + (String)e.getKey();
            tagsBuilder.add(Tags.newTag(key, (String)e.getValue()));
        }
        tagsBuilder.add(Tags.newTag(DOMAIN_KEY, name.getDomain()));
        tagsBuilder.add(CLASS_TAG);
        if (this.defaultTags != null) {
            for (Tag defaultTag : this.defaultTags) {
                tagsBuilder.add(defaultTag);
            }
        }
        return new BasicTagList(tagsBuilder.result());
    }

    private static TagList getTagListWithAdditionalTag(TagList tags, Tag extra) {
        return new BasicTagList(SmallTagMap.builder().addAll(tags).add(extra).result());
    }

    private void addMetric(List<Metric> metrics, String name, TagList tags, Object value) {
        long now = System.currentTimeMillis();
        if (this.onlyNumericMetrics) {
            value = JmxMetricPoller.asNumber(value);
        }
        if (value != null) {
            TagList newTags = this.counters.matches(MonitorConfig.builder(name).withTags(tags).build()) ? JmxMetricPoller.getTagListWithAdditionalTag(tags, DataSourceType.COUNTER) : JmxMetricPoller.getTagListWithAdditionalTag(tags, DataSourceType.GAUGE);
            Metric m = new Metric(name, newTags, now, value);
            metrics.add(m);
        }
    }

    private void extractValues(String path, Map<String, Object> values, CompositeData obj) {
        for (String key : obj.getCompositeType().keySet()) {
            String newPath = path == null ? key : path + "." + key;
            Object value = obj.get(key);
            if (value instanceof CompositeData) {
                this.extractValues(newPath, values, (CompositeData)value);
                continue;
            }
            if (value == null) continue;
            values.put(newPath, value);
        }
    }

    private void getMetrics(MBeanServerConnection con, MetricFilter filter, List<Metric> metrics, ObjectName name) throws JMException, IOException {
        TagList tags = this.createTagList(name);
        MBeanInfo info = con.getMBeanInfo(name);
        MBeanAttributeInfo[] attrInfos = info.getAttributes();
        ArrayList<String> matchingNames = new ArrayList<String>();
        for (MBeanAttributeInfo attrInfo : attrInfos) {
            String attrName = attrInfo.getName();
            if (!filter.matches(new MonitorConfig.Builder(attrName).withTags(tags).build())) continue;
            matchingNames.add(attrName);
        }
        List<Attribute> attributeList = JmxMetricPoller.safelyLoadAttributes(con, name, matchingNames);
        for (Attribute attr : attributeList) {
            String attrName = attr.getName();
            Object obj = attr.getValue();
            if (obj instanceof TabularData) {
                for (Object key : ((TabularData)obj).values()) {
                    if (!(key instanceof CompositeData)) continue;
                    this.addTabularMetrics(filter, metrics, tags, attrName, (CompositeData)key);
                }
                continue;
            }
            if (obj instanceof CompositeData) {
                this.addCompositeMetrics(filter, metrics, tags, attrName, (CompositeData)obj);
                continue;
            }
            this.addMetric(metrics, attrName, tags, obj);
        }
    }

    private void addCompositeMetrics(MetricFilter filter, List<Metric> metrics, TagList tags, String attrName, CompositeData obj) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        this.extractValues(null, values, obj);
        for (Map.Entry e : values.entrySet()) {
            Tag compositeTag = Tags.newTag(COMPOSITE_PATH_KEY, (String)e.getKey());
            TagList newTags = JmxMetricPoller.getTagListWithAdditionalTag(tags, compositeTag);
            if (!filter.matches(MonitorConfig.builder(attrName).withTags(newTags).build())) continue;
            this.addMetric(metrics, attrName, newTags, e.getValue());
        }
    }

    private void addTabularMetrics(MetricFilter filter, List<Metric> metrics, TagList tags, String attrName, CompositeData obj) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put(obj.get("key").toString(), obj.get("value"));
        for (Map.Entry e : values.entrySet()) {
            Tag compositeTag = Tags.newTag(COMPOSITE_PATH_KEY, (String)e.getKey());
            TagList newTags = JmxMetricPoller.getTagListWithAdditionalTag(tags, compositeTag);
            if (!filter.matches(MonitorConfig.builder(attrName).withTags(newTags).build())) continue;
            this.addMetric(metrics, attrName, newTags, e.getValue());
        }
    }

    private static Number asNumber(Object value) {
        Number num = null;
        if (value == null) {
            num = null;
        } else if (value instanceof Number) {
            num = (Number)value;
        } else if (value instanceof Boolean) {
            num = (Boolean)value != false ? 1 : 0;
        }
        return num;
    }

    @Override
    public List<Metric> poll(MetricFilter filter) {
        return this.poll(filter, false);
    }

    @Override
    public List<Metric> poll(MetricFilter filter, boolean reset) {
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        try {
            MBeanServerConnection con = this.connector.getConnection();
            for (ObjectName query : this.queries) {
                Set<ObjectName> names = con.queryNames(query, null);
                if (names.isEmpty()) {
                    LOGGER.warn("no mbeans matched query: {}", (Object)query);
                    continue;
                }
                for (ObjectName name : names) {
                    try {
                        this.getMetrics(con, filter, metrics, name);
                    }
                    catch (Exception e) {
                        LOGGER.warn("failed to get metrics for: " + name, (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("failed to collect jmx metrics.", (Throwable)e);
        }
        return metrics;
    }

    private static List<Attribute> safelyLoadAttributes(MBeanServerConnection server, ObjectName objectName, List<String> matchingNames) {
        try {
            return JmxMetricPoller.batchLoadAttributes(server, objectName, matchingNames);
        }
        catch (Exception e) {
            LOGGER.info("Error batch loading attributes for {} : {}", (Object)objectName, (Object)e.getMessage());
            return JmxMetricPoller.individuallyLoadAttributes(server, objectName, matchingNames);
        }
    }

    private static List<Attribute> batchLoadAttributes(MBeanServerConnection server, ObjectName objectName, List<String> matchingNames) throws InstanceNotFoundException, ReflectionException, IOException {
        String[] namesArray = matchingNames.toArray(new String[matchingNames.size()]);
        return server.getAttributes(objectName, namesArray).asList();
    }

    private static List<Attribute> individuallyLoadAttributes(MBeanServerConnection server, ObjectName objectName, List<String> matchingNames) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (String attrName : matchingNames) {
            try {
                Object value = server.getAttribute(objectName, attrName);
                attributes.add(new Attribute(attrName, value));
            }
            catch (Exception e) {
                LOGGER.info("Couldn't load attribute {} for {} : {}", (Object)new Object[]{attrName, objectName, e.getMessage()}, (Object)e);
            }
        }
        return attributes;
    }
}

