/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Panel;

public class ResizePanel
extends Panel
implements LayoutManager {
    Component one;
    Component two;
    int pos = -1;
    double ratio;
    boolean vertical;
    boolean dragging;
    int border = 100;

    public ResizePanel(Component component, Component component2, double d, boolean bl) {
        this.one = component;
        this.two = component2;
        this.vertical = bl;
        this.ratio = d;
        this.setLayout(this);
        this.add(component);
        this.add(component2);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.size();
        if (this.vertical) {
            this.pos = (int)((double)dimension.height * this.ratio);
            graphics.setColor(Color.white);
            graphics.drawLine(0, this.pos - 2, 0, this.pos + 1);
            graphics.drawLine(0, this.pos - 2, dimension.width - 2, this.pos - 2);
            graphics.setColor(Color.black);
            graphics.drawLine(dimension.width - 1, this.pos + 2, dimension.width - 1, this.pos - 1);
            graphics.drawLine(dimension.width - 1, this.pos + 2, 1, this.pos + 2);
        } else {
            this.pos = (int)((double)dimension.width * this.ratio);
            graphics.setColor(Color.white);
            graphics.drawLine(this.pos - 2, 0, this.pos + 1, 0);
            graphics.drawLine(this.pos - 2, 0, this.pos - 2, dimension.height - 2);
            graphics.setColor(Color.black);
            graphics.drawLine(this.pos + 2, dimension.height - 1, this.pos - 1, dimension.height - 1);
            graphics.drawLine(this.pos + 2, dimension.height - 1, this.pos + 2, 1);
        }
    }

    public boolean mouseDown(Event event, int n, int n2) {
        Dimension dimension = this.size();
        if (this.vertical && n2 >= this.pos - 2 && n2 <= this.pos + 2) {
            this.dragging = true;
        }
        if (!this.vertical && n >= this.pos - 2 && n <= this.pos + 2) {
            this.dragging = true;
        }
        return this.dragging;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.dragging) {
            Dimension dimension = this.size();
            if (this.vertical) {
                this.pos = n2 < this.border ? this.border : (n2 > dimension.height - this.border ? dimension.height - this.border : n2);
                this.ratio = (double)this.pos / (double)dimension.height;
            } else {
                this.pos = n < this.border ? this.border : (n > dimension.width - this.border ? dimension.width - this.border : n);
                this.ratio = (double)this.pos / (double)dimension.width;
            }
            this.layoutContainer(this);
            this.repaint();
        }
        return this.dragging;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        boolean bl = this.dragging;
        this.dragging = false;
        return bl;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void layoutContainer(Container container) {
        Dimension dimension = container.size();
        if (this.vertical) {
            this.pos = (int)((double)dimension.height * this.ratio);
            this.one.reshape(0, 0, dimension.width, this.pos - 3);
            this.one.layout();
            this.two.reshape(0, this.pos + 3, dimension.width, dimension.height - this.pos - 5);
            this.two.layout();
        } else {
            this.pos = (int)((double)dimension.width * this.ratio);
            this.one.reshape(0, 0, this.pos - 3, dimension.height);
            this.one.layout();
            this.two.reshape(this.pos + 3, 0, dimension.width - this.pos - 5, dimension.height);
            this.two.layout();
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension = this.one.minimumSize();
        Dimension dimension2 = this.two.minimumSize();
        if (this.vertical) {
            return new Dimension(dimension.width > dimension2.width ? dimension.width : dimension2.width, dimension.height + dimension2.height);
        }
        return new Dimension(dimension.width + dimension2.width, dimension.height > dimension2.height ? dimension.height : dimension2.height);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.minimumLayoutSize(container);
    }

    public void removeLayoutComponent(Component component) {
    }
}

