/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Future;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadGpsTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadNotesTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadNotesUrlBoundsTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadNotesUrlIdTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmChangeCompressedTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmChangeTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmCompressedTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmIdTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmUrlTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadSessionTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class OpenLocationAction
extends JosmAction {
    protected final transient List<Class<? extends DownloadTask>> downloadTasks;

    public OpenLocationAction() {
        super(I18n.tr("Open Location...", new Object[0]), "openlocation", I18n.tr("Open an URL.", new Object[0]), Shortcut.registerShortcut("system:open_location", I18n.tr("File: {0}", I18n.tr("Open Location...", new Object[0])), 76, 5006), true);
        this.putValue("help", HelpUtil.ht("/Action/OpenLocation"));
        this.downloadTasks = new ArrayList<Class<? extends DownloadTask>>();
        this.addDownloadTaskClass(DownloadOsmTask.class);
        this.addDownloadTaskClass(DownloadGpsTask.class);
        this.addDownloadTaskClass(DownloadNotesTask.class);
        this.addDownloadTaskClass(DownloadOsmChangeTask.class);
        this.addDownloadTaskClass(DownloadOsmUrlTask.class);
        this.addDownloadTaskClass(DownloadOsmIdTask.class);
        this.addDownloadTaskClass(DownloadOsmCompressedTask.class);
        this.addDownloadTaskClass(DownloadOsmChangeCompressedTask.class);
        this.addDownloadTaskClass(DownloadSessionTask.class);
        this.addDownloadTaskClass(DownloadNotesUrlBoundsTask.class);
        this.addDownloadTaskClass(DownloadNotesUrlIdTask.class);
    }

    protected void restoreUploadAddressHistory(HistoryComboBox historyComboBox) {
        LinkedList<String> linkedList = new LinkedList<String>(Main.pref.getCollection(this.getClass().getName() + ".uploadAddressHistory", new LinkedList<String>()));
        Collections.reverse(linkedList);
        historyComboBox.setPossibleItems(linkedList);
    }

    protected void remindUploadAddressHistory(HistoryComboBox historyComboBox) {
        historyComboBox.addCurrentItemToHistory();
        Main.pref.putCollection(this.getClass().getName() + ".uploadAddressHistory", historyComboBox.getHistory());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JCheckBox jCheckBox = new JCheckBox(I18n.tr("Separate Layer", new Object[0]));
        jCheckBox.setToolTipText(I18n.tr("Select if the data should be downloaded into a new layer", new Object[0]));
        jCheckBox.setSelected(Main.pref.getBoolean("download.newlayer"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 23;
        jPanel.add((Component)new JLabel(I18n.tr("Enter URL to download:", new Object[0])), gridBagConstraints);
        HistoryComboBox historyComboBox = new HistoryComboBox();
        historyComboBox.setToolTipText(I18n.tr("Enter an URL from where data should be downloaded", new Object[0]));
        this.restoreUploadAddressHistory(historyComboBox);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)historyComboBox, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Download Location", new Object[0]), new String[]{I18n.tr("Download URL", new Object[0]), I18n.tr("Cancel", new Object[0])});
        extendedDialog.setContent(jPanel, false);
        extendedDialog.setButtonIcons(new String[]{"download", "cancel"});
        extendedDialog.setToolTipTexts(new String[]{I18n.tr("Start downloading data", new Object[0]), I18n.tr("Close dialog and cancel downloading", new Object[0])});
        extendedDialog.configureContextsensitiveHelp("/Action/OpenLocation", true);
        extendedDialog.showDialog();
        if (extendedDialog.getValue() != 1) {
            return;
        }
        this.remindUploadAddressHistory(historyComboBox);
        this.openUrl(jCheckBox.isSelected(), Utils.strip(historyComboBox.getText()));
    }

    public Collection<DownloadTask> findDownloadTasks(String string, boolean bl) {
        ArrayList<DownloadTask> arrayList = new ArrayList<DownloadTask>();
        for (Class<? extends DownloadTask> clazz : this.downloadTasks) {
            if (clazz == null) continue;
            try {
                DownloadTask downloadTask = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                if (!downloadTask.acceptsUrl(string, bl)) continue;
                arrayList.add(downloadTask);
            }
            catch (Exception exception) {
                Main.error(exception);
            }
        }
        return arrayList;
    }

    public String findSummaryDocumentation() {
        StringBuilder stringBuilder = new StringBuilder("<table>");
        for (Class<? extends DownloadTask> clazz : this.downloadTasks) {
            if (clazz == null) continue;
            try {
                DownloadTask downloadTask = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                stringBuilder.append(downloadTask.acceptsDocumentationSummary());
            }
            catch (Exception exception) {
                Main.error(exception);
            }
        }
        stringBuilder.append("</table>");
        return stringBuilder.toString();
    }

    public void openUrl(boolean bl, String string) {
        Collection<DownloadTask> collection = this.findDownloadTasks(string, false);
        if (collection.size() > 1) {
            collection = this.askWhichTasksToLoad(collection);
        } else if (collection.isEmpty()) {
            this.warnNoSuitableTasks(string);
            return;
        }
        PleaseWaitProgressMonitor pleaseWaitProgressMonitor = new PleaseWaitProgressMonitor(I18n.tr("Download Data", new Object[0]));
        for (DownloadTask downloadTask : collection) {
            try {
                Future<?> future = downloadTask.loadUrl(bl, string, pleaseWaitProgressMonitor);
                Main.worker.submit(new PostDownloadHandler(downloadTask, future));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Main.error(illegalArgumentException);
            }
        }
    }

    Collection<DownloadTask> askWhichTasksToLoad(Collection<DownloadTask> collection) {
        final JList<DownloadTask> jList = new JList<DownloadTask>(collection.toArray(new DownloadTask[collection.size()]));
        jList.addSelectionInterval(0, collection.size() - 1);
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Which tasks to perform?", new Object[0]), new String[]{I18n.tr("Ok", new Object[0]), I18n.tr("Cancel", new Object[0])}, true){
            {
                super(component, string, stringArray, bl);
                this.setButtonIcons(new String[]{"ok", "cancel"});
                JPanel jPanel = new JPanel(new GridLayout(2, 1));
                jPanel.add(new JLabel(I18n.tr("Which tasks to perform?", new Object[0])));
                jPanel.add(jList);
                this.setContent(jPanel);
            }
        };
        extendedDialog.showDialog();
        return extendedDialog.getValue() == 1 ? jList.getSelectedValuesList() : Collections.emptyList();
    }

    void warnNoSuitableTasks(String string) {
        String string2 = this.findSummaryDocumentation();
        HelpAwareOptionPane.showMessageDialogInEDT(Main.parent, "<html><p>" + I18n.tr("Cannot open URL ''{0}''<br>The following download tasks accept the URL patterns shown:<br>{1}", string, string2) + "</p></html>", I18n.tr("Download Location", new Object[0]), 0, HelpUtil.ht("/Action/OpenLocation"));
    }

    public final boolean addDownloadTaskClass(Class<? extends DownloadTask> clazz) {
        return this.downloadTasks.add(clazz);
    }
}

