/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.server;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.server.BasicAuthenticationPreferencesPanel;
import org.openstreetmap.josm.gui.preferences.server.FeaturesPanel;
import org.openstreetmap.josm.gui.preferences.server.OAuthAccessTokenHolder;
import org.openstreetmap.josm.gui.preferences.server.OAuthAuthenticationPreferencesPanel;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.tools.I18n;

public class AuthenticationPreferencesPanel
extends VerticallyScrollablePanel
implements PropertyChangeListener {
    private JRadioButton rbBasicAuthentication;
    private JRadioButton rbOAuth;
    private JPanel pnlAuthenticationParameteters;
    private BasicAuthenticationPreferencesPanel pnlBasicAuthPreferences;
    private OAuthAuthenticationPreferencesPanel pnlOAuthPreferences;
    private FeaturesPanel pnlFeaturesPreferences;

    protected final void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        AuthenticationMethodChangeListener authenticationMethodChangeListener = new AuthenticationMethodChangeListener();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.rbBasicAuthentication = new JRadioButton();
        this.add((Component)this.rbBasicAuthentication, gridBagConstraints);
        this.rbBasicAuthentication.setText(I18n.tr("Use Basic Authentication", new Object[0]));
        this.rbBasicAuthentication.setToolTipText(I18n.tr("Select to use HTTP basic authentication with your OSM username and password", new Object[0]));
        this.rbBasicAuthentication.addItemListener(authenticationMethodChangeListener);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        this.rbOAuth = new JRadioButton();
        this.add((Component)this.rbOAuth, gridBagConstraints);
        this.rbOAuth.setText(I18n.tr("Use OAuth", new Object[0]));
        this.rbOAuth.setToolTipText(I18n.tr("Select to use OAuth as authentication mechanism", new Object[0]));
        this.rbOAuth.addItemListener(authenticationMethodChangeListener);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbBasicAuthentication);
        buttonGroup.add(this.rbOAuth);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlAuthenticationParameteters = new JPanel(new BorderLayout());
        this.add((Component)this.pnlAuthenticationParameteters, gridBagConstraints);
        this.pnlBasicAuthPreferences = new BasicAuthenticationPreferencesPanel();
        this.pnlOAuthPreferences = new OAuthAuthenticationPreferencesPanel();
        this.rbBasicAuthentication.setSelected(true);
        this.pnlAuthenticationParameteters.add((Component)this.pnlBasicAuthPreferences, "Center");
        gridBagConstraints.gridy = 2;
        this.add((Component)new JSeparator(), gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 0;
        this.pnlFeaturesPreferences = new FeaturesPanel();
        this.add((Component)this.pnlFeaturesPreferences, gridBagConstraints);
    }

    public AuthenticationPreferencesPanel() {
        this.build();
        this.initFromPreferences();
        HelpUtil.setHelpContext(this, HelpUtil.ht("/Preferences/Connection#AuthenticationSettings"));
    }

    public final void initFromPreferences() {
        String string = OsmApi.getAuthMethod();
        if ("basic".equals(string)) {
            this.rbBasicAuthentication.setSelected(true);
        } else if ("oauth".equals(string)) {
            this.rbOAuth.setSelected(true);
        } else {
            Main.warn(I18n.tr("Unsupported value in preference ''{0}'', got ''{1}''. Using authentication method ''Basic Authentication''.", "osm-server.auth-method", string));
            this.rbBasicAuthentication.setSelected(true);
        }
        this.pnlBasicAuthPreferences.initFromPreferences();
        this.pnlOAuthPreferences.initFromPreferences();
        this.pnlFeaturesPreferences.initFromPreferences();
    }

    public final void saveToPreferences() {
        String string = this.rbBasicAuthentication.isSelected() ? "basic" : "oauth";
        Main.pref.put("osm-server.auth-method", string);
        if ("basic".equals(string)) {
            this.pnlBasicAuthPreferences.saveToPreferences();
            OAuthAccessTokenHolder.getInstance().clear();
            OAuthAccessTokenHolder.getInstance().save(Main.pref, CredentialsManager.getInstance());
        } else if ("oauth".equals(string)) {
            this.pnlBasicAuthPreferences.clearPassword();
            this.pnlBasicAuthPreferences.saveToPreferences();
            this.pnlOAuthPreferences.saveToPreferences();
        }
        this.pnlFeaturesPreferences.saveToPreferences();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.pnlOAuthPreferences != null) {
            this.pnlOAuthPreferences.propertyChange(propertyChangeEvent);
        }
    }

    class AuthenticationMethodChangeListener
    implements ItemListener {
        AuthenticationMethodChangeListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (AuthenticationPreferencesPanel.this.rbBasicAuthentication.isSelected()) {
                AuthenticationPreferencesPanel.this.pnlAuthenticationParameteters.removeAll();
                AuthenticationPreferencesPanel.this.pnlAuthenticationParameteters.add((Component)AuthenticationPreferencesPanel.this.pnlBasicAuthPreferences, "Center");
                AuthenticationPreferencesPanel.this.pnlBasicAuthPreferences.revalidate();
            } else {
                AuthenticationPreferencesPanel.this.pnlAuthenticationParameteters.removeAll();
                AuthenticationPreferencesPanel.this.pnlAuthenticationParameteters.add((Component)AuthenticationPreferencesPanel.this.pnlOAuthPreferences, "Center");
                AuthenticationPreferencesPanel.this.pnlOAuthPreferences.revalidate();
            }
            AuthenticationPreferencesPanel.this.repaint();
        }
    }
}

