/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.array;

import org.jruby.truffle.runtime.array.ArrayMirror;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.array.BasicArrayMirror;

class ObjectArrayMirror
extends BasicArrayMirror {
    private final Object[] array;

    public ObjectArrayMirror(Object[] array) {
        this.array = array;
    }

    @Override
    public int getLength() {
        return this.array.length;
    }

    @Override
    public Object get(int index) {
        return this.array[index];
    }

    @Override
    public void set(int index, Object value) {
        this.array[index] = value;
    }

    @Override
    public ArrayMirror copyArrayAndMirror(int newLength) {
        return new ObjectArrayMirror(ArrayUtils.grow(this.array, newLength));
    }

    @Override
    public void copyTo(ArrayMirror destination, int sourceStart, int destinationStart, int count) {
        System.arraycopy(this.array, sourceStart, destination.getArray(), destinationStart, count);
    }

    @Override
    public void copyTo(Object[] destination, int sourceStart, int destinationStart, int count) {
        System.arraycopy(this.array, sourceStart, destination, destinationStart, count);
    }

    @Override
    public Object getArray() {
        return this.array;
    }
}

