/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.profiles;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.profiles.Profile;
import com.oracle.truffle.api.profiles.ValueProfile;
import java.util.Objects;

public abstract class PrimitiveValueProfile
extends ValueProfile {
    PrimitiveValueProfile() {
    }

    @Override
    public abstract <T> T profile(T var1);

    public abstract byte profile(byte var1);

    public abstract short profile(short var1);

    public abstract int profile(int var1);

    public abstract long profile(long var1);

    public abstract float profile(float var1);

    public abstract double profile(double var1);

    public abstract boolean profile(boolean var1);

    public abstract char profile(char var1);

    public static PrimitiveValueProfile createEqualityProfile() {
        if (Profile.isProfilingEnabled()) {
            return Enabled.create();
        }
        return Disabled.INSTANCE;
    }

    @Deprecated
    public static boolean exactCompare(float a, float b) {
        return Float.floatToRawIntBits(a) == Float.floatToRawIntBits(b);
    }

    @Deprecated
    public static boolean exactCompare(double a, double b) {
        return Double.doubleToRawLongBits(a) == Double.doubleToRawLongBits(b);
    }

    static final class Disabled
    extends PrimitiveValueProfile {
        static final PrimitiveValueProfile INSTANCE = new Disabled();

        Disabled() {
        }

        @Override
        public <T> T profile(T value) {
            return value;
        }

        @Override
        public byte profile(byte value) {
            return value;
        }

        @Override
        public short profile(short value) {
            return value;
        }

        @Override
        public int profile(int value) {
            return value;
        }

        @Override
        public long profile(long value) {
            return value;
        }

        @Override
        public float profile(float value) {
            return value;
        }

        @Override
        public double profile(double value) {
            return value;
        }

        @Override
        public boolean profile(boolean value) {
            return value;
        }

        @Override
        public char profile(char value) {
            return value;
        }

        public String toString() {
            return this.toStringDisabled(PrimitiveValueProfile.class);
        }
    }

    static final class Enabled
    extends PrimitiveValueProfile {
        private static final byte STATE_UNINITIALIZED = 0;
        private static final byte STATE_BYTE = 1;
        private static final byte STATE_SHORT = 2;
        private static final byte STATE_INTEGER = 3;
        private static final byte STATE_LONG = 4;
        private static final byte STATE_BOOLEAN = 5;
        private static final byte STATE_CHARACTER = 6;
        private static final byte STATE_FLOAT = 7;
        private static final byte STATE_DOUBLE = 8;
        private static final byte STATE_IDENTITY = 9;
        private static final byte STATE_GENERIC = 10;
        @CompilerDirectives.CompilationFinal
        private byte state = 0;
        @CompilerDirectives.CompilationFinal
        private Object cachedValue;

        Enabled() {
        }

        @Override
        public <T> T profile(T value) {
            byte s = this.state;
            switch (s) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    Object snapshot = this.cachedValue;
                    if (!snapshot.equals(value)) break;
                    return (T)snapshot;
                }
                case 8: {
                    Object snapshot = this.cachedValue;
                    if (!(value instanceof Double) || !Enabled.exactCompare((Double)snapshot, (Double)value)) break;
                    return (T)snapshot;
                }
                case 7: {
                    Object snapshot = this.cachedValue;
                    if (!(value instanceof Float) || !Enabled.exactCompare(((Float)snapshot).floatValue(), ((Float)value).floatValue())) break;
                    return (T)snapshot;
                }
                case 9: {
                    Object snapshot = this.cachedValue;
                    if (snapshot != value) break;
                    return (T)snapshot;
                }
                case 10: {
                    return value;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.slowpath(s, value);
            return value;
        }

        @Override
        public byte profile(byte value) {
            byte s = this.state;
            if (s != 10) {
                byte castCachedValue;
                if (s == 1 && (castCachedValue = ((Byte)this.cachedValue).byteValue()) == value) {
                    return castCachedValue;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.slowpath(s, value);
            }
            return value;
        }

        @Override
        public short profile(short value) {
            byte s = this.state;
            if (s != 10) {
                short castCachedValue;
                if (s == 2 && (castCachedValue = ((Short)this.cachedValue).shortValue()) == value) {
                    return castCachedValue;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.slowpath(s, value);
            }
            return value;
        }

        @Override
        public int profile(int value) {
            byte s = this.state;
            if (s != 10) {
                int castCachedValue;
                if (s == 3 && (castCachedValue = ((Integer)this.cachedValue).intValue()) == value) {
                    return castCachedValue;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.slowpath(s, value);
            }
            return value;
        }

        @Override
        public long profile(long value) {
            byte s = this.state;
            if (s != 10) {
                long castCachedValue;
                if (s == 4 && (castCachedValue = ((Long)this.cachedValue).longValue()) == value) {
                    return castCachedValue;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.slowpath(s, value);
            }
            return value;
        }

        @Override
        public float profile(float value) {
            byte s = this.state;
            if (s != 10) {
                float castCachedValue;
                if (s == 7 && Enabled.exactCompare(castCachedValue = ((Float)this.cachedValue).floatValue(), value)) {
                    return castCachedValue;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.slowpath(s, Float.valueOf(value));
            }
            return value;
        }

        @Override
        public double profile(double value) {
            byte s = this.state;
            if (s != 10) {
                double castCachedValue;
                if (s == 8 && Enabled.exactCompare(castCachedValue = ((Double)this.cachedValue).doubleValue(), value)) {
                    return castCachedValue;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.slowpath(s, value);
            }
            return value;
        }

        @Override
        public boolean profile(boolean value) {
            byte s = this.state;
            if (s != 10) {
                boolean castCachedValue;
                if (s == 5 && (castCachedValue = ((Boolean)this.cachedValue).booleanValue()) == value) {
                    return castCachedValue;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.slowpath(s, value);
            }
            return value;
        }

        @Override
        public char profile(char value) {
            byte s = this.state;
            if (s != 10) {
                char castCachedValue;
                if (s == 6 && (castCachedValue = ((Character)this.cachedValue).charValue()) == value) {
                    return castCachedValue;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.slowpath(s, Character.valueOf(value));
            }
            return value;
        }

        private void slowpath(byte s, Object value) {
            if (s == 0) {
                this.cachedValue = value;
                this.state = Enabled.specialize(value);
            } else {
                this.state = (byte)10;
                this.cachedValue = null;
            }
        }

        private static byte specialize(Object value) {
            if (value instanceof Byte) {
                return 1;
            }
            if (value instanceof Short) {
                return 2;
            }
            if (value instanceof Integer) {
                return 3;
            }
            if (value instanceof Long) {
                return 4;
            }
            if (value instanceof Boolean) {
                return 5;
            }
            if (value instanceof Character) {
                return 6;
            }
            if (value instanceof Double) {
                return 8;
            }
            if (value instanceof Float) {
                return 7;
            }
            return 9;
        }

        boolean isGeneric() {
            return this.state == 10;
        }

        boolean isUninitialized() {
            return this.state == 0;
        }

        Object getCachedValue() {
            return this.cachedValue;
        }

        public String toString() {
            return this.toString(PrimitiveValueProfile.class, this.state == 0, this.state == 10, this.formatSpecialization());
        }

        private String formatSpecialization() {
            Object snapshot = this.cachedValue;
            if (this.state != 0 && this.state != 10) {
                if (snapshot == null) {
                    return String.format("value == null", new Object[0]);
                }
                if (this.state == 9) {
                    String simpleName = snapshot.getClass().getSimpleName();
                    return String.format("value == %s@%x", simpleName, Objects.hash(snapshot));
                }
                return String.format("value == (%s)%s", snapshot.getClass().getSimpleName(), snapshot);
            }
            return null;
        }

        static PrimitiveValueProfile create() {
            return new Enabled();
        }
    }
}

