/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.UnaryCoreMethodNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.backtrace.Activation;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.layouts.ThreadBacktraceLocationLayoutImpl;

@CoreClass(name="Thread::Backtrace::Location")
public class ThreadBacktraceLocationNodes {

    @CoreMethod(names={"to_s", "inspect"})
    public static abstract class ToSNode
    extends UnaryCoreMethodNode {
        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject toS(DynamicObject threadBacktraceLocation) {
            Activation activation = ThreadBacktraceLocationLayoutImpl.INSTANCE.getActivation(threadBacktraceLocation);
            SourceSection sourceSection = activation.getCallNode().getEncapsulatingSourceSection();
            if (sourceSection.getSource() == null) {
                return this.createString(StringOperations.encodeByteList(sourceSection.getShortDescription(), (Encoding)UTF8Encoding.INSTANCE));
            }
            return this.createString(StringOperations.encodeByteList(String.format("%s:%d:in `%s'", sourceSection.getSource().getName(), sourceSection.getStartLine(), sourceSection.getIdentifier()), (Encoding)UTF8Encoding.INSTANCE));
        }
    }

    @CoreMethod(names={"lineno"})
    public static abstract class LinenoNode
    extends UnaryCoreMethodNode {
        public LinenoNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int lineno(DynamicObject threadBacktraceLocation) {
            Activation activation = ThreadBacktraceLocationLayoutImpl.INSTANCE.getActivation(threadBacktraceLocation);
            SourceSection sourceSection = activation.getCallNode().getEncapsulatingSourceSection();
            return sourceSection.getStartLine();
        }
    }

    @CoreMethod(names={"absolute_path", "path"})
    public static abstract class AbsolutePathNode
    extends UnaryCoreMethodNode {
        public AbsolutePathNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject absolutePath(DynamicObject threadBacktraceLocation) {
            Activation activation = ThreadBacktraceLocationLayoutImpl.INSTANCE.getActivation(threadBacktraceLocation);
            SourceSection sourceSection = activation.getCallNode().getEncapsulatingSourceSection();
            if (sourceSection.getSource() == null) {
                return this.createString(StringOperations.encodeByteList(sourceSection.getShortDescription(), (Encoding)UTF8Encoding.INSTANCE));
            }
            String path = sourceSection.getSource().getPath();
            if (path == null) {
                path = "(unknown)";
            }
            return this.createString(StringOperations.encodeByteList(path, (Encoding)UTF8Encoding.INSTANCE));
        }
    }
}

