/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypes;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.TrufflePrimitiveNodes;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;

@GeneratedBy(value=TrufflePrimitiveNodes.class)
public final class TrufflePrimitiveNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(BindingOfCallerNodeFactory.getInstance(), SourceOfCallerNodeFactory.getInstance(), GCCountNodeFactory.getInstance(), GCTimeNodeFactory.getInstance(), AssertConstantNodeFactory.getInstance(), AssertNotCompiledNodeFactory.getInstance(), JavaClassOfNodeFactory.getInstance(), DumpStringNodeFactory.getInstance(), GraalNodeFactory.getInstance(), SubstrateNodeFactory.getInstance(), GraalVersionNodeFactory.getInstance(), SimpleShellNodeFactory.getInstance(), CoverageResultNodeFactory.getInstance(), CoverageStartNodeFactory.getInstance(), AttachNodeFactory.getInstance(), DetachNodeFactory.getInstance(), CExtLoadNodeFactory.getInstance(), CExtSupportedNodeFactory.getInstance(), DebugPrintNodeFactory.getInstance(), JRubyHomeDirectoryNodeFactory.getInstance(), HostOSNodeFactory.getInstance(), AtExitSystemNodeFactory.getInstance(), InstallRubiniusPrimitiveNodeFactory.getInstance(), FixnumLowerPrimitiveNodeFactory.getInstance(), SynchronizedPrimitiveNodeFactory.getInstance(), FullMemoryBarrierPrimitiveNodeFactory.getInstance(), PrintBacktraceNodeFactory.getInstance(), PrintInterleavedBacktraceNodeFactory.getInstance(), ASTNodeFactory.getInstance(), ObjectTypeOfNodeFactory.getInstance(), SpawnProcessNodeFactory.getInstance(), ContextNodeFactory.getInstance(), LoadNodeFactory.getInstance(), RunJRubyRootNodeFactory.getInstance(), CreateSimpleStringNodeFactory.getInstance(), LogicalProcessorsNodeFactory.getInstance());
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.LogicalProcessorsNode.class)
    public static final class LogicalProcessorsNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.LogicalProcessorsNode> {
        private static LogicalProcessorsNodeFactory logicalProcessorsNodeFactoryInstance;

        private LogicalProcessorsNodeFactory() {
            super(TrufflePrimitiveNodes.LogicalProcessorsNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[][]{{RubyContext.class, SourceSection.class}});
        }

        @Override
        public TrufflePrimitiveNodes.LogicalProcessorsNode createNode(Object ... arguments) {
            if (arguments.length == 2 && (arguments[0] == null || arguments[0] instanceof RubyContext) && (arguments[1] == null || arguments[1] instanceof SourceSection)) {
                return LogicalProcessorsNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrufflePrimitiveNodes.LogicalProcessorsNode> getInstance() {
            if (logicalProcessorsNodeFactoryInstance == null) {
                logicalProcessorsNodeFactoryInstance = new LogicalProcessorsNodeFactory();
            }
            return logicalProcessorsNodeFactoryInstance;
        }

        public static TrufflePrimitiveNodes.LogicalProcessorsNode create(RubyContext context, SourceSection sourceSection) {
            return new LogicalProcessorsNodeGen(context, sourceSection);
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.LogicalProcessorsNode.class)
        public static final class LogicalProcessorsNodeGen
        extends TrufflePrimitiveNodes.LogicalProcessorsNode {
            private LogicalProcessorsNodeGen(RubyContext context, SourceSection sourceSection) {
                super(context, sourceSection);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInteger(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeInteger(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                return this.logicalProcessors();
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.CreateSimpleStringNode.class)
    public static final class CreateSimpleStringNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.CreateSimpleStringNode> {
        private static CreateSimpleStringNodeFactory createSimpleStringNodeFactoryInstance;

        private CreateSimpleStringNodeFactory() {
            super(TrufflePrimitiveNodes.CreateSimpleStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public TrufflePrimitiveNodes.CreateSimpleStringNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CreateSimpleStringNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrufflePrimitiveNodes.CreateSimpleStringNode> getInstance() {
            if (createSimpleStringNodeFactoryInstance == null) {
                createSimpleStringNodeFactoryInstance = new CreateSimpleStringNodeFactory();
            }
            return createSimpleStringNodeFactoryInstance;
        }

        public static TrufflePrimitiveNodes.CreateSimpleStringNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new CreateSimpleStringNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.CreateSimpleStringNode.class)
        public static final class CreateSimpleStringNodeGen
        extends TrufflePrimitiveNodes.CreateSimpleStringNode {
            private CreateSimpleStringNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.createSimpleString();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.RunJRubyRootNode.class)
    public static final class RunJRubyRootNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.RunJRubyRootNode> {
        private static RunJRubyRootNodeFactory runJRubyRootNodeFactoryInstance;

        private RunJRubyRootNodeFactory() {
            super(TrufflePrimitiveNodes.RunJRubyRootNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public TrufflePrimitiveNodes.RunJRubyRootNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RunJRubyRootNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrufflePrimitiveNodes.RunJRubyRootNode> getInstance() {
            if (runJRubyRootNodeFactoryInstance == null) {
                runJRubyRootNodeFactoryInstance = new RunJRubyRootNodeFactory();
            }
            return runJRubyRootNodeFactoryInstance;
        }

        public static TrufflePrimitiveNodes.RunJRubyRootNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new RunJRubyRootNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.RunJRubyRootNode.class)
        public static final class RunJRubyRootNodeGen
        extends TrufflePrimitiveNodes.RunJRubyRootNode {
            private RunJRubyRootNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.runJRubyRootNode();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.LoadNode.class)
    public static final class LoadNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.LoadNode> {
        private static LoadNodeFactory loadNodeFactoryInstance;

        private LoadNodeFactory() {
            super(TrufflePrimitiveNodes.LoadNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public TrufflePrimitiveNodes.LoadNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LoadNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrufflePrimitiveNodes.LoadNode> getInstance() {
            if (loadNodeFactoryInstance == null) {
                loadNodeFactoryInstance = new LoadNodeFactory();
            }
            return loadNodeFactoryInstance;
        }

        public static TrufflePrimitiveNodes.LoadNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new LoadNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.LoadNode.class)
        public static final class LoadNodeGen
        extends TrufflePrimitiveNodes.LoadNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private LoadNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.specialization_.executeBoolean(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="load(DynamicObject, NotProvided)", value=TrufflePrimitiveNodes.LoadNode.class)
            private static final class Load1Node_
            extends BaseNode_ {
                Load1Node_(LoadNodeGen root) {
                    super(root, 2);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    NotProvided arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().executeBoolean_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyString(arguments0Value_)) {
                        return this.root.load(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        if (RubyGuards.isRubyString(arguments0Value_)) {
                            return this.root.load(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LoadNodeGen root) {
                    return new Load1Node_(root);
                }
            }

            @GeneratedBy(methodName="load(DynamicObject, boolean)", value=TrufflePrimitiveNodes.LoadNode.class)
            private static final class Load0Node_
            extends BaseNode_ {
                Load0Node_(LoadNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeBoolean(frameValue);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    boolean arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().executeBoolean_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyString(arguments0Value_)) {
                        return this.root.load(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Boolean) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        boolean arguments1Value_ = (Boolean)arguments1Value;
                        if (RubyGuards.isRubyString(arguments0Value_)) {
                            return this.root.load(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LoadNodeGen root) {
                    return new Load0Node_(root);
                }
            }

            @GeneratedBy(value=TrufflePrimitiveNodes.LoadNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(LoadNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LoadNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=TrufflePrimitiveNodes.LoadNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(LoadNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (Boolean)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LoadNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=TrufflePrimitiveNodes.LoadNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected LoadNodeGen root;

                BaseNode_(LoadNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (LoadNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeBoolean_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract boolean executeBoolean_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) {
                    return (Boolean)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (arguments1Value instanceof Boolean && RubyGuards.isRubyString(arguments0Value_)) {
                            return Load0Node_.create(this.root);
                        }
                        if (arguments1Value instanceof NotProvided && RubyGuards.isRubyString(arguments0Value_)) {
                            return Load1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Boolean.TYPE) {
                        return this.root.arguments1_.executeBoolean((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Boolean ? Boolean.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.ContextNode.class)
    public static final class ContextNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.ContextNode> {
        private static ContextNodeFactory contextNodeFactoryInstance;

        private ContextNodeFactory() {
            super(TrufflePrimitiveNodes.ContextNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public TrufflePrimitiveNodes.ContextNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ContextNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrufflePrimitiveNodes.ContextNode> getInstance() {
            if (contextNodeFactoryInstance == null) {
                contextNodeFactoryInstance = new ContextNodeFactory();
            }
            return contextNodeFactoryInstance;
        }

        public static TrufflePrimitiveNodes.ContextNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ContextNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.ContextNode.class)
        public static final class ContextNodeGen
        extends TrufflePrimitiveNodes.ContextNode {
            private ContextNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeRubyContext_(frameValue);
            }

            public RubyContext executeRubyContext_(VirtualFrame frameValue) {
                return this.context();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeRubyContext_(frameValue);
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.SpawnProcessNode.class)
    public static final class SpawnProcessNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.SpawnProcessNode> {
        private static SpawnProcessNodeFactory spawnProcessNodeFactoryInstance;

        private SpawnProcessNodeFactory() {
            super(TrufflePrimitiveNodes.SpawnProcessNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public TrufflePrimitiveNodes.SpawnProcessNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SpawnProcessNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrufflePrimitiveNodes.SpawnProcessNode> getInstance() {
            if (spawnProcessNodeFactoryInstance == null) {
                spawnProcessNodeFactoryInstance = new SpawnProcessNodeFactory();
            }
            return spawnProcessNodeFactoryInstance;
        }

        public static TrufflePrimitiveNodes.SpawnProcessNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SpawnProcessNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.SpawnProcessNode.class)
        public static final class SpawnProcessNodeGen
        extends TrufflePrimitiveNodes.SpawnProcessNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private SpawnProcessNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInteger(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeInteger(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                DynamicObject arguments2Value_;
                DynamicObject arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    Object arguments2Value = this.arguments2_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value, arguments2Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value = this.arguments2_.execute(frameValue);
                    throw this.unsupported(arguments0Value_, ex.getResult(), arguments2Value);
                }
                try {
                    arguments2Value_ = this.arguments2_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, arguments1Value_, ex.getResult());
                }
                if (RubyGuards.isRubyString(arguments0Value_) && RubyGuards.isRubyArray(arguments1Value_) && RubyGuards.isRubyArray(arguments2Value_)) {
                    return this.spawn(arguments0Value_, arguments1Value_, arguments2Value_);
                }
                throw this.unsupported(arguments0Value_, arguments1Value_, arguments2Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_}, arguments0Value, arguments1Value, arguments2Value);
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.ObjectTypeOfNode.class)
    public static final class ObjectTypeOfNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.ObjectTypeOfNode> {
        private static ObjectTypeOfNodeFactory objectTypeOfNodeFactoryInstance;

        private ObjectTypeOfNodeFactory() {
            super(TrufflePrimitiveNodes.ObjectTypeOfNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public TrufflePrimitiveNodes.ObjectTypeOfNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ObjectTypeOfNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrufflePrimitiveNodes.ObjectTypeOfNode> getInstance() {
            if (objectTypeOfNodeFactoryInstance == null) {
                objectTypeOfNodeFactoryInstance = new ObjectTypeOfNodeFactory();
            }
            return objectTypeOfNodeFactoryInstance;
        }

        public static TrufflePrimitiveNodes.ObjectTypeOfNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ObjectTypeOfNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.ObjectTypeOfNode.class)
        public static final class ObjectTypeOfNodeGen
        extends TrufflePrimitiveNodes.ObjectTypeOfNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ObjectTypeOfNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.objectTypeOf(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.ASTNode.class)
    public static final class ASTNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.ASTNode> {
        private static ASTNodeFactory aSTNodeFactoryInstance;

        private ASTNodeFactory() {
            super(TrufflePrimitiveNodes.ASTNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public TrufflePrimitiveNodes.ASTNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ASTNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrufflePrimitiveNodes.ASTNode> getInstance() {
            if (aSTNodeFactoryInstance == null) {
                aSTNodeFactoryInstance = new ASTNodeFactory();
            }
            return aSTNodeFactoryInstance;
        }

        public static TrufflePrimitiveNodes.ASTNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ASTNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.ASTNode.class)
        public static final class ASTNodeGen
        extends TrufflePrimitiveNodes.ASTNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private ASTNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="astProc(DynamicObject)", value=TrufflePrimitiveNodes.ASTNode.class)
            private static final class AstProcNode_
            extends BaseNode_ {
                AstProcNode_(ASTNodeGen root) {
                    super(root, 3);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyProc(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.astProc(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ASTNodeGen root) {
                    return new AstProcNode_(root);
                }
            }

            @GeneratedBy(methodName="astUnboundMethod(DynamicObject)", value=TrufflePrimitiveNodes.ASTNode.class)
            private static final class AstUnboundMethodNode_
            extends BaseNode_ {
                AstUnboundMethodNode_(ASTNodeGen root) {
                    super(root, 2);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyUnboundMethod(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.astUnboundMethod(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ASTNodeGen root) {
                    return new AstUnboundMethodNode_(root);
                }
            }

            @GeneratedBy(methodName="astMethod(DynamicObject)", value=TrufflePrimitiveNodes.ASTNode.class)
            private static final class AstMethodNode_
            extends BaseNode_ {
                AstMethodNode_(ASTNodeGen root) {
                    super(root, 1);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyMethod(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.astMethod(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ASTNodeGen root) {
                    return new AstMethodNode_(root);
                }
            }

            @GeneratedBy(value=TrufflePrimitiveNodes.ASTNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ASTNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ASTNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=TrufflePrimitiveNodes.ASTNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ASTNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ASTNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=TrufflePrimitiveNodes.ASTNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ASTNodeGen root;

                BaseNode_(ASTNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (ASTNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (RubyGuards.isRubyMethod(arguments0Value_)) {
                            return AstMethodNode_.create(this.root);
                        }
                        if (RubyGuards.isRubyUnboundMethod(arguments0Value_)) {
                            return AstUnboundMethodNode_.create(this.root);
                        }
                        if (RubyGuards.isRubyProc(arguments0Value_)) {
                            return AstProcNode_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.PrintInterleavedBacktraceNode.class)
    public static final class PrintInterleavedBacktraceNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.PrintInterleavedBacktraceNode> {
        private static PrintInterleavedBacktraceNodeFactory printInterleavedBacktraceNodeFactoryInstance;

        private PrintInterleavedBacktraceNodeFactory() {
            super(TrufflePrimitiveNodes.PrintInterleavedBacktraceNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[][]{{RubyContext.class, SourceSection.class}});
        }

        @Override
        public TrufflePrimitiveNodes.PrintInterleavedBacktraceNode createNode(Object ... arguments) {
            if (arguments.length == 2 && (arguments[0] == null || arguments[0] instanceof RubyContext) && (arguments[1] == null || arguments[1] instanceof SourceSection)) {
                return PrintInterleavedBacktraceNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrufflePrimitiveNodes.PrintInterleavedBacktraceNode> getInstance() {
            if (printInterleavedBacktraceNodeFactoryInstance == null) {
                printInterleavedBacktraceNodeFactoryInstance = new PrintInterleavedBacktraceNodeFactory();
            }
            return printInterleavedBacktraceNodeFactoryInstance;
        }

        public static TrufflePrimitiveNodes.PrintInterleavedBacktraceNode create(RubyContext context, SourceSection sourceSection) {
            return new PrintInterleavedBacktraceNodeGen(context, sourceSection);
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.PrintInterleavedBacktraceNode.class)
        public static final class PrintInterleavedBacktraceNodeGen
        extends TrufflePrimitiveNodes.PrintInterleavedBacktraceNode {
            private PrintInterleavedBacktraceNodeGen(RubyContext context, SourceSection sourceSection) {
                super(context, sourceSection);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.printInterleavedBacktrace();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.PrintBacktraceNode.class)
    public static final class PrintBacktraceNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.PrintBacktraceNode> {
        private static PrintBacktraceNodeFactory printBacktraceNodeFactoryInstance;

        private PrintBacktraceNodeFactory() {
            super(TrufflePrimitiveNodes.PrintBacktraceNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[][]{{RubyContext.class, SourceSection.class}});
        }

        @Override
        public TrufflePrimitiveNodes.PrintBacktraceNode createNode(Object ... arguments) {
            if (arguments.length == 2 && (arguments[0] == null || arguments[0] instanceof RubyContext) && (arguments[1] == null || arguments[1] instanceof SourceSection)) {
                return PrintBacktraceNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrufflePrimitiveNodes.PrintBacktraceNode> getInstance() {
            if (printBacktraceNodeFactoryInstance == null) {
                printBacktraceNodeFactoryInstance = new PrintBacktraceNodeFactory();
            }
            return printBacktraceNodeFactoryInstance;
        }

        public static TrufflePrimitiveNodes.PrintBacktraceNode create(RubyContext context, SourceSection sourceSection) {
            return new PrintBacktraceNodeGen(context, sourceSection);
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.PrintBacktraceNode.class)
        public static final class PrintBacktraceNodeGen
        extends TrufflePrimitiveNodes.PrintBacktraceNode {
            private PrintBacktraceNodeGen(RubyContext context, SourceSection sourceSection) {
                super(context, sourceSection);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.printBacktrace();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.FullMemoryBarrierPrimitiveNode.class)
    public static final class FullMemoryBarrierPrimitiveNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.FullMemoryBarrierPrimitiveNode> {
        private static FullMemoryBarrierPrimitiveNodeFactory fullMemoryBarrierPrimitiveNodeFactoryInstance;

        private FullMemoryBarrierPrimitiveNodeFactory() {
            super(TrufflePrimitiveNodes.FullMemoryBarrierPrimitiveNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[][]{{RubyContext.class, SourceSection.class}});
        }

        @Override
        public TrufflePrimitiveNodes.FullMemoryBarrierPrimitiveNode createNode(Object ... arguments) {
            if (arguments.length == 2 && (arguments[0] == null || arguments[0] instanceof RubyContext) && (arguments[1] == null || arguments[1] instanceof SourceSection)) {
                return FullMemoryBarrierPrimitiveNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrufflePrimitiveNodes.FullMemoryBarrierPrimitiveNode> getInstance() {
            if (fullMemoryBarrierPrimitiveNodeFactoryInstance == null) {
                fullMemoryBarrierPrimitiveNodeFactoryInstance = new FullMemoryBarrierPrimitiveNodeFactory();
            }
            return fullMemoryBarrierPrimitiveNodeFactoryInstance;
        }

        public static TrufflePrimitiveNodes.FullMemoryBarrierPrimitiveNode create(RubyContext context, SourceSection sourceSection) {
            return new FullMemoryBarrierPrimitiveNodeGen(context, sourceSection);
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.FullMemoryBarrierPrimitiveNode.class)
        public static final class FullMemoryBarrierPrimitiveNodeGen
        extends TrufflePrimitiveNodes.FullMemoryBarrierPrimitiveNode {
            private FullMemoryBarrierPrimitiveNodeGen(RubyContext context, SourceSection sourceSection) {
                super(context, sourceSection);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.fullMemoryBarrier();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.SynchronizedPrimitiveNode.class)
    public static final class SynchronizedPrimitiveNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.SynchronizedPrimitiveNode> {
        private static SynchronizedPrimitiveNodeFactory synchronizedPrimitiveNodeFactoryInstance;

        private SynchronizedPrimitiveNodeFactory() {
            super(TrufflePrimitiveNodes.SynchronizedPrimitiveNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public TrufflePrimitiveNodes.SynchronizedPrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SynchronizedPrimitiveNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrufflePrimitiveNodes.SynchronizedPrimitiveNode> getInstance() {
            if (synchronizedPrimitiveNodeFactoryInstance == null) {
                synchronizedPrimitiveNodeFactoryInstance = new SynchronizedPrimitiveNodeFactory();
            }
            return synchronizedPrimitiveNodeFactoryInstance;
        }

        public static TrufflePrimitiveNodes.SynchronizedPrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SynchronizedPrimitiveNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.SynchronizedPrimitiveNode.class)
        public static final class SynchronizedPrimitiveNodeGen
        extends TrufflePrimitiveNodes.SynchronizedPrimitiveNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private SynchronizedPrimitiveNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.synchronize(frameValue, arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.FixnumLowerPrimitiveNode.class)
    public static final class FixnumLowerPrimitiveNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.FixnumLowerPrimitiveNode> {
        private static FixnumLowerPrimitiveNodeFactory fixnumLowerPrimitiveNodeFactoryInstance;

        private FixnumLowerPrimitiveNodeFactory() {
            super(TrufflePrimitiveNodes.FixnumLowerPrimitiveNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
        }

        @Override
        public TrufflePrimitiveNodes.FixnumLowerPrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return FixnumLowerPrimitiveNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrufflePrimitiveNodes.FixnumLowerPrimitiveNode> getInstance() {
            if (fixnumLowerPrimitiveNodeFactoryInstance == null) {
                fixnumLowerPrimitiveNodeFactoryInstance = new FixnumLowerPrimitiveNodeFactory();
            }
            return fixnumLowerPrimitiveNodeFactoryInstance;
        }

        public static TrufflePrimitiveNodes.FixnumLowerPrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode operand) {
            return new FixnumLowerPrimitiveNodeGen(context, sourceSection, operand);
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.FixnumLowerPrimitiveNode.class)
        public static final class FixnumLowerPrimitiveNodeGen
        extends TrufflePrimitiveNodes.FixnumLowerPrimitiveNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode operand_;
            @CompilerDirectives.CompilationFinal
            private Class<?> operandType_;
            @Node.Child
            private BaseNode_ specialization_;

            private FixnumLowerPrimitiveNodeGen(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection);
                this.operand_ = operand;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeLong(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static long expectLong(Object value) throws UnexpectedResultException {
                if (value instanceof Long) {
                    return (Long)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="lowerFails(long)", value=TrufflePrimitiveNodes.FixnumLowerPrimitiveNode.class)
            private static final class LowerFailsNode_
            extends BaseNode_ {
                private final Class<?> operandImplicitType;

                LowerFailsNode_(FixnumLowerPrimitiveNodeGen root, Object operandValue) {
                    super(root, 3);
                    this.operandImplicitType = RubyTypesGen.getImplicitLongClass(operandValue);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.operandImplicitType == ((LowerFailsNode_)other).operandImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    long operandValue_;
                    try {
                        operandValue_ = this.executeOperandLong_(frameValue, this.operandImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return FixnumLowerPrimitiveNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    if (!TrufflePrimitiveNodes.FixnumLowerPrimitiveNode.canLower(operandValue_)) {
                        return this.root.lowerFails(operandValue_);
                    }
                    return FixnumLowerPrimitiveNodeGen.expectLong(this.getNext().execute_(frameValue, operandValue_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object operandValue) {
                    long operandValue_;
                    if (RubyTypesGen.isImplicitLong(operandValue, this.operandImplicitType) && !TrufflePrimitiveNodes.FixnumLowerPrimitiveNode.canLower(operandValue_ = RubyTypesGen.asImplicitLong(operandValue, this.operandImplicitType))) {
                        return this.root.lowerFails(operandValue_);
                    }
                    return this.getNext().execute_(frameValue, operandValue);
                }

                static BaseNode_ create(FixnumLowerPrimitiveNodeGen root, Object operandValue) {
                    return new LowerFailsNode_(root, operandValue);
                }
            }

            @GeneratedBy(methodName="lower(long)", value=TrufflePrimitiveNodes.FixnumLowerPrimitiveNode.class)
            private static final class Lower1Node_
            extends BaseNode_ {
                private final Class<?> operandImplicitType;

                Lower1Node_(FixnumLowerPrimitiveNodeGen root, Object operandValue) {
                    super(root, 2);
                    this.operandImplicitType = RubyTypesGen.getImplicitLongClass(operandValue);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.operandImplicitType == ((Lower1Node_)other).operandImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    long operandValue_;
                    try {
                        operandValue_ = this.executeOperandLong_(frameValue, this.operandImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return FixnumLowerPrimitiveNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    if (TrufflePrimitiveNodes.FixnumLowerPrimitiveNode.canLower(operandValue_)) {
                        return this.root.lower(operandValue_);
                    }
                    return FixnumLowerPrimitiveNodeGen.expectInteger(this.getNext().execute_(frameValue, operandValue_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object operandValue) {
                    long operandValue_;
                    if (RubyTypesGen.isImplicitLong(operandValue, this.operandImplicitType) && TrufflePrimitiveNodes.FixnumLowerPrimitiveNode.canLower(operandValue_ = RubyTypesGen.asImplicitLong(operandValue, this.operandImplicitType))) {
                        return this.root.lower(operandValue_);
                    }
                    return this.getNext().execute_(frameValue, operandValue);
                }

                static BaseNode_ create(FixnumLowerPrimitiveNodeGen root, Object operandValue) {
                    return new Lower1Node_(root, operandValue);
                }
            }

            @GeneratedBy(methodName="lower(int)", value=TrufflePrimitiveNodes.FixnumLowerPrimitiveNode.class)
            private static final class Lower0Node_
            extends BaseNode_ {
                private final Class<?> operandImplicitType;

                Lower0Node_(FixnumLowerPrimitiveNodeGen root, Object operandValue) {
                    super(root, 1);
                    this.operandImplicitType = RubyTypesGen.getImplicitIntegerClass(operandValue);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.operandImplicitType == ((Lower0Node_)other).operandImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    int operandValue_;
                    try {
                        if (this.operandImplicitType == Integer.TYPE) {
                            operandValue_ = this.root.operand_.executeInteger(frameValue);
                        } else {
                            Object operandValue__ = this.executeOperand_(frameValue);
                            operandValue_ = RubyTypesGen.expectImplicitInteger(operandValue__, this.operandImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return FixnumLowerPrimitiveNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    return this.root.lower(operandValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object operandValue) {
                    if (RubyTypesGen.isImplicitInteger(operandValue, this.operandImplicitType)) {
                        int operandValue_ = RubyTypesGen.asImplicitInteger(operandValue, this.operandImplicitType);
                        return this.root.lower(operandValue_);
                    }
                    return this.getNext().execute_(frameValue, operandValue);
                }

                static BaseNode_ create(FixnumLowerPrimitiveNodeGen root, Object operandValue) {
                    return new Lower0Node_(root, operandValue);
                }
            }

            @GeneratedBy(value=TrufflePrimitiveNodes.FixnumLowerPrimitiveNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(FixnumLowerPrimitiveNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object operandValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, operandValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object operandValue) {
                    return this.getNext().execute_(frameValue, operandValue);
                }

                static BaseNode_ create(FixnumLowerPrimitiveNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=TrufflePrimitiveNodes.FixnumLowerPrimitiveNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(FixnumLowerPrimitiveNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object operandValue) {
                    return this.uninitialized((Frame)frameValue, operandValue);
                }

                static BaseNode_ create(FixnumLowerPrimitiveNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=TrufflePrimitiveNodes.FixnumLowerPrimitiveNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected FixnumLowerPrimitiveNodeGen root;

                BaseNode_(FixnumLowerPrimitiveNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (FixnumLowerPrimitiveNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.operand_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object operandValue) {
                    return this.execute_((VirtualFrame)frameValue, operandValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object operandValue_ = this.executeOperand_(frameValue);
                    return this.execute_(frameValue, operandValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return FixnumLowerPrimitiveNodeGen.expectInteger(this.execute(frameValue));
                }

                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    return FixnumLowerPrimitiveNodeGen.expectLong(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object operandValue) {
                    if (RubyTypesGen.isImplicitInteger(operandValue)) {
                        return Lower0Node_.create(this.root, operandValue);
                    }
                    if (RubyTypesGen.isImplicitLong(operandValue)) {
                        long operandValue_ = RubyTypesGen.asImplicitLong(operandValue);
                        if (TrufflePrimitiveNodes.FixnumLowerPrimitiveNode.canLower(operandValue_)) {
                            return Lower1Node_.create(this.root, operandValue);
                        }
                        return LowerFailsNode_.create(this.root, operandValue);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeOperand_(Frame frameValue) {
                    Object object;
                    Class operandType_ = this.root.operandType_;
                    if (operandType_ == Integer.TYPE) {
                        return this.root.operand_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (operandType_ == Long.TYPE) {
                        return this.root.operand_.executeLong((VirtualFrame)frameValue);
                    }
                    if (operandType_ != null) return this.root.operand_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.operand_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.operandType_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.operandType_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.operandType_ = _type;
                    return object;
                }

                protected final long executeOperandLong_(Frame frameValue, Class<?> operandImplicitType) throws UnexpectedResultException {
                    if (operandImplicitType == Long.TYPE) {
                        return this.root.operand_.executeLong((VirtualFrame)frameValue);
                    }
                    if (operandImplicitType == Integer.TYPE) {
                        return RubyTypes.promoteToLong(this.root.operand_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object operandValue_ = this.executeOperand_(frameValue);
                    return RubyTypesGen.expectImplicitLong(operandValue_, operandImplicitType);
                }
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.InstallRubiniusPrimitiveNode.class)
    public static final class InstallRubiniusPrimitiveNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.InstallRubiniusPrimitiveNode> {
        private static InstallRubiniusPrimitiveNodeFactory installRubiniusPrimitiveNodeFactoryInstance;

        private InstallRubiniusPrimitiveNodeFactory() {
            super(TrufflePrimitiveNodes.InstallRubiniusPrimitiveNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public TrufflePrimitiveNodes.InstallRubiniusPrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InstallRubiniusPrimitiveNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrufflePrimitiveNodes.InstallRubiniusPrimitiveNode> getInstance() {
            if (installRubiniusPrimitiveNodeFactoryInstance == null) {
                installRubiniusPrimitiveNodeFactoryInstance = new InstallRubiniusPrimitiveNodeFactory();
            }
            return installRubiniusPrimitiveNodeFactoryInstance;
        }

        public static TrufflePrimitiveNodes.InstallRubiniusPrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new InstallRubiniusPrimitiveNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.InstallRubiniusPrimitiveNode.class)
        public static final class InstallRubiniusPrimitiveNodeGen
        extends TrufflePrimitiveNodes.InstallRubiniusPrimitiveNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private InstallRubiniusPrimitiveNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                if (RubyGuards.isRubyMethod(arguments0Value_)) {
                    return this.installRubiniusPrimitive(arguments0Value_);
                }
                throw this.unsupported(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.AtExitSystemNode.class)
    public static final class AtExitSystemNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.AtExitSystemNode> {
        private static AtExitSystemNodeFactory atExitSystemNodeFactoryInstance;

        private AtExitSystemNodeFactory() {
            super(TrufflePrimitiveNodes.AtExitSystemNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public TrufflePrimitiveNodes.AtExitSystemNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AtExitSystemNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrufflePrimitiveNodes.AtExitSystemNode> getInstance() {
            if (atExitSystemNodeFactoryInstance == null) {
                atExitSystemNodeFactoryInstance = new AtExitSystemNodeFactory();
            }
            return atExitSystemNodeFactoryInstance;
        }

        public static TrufflePrimitiveNodes.AtExitSystemNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new AtExitSystemNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.AtExitSystemNode.class)
        public static final class AtExitSystemNodeGen
        extends TrufflePrimitiveNodes.AtExitSystemNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AtExitSystemNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments1Value_;
                boolean arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.atExit(arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.HostOSNode.class)
    public static final class HostOSNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.HostOSNode> {
        private static HostOSNodeFactory hostOSNodeFactoryInstance;

        private HostOSNodeFactory() {
            super(TrufflePrimitiveNodes.HostOSNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[][]{{RubyContext.class, SourceSection.class}});
        }

        @Override
        public TrufflePrimitiveNodes.HostOSNode createNode(Object ... arguments) {
            if (arguments.length == 2 && (arguments[0] == null || arguments[0] instanceof RubyContext) && (arguments[1] == null || arguments[1] instanceof SourceSection)) {
                return HostOSNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrufflePrimitiveNodes.HostOSNode> getInstance() {
            if (hostOSNodeFactoryInstance == null) {
                hostOSNodeFactoryInstance = new HostOSNodeFactory();
            }
            return hostOSNodeFactoryInstance;
        }

        public static TrufflePrimitiveNodes.HostOSNode create(RubyContext context, SourceSection sourceSection) {
            return new HostOSNodeGen(context, sourceSection);
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.HostOSNode.class)
        public static final class HostOSNodeGen
        extends TrufflePrimitiveNodes.HostOSNode {
            private HostOSNodeGen(RubyContext context, SourceSection sourceSection) {
                super(context, sourceSection);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.hostOS();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.JRubyHomeDirectoryNode.class)
    public static final class JRubyHomeDirectoryNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.JRubyHomeDirectoryNode> {
        private static JRubyHomeDirectoryNodeFactory jRubyHomeDirectoryNodeFactoryInstance;

        private JRubyHomeDirectoryNodeFactory() {
            super(TrufflePrimitiveNodes.JRubyHomeDirectoryNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[][]{{RubyContext.class, SourceSection.class}});
        }

        @Override
        public TrufflePrimitiveNodes.JRubyHomeDirectoryNode createNode(Object ... arguments) {
            if (arguments.length == 2 && (arguments[0] == null || arguments[0] instanceof RubyContext) && (arguments[1] == null || arguments[1] instanceof SourceSection)) {
                return JRubyHomeDirectoryNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrufflePrimitiveNodes.JRubyHomeDirectoryNode> getInstance() {
            if (jRubyHomeDirectoryNodeFactoryInstance == null) {
                jRubyHomeDirectoryNodeFactoryInstance = new JRubyHomeDirectoryNodeFactory();
            }
            return jRubyHomeDirectoryNodeFactoryInstance;
        }

        public static TrufflePrimitiveNodes.JRubyHomeDirectoryNode create(RubyContext context, SourceSection sourceSection) {
            return new JRubyHomeDirectoryNodeGen(context, sourceSection);
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.JRubyHomeDirectoryNode.class)
        public static final class JRubyHomeDirectoryNodeGen
        extends TrufflePrimitiveNodes.JRubyHomeDirectoryNode {
            private JRubyHomeDirectoryNodeGen(RubyContext context, SourceSection sourceSection) {
                super(context, sourceSection);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.jrubyHomeDirectory();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.DebugPrintNode.class)
    public static final class DebugPrintNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.DebugPrintNode> {
        private static DebugPrintNodeFactory debugPrintNodeFactoryInstance;

        private DebugPrintNodeFactory() {
            super(TrufflePrimitiveNodes.DebugPrintNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public TrufflePrimitiveNodes.DebugPrintNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DebugPrintNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrufflePrimitiveNodes.DebugPrintNode> getInstance() {
            if (debugPrintNodeFactoryInstance == null) {
                debugPrintNodeFactoryInstance = new DebugPrintNodeFactory();
            }
            return debugPrintNodeFactoryInstance;
        }

        public static TrufflePrimitiveNodes.DebugPrintNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new DebugPrintNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.DebugPrintNode.class)
        public static final class DebugPrintNodeGen
        extends TrufflePrimitiveNodes.DebugPrintNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private DebugPrintNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                if (RubyGuards.isRubyString(arguments0Value_)) {
                    return this.debugPrint(arguments0Value_);
                }
                throw this.unsupported(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.CExtSupportedNode.class)
    public static final class CExtSupportedNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.CExtSupportedNode> {
        private static CExtSupportedNodeFactory cExtSupportedNodeFactoryInstance;

        private CExtSupportedNodeFactory() {
            super(TrufflePrimitiveNodes.CExtSupportedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public TrufflePrimitiveNodes.CExtSupportedNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CExtSupportedNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrufflePrimitiveNodes.CExtSupportedNode> getInstance() {
            if (cExtSupportedNodeFactoryInstance == null) {
                cExtSupportedNodeFactoryInstance = new CExtSupportedNodeFactory();
            }
            return cExtSupportedNodeFactoryInstance;
        }

        public static TrufflePrimitiveNodes.CExtSupportedNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new CExtSupportedNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.CExtSupportedNode.class)
        public static final class CExtSupportedNodeGen
        extends TrufflePrimitiveNodes.CExtSupportedNode {
            private CExtSupportedNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.cExtSupported();
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.CExtLoadNode.class)
    public static final class CExtLoadNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.CExtLoadNode> {
        private static CExtLoadNodeFactory cExtLoadNodeFactoryInstance;

        private CExtLoadNodeFactory() {
            super(TrufflePrimitiveNodes.CExtLoadNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public TrufflePrimitiveNodes.CExtLoadNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CExtLoadNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrufflePrimitiveNodes.CExtLoadNode> getInstance() {
            if (cExtLoadNodeFactoryInstance == null) {
                cExtLoadNodeFactoryInstance = new CExtLoadNodeFactory();
            }
            return cExtLoadNodeFactoryInstance;
        }

        public static TrufflePrimitiveNodes.CExtLoadNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new CExtLoadNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.CExtLoadNode.class)
        public static final class CExtLoadNodeGen
        extends TrufflePrimitiveNodes.CExtLoadNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private CExtLoadNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                DynamicObject arguments2Value_;
                DynamicObject arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    Object arguments2Value = this.arguments2_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value, arguments2Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value = this.arguments2_.execute(frameValue);
                    throw this.unsupported(arguments0Value_, ex.getResult(), arguments2Value);
                }
                try {
                    arguments2Value_ = this.arguments2_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, arguments1Value_, ex.getResult());
                }
                if (RubyGuards.isRubyArray(arguments0Value_) && RubyGuards.isRubyArray(arguments1Value_) && RubyGuards.isRubyArray(arguments2Value_)) {
                    return this.cExtLoad(arguments0Value_, arguments1Value_, arguments2Value_);
                }
                throw this.unsupported(arguments0Value_, arguments1Value_, arguments2Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_}, arguments0Value, arguments1Value, arguments2Value);
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.DetachNode.class)
    public static final class DetachNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.DetachNode> {
        private static DetachNodeFactory detachNodeFactoryInstance;

        private DetachNodeFactory() {
            super(TrufflePrimitiveNodes.DetachNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public TrufflePrimitiveNodes.DetachNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DetachNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrufflePrimitiveNodes.DetachNode> getInstance() {
            if (detachNodeFactoryInstance == null) {
                detachNodeFactoryInstance = new DetachNodeFactory();
            }
            return detachNodeFactoryInstance;
        }

        public static TrufflePrimitiveNodes.DetachNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new DetachNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.DetachNode.class)
        public static final class DetachNodeGen
        extends TrufflePrimitiveNodes.DetachNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private DetachNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                if (RubyGuards.isHandle(arguments0Value_)) {
                    return this.detach(arguments0Value_);
                }
                throw this.unsupported(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.AttachNode.class)
    public static final class AttachNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.AttachNode> {
        private static AttachNodeFactory attachNodeFactoryInstance;

        private AttachNodeFactory() {
            super(TrufflePrimitiveNodes.AttachNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public TrufflePrimitiveNodes.AttachNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AttachNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrufflePrimitiveNodes.AttachNode> getInstance() {
            if (attachNodeFactoryInstance == null) {
                attachNodeFactoryInstance = new AttachNodeFactory();
            }
            return attachNodeFactoryInstance;
        }

        public static TrufflePrimitiveNodes.AttachNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new AttachNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.AttachNode.class)
        public static final class AttachNodeGen
        extends TrufflePrimitiveNodes.AttachNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private AttachNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                return this.specialization_.executeDynamicObject(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="attach(DynamicObject, int, DynamicObject)", value=TrufflePrimitiveNodes.AttachNode.class)
            private static final class AttachNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                AttachNode_(AttachNodeGen root, Object arguments1Value) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((AttachNode_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDynamicObject(frameValue);
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    DynamicObject arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        return this.getNext().executeDynamicObject_(frameValue, ex.getResult(), arguments1Value, arguments2Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, ex.getResult(), arguments2Value);
                    }
                    try {
                        arguments2Value_ = this.root.arguments2_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyString(arguments0Value_)) {
                        return this.root.attach(arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && arguments2Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        DynamicObject arguments2Value_ = (DynamicObject)arguments2Value;
                        if (RubyGuards.isRubyString(arguments0Value_)) {
                            return this.root.attach(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(AttachNodeGen root, Object arguments1Value) {
                    return new AttachNode_(root, arguments1Value);
                }
            }

            @GeneratedBy(value=TrufflePrimitiveNodes.AttachNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(AttachNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(AttachNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=TrufflePrimitiveNodes.AttachNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(AttachNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(AttachNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=TrufflePrimitiveNodes.AttachNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected AttachNodeGen root;

                BaseNode_(AttachNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (AttachNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    return (DynamicObject)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value) && arguments2Value instanceof DynamicObject && RubyGuards.isRubyString(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return AttachNode_.create(this.root, arguments1Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.CoverageStartNode.class)
    public static final class CoverageStartNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.CoverageStartNode> {
        private static CoverageStartNodeFactory coverageStartNodeFactoryInstance;

        private CoverageStartNodeFactory() {
            super(TrufflePrimitiveNodes.CoverageStartNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public TrufflePrimitiveNodes.CoverageStartNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CoverageStartNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrufflePrimitiveNodes.CoverageStartNode> getInstance() {
            if (coverageStartNodeFactoryInstance == null) {
                coverageStartNodeFactoryInstance = new CoverageStartNodeFactory();
            }
            return coverageStartNodeFactoryInstance;
        }

        public static TrufflePrimitiveNodes.CoverageStartNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new CoverageStartNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.CoverageStartNode.class)
        public static final class CoverageStartNodeGen
        extends TrufflePrimitiveNodes.CoverageStartNode {
            private CoverageStartNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.coverageStart();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.CoverageResultNode.class)
    public static final class CoverageResultNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.CoverageResultNode> {
        private static CoverageResultNodeFactory coverageResultNodeFactoryInstance;

        private CoverageResultNodeFactory() {
            super(TrufflePrimitiveNodes.CoverageResultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public TrufflePrimitiveNodes.CoverageResultNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CoverageResultNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrufflePrimitiveNodes.CoverageResultNode> getInstance() {
            if (coverageResultNodeFactoryInstance == null) {
                coverageResultNodeFactoryInstance = new CoverageResultNodeFactory();
            }
            return coverageResultNodeFactoryInstance;
        }

        public static TrufflePrimitiveNodes.CoverageResultNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new CoverageResultNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.CoverageResultNode.class)
        public static final class CoverageResultNodeGen
        extends TrufflePrimitiveNodes.CoverageResultNode {
            private CoverageResultNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.coverageResult();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.SimpleShellNode.class)
    public static final class SimpleShellNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.SimpleShellNode> {
        private static SimpleShellNodeFactory simpleShellNodeFactoryInstance;

        private SimpleShellNodeFactory() {
            super(TrufflePrimitiveNodes.SimpleShellNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public TrufflePrimitiveNodes.SimpleShellNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SimpleShellNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrufflePrimitiveNodes.SimpleShellNode> getInstance() {
            if (simpleShellNodeFactoryInstance == null) {
                simpleShellNodeFactoryInstance = new SimpleShellNodeFactory();
            }
            return simpleShellNodeFactoryInstance;
        }

        public static TrufflePrimitiveNodes.SimpleShellNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SimpleShellNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.SimpleShellNode.class)
        public static final class SimpleShellNodeGen
        extends TrufflePrimitiveNodes.SimpleShellNode {
            private SimpleShellNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.simpleShell();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.GraalVersionNode.class)
    public static final class GraalVersionNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.GraalVersionNode> {
        private static GraalVersionNodeFactory graalVersionNodeFactoryInstance;

        private GraalVersionNodeFactory() {
            super(TrufflePrimitiveNodes.GraalVersionNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public TrufflePrimitiveNodes.GraalVersionNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GraalVersionNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrufflePrimitiveNodes.GraalVersionNode> getInstance() {
            if (graalVersionNodeFactoryInstance == null) {
                graalVersionNodeFactoryInstance = new GraalVersionNodeFactory();
            }
            return graalVersionNodeFactoryInstance;
        }

        public static TrufflePrimitiveNodes.GraalVersionNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new GraalVersionNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.GraalVersionNode.class)
        public static final class GraalVersionNodeGen
        extends TrufflePrimitiveNodes.GraalVersionNode {
            private GraalVersionNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.graalVersion();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.SubstrateNode.class)
    public static final class SubstrateNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.SubstrateNode> {
        private static SubstrateNodeFactory substrateNodeFactoryInstance;

        private SubstrateNodeFactory() {
            super(TrufflePrimitiveNodes.SubstrateNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public TrufflePrimitiveNodes.SubstrateNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SubstrateNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrufflePrimitiveNodes.SubstrateNode> getInstance() {
            if (substrateNodeFactoryInstance == null) {
                substrateNodeFactoryInstance = new SubstrateNodeFactory();
            }
            return substrateNodeFactoryInstance;
        }

        public static TrufflePrimitiveNodes.SubstrateNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SubstrateNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.SubstrateNode.class)
        public static final class SubstrateNodeGen
        extends TrufflePrimitiveNodes.SubstrateNode {
            private SubstrateNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.substrate();
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.GraalNode.class)
    public static final class GraalNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.GraalNode> {
        private static GraalNodeFactory graalNodeFactoryInstance;

        private GraalNodeFactory() {
            super(TrufflePrimitiveNodes.GraalNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public TrufflePrimitiveNodes.GraalNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GraalNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrufflePrimitiveNodes.GraalNode> getInstance() {
            if (graalNodeFactoryInstance == null) {
                graalNodeFactoryInstance = new GraalNodeFactory();
            }
            return graalNodeFactoryInstance;
        }

        public static TrufflePrimitiveNodes.GraalNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new GraalNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.GraalNode.class)
        public static final class GraalNodeGen
        extends TrufflePrimitiveNodes.GraalNode {
            private GraalNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.graal();
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.DumpStringNode.class)
    public static final class DumpStringNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.DumpStringNode> {
        private static DumpStringNodeFactory dumpStringNodeFactoryInstance;

        private DumpStringNodeFactory() {
            super(TrufflePrimitiveNodes.DumpStringNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public TrufflePrimitiveNodes.DumpStringNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DumpStringNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrufflePrimitiveNodes.DumpStringNode> getInstance() {
            if (dumpStringNodeFactoryInstance == null) {
                dumpStringNodeFactoryInstance = new DumpStringNodeFactory();
            }
            return dumpStringNodeFactoryInstance;
        }

        public static TrufflePrimitiveNodes.DumpStringNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new DumpStringNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.DumpStringNode.class)
        public static final class DumpStringNodeGen
        extends TrufflePrimitiveNodes.DumpStringNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private DumpStringNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                if (RubyGuards.isRubyString(arguments0Value_)) {
                    return this.dumpString(arguments0Value_);
                }
                throw this.unsupported(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.JavaClassOfNode.class)
    public static final class JavaClassOfNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.JavaClassOfNode> {
        private static JavaClassOfNodeFactory javaClassOfNodeFactoryInstance;

        private JavaClassOfNodeFactory() {
            super(TrufflePrimitiveNodes.JavaClassOfNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public TrufflePrimitiveNodes.JavaClassOfNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return JavaClassOfNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrufflePrimitiveNodes.JavaClassOfNode> getInstance() {
            if (javaClassOfNodeFactoryInstance == null) {
                javaClassOfNodeFactoryInstance = new JavaClassOfNodeFactory();
            }
            return javaClassOfNodeFactoryInstance;
        }

        public static TrufflePrimitiveNodes.JavaClassOfNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new JavaClassOfNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.JavaClassOfNode.class)
        public static final class JavaClassOfNodeGen
        extends TrufflePrimitiveNodes.JavaClassOfNode {
            @Node.Child
            private RubyNode arguments0_;

            private JavaClassOfNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                return this.javaClassOf(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.AssertNotCompiledNode.class)
    public static final class AssertNotCompiledNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.AssertNotCompiledNode> {
        private static AssertNotCompiledNodeFactory assertNotCompiledNodeFactoryInstance;

        private AssertNotCompiledNodeFactory() {
            super(TrufflePrimitiveNodes.AssertNotCompiledNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public TrufflePrimitiveNodes.AssertNotCompiledNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AssertNotCompiledNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrufflePrimitiveNodes.AssertNotCompiledNode> getInstance() {
            if (assertNotCompiledNodeFactoryInstance == null) {
                assertNotCompiledNodeFactoryInstance = new AssertNotCompiledNodeFactory();
            }
            return assertNotCompiledNodeFactoryInstance;
        }

        public static TrufflePrimitiveNodes.AssertNotCompiledNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new AssertNotCompiledNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.AssertNotCompiledNode.class)
        public static final class AssertNotCompiledNodeGen
        extends TrufflePrimitiveNodes.AssertNotCompiledNode {
            private AssertNotCompiledNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.assertNotCompiled();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.AssertConstantNode.class)
    public static final class AssertConstantNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.AssertConstantNode> {
        private static AssertConstantNodeFactory assertConstantNodeFactoryInstance;

        private AssertConstantNodeFactory() {
            super(TrufflePrimitiveNodes.AssertConstantNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public TrufflePrimitiveNodes.AssertConstantNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AssertConstantNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrufflePrimitiveNodes.AssertConstantNode> getInstance() {
            if (assertConstantNodeFactoryInstance == null) {
                assertConstantNodeFactoryInstance = new AssertConstantNodeFactory();
            }
            return assertConstantNodeFactoryInstance;
        }

        public static TrufflePrimitiveNodes.AssertConstantNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new AssertConstantNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.AssertConstantNode.class)
        public static final class AssertConstantNodeGen
        extends TrufflePrimitiveNodes.AssertConstantNode {
            @Node.Child
            private RubyNode arguments0_;

            private AssertConstantNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                return this.assertConstant(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.GCTimeNode.class)
    public static final class GCTimeNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.GCTimeNode> {
        private static GCTimeNodeFactory gCTimeNodeFactoryInstance;

        private GCTimeNodeFactory() {
            super(TrufflePrimitiveNodes.GCTimeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public TrufflePrimitiveNodes.GCTimeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GCTimeNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrufflePrimitiveNodes.GCTimeNode> getInstance() {
            if (gCTimeNodeFactoryInstance == null) {
                gCTimeNodeFactoryInstance = new GCTimeNodeFactory();
            }
            return gCTimeNodeFactoryInstance;
        }

        public static TrufflePrimitiveNodes.GCTimeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new GCTimeNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.GCTimeNode.class)
        public static final class GCTimeNodeGen
        extends TrufflePrimitiveNodes.GCTimeNode {
            private GCTimeNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeLong(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeLong(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) {
                return this.gcTime();
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.GCCountNode.class)
    public static final class GCCountNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.GCCountNode> {
        private static GCCountNodeFactory gCCountNodeFactoryInstance;

        private GCCountNodeFactory() {
            super(TrufflePrimitiveNodes.GCCountNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public TrufflePrimitiveNodes.GCCountNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GCCountNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrufflePrimitiveNodes.GCCountNode> getInstance() {
            if (gCCountNodeFactoryInstance == null) {
                gCCountNodeFactoryInstance = new GCCountNodeFactory();
            }
            return gCCountNodeFactoryInstance;
        }

        public static TrufflePrimitiveNodes.GCCountNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new GCCountNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.GCCountNode.class)
        public static final class GCCountNodeGen
        extends TrufflePrimitiveNodes.GCCountNode {
            private GCCountNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInteger(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeInteger(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                return this.gcCount();
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.SourceOfCallerNode.class)
    public static final class SourceOfCallerNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.SourceOfCallerNode> {
        private static SourceOfCallerNodeFactory sourceOfCallerNodeFactoryInstance;

        private SourceOfCallerNodeFactory() {
            super(TrufflePrimitiveNodes.SourceOfCallerNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public TrufflePrimitiveNodes.SourceOfCallerNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SourceOfCallerNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrufflePrimitiveNodes.SourceOfCallerNode> getInstance() {
            if (sourceOfCallerNodeFactoryInstance == null) {
                sourceOfCallerNodeFactoryInstance = new SourceOfCallerNodeFactory();
            }
            return sourceOfCallerNodeFactoryInstance;
        }

        public static TrufflePrimitiveNodes.SourceOfCallerNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SourceOfCallerNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.SourceOfCallerNode.class)
        public static final class SourceOfCallerNodeGen
        extends TrufflePrimitiveNodes.SourceOfCallerNode {
            private SourceOfCallerNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.sourceOfCaller();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=TrufflePrimitiveNodes.BindingOfCallerNode.class)
    public static final class BindingOfCallerNodeFactory
    extends NodeFactoryBase<TrufflePrimitiveNodes.BindingOfCallerNode> {
        private static BindingOfCallerNodeFactory bindingOfCallerNodeFactoryInstance;

        private BindingOfCallerNodeFactory() {
            super(TrufflePrimitiveNodes.BindingOfCallerNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public TrufflePrimitiveNodes.BindingOfCallerNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return BindingOfCallerNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<TrufflePrimitiveNodes.BindingOfCallerNode> getInstance() {
            if (bindingOfCallerNodeFactoryInstance == null) {
                bindingOfCallerNodeFactoryInstance = new BindingOfCallerNodeFactory();
            }
            return bindingOfCallerNodeFactoryInstance;
        }

        public static TrufflePrimitiveNodes.BindingOfCallerNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new BindingOfCallerNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=TrufflePrimitiveNodes.BindingOfCallerNode.class)
        public static final class BindingOfCallerNodeGen
        extends TrufflePrimitiveNodes.BindingOfCallerNode {
            private BindingOfCallerNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.bindingOfCaller();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }
}

