/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;

@ImportStatic(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class), @NodeChild(value="index", type=RubyNode.class)})
public abstract class ArrayReadNormalizedNode
extends RubyNode {
    public ArrayReadNormalizedNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract Object executeRead(VirtualFrame var1, DynamicObject var2, int var3);

    @Specialization(guards={"isNullArray(array)"})
    public DynamicObject readNull(DynamicObject array, int index) {
        return this.nil();
    }

    @Specialization(guards={"isInBounds(array, index)", "isIntArray(array)"})
    public int readIntInBounds(DynamicObject array, int index) {
        return ((int[])Layouts.ARRAY.getStore(array))[index];
    }

    @Specialization(guards={"isInBounds(array, index)", "isLongArray(array)"})
    public long readLongInBounds(DynamicObject array, int index) {
        return ((long[])Layouts.ARRAY.getStore(array))[index];
    }

    @Specialization(guards={"isInBounds(array, index)", "isDoubleArray(array)"})
    public double readDoubleInBounds(DynamicObject array, int index) {
        return ((double[])Layouts.ARRAY.getStore(array))[index];
    }

    @Specialization(guards={"isInBounds(array, index)", "isObjectArray(array)"})
    public Object readObjectInBounds(DynamicObject array, int index) {
        return ((Object[])Layouts.ARRAY.getStore(array))[index];
    }

    @Specialization(guards={"!isInBounds(array, index)"})
    public DynamicObject readOutOfBounds(DynamicObject array, int index) {
        return this.nil();
    }

    protected static boolean isInBounds(DynamicObject array, int index) {
        return index >= 0 && index < Layouts.ARRAY.getSize(array);
    }
}

