/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal;

import java.io.File;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.LanguageSourceSetInternal;
import org.gradle.language.base.internal.registry.LanguageTransform;
import org.gradle.language.nativeplatform.internal.CompileTaskConfig;
import org.gradle.language.nativeplatform.internal.DependentSourceSetInternal;
import org.gradle.language.nativeplatform.tasks.AbstractNativeCompileTask;
import org.gradle.language.nativeplatform.tasks.AbstractNativeSourceCompileTask;
import org.gradle.nativeplatform.ObjectFile;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.nativeplatform.toolchain.internal.PreCompiledHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceCompileTaskConfig
extends CompileTaskConfig {
    public SourceCompileTaskConfig(LanguageTransform<? extends LanguageSourceSet, ObjectFile> languageTransform, Class<? extends DefaultTask> taskType) {
        super(languageTransform, taskType);
    }

    @Override
    protected void configureCompileTask(AbstractNativeCompileTask abstractTask, NativeBinarySpecInternal binary, LanguageSourceSetInternal sourceSet) {
        AbstractNativeSourceCompileTask task = (AbstractNativeSourceCompileTask)abstractTask;
        task.setDescription(String.format("Compiles the %s of %s", sourceSet, binary));
        task.source(sourceSet.getSource());
        Project project = task.getProject();
        task.setObjectFileDir(new File(binary.getNamingScheme().getOutputDirectory(project.getBuildDir(), "objs"), sourceSet.getProjectScopedName()));
        if (sourceSet instanceof DependentSourceSetInternal && ((DependentSourceSetInternal)sourceSet).getPreCompiledHeader() != null) {
            DependentSourceSetInternal dependentSourceSet = (DependentSourceSetInternal)sourceSet;
            PreCompiledHeader pch = (PreCompiledHeader)binary.getPrefixFileToPCH().get(dependentSourceSet.getPrefixHeaderFile());
            pch.setPrefixHeaderFile(dependentSourceSet.getPrefixHeaderFile());
            pch.setIncludeString(dependentSourceSet.getPreCompiledHeader());
            task.setPreCompiledHeader(pch);
        }
        binary.binaryInputs((FileCollection)task.getOutputs().getFiles().getAsFileTree().matching((PatternFilterable)new PatternSet().include(new String[]{"**/*.obj", "**/*.o"})));
    }
}

